/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.ipps.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.ipps.core.tables.OutMigrationTableEntry;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class OutMigrationTableEntryLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/outmigration-%s.csv";
    private final CsvContentReader<OutMigrationTableEntry> contentProvider = new CsvContentReader<OutMigrationTableEntry>(OutMigrationTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public OutMigrationTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, NavigableMap<LocalDate, OutMigrationTableEntry>> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, NavigableMap<LocalDate, OutMigrationTableEntry>> generate(String csvFilename) {
        List<OutMigrationTableEntry> content = this.contentProvider.read(csvFilename);
        BinaryOperator comparator = BinaryOperator.maxBy((a, b) -> 0);
        Collector<OutMigrationTableEntry, ?, NavigableMap> collector = Collectors.toMap(OutMigrationTableEntry::getStartDate, Function.identity(), comparator, TreeMap::new);
        return LookupGenerator.generateCrossReferenceToMap(OutMigrationTableEntry::getCounty, content, HashMap::new, collector);
    }
}

