/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging;

import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.TcpSocketAppenderFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import javax.validation.constraints.NotEmpty;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@JsonTypeName(value="tls")
public class TlsSocketAppenderFactory<E extends DeferredProcessingAware>
extends TcpSocketAppenderFactory<E> {
    @Nullable
    private String keyStorePath;
    @Nullable
    private String keyStorePassword;
    @NotEmpty
    private String keyStoreType = "JKS";
    @Nullable
    private String keyStoreProvider;
    @Nullable
    private String trustStorePath;
    @Nullable
    private String trustStorePassword;
    @NotEmpty
    private String trustStoreType = "JKS";
    @Nullable
    private String trustStoreProvider;
    @Nullable
    private String jceProvider;
    @Nullable
    private List<String> supportedProtocols;
    @Nullable
    private List<String> excludedProtocols;
    @Nullable
    private List<String> supportedCipherSuites;
    @Nullable
    private List<String> excludedCipherSuites;
    private boolean validateCerts;
    private boolean validatePeers;

    @JsonProperty
    public boolean isValidatePeers() {
        return this.validatePeers;
    }

    @JsonProperty
    public void setValidatePeers(boolean validatePeers) {
        this.validatePeers = validatePeers;
    }

    @JsonProperty
    public boolean isValidateCerts() {
        return this.validateCerts;
    }

    @JsonProperty
    public void setValidateCerts(boolean validateCerts) {
        this.validateCerts = validateCerts;
    }

    @JsonProperty
    @Nullable
    public List<String> getExcludedCipherSuites() {
        return this.excludedCipherSuites;
    }

    @JsonProperty
    public void setExcludedCipherSuites(List<String> excludedCipherSuites) {
        this.excludedCipherSuites = excludedCipherSuites;
    }

    @JsonProperty
    @Nullable
    public List<String> getSupportedCipherSuites() {
        return this.supportedCipherSuites;
    }

    @JsonProperty
    public void setSupportedCipherSuites(List<String> supportedCipherSuites) {
        this.supportedCipherSuites = supportedCipherSuites;
    }

    @JsonProperty
    @Nullable
    public List<String> getExcludedProtocols() {
        return this.excludedProtocols;
    }

    @JsonProperty
    public void setExcludedProtocols(List<String> excludedProtocols) {
        this.excludedProtocols = excludedProtocols;
    }

    @JsonProperty
    @Nullable
    public List<String> getSupportedProtocols() {
        return this.supportedProtocols;
    }

    @JsonProperty
    public void setSupportedProtocols(List<String> supportedProtocols) {
        this.supportedProtocols = supportedProtocols;
    }

    @JsonProperty
    @Nullable
    public String getTrustStoreProvider() {
        return this.trustStoreProvider;
    }

    @JsonProperty
    public void setTrustStoreProvider(String trustStoreProvider) {
        this.trustStoreProvider = trustStoreProvider;
    }

    @JsonProperty
    @Nullable
    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    @JsonProperty
    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    @JsonProperty
    @Nullable
    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    @JsonProperty
    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    @JsonProperty
    @Nullable
    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    @JsonProperty
    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    @JsonProperty
    @Nullable
    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    @JsonProperty
    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    @JsonProperty
    @Nullable
    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    @JsonProperty
    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    @JsonProperty
    @Nullable
    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    @JsonProperty
    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    @JsonProperty
    @Nullable
    public String getKeyStorePath() {
        return this.keyStorePath;
    }

    @JsonProperty
    public void setKeyStorePath(String keyStorePath) {
        this.keyStorePath = keyStorePath;
    }

    @JsonProperty
    @Nullable
    public String getJceProvider() {
        return this.jceProvider;
    }

    @JsonProperty
    public void setJceProvider(String jceProvider) {
        this.jceProvider = jceProvider;
    }

    private SslContextFactory createSslContextFactory() {
        SslContextFactory.Server factory = new SslContextFactory.Server();
        if (this.keyStorePath != null) {
            factory.setKeyStorePath(this.keyStorePath);
        }
        factory.setKeyStoreType(this.keyStoreType);
        if (this.keyStorePassword != null) {
            factory.setKeyStorePassword(this.keyStorePassword);
        }
        if (this.keyStoreProvider != null) {
            factory.setKeyStoreProvider(this.keyStoreProvider);
        }
        if (this.trustStorePath != null) {
            factory.setTrustStorePath(this.trustStorePath);
        }
        if (this.trustStorePassword != null) {
            factory.setTrustStorePassword(this.trustStorePassword);
        }
        factory.setTrustStoreType(this.trustStoreType);
        if (this.trustStoreProvider != null) {
            factory.setTrustStoreProvider(this.trustStoreProvider);
        }
        factory.setValidateCerts(this.validateCerts);
        factory.setValidatePeerCerts(this.validatePeers);
        if (this.supportedProtocols != null) {
            factory.setIncludeProtocols(this.supportedProtocols.toArray(new String[0]));
        }
        if (this.excludedProtocols != null) {
            factory.setExcludeProtocols(this.excludedProtocols.toArray(new String[0]));
        }
        if (this.supportedCipherSuites != null) {
            factory.setIncludeCipherSuites(this.supportedCipherSuites.toArray(new String[0]));
        }
        if (this.excludedCipherSuites != null) {
            factory.setExcludeCipherSuites(this.excludedCipherSuites.toArray(new String[0]));
        }
        if (this.jceProvider != null) {
            factory.setProvider(this.jceProvider);
        }
        return factory;
    }

    @Override
    protected SocketFactory socketFactory() {
        final SslContextFactory sslContextFactory = this.createSslContextFactory();
        try {
            sslContextFactory.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to configure SSLContext", e);
        }
        return new SocketFactory(){

            @Override
            public Socket createSocket() throws IOException {
                return sslContextFactory.newSslSocket();
            }

            @Override
            public Socket createSocket(String host, int port) {
                return this.unsupported();
            }

            @Override
            public Socket createSocket(String host, int port, InetAddress localHost, int localPort) {
                return this.unsupported();
            }

            @Override
            public Socket createSocket(InetAddress host, int port) {
                return this.unsupported();
            }

            @Override
            public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) {
                return this.unsupported();
            }

            private Socket unsupported() {
                throw new UnsupportedOperationException("Only createSocket is supported");
            }
        };
    }
}

