/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.jaxrs2;

import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.converter.ResolvedSchema;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.ParameterProcessor;
import io.swagger.v3.core.util.PathUtils;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.jaxrs2.OperationParser;
import io.swagger.v3.jaxrs2.ReaderListener;
import io.swagger.v3.jaxrs2.ResolvedParameter;
import io.swagger.v3.jaxrs2.SecurityParser;
import io.swagger.v3.jaxrs2.ext.OpenAPIExtension;
import io.swagger.v3.jaxrs2.ext.OpenAPIExtensions;
import io.swagger.v3.jaxrs2.util.ReaderUtils;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.integration.ContextUtils;
import io.swagger.v3.oas.integration.SwaggerConfiguration;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.integration.api.OpenApiReader;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Application;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reader
implements OpenApiReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(Reader.class);
    public static final String DEFAULT_MEDIA_TYPE_VALUE = "*/*";
    public static final String DEFAULT_DESCRIPTION = "default response";
    protected OpenAPIConfiguration config;
    private Application application;
    private OpenAPI openAPI = new OpenAPI();
    private Components components;
    private Paths paths = new Paths();
    private Set<io.swagger.v3.oas.models.tags.Tag> openApiTags = new LinkedHashSet<io.swagger.v3.oas.models.tags.Tag>();
    private static final String GET_METHOD = "get";
    private static final String POST_METHOD = "post";
    private static final String PUT_METHOD = "put";
    private static final String DELETE_METHOD = "delete";
    private static final String PATCH_METHOD = "patch";
    private static final String TRACE_METHOD = "trace";
    private static final String HEAD_METHOD = "head";
    private static final String OPTIONS_METHOD = "options";

    public Reader() {
        this.components = new Components();
    }

    public Reader(OpenAPI openAPI) {
        this();
        this.setConfiguration(new SwaggerConfiguration().openAPI(openAPI));
    }

    public Reader(OpenAPIConfiguration openApiConfiguration) {
        this();
        this.setConfiguration(openApiConfiguration);
    }

    public OpenAPI getOpenAPI() {
        return this.openAPI;
    }

    public OpenAPI read(Class<?> cls) {
        return this.read(cls, this.resolveApplicationPath(), null, false, null, null, new LinkedHashSet<String>(), new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>(), new HashSet());
    }

    public OpenAPI read(Set<Class<?>> classes) {
        TreeSet sortedClasses = new TreeSet((class1, class2) -> {
            if (class1.equals(class2)) {
                return 0;
            }
            if (class1.isAssignableFrom((Class<?>)class2)) {
                return -1;
            }
            if (class2.isAssignableFrom((Class<?>)class1)) {
                return 1;
            }
            return class1.getName().compareTo(class2.getName());
        });
        sortedClasses.addAll(classes);
        HashMap<Class, ReaderListener> listeners = new HashMap<Class, ReaderListener>();
        String appPath = "";
        for (Class clazz : sortedClasses) {
            ApplicationPath applicationPath;
            if (ReaderListener.class.isAssignableFrom(clazz) && !listeners.containsKey(clazz)) {
                try {
                    listeners.put(clazz, (ReaderListener)clazz.newInstance());
                }
                catch (Exception exception) {
                    LOGGER.error("Failed to create ReaderListener", exception);
                }
            }
            if (this.config == null || !Boolean.TRUE.equals(this.config.isAlwaysResolveAppPath()) || !Application.class.isAssignableFrom(clazz) || (applicationPath = ReflectionUtils.getAnnotation(clazz, ApplicationPath.class)) == null) continue;
            appPath = applicationPath.value();
        }
        for (ReaderListener readerListener : listeners.values()) {
            try {
                readerListener.beforeScan(this, this.openAPI);
            }
            catch (Exception exception) {
                LOGGER.error("Unexpected error invoking beforeScan listener [" + readerListener.getClass().getName() + "]", exception);
            }
        }
        String appPathRuntime = this.resolveApplicationPath();
        if (StringUtils.isNotBlank(appPathRuntime)) {
            appPath = appPathRuntime;
        }
        for (Class clazz : sortedClasses) {
            this.read(clazz, appPath, null, false, null, null, new LinkedHashSet<String>(), new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>(), new HashSet());
        }
        for (ReaderListener readerListener : listeners.values()) {
            try {
                readerListener.afterScan(this, this.openAPI);
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error invoking afterScan listener [" + readerListener.getClass().getName() + "]", e);
            }
        }
        return this.openAPI;
    }

    @Override
    public void setConfiguration(OpenAPIConfiguration openApiConfiguration) {
        if (openApiConfiguration != null) {
            this.config = ContextUtils.deepCopy(openApiConfiguration);
            if (openApiConfiguration.getOpenAPI() != null) {
                this.openAPI = this.config.getOpenAPI();
                if (this.openAPI.getComponents() != null) {
                    this.components = this.openAPI.getComponents();
                }
            }
        }
    }

    @Override
    public OpenAPI read(Set<Class<?>> classes, Map<String, Object> resources) {
        return this.read(classes);
    }

    protected String resolveApplicationPath() {
        if (this.application != null) {
            ApplicationPath applicationPath;
            Class<?> applicationToScan = this.application.getClass();
            while ((applicationPath = applicationToScan.getAnnotation(ApplicationPath.class)) == null && !applicationToScan.getSuperclass().equals(Application.class)) {
                applicationToScan = applicationToScan.getSuperclass();
            }
            if (applicationPath != null && StringUtils.isNotBlank(applicationPath.value())) {
                return applicationPath.value();
            }
            try {
                Application retrievedApp;
                Application innerApp = this.application;
                Method m4 = this.application.getClass().getMethod("getApplication", new Class[0]);
                while (m4 != null && (retrievedApp = (Application)m4.invoke((Object)innerApp, new Object[0])) != null && !retrievedApp.getClass().equals(innerApp.getClass())) {
                    innerApp = retrievedApp;
                    applicationPath = innerApp.getClass().getAnnotation(ApplicationPath.class);
                    if (applicationPath != null && StringUtils.isNotBlank(applicationPath.value())) {
                        return applicationPath.value();
                    }
                    m4 = innerApp.getClass().getMethod("getApplication", new Class[0]);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    public OpenAPI read(Class<?> cls, String parentPath, String parentMethod, boolean isSubresource, RequestBody parentRequestBody, ApiResponses parentResponses, Set<String> parentTags, List<io.swagger.v3.oas.models.parameters.Parameter> parentParameters, Set<Class<?>> scannedResources) {
        Optional<List<SecurityRequirement>> requirementsObject;
        Hidden hidden = cls.getAnnotation(Hidden.class);
        Path apiPath = ReflectionUtils.getAnnotation(cls, Path.class);
        if (hidden != null) {
            return this.openAPI;
        }
        io.swagger.v3.oas.annotations.responses.ApiResponse[] classResponses = (io.swagger.v3.oas.annotations.responses.ApiResponse[])ReflectionUtils.getRepeatableAnnotationsArray(cls, io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        List<SecurityScheme> apiSecurityScheme = ReflectionUtils.getRepeatableAnnotations(cls, SecurityScheme.class);
        List<io.swagger.v3.oas.annotations.security.SecurityRequirement> apiSecurityRequirements = ReflectionUtils.getRepeatableAnnotations(cls, io.swagger.v3.oas.annotations.security.SecurityRequirement.class);
        io.swagger.v3.oas.annotations.ExternalDocumentation apiExternalDocs = ReflectionUtils.getAnnotation(cls, io.swagger.v3.oas.annotations.ExternalDocumentation.class);
        Tag[] apiTags = (Tag[])ReflectionUtils.getRepeatableAnnotationsArray(cls, Tag.class);
        io.swagger.v3.oas.annotations.servers.Server[] apiServers = (io.swagger.v3.oas.annotations.servers.Server[])ReflectionUtils.getRepeatableAnnotationsArray(cls, io.swagger.v3.oas.annotations.servers.Server.class);
        Consumes classConsumes = ReflectionUtils.getAnnotation(cls, Consumes.class);
        Produces classProduces = ReflectionUtils.getAnnotation(cls, Produces.class);
        boolean classDeprecated = ReflectionUtils.getAnnotation(cls, Deprecated.class) != null;
        OpenAPIDefinition openAPIDefinition = ReflectionUtils.getAnnotation(cls, OpenAPIDefinition.class);
        if (openAPIDefinition != null) {
            AnnotationsUtils.getInfo(openAPIDefinition.info()).ifPresent(info -> this.openAPI.setInfo((Info)info));
            SecurityParser.getSecurityRequirements(openAPIDefinition.security()).ifPresent(s2 -> this.openAPI.setSecurity((List<SecurityRequirement>)s2));
            AnnotationsUtils.getExternalDocumentation(openAPIDefinition.externalDocs()).ifPresent(docs -> this.openAPI.setExternalDocs((ExternalDocumentation)docs));
            AnnotationsUtils.getTags(openAPIDefinition.tags(), false).ifPresent(tags -> this.openApiTags.addAll((Collection<io.swagger.v3.oas.models.tags.Tag>)tags));
            AnnotationsUtils.getServers(openAPIDefinition.servers()).ifPresent(servers -> this.openAPI.setServers((List<Server>)servers));
            if (openAPIDefinition.extensions().length > 0) {
                this.openAPI.setExtensions(AnnotationsUtils.getExtensions(openAPIDefinition.extensions()));
            }
        }
        if (apiSecurityScheme != null) {
            for (SecurityScheme securitySchemeAnnotation : apiSecurityScheme) {
                Optional<SecurityParser.SecuritySchemePair> securityScheme = SecurityParser.getSecurityScheme(securitySchemeAnnotation);
                if (!securityScheme.isPresent()) continue;
                HashMap<String, io.swagger.v3.oas.models.security.SecurityScheme> securitySchemeMap = new HashMap<String, io.swagger.v3.oas.models.security.SecurityScheme>();
                if (!StringUtils.isNotBlank(securityScheme.get().key)) continue;
                securitySchemeMap.put(securityScheme.get().key, securityScheme.get().securityScheme);
                if (this.components.getSecuritySchemes() != null && this.components.getSecuritySchemes().size() != 0) {
                    this.components.getSecuritySchemes().putAll(securitySchemeMap);
                    continue;
                }
                this.components.setSecuritySchemes(securitySchemeMap);
            }
        }
        ArrayList<SecurityRequirement> classSecurityRequirements = new ArrayList();
        if (apiSecurityRequirements != null && (requirementsObject = SecurityParser.getSecurityRequirements(apiSecurityRequirements.toArray(new io.swagger.v3.oas.annotations.security.SecurityRequirement[apiSecurityRequirements.size()]))).isPresent()) {
            classSecurityRequirements = requirementsObject.get();
        }
        LinkedHashSet<String> classTags = new LinkedHashSet<String>();
        if (apiTags != null) {
            AnnotationsUtils.getTags(apiTags, false).ifPresent(tags -> tags.stream().map(io.swagger.v3.oas.models.tags.Tag::getName).forEach(classTags::add));
        }
        if (isSubresource && parentTags != null) {
            classTags.addAll(parentTags);
        }
        ArrayList<Server> classServers = new ArrayList<Server>();
        if (apiServers != null) {
            AnnotationsUtils.getServers(apiServers).ifPresent(classServers::addAll);
        }
        Optional<ExternalDocumentation> classExternalDocumentation = AnnotationsUtils.getExternalDocumentation(apiExternalDocs);
        JavaType classType = TypeFactory.defaultInstance().constructType(cls);
        BeanDescription bd = Json.mapper().getSerializationConfig().introspect(classType);
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> globalParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        globalParameters.addAll(ReaderUtils.collectConstructorParameters(cls, this.components, classConsumes, null));
        globalParameters.addAll(ReaderUtils.collectFieldParameters(cls, this.components, classConsumes, null));
        List methods = Arrays.stream(cls.getMethods()).sorted(new MethodComparator()).collect(Collectors.toList());
        for (Method method : methods) {
            ResolvedParameter resolvedParameter;
            Object paramType;
            Parameter paramAnnotation;
            Object type;
            io.swagger.v3.oas.models.Operation operation;
            JsonView jsonViewAnnotationForRequestBody;
            JsonView jsonViewAnnotation;
            Operation apiOperation;
            LinkedHashMap<String, String> regexMap;
            if (this.isOperationHidden(method)) continue;
            AnnotatedMethod annotatedMethod = bd.findMethod(method.getName(), method.getParameterTypes());
            Produces methodProduces = ReflectionUtils.getAnnotation(method, Produces.class);
            Consumes methodConsumes = ReflectionUtils.getAnnotation(method, Consumes.class);
            if (this.isMethodOverridden(method, cls)) continue;
            boolean methodDeprecated = ReflectionUtils.getAnnotation(method, Deprecated.class) != null;
            Path methodPath = ReflectionUtils.getAnnotation(method, Path.class);
            String operationPath = ReaderUtils.getPath(apiPath, methodPath, parentPath, isSubresource);
            if (this.ignoreOperationPath(operationPath, parentPath) && !isSubresource || (operationPath = PathUtils.parsePath(operationPath, regexMap = new LinkedHashMap<String, String>())) == null || this.config != null && ReaderUtils.isIgnored(operationPath, this.config)) continue;
            Class<?> subResource = this.getSubResourceWithJaxRsSubresourceLocatorSpecs(method);
            String httpMethod = ReaderUtils.extractOperationMethod(method, OpenAPIExtensions.chain());
            String string = httpMethod = httpMethod == null && isSubresource ? parentMethod : httpMethod;
            if (StringUtils.isBlank(httpMethod) && subResource == null) continue;
            if (StringUtils.isBlank(httpMethod) && subResource != null) {
                Type returnType = method.getGenericReturnType();
                if (annotatedMethod != null && annotatedMethod.getType() != null) {
                    returnType = annotatedMethod.getType();
                }
                if (this.shouldIgnoreClass(returnType.getTypeName()) && !method.getGenericReturnType().equals(subResource)) continue;
            }
            if ((apiOperation = ReflectionUtils.getAnnotation(method, Operation.class)) != null && apiOperation.ignoreJsonView()) {
                jsonViewAnnotation = null;
                jsonViewAnnotationForRequestBody = null;
            } else {
                jsonViewAnnotation = ReflectionUtils.getAnnotation(method, JsonView.class);
                jsonViewAnnotationForRequestBody = (JsonView)Arrays.stream(ReflectionUtils.getParameterAnnotations(method)).filter(arr -> Arrays.stream(arr).anyMatch(annotation -> annotation.annotationType().equals(io.swagger.v3.oas.annotations.parameters.RequestBody.class))).flatMap(Arrays::stream).filter(annotation -> annotation.annotationType().equals(JsonView.class)).reduce((a, b) -> null).orElse(jsonViewAnnotation);
            }
            if ((operation = this.parseMethod(method, globalParameters, methodProduces, classProduces, methodConsumes, classConsumes, classSecurityRequirements, classExternalDocumentation, classTags, classServers, isSubresource, parentRequestBody, parentResponses, jsonViewAnnotation, classResponses, annotatedMethod)) == null) continue;
            if (classDeprecated || methodDeprecated) {
                operation.setDeprecated(true);
            }
            ArrayList<io.swagger.v3.oas.models.parameters.Parameter> operationParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
            ArrayList<io.swagger.v3.oas.models.parameters.Parameter> formParameters = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
            Annotation[][] paramAnnotations = ReflectionUtils.getParameterAnnotations(method);
            if (annotatedMethod == null) {
                Type[] genericParameterTypes = method.getGenericParameterTypes();
                for (int i = 0; i < genericParameterTypes.length; ++i) {
                    type = TypeFactory.defaultInstance().constructType(genericParameterTypes[i], cls);
                    paramAnnotation = AnnotationsUtils.getAnnotation(Parameter.class, paramAnnotations[i]);
                    paramType = ParameterProcessor.getParameterType(paramAnnotation, true);
                    if (paramType == null) {
                        paramType = type;
                    } else if (!(paramType instanceof Class)) {
                        paramType = type;
                    }
                    resolvedParameter = this.getParameters((Type)paramType, Arrays.asList(paramAnnotations[i]), operation, classConsumes, methodConsumes, jsonViewAnnotation);
                    operationParameters.addAll(resolvedParameter.parameters);
                    formParameters.addAll(resolvedParameter.formParameters);
                    if (resolvedParameter.requestBody == null) continue;
                    this.processRequestBody(resolvedParameter.requestBody, operation, methodConsumes, classConsumes, operationParameters, paramAnnotations[i], (Type)type, jsonViewAnnotationForRequestBody, null);
                }
            } else {
                for (int i = 0; i < annotatedMethod.getParameterCount(); ++i) {
                    AnnotatedParameter param = annotatedMethod.getParameter(i);
                    type = TypeFactory.defaultInstance().constructType(param.getParameterType(), cls);
                    paramAnnotation = AnnotationsUtils.getAnnotation(Parameter.class, paramAnnotations[i]);
                    paramType = ParameterProcessor.getParameterType(paramAnnotation, true);
                    if (paramType == null) {
                        paramType = type;
                    } else if (!(paramType instanceof Class)) {
                        paramType = type;
                    }
                    resolvedParameter = this.getParameters((Type)paramType, Arrays.asList(paramAnnotations[i]), operation, classConsumes, methodConsumes, jsonViewAnnotation);
                    operationParameters.addAll(resolvedParameter.parameters);
                    formParameters.addAll(resolvedParameter.formParameters);
                    if (resolvedParameter.requestBody == null) continue;
                    this.processRequestBody(resolvedParameter.requestBody, operation, methodConsumes, classConsumes, operationParameters, paramAnnotations[i], (Type)type, jsonViewAnnotationForRequestBody, null);
                }
            }
            if (!formParameters.isEmpty()) {
                Iterator<io.swagger.v3.oas.models.parameters.Parameter> mergedSchema = new ObjectSchema();
                LinkedHashMap<String, Encoding> encoding = new LinkedHashMap<String, Encoding>();
                for (io.swagger.v3.oas.models.parameters.Parameter formParam : formParameters) {
                    if (formParam.getExplode() != null || formParam.getStyle() != null && Encoding.StyleEnum.fromString(formParam.getStyle().toString()) != null) {
                        Encoding e = new Encoding();
                        if (formParam.getExplode() != null) {
                            e.explode(formParam.getExplode());
                        }
                        if (formParam.getStyle() != null && Encoding.StyleEnum.fromString(formParam.getStyle().toString()) != null) {
                            e.style(Encoding.StyleEnum.fromString(formParam.getStyle().toString()));
                        }
                        encoding.put(formParam.getName(), e);
                    }
                    ((Schema)((Object)mergedSchema)).addProperties(formParam.getName(), formParam.getSchema());
                    if (formParam.getSchema() != null && StringUtils.isNotBlank(formParam.getDescription()) && StringUtils.isBlank(formParam.getSchema().getDescription())) {
                        formParam.getSchema().description(formParam.getDescription());
                    }
                    if (null == formParam.getRequired() || !formParam.getRequired().booleanValue()) continue;
                    ((Schema)((Object)mergedSchema)).addRequiredItem(formParam.getName());
                }
                io.swagger.v3.oas.models.parameters.Parameter merged = new io.swagger.v3.oas.models.parameters.Parameter().schema((Schema)((Object)mergedSchema));
                this.processRequestBody(merged, operation, methodConsumes, classConsumes, operationParameters, new Annotation[0], null, jsonViewAnnotationForRequestBody, encoding);
            }
            if (!operationParameters.isEmpty()) {
                for (io.swagger.v3.oas.models.parameters.Parameter operationParameter : operationParameters) {
                    operation.addParametersItem(operationParameter);
                }
            }
            if (parentParameters != null) {
                for (io.swagger.v3.oas.models.parameters.Parameter parentParameter : parentParameters) {
                    operation.addParametersItem(parentParameter);
                }
            }
            if (subResource != null && !scannedResources.contains(subResource)) {
                scannedResources.add(subResource);
                this.read(subResource, operationPath, httpMethod, true, operation.getRequestBody(), operation.getResponses(), classTags, operation.getParameters(), scannedResources);
                scannedResources.remove(subResource);
                continue;
            }
            Iterator<OpenAPIExtension> chain = OpenAPIExtensions.chain();
            if (chain.hasNext()) {
                OpenAPIExtension extension = chain.next();
                extension.decorateOperation(operation, method, chain);
            }
            PathItem pathItemObject = this.openAPI.getPaths() != null && this.openAPI.getPaths().get(operationPath) != null ? (PathItem)this.openAPI.getPaths().get(operationPath) : new PathItem();
            if (StringUtils.isBlank(httpMethod)) continue;
            this.setPathItemOperation(pathItemObject, httpMethod, operation);
            this.paths.addPathItem(operationPath, pathItemObject);
            if (this.openAPI.getPaths() != null) {
                this.paths.putAll(this.openAPI.getPaths());
            }
            this.openAPI.setPaths(this.paths);
        }
        if (!this.isEmptyComponents(this.components) && this.openAPI.getComponents() == null) {
            this.openAPI.setComponents(this.components);
        }
        AnnotationsUtils.getTags(apiTags, true).ifPresent(tags -> this.openApiTags.addAll((Collection<io.swagger.v3.oas.models.tags.Tag>)tags));
        if (!this.openApiTags.isEmpty()) {
            LinkedHashSet<io.swagger.v3.oas.models.tags.Tag> tagsSet = new LinkedHashSet<io.swagger.v3.oas.models.tags.Tag>();
            if (this.openAPI.getTags() != null) {
                for (io.swagger.v3.oas.models.tags.Tag tag : this.openAPI.getTags()) {
                    if (!tagsSet.stream().noneMatch(t2 -> t2.getName().equals(tag.getName()))) continue;
                    tagsSet.add(tag);
                }
            }
            for (io.swagger.v3.oas.models.tags.Tag tag : this.openApiTags) {
                if (!tagsSet.stream().noneMatch(t2 -> t2.getName().equals(tag.getName()))) continue;
                tagsSet.add(tag);
            }
            this.openAPI.setTags(new ArrayList<io.swagger.v3.oas.models.tags.Tag>(tagsSet));
        }
        return this.openAPI;
    }

    protected Content processContent(Content content, Schema schema, Consumes methodConsumes, Consumes classConsumes) {
        if (content == null) {
            content = new Content();
        }
        if (methodConsumes != null) {
            for (String value : methodConsumes.value()) {
                this.setMediaTypeToContent(schema, content, value);
            }
        } else if (classConsumes != null) {
            for (String value : classConsumes.value()) {
                this.setMediaTypeToContent(schema, content, value);
            }
        } else {
            this.setMediaTypeToContent(schema, content, DEFAULT_MEDIA_TYPE_VALUE);
        }
        return content;
    }

    protected void processRequestBody(io.swagger.v3.oas.models.parameters.Parameter requestBodyParameter, io.swagger.v3.oas.models.Operation operation, Consumes methodConsumes, Consumes classConsumes, List<io.swagger.v3.oas.models.parameters.Parameter> operationParameters, Annotation[] paramAnnotations, Type type, JsonView jsonViewAnnotation, Map<String, Encoding> encoding) {
        Object content;
        RequestBody requestBody;
        io.swagger.v3.oas.annotations.parameters.RequestBody requestBodyAnnotation = this.getRequestBody(Arrays.asList(paramAnnotations));
        if (requestBodyAnnotation != null) {
            Optional<RequestBody> optionalRequestBody = OperationParser.getRequestBody(requestBodyAnnotation, classConsumes, methodConsumes, this.components, jsonViewAnnotation);
            if (optionalRequestBody.isPresent()) {
                requestBody = optionalRequestBody.get();
                if (StringUtils.isBlank(requestBody.get$ref()) && (requestBody.getContent() == null || requestBody.getContent().isEmpty())) {
                    if (requestBodyParameter.getSchema() != null) {
                        content = this.processContent(requestBody.getContent(), requestBodyParameter.getSchema(), methodConsumes, classConsumes);
                        requestBody.setContent((Content)content);
                    }
                } else if (StringUtils.isBlank(requestBody.get$ref()) && requestBody.getContent() != null && !requestBody.getContent().isEmpty() && requestBodyParameter.getSchema() != null) {
                    for (MediaType mediaType : requestBody.getContent().values()) {
                        if (mediaType.getSchema() == null) {
                            if (requestBodyParameter.getSchema() == null) {
                                mediaType.setSchema(new Schema());
                            } else {
                                mediaType.setSchema(requestBodyParameter.getSchema());
                            }
                        }
                        if (!StringUtils.isBlank(mediaType.getSchema().getType())) continue;
                        mediaType.getSchema().setType(requestBodyParameter.getSchema().getType());
                    }
                }
                operation.setRequestBody(requestBody);
            }
        } else if (operation.getRequestBody() == null) {
            boolean isRequestBodyEmpty = true;
            requestBody = new RequestBody();
            if (StringUtils.isNotBlank(requestBodyParameter.get$ref())) {
                requestBody.set$ref(requestBodyParameter.get$ref());
                isRequestBodyEmpty = false;
            }
            if (StringUtils.isNotBlank(requestBodyParameter.getDescription())) {
                requestBody.setDescription(requestBodyParameter.getDescription());
                isRequestBodyEmpty = false;
            }
            if (Boolean.TRUE.equals(requestBodyParameter.getRequired())) {
                requestBody.setRequired(requestBodyParameter.getRequired());
                isRequestBodyEmpty = false;
            }
            if (requestBodyParameter.getSchema() != null) {
                content = this.processContent(null, requestBodyParameter.getSchema(), methodConsumes, classConsumes);
                requestBody.setContent((Content)content);
                isRequestBodyEmpty = false;
            }
            if (!isRequestBodyEmpty) {
                operation.setRequestBody(requestBody);
            }
        }
        if (operation.getRequestBody() != null && operation.getRequestBody().getContent() != null && encoding != null && !encoding.isEmpty()) {
            Content content2 = operation.getRequestBody().getContent();
            for (String mediaKey : content2.keySet()) {
                if (!mediaKey.equals("application/x-www-form-urlencoded") && !mediaKey.equals("multipart/form-data")) continue;
                MediaType m4 = (MediaType)content2.get(mediaKey);
                m4.encoding(encoding);
            }
        }
    }

    private io.swagger.v3.oas.annotations.parameters.RequestBody getRequestBody(List<Annotation> annotations) {
        if (annotations == null) {
            return null;
        }
        for (Annotation a : annotations) {
            if (!(a instanceof io.swagger.v3.oas.annotations.parameters.RequestBody)) continue;
            return (io.swagger.v3.oas.annotations.parameters.RequestBody)a;
        }
        return null;
    }

    private void setMediaTypeToContent(Schema schema, Content content, String value) {
        MediaType mediaTypeObject = new MediaType();
        mediaTypeObject.setSchema(schema);
        content.addMediaType(value, mediaTypeObject);
    }

    public io.swagger.v3.oas.models.Operation parseMethod(Method method, List<io.swagger.v3.oas.models.parameters.Parameter> globalParameters, JsonView jsonViewAnnotation) {
        JavaType classType = TypeFactory.defaultInstance().constructType(method.getDeclaringClass());
        return this.parseMethod(classType.getClass(), method, globalParameters, null, null, null, null, new ArrayList<SecurityRequirement>(), Optional.empty(), new HashSet<String>(), new ArrayList<Server>(), false, null, null, jsonViewAnnotation, null, null);
    }

    public io.swagger.v3.oas.models.Operation parseMethod(Method method, List<io.swagger.v3.oas.models.parameters.Parameter> globalParameters, Produces methodProduces, Produces classProduces, Consumes methodConsumes, Consumes classConsumes, List<SecurityRequirement> classSecurityRequirements, Optional<ExternalDocumentation> classExternalDocs, Set<String> classTags, List<Server> classServers, boolean isSubresource, RequestBody parentRequestBody, ApiResponses parentResponses, JsonView jsonViewAnnotation, io.swagger.v3.oas.annotations.responses.ApiResponse[] classResponses) {
        JavaType classType = TypeFactory.defaultInstance().constructType(method.getDeclaringClass());
        return this.parseMethod(classType.getClass(), method, globalParameters, methodProduces, classProduces, methodConsumes, classConsumes, classSecurityRequirements, classExternalDocs, classTags, classServers, isSubresource, parentRequestBody, parentResponses, jsonViewAnnotation, classResponses, null);
    }

    public io.swagger.v3.oas.models.Operation parseMethod(Method method, List<io.swagger.v3.oas.models.parameters.Parameter> globalParameters, Produces methodProduces, Produces classProduces, Consumes methodConsumes, Consumes classConsumes, List<SecurityRequirement> classSecurityRequirements, Optional<ExternalDocumentation> classExternalDocs, Set<String> classTags, List<Server> classServers, boolean isSubresource, RequestBody parentRequestBody, ApiResponses parentResponses, JsonView jsonViewAnnotation, io.swagger.v3.oas.annotations.responses.ApiResponse[] classResponses, AnnotatedMethod annotatedMethod) {
        JavaType classType = TypeFactory.defaultInstance().constructType(method.getDeclaringClass());
        return this.parseMethod(classType.getClass(), method, globalParameters, methodProduces, classProduces, methodConsumes, classConsumes, classSecurityRequirements, classExternalDocs, classTags, classServers, isSubresource, parentRequestBody, parentResponses, jsonViewAnnotation, classResponses, annotatedMethod);
    }

    protected io.swagger.v3.oas.models.Operation parseMethod(Class<?> cls, Method method, List<io.swagger.v3.oas.models.parameters.Parameter> globalParameters, Produces methodProduces, Produces classProduces, Consumes methodConsumes, Consumes classConsumes, List<SecurityRequirement> classSecurityRequirements, Optional<ExternalDocumentation> classExternalDocs, Set<String> classTags, List<Server> classServers, boolean isSubresource, RequestBody parentRequestBody, ApiResponses parentResponses, JsonView jsonViewAnnotation, io.swagger.v3.oas.annotations.responses.ApiResponse[] classResponses, AnnotatedMethod annotatedMethod) {
        Object requirementsObject;
        io.swagger.v3.oas.models.Operation operation = new io.swagger.v3.oas.models.Operation();
        Operation apiOperation = ReflectionUtils.getAnnotation(method, Operation.class);
        List<io.swagger.v3.oas.annotations.security.SecurityRequirement> apiSecurity = ReflectionUtils.getRepeatableAnnotations(method, io.swagger.v3.oas.annotations.security.SecurityRequirement.class);
        List<io.swagger.v3.oas.annotations.callbacks.Callback> apiCallbacks = ReflectionUtils.getRepeatableAnnotations(method, io.swagger.v3.oas.annotations.callbacks.Callback.class);
        List<io.swagger.v3.oas.annotations.servers.Server> apiServers = ReflectionUtils.getRepeatableAnnotations(method, io.swagger.v3.oas.annotations.servers.Server.class);
        List<Tag> apiTags = ReflectionUtils.getRepeatableAnnotations(method, Tag.class);
        List<Parameter> apiParameters = ReflectionUtils.getRepeatableAnnotations(method, Parameter.class);
        List<io.swagger.v3.oas.annotations.responses.ApiResponse> apiResponses = ReflectionUtils.getRepeatableAnnotations(method, io.swagger.v3.oas.annotations.responses.ApiResponse.class);
        io.swagger.v3.oas.annotations.parameters.RequestBody apiRequestBody = ReflectionUtils.getAnnotation(method, io.swagger.v3.oas.annotations.parameters.RequestBody.class);
        io.swagger.v3.oas.annotations.ExternalDocumentation apiExternalDocumentation = ReflectionUtils.getAnnotation(method, io.swagger.v3.oas.annotations.ExternalDocumentation.class);
        LinkedHashMap<String, Callback> callbacks = new LinkedHashMap<String, Callback>();
        if (apiCallbacks != null) {
            for (io.swagger.v3.oas.annotations.callbacks.Callback callback : apiCallbacks) {
                Map<String, Callback> currentCallbacks = this.getCallbacks(callback, methodProduces, classProduces, methodConsumes, classConsumes, jsonViewAnnotation);
                callbacks.putAll(currentCallbacks);
            }
        }
        if (callbacks.size() > 0) {
            operation.setCallbacks(callbacks);
        }
        classSecurityRequirements.forEach(operation::addSecurityItem);
        if (apiSecurity != null && ((Optional)(requirementsObject = SecurityParser.getSecurityRequirements(apiSecurity.toArray(new io.swagger.v3.oas.annotations.security.SecurityRequirement[apiSecurity.size()])))).isPresent()) {
            ((Optional)requirementsObject).get().stream().filter(r -> operation.getSecurity() == null || !operation.getSecurity().contains(r)).forEach(operation::addSecurityItem);
        }
        if (classServers != null) {
            classServers.forEach(operation::addServersItem);
        }
        if (apiServers != null) {
            AnnotationsUtils.getServers(apiServers.toArray(new io.swagger.v3.oas.annotations.servers.Server[apiServers.size()])).ifPresent(servers -> servers.forEach(operation::addServersItem));
        }
        AnnotationsUtils.getExternalDocumentation(apiExternalDocumentation).ifPresent(operation::setExternalDocs);
        if (apiTags != null) {
            apiTags.stream().filter(t2 -> operation.getTags() == null || operation.getTags() != null && !operation.getTags().contains(t2.name())).map(Tag::name).forEach(operation::addTagsItem);
            AnnotationsUtils.getTags(apiTags.toArray(new Tag[apiTags.size()]), true).ifPresent(tags -> this.openApiTags.addAll((Collection<io.swagger.v3.oas.models.tags.Tag>)tags));
        }
        if (globalParameters != null) {
            for (io.swagger.v3.oas.models.parameters.Parameter parameter : globalParameters) {
                operation.addParametersItem(parameter);
            }
        }
        if (apiParameters != null) {
            this.getParametersListFromAnnotation(apiParameters.toArray(new Parameter[apiParameters.size()]), classConsumes, methodConsumes, operation, jsonViewAnnotation).ifPresent(p -> p.forEach(operation::addParametersItem));
        }
        if (apiRequestBody != null && operation.getRequestBody() == null) {
            OperationParser.getRequestBody(apiRequestBody, classConsumes, methodConsumes, this.components, jsonViewAnnotation).ifPresent(operation::setRequestBody);
        }
        if (StringUtils.isBlank(operation.getOperationId())) {
            operation.setOperationId(this.getOperationId(method.getName()));
        }
        if (classResponses != null && classResponses.length > 0) {
            OperationParser.getApiResponses(classResponses, classProduces, methodProduces, this.components, jsonViewAnnotation).ifPresent(responses -> {
                if (operation.getResponses() == null) {
                    operation.setResponses((ApiResponses)responses);
                } else {
                    responses.forEach(operation.getResponses()::addApiResponse);
                }
            });
        }
        if (apiOperation != null) {
            this.setOperationObjectFromApiOperationAnnotation(operation, apiOperation, methodProduces, classProduces, methodConsumes, classConsumes, jsonViewAnnotation);
        }
        if (apiResponses != null && !apiResponses.isEmpty()) {
            OperationParser.getApiResponses(apiResponses.toArray(new io.swagger.v3.oas.annotations.responses.ApiResponse[apiResponses.size()]), classProduces, methodProduces, this.components, jsonViewAnnotation).ifPresent(responses -> {
                if (operation.getResponses() == null) {
                    operation.setResponses((ApiResponses)responses);
                } else {
                    responses.forEach(operation.getResponses()::addApiResponse);
                }
            });
        }
        if (classTags != null) {
            classTags.stream().filter(t2 -> operation.getTags() == null || operation.getTags() != null && !operation.getTags().contains(t2)).forEach(operation::addTagsItem);
        }
        if (operation.getExternalDocs() == null) {
            classExternalDocs.ifPresent(operation::setExternalDocs);
        }
        if (isSubresource && parentRequestBody != null) {
            if (operation.getRequestBody() == null) {
                operation.requestBody(parentRequestBody);
            } else {
                Content content = operation.getRequestBody().getContent();
                if (content == null) {
                    content = parentRequestBody.getContent();
                    operation.getRequestBody().setContent(content);
                } else if (parentRequestBody.getContent() != null) {
                    for (String parentMediaType : parentRequestBody.getContent().keySet()) {
                        if (content.get(parentMediaType) != null) continue;
                        content.addMediaType(parentMediaType, (MediaType)parentRequestBody.getContent().get(parentMediaType));
                    }
                }
            }
        }
        Type returnType = method.getGenericReturnType();
        if (annotatedMethod != null && annotatedMethod.getType() != null) {
            returnType = annotatedMethod.getType();
        }
        Class<?> clazz = this.getSubResourceWithJaxRsSubresourceLocatorSpecs(method);
        if (!this.shouldIgnoreClass(returnType.getTypeName()) && !method.getGenericReturnType().equals(clazz)) {
            ResolvedSchema resolvedSchema = ModelConverters.getInstance().resolveAsResolvedSchema(new AnnotatedType(returnType).resolveAsRef(true).jsonViewAnnotation(jsonViewAnnotation));
            if (resolvedSchema.schema != null) {
                Map<String, Schema> schemaMap;
                Schema returnTypeSchema = resolvedSchema.schema;
                Content content = new Content();
                MediaType mediaType = new MediaType().schema(returnTypeSchema);
                AnnotationsUtils.applyTypes(classProduces == null ? new String[]{} : classProduces.value(), methodProduces == null ? new String[]{} : methodProduces.value(), content, mediaType);
                if (operation.getResponses() == null) {
                    operation.responses(new ApiResponses()._default(new ApiResponse().description(DEFAULT_DESCRIPTION).content(content)));
                }
                if (operation.getResponses().getDefault() != null && StringUtils.isBlank(operation.getResponses().getDefault().get$ref())) {
                    if (operation.getResponses().getDefault().getContent() == null) {
                        operation.getResponses().getDefault().content(content);
                    } else {
                        for (String key2 : operation.getResponses().getDefault().getContent().keySet()) {
                            if (((MediaType)operation.getResponses().getDefault().getContent().get(key2)).getSchema() != null) continue;
                            ((MediaType)operation.getResponses().getDefault().getContent().get(key2)).setSchema(returnTypeSchema);
                        }
                    }
                }
                if ((schemaMap = resolvedSchema.referencedSchemas) != null) {
                    schemaMap.forEach((key, schema) -> this.components.addSchemas((String)key, (Schema)schema));
                }
            }
        }
        if (operation.getResponses() == null || operation.getResponses().isEmpty()) {
            Content content = new Content();
            MediaType mediaType = new MediaType();
            AnnotationsUtils.applyTypes(classProduces == null ? new String[]{} : classProduces.value(), methodProduces == null ? new String[]{} : methodProduces.value(), content, mediaType);
            ApiResponse apiResponseObject = new ApiResponse().description(DEFAULT_DESCRIPTION).content(content);
            operation.setResponses(new ApiResponses()._default(apiResponseObject));
        }
        return operation;
    }

    private boolean shouldIgnoreClass(String className) {
        if (StringUtils.isBlank(className)) {
            return true;
        }
        boolean ignore = false;
        String rawClassName = className;
        if (rawClassName.startsWith("[")) {
            rawClassName = className.replace("[simple type, class ", "");
            rawClassName = rawClassName.substring(0, rawClassName.length() - 1);
        }
        ignore = (ignore = rawClassName.startsWith("javax.ws.rs.")) || rawClassName.equalsIgnoreCase("void");
        ignore = ignore || ModelConverters.getInstance().isRegisteredAsSkippedClass(rawClassName);
        return ignore;
    }

    private Map<String, Callback> getCallbacks(io.swagger.v3.oas.annotations.callbacks.Callback apiCallback, Produces methodProduces, Produces classProduces, Consumes methodConsumes, Consumes classConsumes, JsonView jsonViewAnnotation) {
        HashMap<String, Callback> callbackMap = new HashMap<String, Callback>();
        if (apiCallback == null) {
            return callbackMap;
        }
        Callback callbackObject = new Callback();
        if (StringUtils.isNotBlank(apiCallback.ref())) {
            callbackObject.set$ref(apiCallback.ref());
            callbackMap.put(apiCallback.name(), callbackObject);
            return callbackMap;
        }
        PathItem pathItemObject = new PathItem();
        for (Operation callbackOperation : apiCallback.operation()) {
            io.swagger.v3.oas.models.Operation callbackNewOperation = new io.swagger.v3.oas.models.Operation();
            this.setOperationObjectFromApiOperationAnnotation(callbackNewOperation, callbackOperation, methodProduces, classProduces, methodConsumes, classConsumes, jsonViewAnnotation);
            this.setPathItemOperation(pathItemObject, callbackOperation.method(), callbackNewOperation);
        }
        callbackObject.addPathItem(apiCallback.callbackUrlExpression(), pathItemObject);
        callbackMap.put(apiCallback.name(), callbackObject);
        return callbackMap;
    }

    private void setPathItemOperation(PathItem pathItemObject, String method, io.swagger.v3.oas.models.Operation operation) {
        switch (method) {
            case "post": {
                pathItemObject.post(operation);
                break;
            }
            case "get": {
                pathItemObject.get(operation);
                break;
            }
            case "delete": {
                pathItemObject.delete(operation);
                break;
            }
            case "put": {
                pathItemObject.put(operation);
                break;
            }
            case "patch": {
                pathItemObject.patch(operation);
                break;
            }
            case "trace": {
                pathItemObject.trace(operation);
                break;
            }
            case "head": {
                pathItemObject.head(operation);
                break;
            }
            case "options": {
                pathItemObject.options(operation);
                break;
            }
        }
    }

    private void setOperationObjectFromApiOperationAnnotation(io.swagger.v3.oas.models.Operation operation, Operation apiOperation, Produces methodProduces, Produces classProduces, Consumes methodConsumes, Consumes classConsumes, JsonView jsonViewAnnotation) {
        Map<String, Object> extensions;
        if (StringUtils.isNotBlank(apiOperation.summary())) {
            operation.setSummary(apiOperation.summary());
        }
        if (StringUtils.isNotBlank(apiOperation.description())) {
            operation.setDescription(apiOperation.description());
        }
        if (StringUtils.isNotBlank(apiOperation.operationId())) {
            operation.setOperationId(this.getOperationId(apiOperation.operationId()));
        }
        if (apiOperation.deprecated()) {
            operation.setDeprecated(apiOperation.deprecated());
        }
        ReaderUtils.getStringListFromStringArray(apiOperation.tags()).ifPresent(tags -> tags.stream().filter(t2 -> operation.getTags() == null || operation.getTags() != null && !operation.getTags().contains(t2)).forEach(operation::addTagsItem));
        if (operation.getExternalDocs() == null) {
            AnnotationsUtils.getExternalDocumentation(apiOperation.externalDocs()).ifPresent(operation::setExternalDocs);
        }
        OperationParser.getApiResponses(apiOperation.responses(), classProduces, methodProduces, this.components, jsonViewAnnotation).ifPresent(responses -> {
            if (operation.getResponses() == null) {
                operation.setResponses((ApiResponses)responses);
            } else {
                responses.forEach(operation.getResponses()::addApiResponse);
            }
        });
        AnnotationsUtils.getServers(apiOperation.servers()).ifPresent(servers -> servers.forEach(operation::addServersItem));
        this.getParametersListFromAnnotation(apiOperation.parameters(), classConsumes, methodConsumes, operation, jsonViewAnnotation).ifPresent(p -> p.forEach(operation::addParametersItem));
        Optional<List<SecurityRequirement>> requirementsObject = SecurityParser.getSecurityRequirements(apiOperation.security());
        if (requirementsObject.isPresent()) {
            requirementsObject.get().stream().filter(r -> operation.getSecurity() == null || !operation.getSecurity().contains(r)).forEach(operation::addSecurityItem);
        }
        if (apiOperation.requestBody() != null && operation.getRequestBody() == null) {
            OperationParser.getRequestBody(apiOperation.requestBody(), classConsumes, methodConsumes, this.components, jsonViewAnnotation).ifPresent(operation::setRequestBody);
        }
        if (apiOperation.extensions().length > 0 && (extensions = AnnotationsUtils.getExtensions(apiOperation.extensions())) != null) {
            extensions.forEach(operation::addExtension);
        }
    }

    protected String getOperationId(String operationId) {
        boolean operationIdUsed = this.existOperationId(operationId);
        String operationIdToFind = null;
        int counter = 0;
        while (operationIdUsed) {
            operationIdToFind = String.format("%s_%d", operationId, ++counter);
            operationIdUsed = this.existOperationId(operationIdToFind);
        }
        if (operationIdToFind != null) {
            operationId = operationIdToFind;
        }
        return operationId;
    }

    private boolean existOperationId(String operationId) {
        if (this.openAPI == null) {
            return false;
        }
        if (this.openAPI.getPaths() == null || this.openAPI.getPaths().isEmpty()) {
            return false;
        }
        for (PathItem path : this.openAPI.getPaths().values()) {
            Set<String> pathOperationIds = this.extractOperationIdFromPathItem(path);
            if (!pathOperationIds.contains(operationId)) continue;
            return true;
        }
        return false;
    }

    protected Optional<List<io.swagger.v3.oas.models.parameters.Parameter>> getParametersListFromAnnotation(Parameter[] parameters, Consumes classConsumes, Consumes methodConsumes, io.swagger.v3.oas.models.Operation operation, JsonView jsonViewAnnotation) {
        if (parameters == null) {
            return Optional.empty();
        }
        ArrayList<io.swagger.v3.oas.models.parameters.Parameter> parametersObject = new ArrayList<io.swagger.v3.oas.models.parameters.Parameter>();
        for (Parameter parameter : parameters) {
            ResolvedParameter resolvedParameter = this.getParameters(ParameterProcessor.getParameterType(parameter), Collections.singletonList(parameter), operation, classConsumes, methodConsumes, jsonViewAnnotation);
            parametersObject.addAll(resolvedParameter.parameters);
        }
        if (parametersObject.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(parametersObject);
    }

    protected ResolvedParameter getParameters(Type type, List<Annotation> annotations, io.swagger.v3.oas.models.Operation operation, Consumes classConsumes, Consumes methodConsumes, JsonView jsonViewAnnotation) {
        Iterator<OpenAPIExtension> chain = OpenAPIExtensions.chain();
        if (!chain.hasNext()) {
            return new ResolvedParameter();
        }
        LOGGER.debug("getParameters for {}", (Object)type);
        HashSet<Type> typesToSkip = new HashSet<Type>();
        OpenAPIExtension extension = chain.next();
        LOGGER.debug("trying extension {}", (Object)extension);
        return extension.extractParameters(annotations, type, typesToSkip, this.components, classConsumes, methodConsumes, true, jsonViewAnnotation, chain);
    }

    private Set<String> extractOperationIdFromPathItem(PathItem path) {
        HashSet<String> ids = new HashSet<String>();
        if (path.getGet() != null && StringUtils.isNotBlank(path.getGet().getOperationId())) {
            ids.add(path.getGet().getOperationId());
        }
        if (path.getPost() != null && StringUtils.isNotBlank(path.getPost().getOperationId())) {
            ids.add(path.getPost().getOperationId());
        }
        if (path.getPut() != null && StringUtils.isNotBlank(path.getPut().getOperationId())) {
            ids.add(path.getPut().getOperationId());
        }
        if (path.getDelete() != null && StringUtils.isNotBlank(path.getDelete().getOperationId())) {
            ids.add(path.getDelete().getOperationId());
        }
        if (path.getOptions() != null && StringUtils.isNotBlank(path.getOptions().getOperationId())) {
            ids.add(path.getOptions().getOperationId());
        }
        if (path.getHead() != null && StringUtils.isNotBlank(path.getHead().getOperationId())) {
            ids.add(path.getHead().getOperationId());
        }
        if (path.getPatch() != null && StringUtils.isNotBlank(path.getPatch().getOperationId())) {
            ids.add(path.getPatch().getOperationId());
        }
        return ids;
    }

    private boolean isEmptyComponents(Components components) {
        if (components == null) {
            return true;
        }
        if (components.getSchemas() != null && components.getSchemas().size() > 0) {
            return false;
        }
        if (components.getSecuritySchemes() != null && components.getSecuritySchemes().size() > 0) {
            return false;
        }
        if (components.getCallbacks() != null && components.getCallbacks().size() > 0) {
            return false;
        }
        if (components.getExamples() != null && components.getExamples().size() > 0) {
            return false;
        }
        if (components.getExtensions() != null && components.getExtensions().size() > 0) {
            return false;
        }
        if (components.getHeaders() != null && components.getHeaders().size() > 0) {
            return false;
        }
        if (components.getLinks() != null && components.getLinks().size() > 0) {
            return false;
        }
        if (components.getParameters() != null && components.getParameters().size() > 0) {
            return false;
        }
        if (components.getRequestBodies() != null && components.getRequestBodies().size() > 0) {
            return false;
        }
        return components.getResponses() == null || components.getResponses().size() <= 0;
    }

    protected boolean isOperationHidden(Method method) {
        Operation apiOperation = ReflectionUtils.getAnnotation(method, Operation.class);
        if (apiOperation != null && apiOperation.hidden()) {
            return true;
        }
        Hidden hidden = method.getAnnotation(Hidden.class);
        if (hidden != null) {
            return true;
        }
        return this.config != null && !Boolean.TRUE.equals(this.config.isReadAllResources()) && apiOperation == null;
    }

    protected boolean isMethodOverridden(Method method, Class<?> cls) {
        return ReflectionUtils.isOverriddenMethod(method, cls);
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    protected boolean ignoreOperationPath(String path, String parentPath) {
        return false;
    }

    protected boolean ignoreOperationPathStrict(String path, String parentPath) {
        if (StringUtils.isBlank(path) && StringUtils.isBlank(parentPath)) {
            return true;
        }
        if (StringUtils.isNotBlank(path) && StringUtils.isBlank(parentPath)) {
            return false;
        }
        if (StringUtils.isBlank(path) && StringUtils.isNotBlank(parentPath)) {
            return false;
        }
        if (parentPath != null && !"".equals(parentPath) && !"/".equals(parentPath)) {
            if (!parentPath.startsWith("/")) {
                parentPath = "/" + parentPath;
            }
            if (parentPath.endsWith("/")) {
                parentPath = parentPath.substring(0, parentPath.length() - 1);
            }
        }
        if (path != null && !"".equals(path) && !"/".equals(path)) {
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path.equals(parentPath);
    }

    protected Class<?> getSubResourceWithJaxRsSubresourceLocatorSpecs(Method method) {
        Class<?> type;
        Class<?> rawType = method.getReturnType();
        if (Class.class.equals(rawType)) {
            type = Reader.getClassArgument(method.getGenericReturnType());
            if (type == null) {
                return null;
            }
        } else {
            type = rawType;
        }
        if (method.getAnnotation(Path.class) != null && ReaderUtils.extractOperationMethod(method, null) == null) {
            return type;
        }
        return null;
    }

    private static Class<?> getClassArgument(Type cls) {
        if (cls instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)cls;
            Type[] args = parameterized.getActualTypeArguments();
            if (args.length != 1) {
                LOGGER.error("Unexpected class definition: {}", (Object)cls);
                return null;
            }
            Type first = args[0];
            if (first instanceof Class) {
                return (Class)first;
            }
            return null;
        }
        LOGGER.error("Unknown class definition: {}", (Object)cls);
        return null;
    }

    private static class MethodComparator
    implements Comparator<Method> {
        private MethodComparator() {
        }

        @Override
        public int compare(Method m1, Method m22) {
            int val = m1.getName().compareTo(m22.getName());
            if (val == 0 && (val = m1.getParameterTypes().length - m22.getParameterTypes().length) == 0) {
                Class<?>[] types1 = m1.getParameterTypes();
                Class<?>[] types2 = m22.getParameterTypes();
                for (int i = 0; i < types1.length && (val = types1[i].getName().compareTo(types2[i].getName())) == 0; ++i) {
                }
            }
            return val;
        }
    }
}

