// Generated by delombok at Thu Feb 13 23:36:51 UTC 2025
package gov.cms.fiss.pricers.ipps.api.v2;

import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithNineFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.math.RoundingMode;

@Schema(description = "The additional operating variable information from claim pricing.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-ADDITIONAL-VARIABLES", value = "<structure>")})})
public class AdditionalOperatingVariableData {
  @BigDecimalScale(roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The operating base diagnosis-related group (DRG) payment.", example = "329078.56", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-OPER-BASE-DRG-PAY", value = "PIC 9(08)V99")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal operatingBaseDrgPayment;
  @BigDecimalScale(scale = 4, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The operating disproportionate share hospital (DSH) amount.", example = "4.5045", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-OPER-DSH", value = "PIC 9(01)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal operatingDisproportionateShareHospitalAmount;
  @BigDecimalScale(scale = 4, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The operating disproportionate share hospital ratio; derived from provider ratios.", example = "4.5045", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-WK-OPER-DSH", value = "PIC 9(01)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal operatingDisproportionateShareHospitalRatio;
  @BigDecimalScale(scale = 9, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The new technology add-on payment.", example = "9485.76", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-DOLLAR-THRESHOLD", value = "PIC 9(07)V9(09)")})})
  @ValidDecimalOutputWithNineFractionDigits
  private BigDecimal operatingDollarThreshold;
  @BigDecimalScale(scale = 9, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The operating federal-specific portion part.", example = "984307.256493255", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-OPER-FSP-PART", value = "PIC 9(06)V9(09)")})})
  @ValidDecimalOutputWithNineFractionDigits
  private BigDecimal operatingFederalSpecificPortionPart;
  @BigDecimalScale(scale = 9, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The operating hospital-specific portion part.", example = "1234.896525245", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-OPER-HSP-PART", value = "PIC 9(06)V9(09)")})})
  @ValidDecimalOutputWithNineFractionDigits
  private BigDecimal operatingHospitalSpecificPortionPart;
  @BigDecimalScale(scale = 9, roundingMode = RoundingMode.HALF_UP)
  @Schema(description = "The operating indirect medical education amount.", example = "738.920546234", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "H-OPER-IME-TEACH", value = "PIC 9(06)V9(09)")})})
  @ValidDecimalOutputWithNineFractionDigits
  private BigDecimal operatingIndirectMedicalEducationAmount;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingBaseDrgPayment() {
    return this.operatingBaseDrgPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingDisproportionateShareHospitalAmount() {
    return this.operatingDisproportionateShareHospitalAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingDisproportionateShareHospitalRatio() {
    return this.operatingDisproportionateShareHospitalRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingDollarThreshold() {
    return this.operatingDollarThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingFederalSpecificPortionPart() {
    return this.operatingFederalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingHospitalSpecificPortionPart() {
    return this.operatingHospitalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOperatingIndirectMedicalEducationAmount() {
    return this.operatingIndirectMedicalEducationAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingBaseDrgPayment(final BigDecimal operatingBaseDrgPayment) {
    this.operatingBaseDrgPayment = operatingBaseDrgPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingDisproportionateShareHospitalAmount(final BigDecimal operatingDisproportionateShareHospitalAmount) {
    this.operatingDisproportionateShareHospitalAmount = operatingDisproportionateShareHospitalAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingDisproportionateShareHospitalRatio(final BigDecimal operatingDisproportionateShareHospitalRatio) {
    this.operatingDisproportionateShareHospitalRatio = operatingDisproportionateShareHospitalRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingDollarThreshold(final BigDecimal operatingDollarThreshold) {
    this.operatingDollarThreshold = operatingDollarThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingFederalSpecificPortionPart(final BigDecimal operatingFederalSpecificPortionPart) {
    this.operatingFederalSpecificPortionPart = operatingFederalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingHospitalSpecificPortionPart(final BigDecimal operatingHospitalSpecificPortionPart) {
    this.operatingHospitalSpecificPortionPart = operatingHospitalSpecificPortionPart;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOperatingIndirectMedicalEducationAmount(final BigDecimal operatingIndirectMedicalEducationAmount) {
    this.operatingIndirectMedicalEducationAmount = operatingIndirectMedicalEducationAmount;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof AdditionalOperatingVariableData)) return false;
    final AdditionalOperatingVariableData other = (AdditionalOperatingVariableData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$operatingBaseDrgPayment = this.getOperatingBaseDrgPayment();
    final java.lang.Object other$operatingBaseDrgPayment = other.getOperatingBaseDrgPayment();
    if (this$operatingBaseDrgPayment == null ? other$operatingBaseDrgPayment != null : !this$operatingBaseDrgPayment.equals(other$operatingBaseDrgPayment)) return false;
    final java.lang.Object this$operatingDisproportionateShareHospitalAmount = this.getOperatingDisproportionateShareHospitalAmount();
    final java.lang.Object other$operatingDisproportionateShareHospitalAmount = other.getOperatingDisproportionateShareHospitalAmount();
    if (this$operatingDisproportionateShareHospitalAmount == null ? other$operatingDisproportionateShareHospitalAmount != null : !this$operatingDisproportionateShareHospitalAmount.equals(other$operatingDisproportionateShareHospitalAmount)) return false;
    final java.lang.Object this$operatingDisproportionateShareHospitalRatio = this.getOperatingDisproportionateShareHospitalRatio();
    final java.lang.Object other$operatingDisproportionateShareHospitalRatio = other.getOperatingDisproportionateShareHospitalRatio();
    if (this$operatingDisproportionateShareHospitalRatio == null ? other$operatingDisproportionateShareHospitalRatio != null : !this$operatingDisproportionateShareHospitalRatio.equals(other$operatingDisproportionateShareHospitalRatio)) return false;
    final java.lang.Object this$operatingDollarThreshold = this.getOperatingDollarThreshold();
    final java.lang.Object other$operatingDollarThreshold = other.getOperatingDollarThreshold();
    if (this$operatingDollarThreshold == null ? other$operatingDollarThreshold != null : !this$operatingDollarThreshold.equals(other$operatingDollarThreshold)) return false;
    final java.lang.Object this$operatingFederalSpecificPortionPart = this.getOperatingFederalSpecificPortionPart();
    final java.lang.Object other$operatingFederalSpecificPortionPart = other.getOperatingFederalSpecificPortionPart();
    if (this$operatingFederalSpecificPortionPart == null ? other$operatingFederalSpecificPortionPart != null : !this$operatingFederalSpecificPortionPart.equals(other$operatingFederalSpecificPortionPart)) return false;
    final java.lang.Object this$operatingHospitalSpecificPortionPart = this.getOperatingHospitalSpecificPortionPart();
    final java.lang.Object other$operatingHospitalSpecificPortionPart = other.getOperatingHospitalSpecificPortionPart();
    if (this$operatingHospitalSpecificPortionPart == null ? other$operatingHospitalSpecificPortionPart != null : !this$operatingHospitalSpecificPortionPart.equals(other$operatingHospitalSpecificPortionPart)) return false;
    final java.lang.Object this$operatingIndirectMedicalEducationAmount = this.getOperatingIndirectMedicalEducationAmount();
    final java.lang.Object other$operatingIndirectMedicalEducationAmount = other.getOperatingIndirectMedicalEducationAmount();
    if (this$operatingIndirectMedicalEducationAmount == null ? other$operatingIndirectMedicalEducationAmount != null : !this$operatingIndirectMedicalEducationAmount.equals(other$operatingIndirectMedicalEducationAmount)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof AdditionalOperatingVariableData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $operatingBaseDrgPayment = this.getOperatingBaseDrgPayment();
    result = result * PRIME + ($operatingBaseDrgPayment == null ? 43 : $operatingBaseDrgPayment.hashCode());
    final java.lang.Object $operatingDisproportionateShareHospitalAmount = this.getOperatingDisproportionateShareHospitalAmount();
    result = result * PRIME + ($operatingDisproportionateShareHospitalAmount == null ? 43 : $operatingDisproportionateShareHospitalAmount.hashCode());
    final java.lang.Object $operatingDisproportionateShareHospitalRatio = this.getOperatingDisproportionateShareHospitalRatio();
    result = result * PRIME + ($operatingDisproportionateShareHospitalRatio == null ? 43 : $operatingDisproportionateShareHospitalRatio.hashCode());
    final java.lang.Object $operatingDollarThreshold = this.getOperatingDollarThreshold();
    result = result * PRIME + ($operatingDollarThreshold == null ? 43 : $operatingDollarThreshold.hashCode());
    final java.lang.Object $operatingFederalSpecificPortionPart = this.getOperatingFederalSpecificPortionPart();
    result = result * PRIME + ($operatingFederalSpecificPortionPart == null ? 43 : $operatingFederalSpecificPortionPart.hashCode());
    final java.lang.Object $operatingHospitalSpecificPortionPart = this.getOperatingHospitalSpecificPortionPart();
    result = result * PRIME + ($operatingHospitalSpecificPortionPart == null ? 43 : $operatingHospitalSpecificPortionPart.hashCode());
    final java.lang.Object $operatingIndirectMedicalEducationAmount = this.getOperatingIndirectMedicalEducationAmount();
    result = result * PRIME + ($operatingIndirectMedicalEducationAmount == null ? 43 : $operatingIndirectMedicalEducationAmount.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "AdditionalOperatingVariableData(operatingBaseDrgPayment=" + this.getOperatingBaseDrgPayment() + ", operatingDisproportionateShareHospitalAmount=" + this.getOperatingDisproportionateShareHospitalAmount() + ", operatingDisproportionateShareHospitalRatio=" + this.getOperatingDisproportionateShareHospitalRatio() + ", operatingDollarThreshold=" + this.getOperatingDollarThreshold() + ", operatingFederalSpecificPortionPart=" + this.getOperatingFederalSpecificPortionPart() + ", operatingHospitalSpecificPortionPart=" + this.getOperatingHospitalSpecificPortionPart() + ", operatingIndirectMedicalEducationAmount=" + this.getOperatingIndirectMedicalEducationAmount() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public AdditionalOperatingVariableData() {
  }
}
