/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf;

import gov.cms.fiss.pricers.common.application.OpenApiPricerApplication;
import gov.cms.fiss.pricers.common.application.contract.OpenApiCustomizer;
import gov.cms.fiss.pricers.common.application.resources.CbsaWageIndexResource;
import gov.cms.fiss.pricers.irf.IrfPricerConfiguration;
import gov.cms.fiss.pricers.irf.core.IrfPricerDispatch;
import gov.cms.fiss.pricers.irf.resources.IrfClaimPricingResource;
import gov.cms.fiss.pricers.irf.resources.IrfExtractionUtil;
import io.dropwizard.setup.Environment;
import io.swagger.v3.oas.models.info.Info;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class IrfPricerApplication
extends OpenApiPricerApplication<IrfPricerConfiguration> {
    public static void main(String[] args) throws Exception {
        new IrfPricerApplication().run(args);
    }

    @Override
    protected void configureApplication(IrfPricerConfiguration configuration, Environment environment) {
        IrfClaimPricingResource v2Resource = new IrfClaimPricingResource(new IrfPricerDispatch(configuration));
        environment.jersey().register(v2Resource);
        environment.jersey().register(new CbsaWageIndexResource(configuration, IrfExtractionUtil.CBSA_EXTRACTOR));
    }

    @Override
    protected List<OpenApiCustomizer> getContractCustomizers() {
        ArrayList<OpenApiCustomizer> customizers = new ArrayList<OpenApiCustomizer>(super.getContractCustomizers());
        customizers.add((configuration, environment, oas) -> oas.info(new Info().title("IRF Pricer").version("v1")));
        return customizers;
    }

    @Override
    public String getName() {
        return "irf-pricer";
    }

    @Override
    protected List<Package> getResourcePackages() {
        return Collections.singletonList(IrfClaimPricingResource.class.getPackage());
    }

    @Override
    protected Map<Integer, String> getCalculationVersions() {
        return Map.ofEntries(Map.entry(2015, "2015.0"), Map.entry(2016, "2016.0"), Map.entry(2017, "2017.0"), Map.entry(2018, "2018.0"), Map.entry(2019, "2019.0"), Map.entry(2020, "2020.1"), Map.entry(2021, "2021.0"), Map.entry(2022, "2022.0"), Map.entry(2023, "2023.0"), Map.entry(2024, "2024.2"), Map.entry(2025, "2025.0"));
    }
}

