/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import lombok.Generated;

@Schema(description="The claim information associated with the request.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="BILL-NEW-DATA", value="<structure>")})})
public class IrfClaimData
extends ClaimData {
    @NotNull
    @Pattern(regexp="[A-D]\\d{4}", message="must be `A`, `B`, `C` or `D` followed by four digits")
    @Schema(description="The case-mix group (CMG) code.", example="C2004", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-CMG-CODE", value="PIC X(05)")})})
    private @NotNull @Pattern(regexp="[A-D]\\d{4}", message="must be `A`, `B`, `C` or `D` followed by four digits") String caseMixGroup;
    @BigDecimalScale
    @DecimalMax(value="9999999.99")
    @DecimalMin(value="0")
    @Digits(integer=7, fraction=2)
    @NotNull
    @Schema(description="The charges covered by the claim.", example="52332.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-COV-CHARGES", value="PIC 9(07)V9(02)")})})
    private @DecimalMax(value="9999999.99") @DecimalMin(value="0") @Digits(integer=7, fraction=2) @NotNull BigDecimal coveredCharges;
    @Max(value=999L)
    @Min(value=0L)
    @Schema(description="The covered days.", example="20", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-COV-DAYS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) int coveredDays;
    @NotNull
    @Schema(description="The discharge date of the claim request.", example="2021-05-13", format="yyyy-MM-dd", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-DISHCARGE-DATE", value="B-DISCHG-CC  PIC 9(02)\nB-DISCHG-YY  PIC 9(02)\nB-DISCHG-MM  PIC 9(02)\nB-DISCHG-DD  PIC 9(02)")})})
    @StrictLocalDate
    private LocalDate dischargeDate;
    @Max(value=999L)
    @Min(value=0L)
    @Schema(description="The length of stay (LOS).", example="5", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-LOS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) int lengthOfStay;
    @Max(value=99L)
    @Min(value=0L)
    @Schema(description="The lifetime reserve (LTR) days.", example="12", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-LTR-DAYS", value="PIC 9(02)")})})
    private @Max(value=99L) @Min(value=0L) int lifetimeReserveDays;
    @Pattern(regexp="\\d", message="must be one digit")
    @Schema(description="The outlier special payment indicator.", example="1", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-SPEC-PAY-IND", value="PIC X(01)")})})
    private @Pattern(regexp="\\d", message="must be one digit") String outlierSpecialPaymentIndicator;
    @NotNull
    @Pattern(regexp="\\d{2}", message="must be 2 digits")
    @Schema(description="The patient status.", example="02", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="B-PATIENT-STATUS", value="PIC X(02)")})})
    private @NotNull @Pattern(regexp="\\d{2}", message="must be 2 digits") String patientStatus;

    @Generated
    public String getCaseMixGroup() {
        return this.caseMixGroup;
    }

    @Generated
    public BigDecimal getCoveredCharges() {
        return this.coveredCharges;
    }

    @Generated
    public int getCoveredDays() {
        return this.coveredDays;
    }

    @Generated
    public LocalDate getDischargeDate() {
        return this.dischargeDate;
    }

    @Generated
    public int getLengthOfStay() {
        return this.lengthOfStay;
    }

    @Generated
    public int getLifetimeReserveDays() {
        return this.lifetimeReserveDays;
    }

    @Generated
    public String getOutlierSpecialPaymentIndicator() {
        return this.outlierSpecialPaymentIndicator;
    }

    @Generated
    public String getPatientStatus() {
        return this.patientStatus;
    }

    @Generated
    public void setCaseMixGroup(String caseMixGroup) {
        this.caseMixGroup = caseMixGroup;
    }

    @Generated
    public void setCoveredCharges(BigDecimal coveredCharges) {
        this.coveredCharges = coveredCharges;
    }

    @Generated
    public void setCoveredDays(int coveredDays) {
        this.coveredDays = coveredDays;
    }

    @Generated
    public void setDischargeDate(LocalDate dischargeDate) {
        this.dischargeDate = dischargeDate;
    }

    @Generated
    public void setLengthOfStay(int lengthOfStay) {
        this.lengthOfStay = lengthOfStay;
    }

    @Generated
    public void setLifetimeReserveDays(int lifetimeReserveDays) {
        this.lifetimeReserveDays = lifetimeReserveDays;
    }

    @Generated
    public void setOutlierSpecialPaymentIndicator(String outlierSpecialPaymentIndicator) {
        this.outlierSpecialPaymentIndicator = outlierSpecialPaymentIndicator;
    }

    @Generated
    public void setPatientStatus(String patientStatus) {
        this.patientStatus = patientStatus;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IrfClaimData)) {
            return false;
        }
        IrfClaimData other = (IrfClaimData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCoveredDays() != other.getCoveredDays()) {
            return false;
        }
        if (this.getLengthOfStay() != other.getLengthOfStay()) {
            return false;
        }
        if (this.getLifetimeReserveDays() != other.getLifetimeReserveDays()) {
            return false;
        }
        String this$caseMixGroup = this.getCaseMixGroup();
        String other$caseMixGroup = other.getCaseMixGroup();
        if (this$caseMixGroup == null ? other$caseMixGroup != null : !this$caseMixGroup.equals(other$caseMixGroup)) {
            return false;
        }
        BigDecimal this$coveredCharges = this.getCoveredCharges();
        BigDecimal other$coveredCharges = other.getCoveredCharges();
        if (this$coveredCharges == null ? other$coveredCharges != null : !((Object)this$coveredCharges).equals(other$coveredCharges)) {
            return false;
        }
        LocalDate this$dischargeDate = this.getDischargeDate();
        LocalDate other$dischargeDate = other.getDischargeDate();
        if (this$dischargeDate == null ? other$dischargeDate != null : !((Object)this$dischargeDate).equals(other$dischargeDate)) {
            return false;
        }
        String this$outlierSpecialPaymentIndicator = this.getOutlierSpecialPaymentIndicator();
        String other$outlierSpecialPaymentIndicator = other.getOutlierSpecialPaymentIndicator();
        if (this$outlierSpecialPaymentIndicator == null ? other$outlierSpecialPaymentIndicator != null : !this$outlierSpecialPaymentIndicator.equals(other$outlierSpecialPaymentIndicator)) {
            return false;
        }
        String this$patientStatus = this.getPatientStatus();
        String other$patientStatus = other.getPatientStatus();
        return !(this$patientStatus == null ? other$patientStatus != null : !this$patientStatus.equals(other$patientStatus));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IrfClaimData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCoveredDays();
        result = result * 59 + this.getLengthOfStay();
        result = result * 59 + this.getLifetimeReserveDays();
        String $caseMixGroup = this.getCaseMixGroup();
        result = result * 59 + ($caseMixGroup == null ? 43 : $caseMixGroup.hashCode());
        BigDecimal $coveredCharges = this.getCoveredCharges();
        result = result * 59 + ($coveredCharges == null ? 43 : ((Object)$coveredCharges).hashCode());
        LocalDate $dischargeDate = this.getDischargeDate();
        result = result * 59 + ($dischargeDate == null ? 43 : ((Object)$dischargeDate).hashCode());
        String $outlierSpecialPaymentIndicator = this.getOutlierSpecialPaymentIndicator();
        result = result * 59 + ($outlierSpecialPaymentIndicator == null ? 43 : $outlierSpecialPaymentIndicator.hashCode());
        String $patientStatus = this.getPatientStatus();
        result = result * 59 + ($patientStatus == null ? 43 : $patientStatus.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "IrfClaimData(caseMixGroup=" + this.getCaseMixGroup() + ", coveredCharges=" + this.getCoveredCharges() + ", coveredDays=" + this.getCoveredDays() + ", dischargeDate=" + this.getDischargeDate() + ", lengthOfStay=" + this.getLengthOfStay() + ", lifetimeReserveDays=" + this.getLifetimeReserveDays() + ", outlierSpecialPaymentIndicator=" + this.getOutlierSpecialPaymentIndicator() + ", patientStatus=" + this.getPatientStatus() + ")";
    }

    @Generated
    public IrfClaimData() {
    }
}

