/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateTeachPercent
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        BigDecimal capitalIndirectMedicalEducationRatio = providerData.getCapitalIndirectMedicalEducationRatio();
        if (capitalIndirectMedicalEducationRatio == null) {
            capitalIndirectMedicalEducationRatio = BigDecimal.ZERO;
        }
        calculationContext.setTeachPercent(BigDecimalUtils.pow(capitalIndirectMedicalEducationRatio.add(BigDecimal.ONE), calculationContext.getCalcTeach(), 10).subtract(BigDecimal.ONE).setScale(4, RoundingMode.HALF_UP));
    }
}

