/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules.bill_review;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class AdjustBlendedRates
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        if (LocalDateUtils.isAfter(calculationContext.getProviderFiscalYearBegin(), calculationContext.getClaimDischargeDate())) {
            calculationContext.applyResultCode(ResultCode.DISCHRG_PRIOR_TO_PROV_FY_73);
            return;
        }
        if (StringUtils.equals(calculationContext.getPpsBlendIndicator(), "4")) {
            paymentData.setFederalRatePercent(IrfPricerContext.FEDERAL_RATE_FULL.setScale(4, RoundingMode.HALF_UP));
            paymentData.setFacilityRatePercent(IrfPricerContext.FACILITY_RATE_0.setScale(4, RoundingMode.HALF_UP));
        } else if (StringUtils.equals(calculationContext.getPpsBlendIndicator(), "3")) {
            paymentData.setFederalRatePercent(IrfPricerContext.FEDERAL_RATE_TWO_THIRDS.setScale(4, RoundingMode.HALF_UP));
            paymentData.setFacilityRatePercent(IrfPricerContext.FACILITY_RATE_ONE_THIRD.setScale(4, RoundingMode.HALF_UP));
        } else {
            calculationContext.applyResultCode(ResultCode.INVALID_BLEND_IND_72);
        }
    }
}

