/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules.rules2020;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class Irf2020CalculateStandardPayment
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        if (calculationContext.isTransferCase()) {
            paymentData.setStandardPayment(BigDecimalUtils.truncateDecimals(paymentData.getBudgetNeutralityConversionAmount().divide(BigDecimal.valueOf(paymentData.getAverageLengthOfStay()), 4, RoundingMode.DOWN).multiply(BigDecimal.valueOf((double)paymentData.getLengthOfStay() + 0.5)).multiply(paymentData.getCaseMixGroupRelativeWeight())));
        } else {
            paymentData.setStandardPayment(BigDecimalUtils.truncateDecimals(paymentData.getCaseMixGroupRelativeWeight().multiply(paymentData.getBudgetNeutralityConversionAmount())));
        }
    }
}

