/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules.rules2020.finalize_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import java.math.BigDecimal;

public class Irf2020UpdateResultCode
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        if (BigDecimalUtils.equals(BigDecimal.ONE, paymentData.getFederalRatePercent())) {
            if (!calculationContext.isTransferCase()) {
                if (BigDecimalUtils.isGreaterThanZero(paymentData.getOutlierPayment())) {
                    calculationContext.applyResultCode(ResultCode.CMG_PAYMENT_OUTLIER_01);
                }
            } else if (BigDecimalUtils.isGreaterThanZero(paymentData.getOutlierPayment())) {
                calculationContext.applyResultCode(ResultCode.TRANSFER_PAID_OUTLIER_03);
            } else {
                calculationContext.applyResultCode(ResultCode.TRANSFER_PAID_NO_OUTLIER_02);
            }
        } else if (!calculationContext.isTransferCase()) {
            if (BigDecimalUtils.isGreaterThanZero(paymentData.getOutlierPayment())) {
                calculationContext.applyResultCode(ResultCode.BLEND_CMG_PAY_OUTLIER_05);
            } else {
                calculationContext.applyResultCode(ResultCode.BLEND_CMG_PAY_NO_OUTLIER_04);
            }
        } else if (BigDecimalUtils.isGreaterThanZero(paymentData.getOutlierPayment())) {
            calculationContext.applyResultCode(ResultCode.BLEND_TRNSFR_PAY_OUTLIER_07);
        } else {
            calculationContext.applyResultCode(ResultCode.BLEND_TRNSFR_PAY_NO_OUTLIER_06);
        }
    }
}

