/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.optional;

import io.dropwizard.jersey.optional.EmptyOptionalException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.glassfish.jersey.message.MessageBodyWorkers;

@Provider
@Produces(value={"*/*"})
public class OptionalMessageBodyWriter
implements MessageBodyWriter<Optional<?>> {
    @Inject
    @Nullable
    private javax.inject.Provider<MessageBodyWorkers> mbw;

    @Override
    public long getSize(Optional<?> entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return 0L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Optional.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(Optional<?> entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        Object entityObj = entity.orElseThrow(() -> EmptyOptionalException.INSTANCE);
        Class<?> innerGenericType = genericType instanceof ParameterizedType ? ((ParameterizedType)genericType).getActualTypeArguments()[0] : entityObj.getClass();
        MessageBodyWriter<?> writer = Objects.requireNonNull(this.mbw).get().getMessageBodyWriter(entityObj.getClass(), innerGenericType, annotations, mediaType);
        writer.writeTo(entityObj, entityObj.getClass(), innerGenericType, annotations, mediaType, httpHeaders, entityStream);
    }
}

