/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.Deque;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.opentest4j.AssertionFailedError;

class AssertionUtils {
    private AssertionUtils() {
    }

    static void fail() {
        throw new AssertionFailedError();
    }

    static void fail(String message) {
        throw new AssertionFailedError(message);
    }

    static void fail(String message, Throwable cause) {
        throw new AssertionFailedError(message, cause);
    }

    static void fail(Throwable cause) {
        throw new AssertionFailedError(null, cause);
    }

    static void fail(Supplier<String> messageSupplier) {
        throw new AssertionFailedError(AssertionUtils.nullSafeGet(messageSupplier));
    }

    static String nullSafeGet(Supplier<String> messageSupplier) {
        return messageSupplier != null ? messageSupplier.get() : null;
    }

    static String getCanonicalName(Class<?> clazz) {
        try {
            String canonicalName = clazz.getCanonicalName();
            return canonicalName != null ? canonicalName : clazz.getName();
        }
        catch (Throwable t2) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(t2);
            return clazz.getName();
        }
    }

    static String formatIndexes(Deque<Integer> indexes) {
        if (indexes == null || indexes.isEmpty()) {
            return "";
        }
        String indexesString = indexes.stream().map(Object::toString).collect(Collectors.joining("][", "[", "]"));
        return " at index " + indexesString;
    }

    static boolean floatsAreEqual(float value1, float value2, float delta) {
        AssertionUtils.assertValidDelta(delta);
        return AssertionUtils.floatsAreEqual(value1, value2) || Math.abs(value1 - value2) <= delta;
    }

    static void assertValidDelta(float delta) {
        if (Float.isNaN(delta) || (double)delta < 0.0) {
            AssertionUtils.failIllegalDelta(String.valueOf(delta));
        }
    }

    static void assertValidDelta(double delta) {
        if (Double.isNaN(delta) || delta < 0.0) {
            AssertionUtils.failIllegalDelta(String.valueOf(delta));
        }
    }

    static boolean floatsAreEqual(float value1, float value2) {
        return Float.floatToIntBits(value1) == Float.floatToIntBits(value2);
    }

    static boolean doublesAreEqual(double value1, double value2, double delta) {
        AssertionUtils.assertValidDelta(delta);
        return AssertionUtils.doublesAreEqual(value1, value2) || Math.abs(value1 - value2) <= delta;
    }

    static boolean doublesAreEqual(double value1, double value2) {
        return Double.doubleToLongBits(value1) == Double.doubleToLongBits(value2);
    }

    static boolean objectsAreEqual(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }

    private static void failIllegalDelta(String delta) {
        AssertionUtils.fail("positive delta expected but was: <" + delta + ">");
    }
}

