/*
 * Decompiled with CFR 0.152.
 */
package org.zalando.problem;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.zalando.problem.Exceptional;
import org.zalando.problem.Problem;
import org.zalando.problem.spi.StackTraceProcessor;

@API(status=API.Status.STABLE)
public abstract class ThrowableProblem
extends RuntimeException
implements Problem,
Exceptional {
    protected ThrowableProblem() {
        this((ThrowableProblem)null);
    }

    protected ThrowableProblem(@Nullable ThrowableProblem cause) {
        super(cause);
        Collection<StackTraceElement> stackTrace = StackTraceProcessor.COMPOUND.process(Arrays.asList(this.getStackTrace()));
        this.setStackTrace(stackTrace.toArray(new StackTraceElement[0]));
    }

    @Override
    public String getMessage() {
        return Stream.of(this.getTitle(), this.getDetail()).filter(Objects::nonNull).collect(Collectors.joining(": "));
    }

    @Override
    public ThrowableProblem getCause() {
        return (ThrowableProblem)super.getCause();
    }

    @Override
    public String toString() {
        return Problem.toString(this);
    }
}

