// Generated by delombok at Thu Dec 19 19:42:26 UTC 2024
package gov.cms.fiss.pricers.irf.core;

import gov.cms.fiss.pricers.common.api.InternalPricerException;
import gov.cms.fiss.pricers.common.api.YearNotImplementedException;
import gov.cms.fiss.pricers.common.application.ClaimProcessor;
import gov.cms.fiss.pricers.common.application.PricerDispatch;
import gov.cms.fiss.pricers.irf.IrfPricerConfiguration;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.core.tables.DataTables;

public class IrfPricerDispatch extends PricerDispatch<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerConfiguration> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger LOGGER = org.slf4j.LoggerFactory.getLogger(IrfPricerDispatch.class);

  public IrfPricerDispatch(IrfPricerConfiguration pricerConfiguration) {
    super(pricerConfiguration, o -> o.getReturnCodeData().getCode());
  }

  @Override
  protected void initializeReferences(IrfPricerConfiguration pricerConfiguration) {
    DataTables.loadDataTables(pricerConfiguration);
    for (final int supportedYear : pricerConfiguration.getSupportedYears()) {
      switch (supportedYear) {
      default: 
        yearReference.register(supportedYear, Irf2015RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Irf2016RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Irf2017RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Irf2018RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Irf2019RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Irf2020RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Irf2021RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Irf2022RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Irf2023RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Irf2024RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        yearReference.register(supportedYear, Irf2025RulePricer.class, DataTables.forYear(supportedYear));
        break;
      default: 
        break;
      }
    }
  }

  @Override
  protected ClaimProcessor<IrfClaimPricingRequest, IrfClaimPricingResponse> getProcessor(IrfClaimPricingRequest input) throws YearNotImplementedException, InternalPricerException {
    return yearReference.fromFiscalYear(input.getClaimData().getDischargeDate(), "dischargeDate");
  }

  @Override
  protected boolean isErrorOutput(IrfClaimPricingResponse output) {
    final int code = Integer.parseInt(output.getReturnCodeData().getCode());
    return ResultCode.fromCode(code).isError();
  }
}
