// Generated by delombok at Thu Dec 19 19:42:26 UTC 2024
package gov.cms.fiss.pricers.irf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.irf.IrfPricerConfiguration;
import java.time.LocalDate;
import java.util.Map;
import java.util.Map.Entry;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;

public class DataTables {
  private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<>();
  /**
   * Corresponds to {@code CBSA-WI-TABLE} lookup table from the COBOL source.
   */
  private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
  /**
   * Corresponds to {@code CMG-TABLE-DATA} lookup table from the COBOL source.
   */
  private final Map<String, CmgTableEntry> cmgTable;

  public DataTables(Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable, Map<String, CmgTableEntry> cmgTable) {
    this.cbsaTable = cbsaTable;
    this.cmgTable = cmgTable;
  }

  public static DataTables forYear(int pricerYear) {
    return YEAR_LOOKUP.get(pricerYear);
  }

  /**
   * Loads data tables.
   *
   * @param pricerConfiguration the pricer configuration to use
   */
  public static void loadDataTables(IrfPricerConfiguration pricerConfiguration) {
    final CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
    final CbsaWageIndexLookupGenerator cbsaLookupProvider = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
    final CmgTableEntryLookupGenerator cmgTableEntryLookupGenerator = new CmgTableEntryLookupGenerator(csvIngestionConfiguration);
    // Load all the tables
    for (final int pricerYear : pricerConfiguration.getSupportedYears()) {
      YEAR_LOOKUP.put(pricerYear, new DataTables(cbsaLookupProvider.generate(pricerYear), cmgTableEntryLookupGenerator.generate(pricerYear)));
    }
  }

  public CbsaWageIndexEntry getCbsaWageIndexEntry(String cbsa, LocalDate effectiveDate) {
    final NavigableMap<LocalDate, CbsaWageIndexEntry> entries = cbsaTable.get(cbsa);
    if (entries != null) {
      final Entry<LocalDate, CbsaWageIndexEntry> entry = entries.floorEntry(effectiveDate);
      return null == entry ? null : entry.getValue();
    }
    return null;
  }

  public CmgTableEntry getCmgEntry(String cmgCode) {
    return this.cmgTable.get(cmgCode);
  }

  /**
   * Corresponds to {@code CBSA-WI-TABLE} lookup table from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
    return this.cbsaTable;
  }
}
