/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.AbstractDiagnosisCode;
import com.mmm.cms.homehealth.EtiologyPairsList;
import com.mmm.cms.homehealth.proto.CodeType_EN;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosticGroupIF;
import com.mmm.cms.homehealth.proto.EtiologyPairingListIF;
import java.util.List;

public class DiagnosisCode
extends AbstractDiagnosisCode
implements DiagnosisCodeIF,
Cloneable {
    protected boolean secondaryOnly;
    protected transient boolean primary;
    protected transient EtiologyPairsList etiologyPairCodes;
    protected int offset;
    protected boolean primaryAwardableCode;

    public DiagnosisCode() {
    }

    public DiagnosisCode(String code, CodeType_EN codeType) {
        super(code, codeType);
    }

    public DiagnosisCode(String code) {
        super(code, CodeType_EN.ICD_9);
    }

    public DiagnosisCode(String code, boolean validCode, boolean validForScoring) {
        super(code, CodeType_EN.ICD_9, validCode, validForScoring);
    }

    public DiagnosisCode(String code, CodeType_EN codetype, boolean validCode, boolean validForScoring) {
        super(code, codetype, validCode, validForScoring);
    }

    @Override
    public DiagnosisCodeIF clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public EtiologyPairingListIF getEtiologyPairCodes() {
        if (this.etiologyPairCodes == null) {
            this.etiologyPairCodes = new EtiologyPairsList();
        }
        return this.etiologyPairCodes;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public boolean isSecondaryOnly() {
        return this.secondaryOnly;
    }

    @Override
    public boolean isPrimary() {
        return this.primary;
    }

    @Override
    public boolean isPrimaryAwardableCode() {
        return this.primaryAwardableCode;
    }

    @Override
    public boolean isDiabeticUlcer() {
        DiagnosticGroupIF group = this.getDiagnosticGroup();
        return group != null && "Diabetic Ulcers".equals(group.getDescription());
    }

    @Override
    public boolean isUlcer() {
        DiagnosticGroupIF group = this.getDiagnosticGroup();
        return group != null && "Non-pressure and non-stasis ulcers (other than diabetic)".equals(group.getDescription());
    }

    @Override
    public boolean isEtiologyInPairingList(DiagnosisCodeIF code) {
        return this.etiologyPairCodes != null && this.etiologyPairCodes.size() > 0 && code != null && !code.isEmpty() && this.etiologyPairCodes.contains(code);
    }

    @Override
    public boolean isValidEtiologyPairing(DiagnosisCodeIF etiologyCode) {
        return this.etiologyPairCodes != null ? this.etiologyPairCodes.isValidEtiologyPairing(etiologyCode) : false;
    }

    @Override
    public void setEtiologyPairCodes(List<DiagnosisCodeIF> pairs) {
        this.etiologyPairCodes.addAll(pairs);
    }

    @Override
    public void setDiabeticUlcer(boolean diabeticUlcer) {
        throw new UnsupportedOperationException("Diabetic Ulcer is determined by the Diagnostic Group.");
    }

    @Override
    public void setOffset(int offset) {
        if (offset < 0 || offset > 17) {
            throw new IllegalArgumentException("setOffset() - value must be >= 0 and <= 17. Value is " + offset);
        }
        this.offset = offset;
    }

    @Override
    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    @Override
    public void setPrimaryAwardableCode(boolean primaryAwardableVCode) throws IllegalStateException {
        this.primaryAwardableCode = primaryAwardableVCode;
    }

    @Override
    public void setSecondaryOnly(boolean bool) {
        this.secondaryOnly = bool;
    }

    @Override
    public void setUlcer(boolean ulcer) {
        throw new UnsupportedOperationException("Ulcer is determined by the Diagnostic Group.");
    }

    @Override
    public String toStringFinest() {
        return "DiagnosisCode{{" + super.toStringFinest() + "}, secondaryOnly=" + this.secondaryOnly + ", primary=" + this.primary + ", etiologyPairCodes=" + this.etiologyPairCodes + '}';
    }
}

