/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.CaseMixAdjustmentItem;
import com.mmm.cms.homehealth.DiagnosisCode;
import com.mmm.cms.homehealth.DiagnosticGroup;
import com.mmm.cms.homehealth.proto.CaseMixAdjustmentItemIF;
import com.mmm.cms.homehealth.proto.DataManagerIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosticGroupIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.PointsScoringEquationsIF;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class GrouperDataManager
implements DataManagerIF {
    public static final String PROPERTY_MASTER_NAME_BASE_PATH = "master.base.path";
    public static final String PROPERTY_NAME_BASE_PATH_SUFFIX = "base.path";
    public static final String PROPERTY_INCLUDE_CODE_DESCRIPTIONS = "include.code.descriptions";
    public static String ICD_9_DIAGNOSIS_CODE_TABLENAME = "DiagnosisCodes.txt";
    public static String NRS_ICD_9_DIAGNOSIS_CODE_TABLENAME = "NRSDiagnosisCodes.txt";
    public static String DIAGNOSTIC_GROUP_TABLENAME = "DiagnosticGroup.txt";
    public static String NRS_DIAGNOSTIC_GROUP_TABLENAME = "NRSDiagnosticGroup.txt";
    public static String SCORING_CASEMIX_ADJUSTMENT_TABLENAME = "Scoring_CasemixAdjustments.txt";
    public static String NRSSCORING_CASEMIX_ADJUSTMENT_TABLENAME = "NRSScoring_CasemixAdjustments.txt";
    public static String DIAGNOSIS_ETIOLOGY_PAIRS = "DiagnosisEtiologyPairs.txt";
    public static String OPTIONAL_VCODES_TABLENAME = "OptionalVCodes.txt";
    private Map<String, DiagnosisCodeIF> diagnosisCodes;
    private Map<String, DiagnosisCodeIF> nrsDiagnosisCodes;
    private Map<Integer, DiagnosticGroupIF> diagnosticGroups;
    private Map<Integer, DiagnosticGroupIF> nrsDiagnosticGroups;
    private Map<Integer, CaseMixAdjustmentItemIF> caseMixAdjustments;
    private Map<Integer, CaseMixAdjustmentItemIF> nrsCaseMixAdjustments;
    private File basePath;
    private boolean includeDescriptions;
    private final Pattern splitPattern;
    protected HomeHealthGrouperIF homeHealthGrouper;

    public GrouperDataManager(HomeHealthGrouperIF homeHealthGrouper) {
        this.homeHealthGrouper = homeHealthGrouper;
        this.splitPattern = Pattern.compile("\\t");
        this.caseMixAdjustments = new HashMap<Integer, CaseMixAdjustmentItemIF>();
        this.nrsCaseMixAdjustments = new HashMap<Integer, CaseMixAdjustmentItemIF>();
    }

    @Override
    public DiagnosisCodeIF createDiagnosisCode(String code, boolean validCode, boolean validForScoring) {
        return new DiagnosisCode(code, validCode, validForScoring);
    }

    @Override
    public DiagnosticGroupIF createDiagnosticGroup(int id) {
        return new DiagnosticGroup(id);
    }

    @Override
    public List<DiagnosticGroupIF> getDiagnosticGroups() {
        Collection<DiagnosticGroupIF> collection = this.diagnosticGroups.values();
        ArrayList<DiagnosticGroupIF> groups = new ArrayList<DiagnosticGroupIF>(collection);
        Collections.sort(groups, new Comparator<DiagnosticGroupIF>(){

            @Override
            public int compare(DiagnosticGroupIF o1, DiagnosticGroupIF o2) {
                return o1.getId() - o2.getId();
            }
        });
        return groups;
    }

    @Override
    public List<DiagnosticGroupIF> getDiagnosticGroupsNRS() {
        Collection<DiagnosticGroupIF> collection = this.nrsDiagnosticGroups.values();
        ArrayList<DiagnosticGroupIF> groups = new ArrayList<DiagnosticGroupIF>(collection);
        Collections.sort(groups, new Comparator<DiagnosticGroupIF>(){

            @Override
            public int compare(DiagnosticGroupIF o1, DiagnosticGroupIF o2) {
                return o1.getId() - o2.getId();
            }
        });
        return groups;
    }

    protected String getBasePathName(Properties properties) {
        String tmpStr = properties.getProperty(this.homeHealthGrouper.getClass().getName() + "." + PROPERTY_NAME_BASE_PATH_SUFFIX);
        if (tmpStr == null) {
            tmpStr = ".";
        }
        return tmpStr;
    }

    public File getBasePath() {
        return this.basePath;
    }

    @Override
    public HomeHealthGrouperIF getHomeHealthGrouper() {
        return this.homeHealthGrouper;
    }

    @Override
    public DiagnosisCodeIF getNRSDiagnosisCode(String value) {
        return this.getDiagnosisCodeBase(this.nrsDiagnosisCodes, value);
    }

    @Override
    public DiagnosisCodeIF getDiagnosisCode(String value) {
        return this.getDiagnosisCodeBase(this.diagnosisCodes, value);
    }

    protected DiagnosisCodeIF getDiagnosisCodeBase(Map<String, DiagnosisCodeIF> codes, String value) {
        DiagnosisCodeIF code = codes.get(value);
        if (code != null) {
            try {
                code = code.clone();
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
            }
        }
        return code;
    }

    @Override
    public List<CaseMixAdjustmentItemIF> getCaseMixAdjustments() {
        return this.getCaseMixAdjustments_general(this.caseMixAdjustments);
    }

    protected final List<CaseMixAdjustmentItemIF> getCaseMixAdjustments_general(Map<Integer, CaseMixAdjustmentItemIF> table) {
        ArrayList<CaseMixAdjustmentItemIF> list = new ArrayList<CaseMixAdjustmentItemIF>(table.size());
        for (CaseMixAdjustmentItemIF casemix : table.values()) {
            list.add(new ReadOnlyCaseMix(casemix));
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 != o2) {
                    if (o1 != null) {
                        CaseMixAdjustmentItemIF caseMix1 = (CaseMixAdjustmentItemIF)o1;
                        if (o2 != null) {
                            CaseMixAdjustmentItemIF caseMix2 = (CaseMixAdjustmentItemIF)o2;
                            return caseMix1.getId() - caseMix2.getId();
                        }
                        return 1;
                    }
                    return -1;
                }
                return 0;
            }
        });
        return list;
    }

    @Override
    public List<DiagnosisCodeIF> getClinicalCodes() {
        ArrayList<DiagnosisCodeIF> codes = new ArrayList<DiagnosisCodeIF>(this.diagnosisCodes.values());
        return codes;
    }

    @Override
    public DiagnosticGroupIF getDiagnosticGroup(long id) {
        DiagnosticGroupIF group = this.diagnosticGroups.get((int)id);
        if (group == null) {
            group = DiagnosticGroup.GROUP_UNKNOWN;
        }
        return group;
    }

    @Override
    public DiagnosticGroupIF getNRSDiagnosticGroup(long id) {
        DiagnosticGroupIF group = this.nrsDiagnosticGroups.get((int)id);
        if (group == null) {
            group = DiagnosticGroup.GROUP_UNKNOWN;
        }
        return group;
    }

    @Override
    public List<DiagnosisCodeIF> getNonRoutineCodes() {
        ArrayList<DiagnosisCodeIF> codes = new ArrayList<DiagnosisCodeIF>(this.nrsDiagnosisCodes.values());
        return codes;
    }

    @Override
    public CaseMixAdjustmentItemIF getNRSCaseMixAdjustment(int caseMixId) {
        return this.nrsCaseMixAdjustments.get(caseMixId);
    }

    @Override
    public List<CaseMixAdjustmentItemIF> getNRSCaseMixAdjustments() {
        return this.getCaseMixAdjustments_general(this.nrsCaseMixAdjustments);
    }

    @Override
    public Pattern getSplitPattern() {
        return this.splitPattern;
    }

    @Override
    public void init(Properties props) throws Exception, RemoteException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.log(Level.INFO, "init() - starting...");
        String tmpstr = this.getBasePathName(props);
        this.basePath = new File(tmpstr);
        tmpstr = props.getProperty(PROPERTY_INCLUDE_CODE_DESCRIPTIONS, "false");
        this.includeDescriptions = Boolean.parseBoolean(tmpstr);
        logger.log(Level.INFO, "HH-PPS: Loading configuration from base path: ''{0}''", this.basePath);
        logger.log(Level.INFO, "HH-PPS: Loading Diagnostic Groups");
        this.loadDiagnosticGroups();
        logger.log(Level.INFO, "HH-PPS: Loading Diagnosis Codes");
        this.loadDiagnosisCodes();
        logger.log(Level.INFO, "HH-PPS: Loading Case Mix Adujustments");
        this.loadCaseMixAdjustments();
        logger.log(Level.INFO, "HH-PPS: Loading NRS Diagnostic Groups");
        this.loadNRSDiagnosticGroups();
        logger.log(Level.INFO, "HH-PPS: Loading NRS Diagnosis Codes");
        this.loadNRSDiagnosisCodes();
        logger.log(Level.INFO, "HH-PPS: Loading NRS Case Mix Adujustments");
        this.loadNRSCaseMixAdjustments();
        logger.log(Level.INFO, "HH-PPS: Loading Optional Payment Codes");
        this.loadOptionalVCodes();
        logger.log(Level.INFO, "HH-PPS: init() - Done");
    }

    @Override
    public boolean isIncludeDescriptions() {
        return this.includeDescriptions;
    }

    protected void loadDiagnosticGroups() throws FileNotFoundException, IOException {
        File file = new File(this.basePath, DIAGNOSTIC_GROUP_TABLENAME);
        this.diagnosticGroups = new HashMap<Integer, DiagnosticGroupIF>();
        this.loadDiagnosticGroupsBase(file, this.diagnosticGroups);
    }

    protected void loadDiagnosisCodes() throws FileNotFoundException, IOException {
        File file = new File(this.basePath, ICD_9_DIAGNOSIS_CODE_TABLENAME);
        this.diagnosisCodes = new HashMap<String, DiagnosisCodeIF>();
        this.loadDiagnosisCodeBase(file, this.diagnosisCodes, false);
        this.loadEtiologyPairs(this.diagnosisCodes);
    }

    protected void loadDiagnosisCodeBase(File file, Map<String, DiagnosisCodeIF> codeHash, boolean isNrs) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "HH-PPS: Reading diagnosis file: {0}", file.getAbsolutePath());
            while ((line = reader.readLine()) != null) {
                String[] tokens = this.splitPattern.split(line, 0);
                if (tokens.length <= 1 || tokens[0].trim().toUpperCase().startsWith("DIAGNOS")) continue;
                DiagnosisCodeIF diag = this.createDiagnosisCode(tokens[0].trim(), true, true);
                switch (tokens.length) {
                    case 4: 
                    case 5: {
                        diag.setSecondaryOnly("M".equals(tokens[3].trim()));
                    }
                    case 3: {
                        if (!tokens[2].isEmpty()) {
                            diag.setDiagnosticGroup(isNrs ? this.getNRSDiagnosticGroup(Long.parseLong(tokens[2])) : this.getDiagnosticGroup(Long.parseLong(tokens[2])));
                        }
                    }
                    case 2: {
                        if (!this.includeDescriptions) break;
                        diag.setDescription(tokens[1]);
                    }
                }
                if (diag.getDiagnosticGroup().getId() == 0) {
                    diag.setValidForScoring(false);
                }
                codeHash.put(diag.getCode(), diag);
            }
        }
        catch (OutOfMemoryError o) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Out of memory");
        }
    }

    protected void loadNRSDiagnosisCodes() throws FileNotFoundException, IOException {
        File file = new File(this.basePath, NRS_ICD_9_DIAGNOSIS_CODE_TABLENAME);
        this.nrsDiagnosisCodes = new HashMap<String, DiagnosisCodeIF>();
        this.loadDiagnosisCodeBase(file, this.nrsDiagnosisCodes, true);
        this.loadEtiologyPairs(this.nrsDiagnosisCodes);
    }

    protected void loadNRSDiagnosticGroups() throws FileNotFoundException, IOException {
        this.nrsDiagnosticGroups = new HashMap<Integer, DiagnosticGroupIF>();
        File file = new File(this.basePath, NRS_DIAGNOSTIC_GROUP_TABLENAME);
        this.loadDiagnosticGroupsBase(file, this.nrsDiagnosticGroups);
    }

    protected void loadDiagnosticGroupsBase(File file, Map<Integer, DiagnosticGroupIF> groupHash) throws FileNotFoundException, IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            String[] tokens;
            if (line.isEmpty() || (tokens = this.splitPattern.split(line, 0))[0].trim().toUpperCase().startsWith("DIAGNOS")) continue;
            DiagnosticGroupIF diagGroup = this.createDiagnosticGroup(Integer.valueOf(tokens[0]));
            diagGroup.setDescription(tokens[1]);
            groupHash.put(diagGroup.hashCode(), diagGroup);
        }
    }

    public void loadCaseMixAdjustments() throws FileNotFoundException, IOException {
        String line;
        File file = new File(this.basePath, SCORING_CASEMIX_ADJUSTMENT_TABLENAME);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            String[] tokens = this.splitPattern.split(line);
            if (tokens[0].trim().toUpperCase().startsWith("ID")) continue;
            CaseMixAdjustmentItem caseMix = new CaseMixAdjustmentItem();
            caseMix.setId(Integer.valueOf(tokens[0]));
            caseMix.setName(tokens[1]);
            for (int idx = 2; idx < tokens.length; ++idx) {
                try {
                    caseMix.setAdjustment(idx - 1, Integer.parseInt(tokens[idx]));
                    continue;
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "HH-PPS: Loading CaseMixAdjustment: Equation " + idx + " contains invalid number of '" + tokens[idx] + "'", e);
                }
            }
            this.caseMixAdjustments.put(((Object)caseMix).hashCode(), caseMix);
        }
    }

    @Override
    public CaseMixAdjustmentItemIF getCaseMixAdjustment(int caseMixId) {
        return this.caseMixAdjustments.get(caseMixId);
    }

    public void loadNRSCaseMixAdjustments() throws FileNotFoundException, IOException {
        String line;
        File file = new File(this.basePath, NRSSCORING_CASEMIX_ADJUSTMENT_TABLENAME);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            String[] tokens = this.splitPattern.split(line);
            if (tokens[0].trim().toUpperCase().startsWith("ID")) continue;
            CaseMixAdjustmentItem caseMix = new CaseMixAdjustmentItem();
            caseMix.setId(Integer.valueOf(tokens[0]));
            caseMix.setName(tokens[1]);
            for (int idx = 2; idx < tokens.length; ++idx) {
                try {
                    caseMix.setAdjustment(idx - 1, Integer.parseInt(tokens[idx]));
                    continue;
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "HH-PPS: Loading NRSCaseMixAdjustment: Equation " + idx + " contains invalid number of '" + tokens[idx] + "'", e);
                }
            }
            this.nrsCaseMixAdjustments.put(((Object)caseMix).hashCode(), caseMix);
        }
    }

    public void loadEtiologyPairs(Map<String, DiagnosisCodeIF> dxCodes) throws FileNotFoundException, IOException {
        String line;
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (dxCodes == null || dxCodes.isEmpty()) {
            logger.log(Level.WARNING, "Etiology Pairs: Can not load pairs.  No list of Diagnosis codes exist.  Please Diagnosis codes first.");
        }
        HashMap<String, Boolean> errorReported = new HashMap<String, Boolean>();
        File file = new File(this.basePath, DIAGNOSIS_ETIOLOGY_PAIRS);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            String[] tokens = this.splitPattern.split(line);
            if (tokens.length != 2 || tokens[0].trim().toUpperCase().startsWith("DIAGNOS")) continue;
            DiagnosisCodeIF primaryCode = dxCodes.get(tokens[0]);
            if (primaryCode != null) {
                DiagnosisCodeIF pairedCode = dxCodes.get(tokens[1]);
                if (pairedCode == null) {
                    pairedCode = this.createDiagnosisCode(tokens[1], false, false);
                    if (errorReported.get(tokens[1]) == null) {
                        errorReported.put(tokens[1], Boolean.TRUE);
                        logger.log(Level.FINE, "HH-PPS: Etiology Pairs: Paired/secondary Diagnosis code not found or not valid: ''{0}''", tokens[1]);
                    }
                }
                primaryCode.getEtiologyPairCodes().add(pairedCode);
                continue;
            }
            if (errorReported.get(tokens[0]) != null) continue;
            errorReported.put(tokens[0], Boolean.TRUE);
            logger.log(Level.FINE, "HH-PPS: Etiology Pairs: Primary Diagnosis code not found or not valid: ''{0}''", tokens[0]);
        }
        if (errorReported.size() > 0) {
            logger.log(Level.WARNING, "HH-PPS: Etiology Pairs: Number of Missing/Invalid Diagnosis codes: {0}", errorReported.size());
        }
    }

    public void loadOptionalVCodes() throws FileNotFoundException, IOException {
        String line;
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (this.diagnosisCodes == null || this.diagnosisCodes.isEmpty()) {
            logger.log(Level.WARNING, "Optional Payment Code: Can not load.  No list of Diagnosis codes exist.  Please Diagnosis codes first.");
        }
        if (this.nrsDiagnosisCodes == null || this.nrsDiagnosisCodes.isEmpty()) {
            logger.log(Level.WARNING, "Optional Payment Code: Can not load.  No list of Diagnosis codes exist.  Please Diagnosis codes first.");
        }
        File file = new File(this.basePath, OPTIONAL_VCODES_TABLENAME);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            String[] tokens = this.splitPattern.split(line);
            if (tokens.length != 2) continue;
            DiagnosisCode code = (DiagnosisCode)this.diagnosisCodes.get(tokens[0]);
            if (code == null) {
                code = new DiagnosisCode(tokens[0], false, false);
                code.setDescription(tokens[1]);
            }
            code.setOptionalPaymentCode(true);
            this.diagnosisCodes.put(code.getCode(), code);
            code = (DiagnosisCode)this.nrsDiagnosisCodes.get(tokens[0]);
            if (code == null) {
                code = new DiagnosisCode(tokens[0], false, false);
                code.setDescription(tokens[1]);
            }
            code.setOptionalPaymentCode(true);
            this.nrsDiagnosisCodes.put(code.getCode(), code);
        }
    }

    public void setBasePath(File basePath) {
        this.basePath = basePath;
    }

    public void setHomeHealthGrouper(HomeHealthGrouperIF grouperVersion) {
        this.homeHealthGrouper = grouperVersion;
    }

    @Override
    public void setIncludeDescriptions(boolean includeDescriptions) {
        this.includeDescriptions = includeDescriptions;
    }

    class ReadOnlyCaseMix
    implements CaseMixAdjustmentItemIF {
        CaseMixAdjustmentItemIF item;

        public ReadOnlyCaseMix(CaseMixAdjustmentItemIF item) {
            this.item = item;
        }

        public String toString() {
            return this.item.toString();
        }

        public int hashCode() {
            return this.item.hashCode();
        }

        public boolean equals(Object obj) {
            return this.item.equals(obj);
        }

        @Override
        public String getName() {
            return this.item.getName();
        }

        @Override
        public int getId() {
            return this.item.getId();
        }

        @Override
        public int getLater14Plus() {
            return this.item.getLater14Plus();
        }

        @Override
        public int getLater13AndUnder() {
            return this.item.getLater13AndUnder();
        }

        @Override
        public int getEquationValue(int idx) {
            return this.item.getEquationValue(idx);
        }

        @Override
        public int getEarly14Plus() {
            return this.item.getEarly14Plus();
        }

        @Override
        public int getEarly13AndUnder() {
            return this.item.getEarly13AndUnder();
        }

        @Override
        public int getAdjustment(int equationId) {
            return this.item.getAdjustment(equationId);
        }

        @Override
        public void setAdjustment(int equationId, int value) {
        }

        @Override
        public void setEarly13AndUnder(int equation1) {
        }

        @Override
        public void setEarly14Plus(int equation2) {
        }

        @Override
        public void setId(int id) {
        }

        @Override
        public void setLater13AndUnder(int equation3) {
        }

        @Override
        public void setLater14Plus(int equation4) {
        }

        @Override
        public void setName(String Name) {
        }

        @Override
        public void add(PointsScoringEquationsIF points) {
        }

        @Override
        public void addToEarly13AndUnder(int equation) {
        }

        @Override
        public void addToEarly14Plus(int equation) {
        }

        @Override
        public void addToLater13AndUnder(int equation) {
        }

        @Override
        public void addToLater14Plus(int equation) {
        }

        @Override
        public void setEquationValue(int idx, int value) {
        }
    }
}

