/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.proto.HIPPSCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.PointsScoringEquationsIF;
import com.mmm.cms.util.ValidateUtils;

public class HIPPSCode
implements HIPPSCodeIF {
    private static final char BLANK = ' ';
    private static final boolean DEBUG;
    protected int groupingStep;
    protected int hippsScoringEquation;
    protected char clinicalSeverity;
    protected char functionalSeverity;
    protected char servicesUtilization;
    protected char nonRoutineSupplies;
    protected String timing;
    protected int therapyNeedNumber;

    public HIPPSCode() {
        this.setToBlank();
    }

    public HIPPSCode(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, PointsScoringEquationsIF clinicalScore, PointsScoringEquationsIF functionalScore, int nrsScore) {
        this.therapyNeedNumber = record.getTHER_NEED_NBR();
        this.timing = record.getEPISODE_TIMING();
        if (!(validator.isINFO_COMPLETED_DT_Valid() && validator.isASSMT_REASON_Valid() && validator.isTHER_NEED_Valid() && (ValidateUtils.isValidValue(this.timing, new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO}) || "UK".equals(this.timing)))) {
            this.setToBlank();
            if (DEBUG) {
                if (validator.isTHER_NEED_Valid()) {
                    this.clinicalSeverity = (char)87;
                }
                if (validator.isASSMT_REASON_Valid()) {
                    this.functionalSeverity = (char)88;
                }
                if (!ValidateUtils.isValidValue(this.timing, new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO}) && !"UK".equals(this.timing)) {
                    this.servicesUtilization = (char)89;
                }
                if (validator.isINFO_COMPLETED_DT_Valid()) {
                    this.nonRoutineSupplies = (char)90;
                }
            }
            return;
        }
        this.evaluateRecord(record, clinicalScore, functionalScore, nrsScore);
    }

    protected void evaluateRecord(HomeHealthRecordIF record, PointsScoringEquationsIF clinicalScore, PointsScoringEquationsIF functionalScore, int nrsScore) {
        if (this.determineStepEquation()) {
            this.determineClinicalSeverity(clinicalScore.getEquationValue(this.hippsScoringEquation - 1));
            this.determineFunctionalSeverity(functionalScore.getEquationValue(this.hippsScoringEquation - 1));
            this.determineServiceDomain();
            this.determineNrs(nrsScore);
        } else {
            this.setToBlank();
        }
    }

    @Override
    public char getClinicalSeverity() {
        return this.clinicalSeverity;
    }

    @Override
    public void setClinicalSeverity(char clinicalSeverity) {
        this.clinicalSeverity = clinicalSeverity;
    }

    @Override
    public char getFunctionalSeverity() {
        return this.functionalSeverity;
    }

    @Override
    public void setFunctionalSeverity(char functionalSeverity) {
        this.functionalSeverity = functionalSeverity;
    }

    @Override
    public int getGroupingStep() {
        return this.groupingStep;
    }

    @Override
    public void setGroupingStep(int groupingStep) {
        this.groupingStep = groupingStep;
    }

    @Override
    public char getNonRoutineSupplies() {
        return this.nonRoutineSupplies;
    }

    @Override
    public void setNonRoutineSupplies(char nonRoutineSupplies) {
        this.nonRoutineSupplies = nonRoutineSupplies;
    }

    @Override
    public char getServicesUtilization() {
        return this.servicesUtilization;
    }

    @Override
    public void setServicesUtilization(char servicesUtilization) {
        this.servicesUtilization = servicesUtilization;
    }

    @Override
    public String getCode() {
        StringBuilder buffer = new StringBuilder();
        if (this.groupingStep > 0) {
            buffer.append(this.groupingStep);
        } else {
            buffer.append(' ');
        }
        buffer.append(this.clinicalSeverity);
        buffer.append(this.functionalSeverity);
        buffer.append(this.servicesUtilization);
        buffer.append(this.nonRoutineSupplies);
        return buffer.toString();
    }

    protected final void setToBlank() {
        this.groupingStep = 0;
        this.hippsScoringEquation = 32;
        this.clinicalSeverity = (char)32;
        this.functionalSeverity = (char)32;
        this.servicesUtilization = (char)32;
        this.nonRoutineSupplies = (char)32;
    }

    public final String toString() {
        return this.getCode();
    }

    protected boolean determineStepEquation() {
        if ("01".equals(this.timing) || "UK".equals(this.timing)) {
            if (this.therapyNeedNumber <= 13) {
                this.hippsScoringEquation = 1;
                this.groupingStep = 1;
            } else {
                this.hippsScoringEquation = 2;
                this.groupingStep = this.therapyNeedNumber <= 19 ? 2 : 5;
            }
            return true;
        }
        if ("02".equals(this.timing)) {
            if (this.therapyNeedNumber <= 13) {
                this.hippsScoringEquation = 3;
                this.groupingStep = 3;
            } else {
                this.hippsScoringEquation = 4;
                this.groupingStep = this.therapyNeedNumber <= 19 ? 4 : 5;
            }
            return true;
        }
        return false;
    }

    protected void determineClinicalSeverity(int equationValue) {
        switch (this.groupingStep) {
            case 1: {
                if (equationValue <= 4) {
                    this.clinicalSeverity = (char)65;
                    break;
                }
                if (equationValue <= 8) {
                    this.clinicalSeverity = (char)66;
                    break;
                }
                this.clinicalSeverity = (char)67;
                break;
            }
            case 2: {
                if (equationValue <= 6) {
                    this.clinicalSeverity = (char)65;
                    break;
                }
                if (equationValue <= 14) {
                    this.clinicalSeverity = (char)66;
                    break;
                }
                this.clinicalSeverity = (char)67;
                break;
            }
            case 3: {
                if (equationValue <= 2) {
                    this.clinicalSeverity = (char)65;
                    break;
                }
                if (equationValue <= 5) {
                    this.clinicalSeverity = (char)66;
                    break;
                }
                this.clinicalSeverity = (char)67;
                break;
            }
            case 4: {
                if (equationValue <= 8) {
                    this.clinicalSeverity = (char)65;
                    break;
                }
                if (equationValue <= 16) {
                    this.clinicalSeverity = (char)66;
                    break;
                }
                this.clinicalSeverity = (char)67;
                break;
            }
            case 5: {
                this.clinicalSeverity = equationValue <= 7 ? (char)65 : (equationValue <= 14 ? (char)66 : (char)67);
            }
        }
    }

    public void determineFunctionalSeverity(int equationValue) {
        switch (this.groupingStep) {
            case 1: {
                if (equationValue <= 5) {
                    this.functionalSeverity = (char)70;
                    break;
                }
                if (equationValue == 6) {
                    this.functionalSeverity = (char)71;
                    break;
                }
                this.functionalSeverity = (char)72;
                break;
            }
            case 2: {
                if (equationValue <= 6) {
                    this.functionalSeverity = (char)70;
                    break;
                }
                if (equationValue == 7) {
                    this.functionalSeverity = (char)71;
                    break;
                }
                this.functionalSeverity = (char)72;
                break;
            }
            case 3: {
                if (equationValue <= 8) {
                    this.functionalSeverity = (char)70;
                    break;
                }
                if (equationValue == 9) {
                    this.functionalSeverity = (char)71;
                    break;
                }
                this.functionalSeverity = (char)72;
                break;
            }
            case 4: {
                if (equationValue <= 7) {
                    this.functionalSeverity = (char)70;
                    break;
                }
                if (equationValue == 8) {
                    this.functionalSeverity = (char)71;
                    break;
                }
                this.functionalSeverity = (char)72;
                break;
            }
            case 5: {
                this.functionalSeverity = equationValue <= 6 ? (char)70 : (equationValue == 7 ? (char)71 : (char)72);
            }
        }
    }

    protected void determineServiceDomain() {
        switch (this.groupingStep) {
            case 1: 
            case 3: {
                if (this.therapyNeedNumber <= 5) {
                    this.servicesUtilization = (char)75;
                    break;
                }
                if (this.therapyNeedNumber == 6) {
                    this.servicesUtilization = (char)76;
                    break;
                }
                if (this.therapyNeedNumber <= 9) {
                    this.servicesUtilization = (char)77;
                    break;
                }
                if (this.therapyNeedNumber == 10) {
                    this.servicesUtilization = (char)78;
                    break;
                }
                if (this.therapyNeedNumber <= 13) {
                    this.servicesUtilization = (char)80;
                    break;
                }
                this.servicesUtilization = (char)32;
                break;
            }
            case 2: 
            case 4: {
                if (this.therapyNeedNumber <= 15) {
                    this.servicesUtilization = (char)75;
                    break;
                }
                if (this.therapyNeedNumber <= 17) {
                    this.servicesUtilization = (char)76;
                    break;
                }
                if (this.therapyNeedNumber <= 19) {
                    this.servicesUtilization = (char)77;
                    break;
                }
                this.servicesUtilization = (char)32;
                break;
            }
            case 5: {
                this.servicesUtilization = (char)75;
            }
        }
    }

    protected void determineNrs(int nrsScore) {
        if (nrsScore > -1) {
            this.nonRoutineSupplies = nrsScore == 0 ? (char)83 : (nrsScore <= 14 ? (char)84 : (nrsScore <= 27 ? (char)85 : (nrsScore <= 48 ? (char)86 : (nrsScore <= 98 ? (char)87 : (char)88))));
        }
    }

    static {
        String str = System.getenv("home_health_hipps_debug");
        DEBUG = Boolean.parseBoolean(str);
    }
}

