/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.HIPPSCode;
import com.mmm.cms.homehealth.HIPPSThreshold;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.PointsScoringEquationsIF;
import java.util.ArrayList;
import java.util.List;

public class HIPPSCode_2016
extends HIPPSCode {
    public static final List<HIPPSThreshold> HIPPS_THRESHOLDS_CLINICAL = new ArrayList<HIPPSThreshold>();
    public static final List<HIPPSThreshold> HIPPS_THRESHOLDS_FUNCTIONAL;

    public HIPPSCode_2016() {
    }

    public HIPPSCode_2016(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, PointsScoringEquationsIF clinicalScore, PointsScoringEquationsIF functionalScore, int nrsScore) {
        super(record, validator, clinicalScore, functionalScore, nrsScore);
    }

    @Override
    protected void evaluateRecord(HomeHealthRecordIF record, PointsScoringEquationsIF clinicalScore, PointsScoringEquationsIF functionalScore, int nrsScore) {
        if (this.determineStepEquation()) {
            this.determineClinicalSeverity(clinicalScore.getEquationValue(this.hippsScoringEquation - 1));
            this.determineFunctionalSeverity(functionalScore.getEquationValue(this.hippsScoringEquation - 1));
            this.determineServiceDomain();
            this.determineNrs(nrsScore);
        } else {
            this.setToBlank();
        }
    }

    @Override
    protected void determineClinicalSeverity(int equationValue) {
        for (HIPPSThreshold threshold : HIPPS_THRESHOLDS_CLINICAL) {
            if (!threshold.getTimingValue().equals(this.timing) || this.therapyNeedNumber > threshold.getVisitsUpperLimit()) continue;
            this.clinicalSeverity = threshold.getHippsSeverityValue(equationValue);
            break;
        }
    }

    @Override
    public void determineFunctionalSeverity(int equationValue) {
        for (HIPPSThreshold threshold : HIPPS_THRESHOLDS_FUNCTIONAL) {
            if (!threshold.getTimingValue().equals(this.timing) || this.therapyNeedNumber > threshold.getVisitsUpperLimit()) continue;
            this.functionalSeverity = threshold.getHippsSeverityValue(equationValue);
            break;
        }
    }

    static {
        HIPPSThreshold threshold = new HIPPSThreshold("UK", 13, 1, 1);
        threshold.addSeverityLimit(0, 1, 'A');
        threshold.addSeverityLimit(2, 3, 'B');
        threshold.addSeverityLimit(4, 1000, 'C');
        HIPPS_THRESHOLDS_CLINICAL.add(threshold);
        threshold = new HIPPSThreshold("UK", 19, 2, 2);
        threshold.addSeverityLimit(0, 1, 'A');
        threshold.addSeverityLimit(2, 7, 'B');
        threshold.addSeverityLimit(8, 1000, 'C');
        HIPPS_THRESHOLDS_CLINICAL.add(threshold);
        threshold = new HIPPSThreshold("UK", 1000, 5, 2);
        threshold.addSeverityLimit(0, 3, 'A');
        threshold.addSeverityLimit(4, 16, 'B');
        threshold.addSeverityLimit(17, 1000, 'C');
        HIPPS_THRESHOLDS_CLINICAL.add(threshold);
        threshold = new HIPPSThreshold("01", 13, 1, 1);
        threshold.addSeverityLimit(0, 1, 'A');
        threshold.addSeverityLimit(2, 3, 'B');
        threshold.addSeverityLimit(4, 1000, 'C');
        HIPPS_THRESHOLDS_CLINICAL.add(threshold);
        threshold = new HIPPSThreshold("01", 19, 2, 2);
        threshold.addSeverityLimit(0, 1, 'A');
        threshold.addSeverityLimit(2, 7, 'B');
        threshold.addSeverityLimit(8, 1000, 'C');
        HIPPS_THRESHOLDS_CLINICAL.add(threshold);
        threshold = new HIPPSThreshold("01", 1000, 5, 2);
        threshold.addSeverityLimit(0, 3, 'A');
        threshold.addSeverityLimit(4, 16, 'B');
        threshold.addSeverityLimit(17, 1000, 'C');
        HIPPS_THRESHOLDS_CLINICAL.add(threshold);
        threshold = new HIPPSThreshold("02", 13, 3, 3);
        threshold.addSeverityLimit(0, 0, 'A');
        threshold.addSeverityLimit(1, 1, 'B');
        threshold.addSeverityLimit(2, 1000, 'C');
        HIPPS_THRESHOLDS_CLINICAL.add(threshold);
        threshold = new HIPPSThreshold("02", 19, 4, 4);
        threshold.addSeverityLimit(0, 3, 'A');
        threshold.addSeverityLimit(4, 12, 'B');
        threshold.addSeverityLimit(13, 1000, 'C');
        HIPPS_THRESHOLDS_CLINICAL.add(threshold);
        threshold = new HIPPSThreshold("02", 1000, 5, 4);
        threshold.addSeverityLimit(0, 3, 'A');
        threshold.addSeverityLimit(4, 16, 'B');
        threshold.addSeverityLimit(17, 1000, 'C');
        HIPPS_THRESHOLDS_CLINICAL.add(threshold);
        HIPPS_THRESHOLDS_FUNCTIONAL = new ArrayList<HIPPSThreshold>();
        threshold = new HIPPSThreshold("UK", 13, 1, 1);
        threshold.addSeverityLimit(0, 14, 'F');
        threshold.addSeverityLimit(15, 15, 'G');
        threshold.addSeverityLimit(16, 1000, 'H');
        HIPPS_THRESHOLDS_FUNCTIONAL.add(threshold);
        threshold = new HIPPSThreshold("UK", 19, 2, 2);
        threshold.addSeverityLimit(0, 6, 'F');
        threshold.addSeverityLimit(7, 13, 'G');
        threshold.addSeverityLimit(14, 1000, 'H');
        HIPPS_THRESHOLDS_FUNCTIONAL.add(threshold);
        threshold = new HIPPSThreshold("UK", 1000, 5, 2);
        threshold.addSeverityLimit(0, 2, 'F');
        threshold.addSeverityLimit(3, 6, 'G');
        threshold.addSeverityLimit(7, 1000, 'H');
        HIPPS_THRESHOLDS_FUNCTIONAL.add(threshold);
        threshold = new HIPPSThreshold("01", 13, 1, 1);
        threshold.addSeverityLimit(0, 14, 'F');
        threshold.addSeverityLimit(15, 15, 'G');
        threshold.addSeverityLimit(16, 1000, 'H');
        HIPPS_THRESHOLDS_FUNCTIONAL.add(threshold);
        threshold = new HIPPSThreshold("01", 19, 2, 2);
        threshold.addSeverityLimit(0, 6, 'F');
        threshold.addSeverityLimit(7, 13, 'G');
        threshold.addSeverityLimit(14, 1000, 'H');
        HIPPS_THRESHOLDS_FUNCTIONAL.add(threshold);
        threshold = new HIPPSThreshold("01", 1000, 5, 2);
        threshold.addSeverityLimit(0, 2, 'F');
        threshold.addSeverityLimit(3, 6, 'G');
        threshold.addSeverityLimit(7, 1000, 'H');
        HIPPS_THRESHOLDS_FUNCTIONAL.add(threshold);
        threshold = new HIPPSThreshold("02", 13, 3, 3);
        threshold.addSeverityLimit(0, 6, 'F');
        threshold.addSeverityLimit(7, 10, 'G');
        threshold.addSeverityLimit(11, 1000, 'H');
        HIPPS_THRESHOLDS_FUNCTIONAL.add(threshold);
        threshold = new HIPPSThreshold("02", 19, 4, 4);
        threshold.addSeverityLimit(0, 0, 'F');
        threshold.addSeverityLimit(1, 7, 'G');
        threshold.addSeverityLimit(8, 1000, 'H');
        HIPPS_THRESHOLDS_FUNCTIONAL.add(threshold);
        threshold = new HIPPSThreshold("02", 1000, 5, 4);
        threshold.addSeverityLimit(0, 2, 'F');
        threshold.addSeverityLimit(3, 6, 'G');
        threshold.addSeverityLimit(7, 1000, 'H');
        HIPPS_THRESHOLDS_FUNCTIONAL.add(threshold);
    }
}

