/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v2308_1;

import com.mmm.cms.homehealth.DataValidityFlag;
import com.mmm.cms.homehealth.proto.DataValidityFlagIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecord_B_IF;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.util.ScoringEventFormatter;
import com.mmm.cms.util.ValidateUtils;
import java.util.Collection;

public abstract class AbstractBaseValidator_v2308
implements HomeHealthRecordValidatorIF {
    public static final String[] ASSESSMENT_REASON_VALUES = new String[]{"01", "03", "04", "05"};
    public static final String[] ASSESSMENT_1_3_ONLY = new String[]{"01", "03"};
    public static final String[] ASSESSMENT_4_5_ONLY = new String[]{"04", "05"};
    protected boolean ASSMT_REASON_INVLD;
    protected boolean INFO_COMPLETED_DT_INVLD;
    protected boolean THERAPIES_INVLD;
    protected boolean INTERNAL_LOGIC_INVLD;
    protected boolean VISION_INVLD;
    protected boolean PAIN_INVLD;
    protected boolean LESION_INVLD;
    protected boolean NPRSULC1_INVLD;
    protected boolean NPRSULC2_INVLD;
    protected boolean NPRSULC3_INVLD;
    protected boolean NPRSULC4_INVLD;
    protected boolean UNOBS_PRSULC_INVLD;
    protected boolean STGPRSUL_INVLD;
    protected boolean NBR_STASULC_INVLD;
    protected boolean UNOBS_STASULC_INVLD;
    protected boolean STATSTASIS_INVLD;
    protected boolean STATSURG_INVLD;
    protected boolean DYSPNEIC_INVLD;
    protected boolean UR_INCONT_INVLD;
    protected boolean BWLINCONT_INVLD;
    protected boolean OSTOMY_INVLD;
    protected boolean CUR_DRESS_INVLD;
    protected boolean CUR_BATHING_INVLD;
    protected boolean CUR_TOILETING_INVLD;
    protected boolean CUR_TRANSFER_INVLD;
    protected boolean CUR_AMBULATION_INVLD;
    protected boolean CUR_INJECT_MEDS_INVLD;
    protected boolean THER_NEED_INVLD;
    protected DataValidityFlagIF dataValidityFlag;
    protected HomeHealthGrouperIF grouper;
    protected int[] diagnosisScoringStatus;

    public AbstractBaseValidator_v2308(HomeHealthGrouperIF grouper) {
        this.grouper = grouper;
        this.dataValidityFlag = new DataValidityFlag();
        this.diagnosisScoringStatus = new int[18];
    }

    @Override
    public DataValidityFlagIF getDataValidityFlag() {
        return this.dataValidityFlag;
    }

    @Override
    public void setDataValidityFlag(DataValidityFlagIF dataValidityFlag) {
        if (dataValidityFlag == null) {
            throw new IllegalArgumentException("dataValidityFlag parameter can not be null");
        }
        this.dataValidityFlag = dataValidityFlag;
    }

    @Override
    public final boolean isClinicalDomainDataIssueFlag() {
        return this.dataValidityFlag.isClinicalIssue();
    }

    @Override
    public final boolean isFunctionalDomainDataIssueFlag() {
        return this.dataValidityFlag.isFunctionalIssue();
    }

    @Override
    public final boolean isManifestationSequenceIssueFlag() {
        return this.dataValidityFlag.isManifestationSequenceIssue();
    }

    @Override
    public final boolean isServiceDomainDataIssueFlag() {
        return this.dataValidityFlag.isServiceIssue();
    }

    @Override
    public CollectionValidationEditsIF validate(HomeHealthRecordIF recordIF, Collection<HomeHealthEventListenerIF> listeners) {
        CollectionValidationEditsIF edits = null;
        if (recordIF instanceof HomeHealthRecord_B_IF) {
            HomeHealthRecord_B_IF record = (HomeHealthRecord_B_IF)recordIF;
            if (!this.validateASSMT_REASON(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Assessment Reason", record.getASSMT_REASON());
            }
            if (!this.validateExistingCodes(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Primary Diagnosis", record.getPRIMARY_DIAG_ICD().getCode());
            }
            if (!this.validatePRIMARY_DIAG_ICD(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Primary Diagnosis", record.getPRIMARY_DIAG_ICD().getCode());
            }
            if (!this.validatePAYMENT_ECodes(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Payment Codes E-codes", "<various>");
            }
            if (!this.validateTHH(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Therapies Received at Home", record.getTHH_IV_INFUSION() + ", " + record.getTHH_PAR_NUTRITION() + ", " + record.getTHH_ENT_NUTRITION() + ", " + record.getTHH_NONE_ABOVE());
            }
            if (!this.validateVISION(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Vision", record.getVISION());
            }
            if (!this.validateLESION_OPEN_WND(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Open Lesion Wound", record.getLESION_OPEN_WND());
            }
            if (!this.validateFREQ_PAIN(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Frequent Pain", record.getPAIN_FREQ_ACTVTY_MVMT());
            }
            if (!this.validateNPRSULC(record, listeners)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Number of Pressure Ulcers (4 Stages)", record.getNBR_PRSULC_STG1() + ", " + record.getNBR_PRSULC_STG2() + ", " + record.getNBR_PRSULC_STG3() + ", " + record.getNBR_PRSULC_STG4() + ", " + record.getUNOBS_PRSULC());
            }
            if (!this.validateSTGPRSUL(record, listeners)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Stage of Problem Ulcer", record.getSTG_PRBLM_ULCER());
            }
            if (!this.validateNBR_STASULC(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Number of Stasis Ulcers", record.getNBR_STAS_ULCR());
            }
            if (!this.validateUNOBS_STASULC(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Unobserved Stasis Ulcers", record.getUNOBS_STASULC());
            }
            if (!this.validateSTATSTASIS(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Status of Stasis Ulcers", record.getSTUS_PRBLM_STAS_ULCR());
            }
            if (!this.validateSTATSURG(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Status of Surgical Wound", record.getSTUS_PRBLM_SRGCL_WND());
            }
            if (!this.validateWHEN_DYSPNEIC(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "When Dyspneic", record.getWHEN_DYSPNEIC());
            }
            if (!this.validateUR_INCONT(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Urinary Incontinence", record.getUR_INCONT());
            }
            if (!this.validateBWL_INCONT(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Bowl Incontinence", record.getBWL_INCONT());
            }
            if (!this.validateBWL_INCONT_OSTOMY(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Bowl Incontinence Ostomy", record.getOSTOMY());
            }
            if (!this.validateCUR_INJECT_MEDS(record)) {
                this.dataValidityFlag.setClinicalIssue(true);
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Current Injectable Meds", record.getCRNT_MGMT_INJCTN_MDCTN());
            }
            if (!this.validateCUR_DRESS(record)) {
                this.dataValidityFlag.setFunctionalIssue(true);
                ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Dressing (Upper & Lower)", record.getCRNT_DRESS_UPPER() + ", " + record.getCRNT_DRESS_LOWER());
            }
            if (!this.validateCUR_BATHING(record)) {
                this.dataValidityFlag.setFunctionalIssue(true);
                ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Bathing", record.getCRNT_BATHG());
            }
            if (!this.validateCUR_TOILETING(record)) {
                this.dataValidityFlag.setFunctionalIssue(true);
                ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Toileting", record.getCRNT_TOILTG());
            }
            if (!this.validateCUR_TRANSFERRING(record)) {
                this.dataValidityFlag.setFunctionalIssue(true);
                ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Tranferring", record.getCRNT_TRNSFRNG());
            }
            if (!this.validateCUR_AMBULATION(record)) {
                this.dataValidityFlag.setFunctionalIssue(true);
                ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Ambulation", record.getCRNT_AMBLTN());
            }
            if (!this.validateTHER_NEED(record)) {
                this.dataValidityFlag.setServiceIssue(true);
                ScoringEventFormatter.fireServiceIssueEvent(listeners, this.grouper, null, "Therapy Need and Number of Therapies", record.getTHER_NEED_NBR() + ", " + record.getTHER_NEED_NA());
            }
            if (!this.isValidPrincipalDiagnosisCode(record)) {
                this.dataValidityFlag.setManifestationSequenceIssue(true);
                ScoringEventFormatter.fireManifestationIssueEvent(listeners, this.grouper, null, "Primary Diagnosis", record.getPRIMARY_DIAG_ICD().getCode());
            }
            if (!this.validateDiagnosisCodes(record, listeners)) {
                this.dataValidityFlag.setManifestationSequenceIssue(true);
                ScoringEventFormatter.fireManifestationIssueEvent(listeners, this.grouper, null, "All Diagnosis", "<various>");
            }
            for (int idx = 0; idx < 18; ++idx) {
                DiagnosisCodeIF code = record.getDiagnosisCode(idx);
                this.diagnosisScoringStatus[idx] = code.isValidForScoring() ? 2 : (code.isValidCode() || code.isOptionalPaymentCode() ? 1 : 0);
            }
        }
        return edits;
    }

    @Override
    public boolean validate(HomeHealthRecordIF recordIF) {
        this.validate(recordIF, null);
        return !this.dataValidityFlag.isIssuePresent();
    }

    public boolean validateASSMT_REASON(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            this.ASSMT_REASON_INVLD = true;
        }
        return !this.ASSMT_REASON_INVLD;
    }

    public boolean validateExistingCodes(HomeHealthRecordIF record) {
        int idx = 6;
        boolean valid = true;
        while (idx-- > 0) {
            DiagnosisCodeIF code = record.getDiagnosisCode(idx);
            if (!code.isValidCode() && !code.isEmpty()) {
                valid = false;
                break;
            }
            code = record.getOptionalDiagnosisCode3(idx);
            if (!code.isValidCode() && !code.isEmpty()) {
                valid = false;
                break;
            }
            code = record.getOptionalDiagnosisCode4(idx);
            if (code.isValidCode() || code.isEmpty()) continue;
            valid = false;
            break;
        }
        return valid;
    }

    public boolean validatePRIMARY_DIAG_ICD(HomeHealthRecordIF record) {
        DiagnosisCodeIF code = record.getPRIMARY_DIAG_ICD();
        boolean valid = true;
        if (code.isExternalCauseCode()) {
            code.setValidForScoring(false);
            valid = false;
        }
        return valid;
    }

    public boolean validatePAYMENT_ECodes(HomeHealthRecordIF record) {
        boolean valid = true;
        for (int idx = 0; idx < 6; ++idx) {
            DiagnosisCodeIF code = record.getOptionalDiagnosisCode3(idx);
            if (code.isExternalCauseCode()) {
                valid = false;
                code.setValidForScoring(valid);
            }
            if (!(code = record.getOptionalDiagnosisCode4(idx)).isExternalCauseCode()) continue;
            valid = false;
            code.setValidForScoring(valid);
        }
        return valid;
    }

    public boolean validateTHH(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getTHH_IV_INFUSION(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
            this.THERAPIES_INVLD = true;
        }
        if (!ValidateUtils.isValidValue(record.getTHH_PAR_NUTRITION(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
            this.THERAPIES_INVLD = true;
        }
        if (!ValidateUtils.isValidValue(record.getTHH_ENT_NUTRITION(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
            this.THERAPIES_INVLD = true;
        }
        if (!ValidateUtils.isValidValue(record.getTHH_NONE_ABOVE(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
            this.THERAPIES_INVLD = true;
        }
        if ("1".equals(record.getTHH_NONE_ABOVE()) && ("1".equals(record.getTHH_IV_INFUSION()) || "1".equals(record.getTHH_PAR_NUTRITION()) || "1".equals(record.getTHH_ENT_NUTRITION()))) {
            this.INTERNAL_LOGIC_INVLD = true;
        }
        if ("0".equals(record.getTHH_NONE_ABOVE()) && "0".equals(record.getTHH_IV_INFUSION()) && "0".equals(record.getTHH_PAR_NUTRITION()) && "0".equals(record.getTHH_ENT_NUTRITION())) {
            this.INTERNAL_LOGIC_INVLD = true;
        }
        return !this.THERAPIES_INVLD && !this.INTERNAL_LOGIC_INVLD;
    }

    public boolean validateVISION(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getVISION(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO})) {
            this.VISION_INVLD = true;
        }
        return !this.VISION_INVLD;
    }

    public boolean validateFREQ_PAIN(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getPAIN_FREQ_ACTVTY_MVMT(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE})) {
            this.PAIN_INVLD = true;
        }
        return !this.PAIN_INVLD;
    }

    public boolean validateLESION_OPEN_WND(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getLESION_OPEN_WND(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
            this.LESION_INVLD = true;
        }
        return !this.LESION_INVLD;
    }

    public boolean validateNPRSULC(HomeHealthRecordIF record, Collection<HomeHealthEventListenerIF> listeners) {
        if (!ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY})) {
            if ("1".equals(record.getLESION_OPEN_WND()) && "1".equals(((HomeHealthRecord_B_IF)record).getPRESS_ULCER())) {
                if (!ValidateUtils.isValidValue(record.getNBR_PRSULC_STG1(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                    this.NPRSULC1_INVLD = true;
                }
                if (!ValidateUtils.isValidValue(record.getNBR_PRSULC_STG2(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                    this.NPRSULC2_INVLD = true;
                }
                if (!ValidateUtils.isValidValue(record.getNBR_PRSULC_STG3(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                    this.NPRSULC3_INVLD = true;
                }
                if (!ValidateUtils.isValidValue(record.getNBR_PRSULC_STG4(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                    this.NPRSULC4_INVLD = true;
                }
                if (!ValidateUtils.isValidValue(((HomeHealthRecord_B_IF)record).getUNOBS_PRSULC(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                    this.UNOBS_PRSULC_INVLD = true;
                }
            } else {
                if (ValidateUtils.isValidValue(record.getNBR_PRSULC_STG1(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                    this.NPRSULC1_INVLD = true;
                }
                if (ValidateUtils.isValidValue(record.getNBR_PRSULC_STG2(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                    this.NPRSULC2_INVLD = true;
                }
                if (ValidateUtils.isValidValue(record.getNBR_PRSULC_STG3(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                    this.NPRSULC3_INVLD = true;
                }
                if (ValidateUtils.isValidValue(record.getNBR_PRSULC_STG4(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                    this.NPRSULC4_INVLD = true;
                }
                if (ValidateUtils.isValidValue(((HomeHealthRecord_B_IF)record).getUNOBS_PRSULC(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                    this.UNOBS_PRSULC_INVLD = true;
                }
            }
        } else if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY})) {
            if ("1".equals(record.getLESION_OPEN_WND())) {
                if (!ValidateUtils.isValidValue(record.getNBR_PRSULC_STG1(), ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR, ValidateUtils.ARRAY_SPACE_2)) {
                    this.NPRSULC1_INVLD = true;
                }
                if (!ValidateUtils.isValidValue(record.getNBR_PRSULC_STG2(), ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR, ValidateUtils.ARRAY_SPACE_2)) {
                    this.NPRSULC2_INVLD = true;
                }
                if (!ValidateUtils.isValidValue(record.getNBR_PRSULC_STG3(), ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR, ValidateUtils.ARRAY_SPACE_2)) {
                    this.NPRSULC3_INVLD = true;
                }
                if (!ValidateUtils.isValidValue(record.getNBR_PRSULC_STG4(), ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR, ValidateUtils.ARRAY_SPACE_2)) {
                    this.NPRSULC4_INVLD = true;
                }
                if (!" ".equals(((HomeHealthRecord_B_IF)record).getUNOBS_PRSULC()) && !ValidateUtils.isValidValue(((HomeHealthRecord_B_IF)record).getUNOBS_PRSULC(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                    this.UNOBS_PRSULC_INVLD = true;
                }
            } else if (!"1".equals(record.getLESION_OPEN_WND())) {
                if (ValidateUtils.isValidValue(record.getNBR_PRSULC_STG1(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                    this.NPRSULC1_INVLD = true;
                }
                if (ValidateUtils.isValidValue(record.getNBR_PRSULC_STG2(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                    this.NPRSULC2_INVLD = true;
                }
                if (ValidateUtils.isValidValue(record.getNBR_PRSULC_STG3(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                    this.NPRSULC3_INVLD = true;
                }
                if (ValidateUtils.isValidValue(record.getNBR_PRSULC_STG4(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                    this.NPRSULC4_INVLD = true;
                }
                if (ValidateUtils.isValidValue(((HomeHealthRecord_B_IF)record).getUNOBS_PRSULC(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                    this.UNOBS_PRSULC_INVLD = true;
                }
            }
        }
        return !this.NPRSULC1_INVLD && !this.NPRSULC2_INVLD && !this.NPRSULC3_INVLD && !this.NPRSULC4_INVLD && !this.UNOBS_PRSULC_INVLD;
    }

    public boolean validateSTGPRSUL(HomeHealthRecordIF record, Collection<HomeHealthEventListenerIF> listeners) {
        if (!ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY})) {
            if ("1".equals(record.getLESION_OPEN_WND()) && "1".equals(((HomeHealthRecord_B_IF)record).getPRESS_ULCER())) {
                if (!ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
                    this.STGPRSUL_INVLD = true;
                }
                if ((ValidateUtils.isValidValue(record.getNBR_PRSULC_STG1(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR}) || ValidateUtils.isValidValue(record.getNBR_PRSULC_STG2(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR}) || ValidateUtils.isValidValue(record.getNBR_PRSULC_STG3(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR}) || ValidateUtils.isValidValue(record.getNBR_PRSULC_STG4(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR})) && !ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR})) {
                    this.STGPRSUL_INVLD = true;
                }
            } else if (ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
                this.STGPRSUL_INVLD = true;
            }
        } else if ("1".equals(record.getLESION_OPEN_WND())) {
            if (!ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR, ValidateUtils.ARRAY_SPACE_2, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
                this.STGPRSUL_INVLD = true;
            }
            if ((ValidateUtils.isValidValue(record.getNBR_PRSULC_STG1(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR}) || ValidateUtils.isValidValue(record.getNBR_PRSULC_STG2(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR}) || ValidateUtils.isValidValue(record.getNBR_PRSULC_STG3(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR}) || ValidateUtils.isValidValue(record.getNBR_PRSULC_STG4(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR})) && !ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR})) {
                this.STGPRSUL_INVLD = true;
            }
        } else if (ValidateUtils.isValidValue(record.getSTG_PRBLM_ULCER(), ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
            this.STGPRSUL_INVLD = true;
        }
        return !this.STGPRSUL_INVLD;
    }

    public boolean validateNBR_STASULC(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY})) {
            if ("1".equals(record.getLESION_OPEN_WND()) && "1".equals(record.getSTAS_ULCR_PRSNT())) {
                if (!ValidateUtils.isValidValue(record.getNBR_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                    this.NBR_STASULC_INVLD = true;
                }
            } else if (ValidateUtils.isValidValue(record.getNBR_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
                this.NBR_STASULC_INVLD = true;
            }
        } else if ("1".equals(record.getLESION_OPEN_WND())) {
            if (!ValidateUtils.isValidValue(record.getNBR_STAS_ULCR(), ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR, ValidateUtils.ARRAY_SPACE_2)) {
                this.NBR_STASULC_INVLD = true;
            }
        } else if (ValidateUtils.isValidValue(record.getNBR_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
            this.NBR_STASULC_INVLD = true;
        }
        return !this.NBR_STASULC_INVLD;
    }

    public boolean validateUNOBS_STASULC(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY})) {
            if ("1".equals(record.getLESION_OPEN_WND()) && "1".equals(record.getSTAS_ULCR_PRSNT())) {
                if (!ValidateUtils.isValidValue(((HomeHealthRecord_B_IF)record).getUNOBS_STASULC(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                    this.UNOBS_STASULC_INVLD = true;
                }
            } else if (ValidateUtils.isValidValue(((HomeHealthRecord_B_IF)record).getUNOBS_STASULC(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                this.UNOBS_STASULC_INVLD = true;
            }
        } else if ("1".equals(record.getLESION_OPEN_WND())) {
            if (!ValidateUtils.isValidValue(((HomeHealthRecord_B_IF)record).getUNOBS_STASULC(), ValidateUtils.ARRAY_ZERO_ONE, ValidateUtils.ARRAY_SPACE_1)) {
                this.UNOBS_STASULC_INVLD = true;
            }
        } else if (ValidateUtils.isValidValue(((HomeHealthRecord_B_IF)record).getUNOBS_STASULC(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
            this.UNOBS_STASULC_INVLD = true;
        }
        return !this.UNOBS_STASULC_INVLD;
    }

    public boolean validateSTATSTASIS(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY})) {
            if ("1".equals(record.getLESION_OPEN_WND()) && "1".equals(record.getSTAS_ULCR_PRSNT()) && ValidateUtils.isValidValue(record.getNBR_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR})) {
                if (!ValidateUtils.isValidValue(record.getSTUS_PRBLM_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR})) {
                    this.STATSTASIS_INVLD = true;
                }
            } else if (ValidateUtils.isValidValue(record.getSTUS_PRBLM_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR})) {
                this.STATSTASIS_INVLD = true;
            }
        } else if ("1".equals(record.getLESION_OPEN_WND()) && ValidateUtils.isValidValue(record.getNBR_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR})) {
            if (!ValidateUtils.isValidValue(record.getSTUS_PRBLM_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR})) {
                this.STATSTASIS_INVLD = true;
            }
        } else if (ValidateUtils.isValidValue(record.getSTUS_PRBLM_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR})) {
            this.STATSTASIS_INVLD = true;
        }
        return !this.STATSTASIS_INVLD;
    }

    public boolean validateSTATSURG(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY})) {
            if ("1".equals(record.getLESION_OPEN_WND()) && "1".equals(record.getSRGCL_WND_PRSNT())) {
                if (ValidateUtils.isValidValue(((HomeHealthRecord_B_IF)record).getNBR_SURGWND(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE_FOUR}) && !ValidateUtils.isValidValue(record.getSTUS_PRBLM_SRGCL_WND(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE})) {
                    this.STATSURG_INVLD = true;
                }
            } else if (ValidateUtils.isValidValue(record.getSTUS_PRBLM_SRGCL_WND(), ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
                this.STATSURG_INVLD = true;
            }
        } else if ("1".equals(record.getLESION_OPEN_WND())) {
            if (!ValidateUtils.isValidValue(record.getSTUS_PRBLM_SRGCL_WND(), ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE, ValidateUtils.ARRAY_SPACE_2, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
                this.STATSURG_INVLD = true;
            }
        } else if (ValidateUtils.isValidValue(record.getSTUS_PRBLM_SRGCL_WND(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO_THREE})) {
            this.STATSURG_INVLD = true;
        }
        return !this.STATSURG_INVLD;
    }

    public boolean validateWHEN_DYSPNEIC(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getWHEN_DYSPNEIC(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
            this.DYSPNEIC_INVLD = true;
        }
        return !this.DYSPNEIC_INVLD;
    }

    public boolean validateUR_INCONT(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getUR_INCONT(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO})) {
            this.UR_INCONT_INVLD = true;
        }
        return !this.UR_INCONT_INVLD;
    }

    public boolean validateBWL_INCONT(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY})) {
            if (!ValidateUtils.isValidValue(record.getBWL_INCONT(), ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE, ValidateUtils.ARRAY_NOT_APPLICABLE, ValidateUtils.ARRAY_UNKNOWN_UK)) {
                this.BWLINCONT_INVLD = true;
            }
        } else if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && !ValidateUtils.isValidValue(record.getBWL_INCONT(), ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
            this.BWLINCONT_INVLD = true;
        }
        return !this.BWLINCONT_INVLD;
    }

    public boolean validateBWL_INCONT_OSTOMY(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getBWL_INCONT(), ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE, ValidateUtils.ARRAY_UNKNOWN_UK)) {
            if (!"00".equals(record.getOSTOMY())) {
                this.OSTOMY_INVLD = true;
            }
        } else if ("NA".equals(record.getBWL_INCONT())) {
            if (!ValidateUtils.isValidValue(record.getOSTOMY(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO})) {
                this.OSTOMY_INVLD = true;
            }
        } else if (!ValidateUtils.isValidValue(record.getOSTOMY(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO})) {
            this.OSTOMY_INVLD = true;
        }
        return !this.OSTOMY_INVLD;
    }

    public boolean validateCUR_INJECT_MEDS(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getCRNT_MGMT_INJCTN_MDCTN(), ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
            this.CUR_INJECT_MEDS_INVLD = true;
        }
        return !this.CUR_INJECT_MEDS_INVLD;
    }

    public boolean validateCUR_DRESS(HomeHealthRecordIF record) {
        if ("00".equals(record.getCRNT_DRESS_LOWER()) && !ValidateUtils.isValidValue(record.getCRNT_DRESS_UPPER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE})) {
            this.CUR_DRESS_INVLD = true;
        } else if ("00".equals(record.getCRNT_DRESS_UPPER()) && !ValidateUtils.isValidValue(record.getCRNT_DRESS_LOWER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE})) {
            this.CUR_DRESS_INVLD = true;
        }
        return !this.CUR_DRESS_INVLD;
    }

    public boolean validateCUR_BATHING(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getCRNT_BATHG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE})) {
            this.CUR_BATHING_INVLD = true;
        }
        return !this.CUR_BATHING_INVLD;
    }

    public boolean validateCUR_TOILETING(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getCRNT_TOILTG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
            this.CUR_TOILETING_INVLD = true;
        }
        return !this.CUR_TOILETING_INVLD;
    }

    public boolean validateCUR_TRANSFERRING(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getCRNT_TRNSFRNG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE})) {
            this.CUR_TRANSFER_INVLD = true;
        }
        return !this.CUR_TRANSFER_INVLD;
    }

    public boolean validateCUR_AMBULATION(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getCRNT_AMBLTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE})) {
            this.CUR_AMBULATION_INVLD = true;
        }
        return !this.CUR_AMBULATION_INVLD;
    }

    public boolean validateTHER_NEED(HomeHealthRecordIF record) {
        String therapyNeedNA = record.getTHER_NEED_NA();
        if (therapyNeedNA.equals("1")) {
            if (record.getTHER_NEED_NBR() >= 0) {
                this.THER_NEED_INVLD = true;
            }
        } else if (therapyNeedNA.equals("0") && (record.getTHER_NEED_NBR() < 0 || record.getTHER_NEED_NBR() > 999)) {
            this.THER_NEED_INVLD = true;
        }
        return !this.THER_NEED_INVLD;
    }

    public boolean isValidPrincipalDiagnosisCode(HomeHealthRecordIF record) {
        DiagnosisCodeIF code = record.getPRIMARY_DIAG_ICD();
        return code != null && !code.isEmpty() && !code.isSecondaryOnly() && !code.isExternalCauseCode();
    }

    public abstract boolean validateDiagnosisCodes(HomeHealthRecordIF var1, Collection<HomeHealthEventListenerIF> var2);

    @Override
    public int[] getDiagnosisScoringStatus() {
        return this.diagnosisScoringStatus;
    }

    @Override
    public void setDiagnosisScoringStatus(int[] diagnosisScoringStatus) {
        this.diagnosisScoringStatus = diagnosisScoringStatus;
    }

    @Override
    public boolean isCUR_BATHING_Valid() {
        return !this.CUR_BATHING_INVLD;
    }

    @Override
    public boolean isCUR_TOILETING_Valid() {
        return !this.CUR_TOILETING_INVLD;
    }

    @Override
    public boolean isCUR_TRANSFER_Valid() {
        return !this.CUR_TRANSFER_INVLD;
    }

    @Override
    public boolean isCUR_AMBULATION_Valid() {
        return !this.CUR_AMBULATION_INVLD;
    }

    @Override
    public boolean isCUR_INJECT_MEDS_Valid() {
        return !this.CUR_INJECT_MEDS_INVLD;
    }

    @Override
    public boolean isTHER_NEED_Valid() {
        return !this.THER_NEED_INVLD;
    }

    @Override
    public boolean isDYSPNEIC_Valid() {
        return !this.DYSPNEIC_INVLD;
    }

    @Override
    public boolean isUR_INCONT_Valid() {
        return !this.UR_INCONT_INVLD;
    }

    @Override
    public boolean isBWLINCONT_Valid() {
        return !this.BWLINCONT_INVLD;
    }

    @Override
    public boolean isOSTOMY_Valid() {
        return !this.OSTOMY_INVLD;
    }

    @Override
    public boolean isCUR_DRESS_Valid() {
        return !this.CUR_DRESS_INVLD;
    }

    @Override
    public boolean isSTGPRSUL_Valid() {
        return !this.STGPRSUL_INVLD;
    }

    @Override
    public boolean isNBR_STASULC_Valid() {
        return !this.NBR_STASULC_INVLD;
    }

    @Override
    public boolean isUNOBS_STASULC_Valid() {
        return !this.UNOBS_STASULC_INVLD;
    }

    @Override
    public boolean isSTATSTASIS_Valid() {
        return !this.STATSTASIS_INVLD;
    }

    @Override
    public boolean isSTATSURG_Valid() {
        return !this.STATSURG_INVLD;
    }

    @Override
    public boolean isNPRSULC1_Valid() {
        return !this.NPRSULC1_INVLD;
    }

    @Override
    public boolean isNPRSULC2_Valid() {
        return !this.NPRSULC2_INVLD;
    }

    @Override
    public boolean isNPRSULC3_Valid() {
        return !this.NPRSULC3_INVLD;
    }

    @Override
    public boolean isNPRSULC4_Valid() {
        return !this.NPRSULC4_INVLD;
    }

    @Override
    public boolean isUNOBS_PRSULC_Valid() {
        return !this.UNOBS_PRSULC_INVLD;
    }

    @Override
    public boolean isASSMT_REASON_Valid() {
        return !this.ASSMT_REASON_INVLD;
    }

    @Override
    public boolean isINFO_COMPLETED_DT_Valid() {
        return !this.INFO_COMPLETED_DT_INVLD;
    }

    @Override
    public boolean isINTERNAL_LOGIC_Valid() {
        return !this.INTERNAL_LOGIC_INVLD;
    }

    @Override
    public boolean isTHERAPIES_Valid() {
        return !this.THERAPIES_INVLD;
    }

    @Override
    public boolean isVISION_Valid() {
        return !this.VISION_INVLD;
    }

    @Override
    public boolean isPAIN_Valid() {
        return !this.PAIN_INVLD;
    }

    @Override
    public boolean isLESION_Valid() {
        return !this.LESION_INVLD;
    }
}

