/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v2308_1;

import com.mmm.cms.homehealth.GrouperDataManager;
import com.mmm.cms.homehealth.HIPPSCode;
import com.mmm.cms.homehealth.HomeHealthEventNotifier;
import com.mmm.cms.homehealth.PointsScoringEquations;
import com.mmm.cms.homehealth.ScoringResults;
import com.mmm.cms.homehealth.TreatmentAuthorization;
import com.mmm.cms.homehealth.proto.CaseMixAdjustmentItemIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosticGroupIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecord_B_IF;
import com.mmm.cms.homehealth.proto.HomeHealthRecord_C1_IF;
import com.mmm.cms.homehealth.proto.HomeHealthRecord_C_IF;
import com.mmm.cms.homehealth.proto.ScoringPointsIF;
import com.mmm.cms.homehealth.proto.ScoringResultsIF;
import com.mmm.cms.homehealth.v2308_1.ClinicalFunctional_ScoringModel_v2308;
import com.mmm.cms.homehealth.v2308_1.HomeHealthRecordClinicalValidator;
import com.mmm.cms.homehealth.v2308_1.HomeHealthRecordNRSValidator;
import com.mmm.cms.homehealth.v2308_1.NRS_ScoringModel_v2308;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ScoringEventFormatter;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;

public class GrouperVersion_v2308_1
extends HomeHealthEventNotifier
implements HomeHealthGrouperIF {
    private Calendar effectiveDateStart;
    private Calendar effectiveDateStartWindow;
    private Calendar effectiveDateThru;
    private GrouperDataManager grouperDataManager;
    protected NRS_ScoringModel_v2308 nrsScoringModel;
    protected ClinicalFunctional_ScoringModel_v2308 clinicalModel_1;
    protected ClinicalFunctional_ScoringModel_v2308 clinicalModel_2;
    protected ClinicalFunctional_ScoringModel_v2308 clinicalModel_3;
    protected ClinicalFunctional_ScoringModel_v2308 clinicalModel_4;
    protected String version;

    public GrouperVersion_v2308_1() {
        this(new GregorianCalendar(2008, 0, 1), new GregorianCalendar(2008, 8, 30), new GregorianCalendar(2007, 11, 27));
    }

    public GrouperVersion_v2308_1(Calendar start, Calendar thru, Calendar window) {
        if (start == null || thru == null) {
            throw new IllegalArgumentException("Neither the start date or the thru date can be null");
        }
        this.effectiveDateStart = start;
        this.effectiveDateThru = thru;
        this.effectiveDateStartWindow = window == null ? start : window;
        this.version = "V2308";
    }

    @Override
    public int[][] determineScoreOrder(HomeHealthRecordIF record) {
        int[][] scoreOrder = new int[6][3];
        for (int diagIdx = 0; diagIdx < 6; ++diagIdx) {
            DiagnosisCodeIF diagCode = record.getDiagnosisCode(diagIdx);
            if (diagCode.isOptionalPaymentCode()) {
                DiagnosisCodeIF diagCodeOptional = record.getOptionalDiagnosisCode4(diagIdx);
                if (diagCodeOptional.isValidForScoring()) {
                    scoreOrder[diagIdx][2] = 2;
                    scoreOrder[diagIdx][1] = 2;
                    continue;
                }
                diagCodeOptional = record.getOptionalDiagnosisCode3(diagIdx);
                if (!diagCodeOptional.isValidForScoring()) continue;
                scoreOrder[diagIdx][1] = 1;
                continue;
            }
            if (!diagCode.isValidForScoring()) continue;
            if (diagCode.isSecondaryOnly()) {
                scoreOrder[diagIdx][0] = 2;
                scoreOrder[diagIdx - 1][0] = 2;
                continue;
            }
            scoreOrder[diagIdx][0] = 1;
        }
        return scoreOrder;
    }

    @Override
    public List<DiagnosticGroupIF> getDiagnosticGroups() {
        return this.grouperDataManager.getDiagnosticGroups();
    }

    @Override
    public List<DiagnosticGroupIF> getDiagnosticGroupsNRS() {
        return this.grouperDataManager.getDiagnosticGroupsNRS();
    }

    @Override
    public String getName() {
        return "HHA PPS Grouper - Pre October 2008 ICD-9-CM codes, " + this.getVersion();
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Calendar getEffectiveDateStart() {
        return this.effectiveDateStart;
    }

    @Override
    public Calendar getEffectiveDateThru() {
        return this.effectiveDateThru;
    }

    @Override
    public boolean isValidForVersion(HomeHealthRecordIF record) {
        boolean valid;
        Class acceptableRecordClass = this.getAcceptableRecordClass();
        if (record == null || !acceptableRecordClass.isAssignableFrom(record.getClass())) {
            valid = false;
        } else {
            Calendar date = record.getINFO_COMPLETED_DT();
            if (date != null) {
                int tmpInt = IntegerUtils.parseInt(record.getASSMT_REASON(), 0);
                switch (tmpInt) {
                    case 1: 
                    case 3: {
                        valid = !date.before(this.effectiveDateStart);
                        break;
                    }
                    case 4: 
                    case 5: {
                        valid = !date.before(this.effectiveDateStartWindow);
                        break;
                    }
                    default: {
                        valid = false;
                    }
                }
                if (valid) {
                    valid = !date.after(this.effectiveDateThru);
                }
            } else {
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public String getDescription() {
        return "Provides the version 2.03 scoring logic for codes valid between January 1, 2008 thru September 30, 2008 inclusive.";
    }

    @Override
    public void setDescription(String arg0) {
    }

    @Override
    public void init(Properties props) throws Exception {
        this.grouperDataManager = new GrouperDataManager(this);
        this.grouperDataManager.init(props);
        this.clinicalModel_1 = new ClinicalFunctional_ScoringModel_v2308(this, this.grouperDataManager, 1);
        this.clinicalModel_2 = new ClinicalFunctional_ScoringModel_v2308(this, this.grouperDataManager, 2);
        this.clinicalModel_3 = new ClinicalFunctional_ScoringModel_v2308(this, this.grouperDataManager, 3);
        this.clinicalModel_4 = new ClinicalFunctional_ScoringModel_v2308(this, this.grouperDataManager, 4);
        this.nrsScoringModel = new NRS_ScoringModel_v2308(this, this.grouperDataManager);
    }

    @Override
    public ScoringResultsIF score(HomeHealthRecordIF record, boolean validateDates) {
        ScoringResults scoringResult;
        ScoringEventFormatter.fireScoringRecord(this.getEventListenersList(), this, "Pre-scoring: ", record);
        if (validateDates && !this.isValidForVersion(record)) {
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), ": record not valid for this version");
            scoringResult = new ScoringResults(record);
        } else if (record instanceof HomeHealthRecord_C_IF || record instanceof HomeHealthRecord_C1_IF) {
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), ": Invalid record format for this version");
            scoringResult = new ScoringResults(record);
        } else {
            PointsScoringEquations clinicalScore = new PointsScoringEquations();
            PointsScoringEquations functionalScore = new PointsScoringEquations();
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), "populating codes for Clinical/Functional scoring");
            this.clinicalModel_1.populateCodes(record);
            ScoringEventFormatter.fireScoringRecord(this.getEventListenersList(), this, "Post-populating record: ", record);
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), "Validating record");
            HomeHealthRecordValidatorIF validator = this.getClinicalValidator();
            validator.validate(record, this.getEventListenersList());
            ScoringPointsIF scoringPoints = this.clinicalModel_1.score(record, validator);
            clinicalScore.setEarly13AndUnder(scoringPoints.getScores()[0]);
            functionalScore.setEarly13AndUnder(scoringPoints.getScores()[1]);
            scoringPoints = this.clinicalModel_2.score(record, validator);
            clinicalScore.setEarly14Plus(scoringPoints.getScores()[0]);
            functionalScore.setEarly14Plus(scoringPoints.getScores()[1]);
            scoringPoints = this.clinicalModel_3.score(record, validator);
            clinicalScore.setLater13AndUnder(scoringPoints.getScores()[0]);
            functionalScore.setLater13AndUnder(scoringPoints.getScores()[1]);
            scoringPoints = this.clinicalModel_4.score(record, validator);
            clinicalScore.setLater14Plus(scoringPoints.getScores()[0]);
            functionalScore.setLater14Plus(scoringPoints.getScores()[1]);
            ScoringEventFormatter.fireScoringGeneral(this.getEventListenersList(), this, null, this.getName(), "populating codes for Non-Routine Supplies scoring");
            this.nrsScoringModel.populateCodes(record);
            HomeHealthRecordValidatorIF nrsValidator = this.getNRSValidator();
            nrsValidator.validate(record);
            ScoringEventFormatter.fireScoringRecord(this.getEventListenersList(), this, "Post-populate with NRS Diagnosis: ", record);
            scoringPoints = this.nrsScoringModel.score(record, nrsValidator);
            int nrsScore = scoringPoints.getScores()[0];
            HIPPSCode hippsCode = new HIPPSCode(record, validator, clinicalScore, functionalScore, nrsScore);
            TreatmentAuthorization treatment = hippsCode.getCode().trim().isEmpty() ? new TreatmentAuthorization(record, null, null, null) : new TreatmentAuthorization(record, validator, clinicalScore, functionalScore);
            scoringResult = new ScoringResults(hippsCode, this.getVersion(), validator.getDataValidityFlag(), treatment, validator, nrsValidator);
        }
        return scoringResult;
    }

    @Override
    public List<CaseMixAdjustmentItemIF> getCaseMixAdjustments() {
        return this.grouperDataManager.getCaseMixAdjustments();
    }

    @Override
    public List<DiagnosisCodeIF> getClinicalCodes() {
        return this.grouperDataManager.getClinicalCodes();
    }

    @Override
    public HomeHealthRecordValidatorIF getClinicalValidator() {
        return new HomeHealthRecordClinicalValidator(this);
    }

    @Override
    public List<DiagnosisCodeIF> getNonRoutineCodes() {
        return this.grouperDataManager.getNonRoutineCodes();
    }

    @Override
    public List<CaseMixAdjustmentItemIF> getNRSCaseMixAdjustments() {
        return this.grouperDataManager.getNRSCaseMixAdjustments();
    }

    @Override
    public HomeHealthRecordValidatorIF getNRSValidator() {
        return new HomeHealthRecordNRSValidator(this);
    }

    @Override
    public boolean isValidDiagnosisCode(HomeHealthRecordIF record, DiagnosisCodeIF code) {
        return code == null ? false : this.grouperDataManager.getDiagnosisCode(code.getCode()) != null;
    }

    @Override
    public HomeHealthRecordValidatorIF populateValidateClinicalCodes(HomeHealthRecordIF record) {
        HomeHealthRecordClinicalValidator validator = new HomeHealthRecordClinicalValidator(this);
        this.clinicalModel_1.populateCodes(record);
        validator.validate(record);
        return validator;
    }

    @Override
    public void setVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("setVersion() - version can not be null.");
        }
        this.version = version;
    }

    @Override
    public ScoringResultsIF score(HomeHealthRecordIF record, boolean validateDates, CollectionValidationEditsIF validationEdits, Collection<HomeHealthEventListenerIF> listeners) {
        return this.score(record, validateDates);
    }

    @Override
    public void setEffectiveDateStart(Calendar effectiveDateStart) {
        this.effectiveDateStart = effectiveDateStart;
    }

    @Override
    public void setEffectiveDateThru(Calendar effectiveDateThru) {
        this.effectiveDateThru = effectiveDateThru;
    }

    @Override
    public Class getAcceptableRecordClass() {
        return HomeHealthRecord_B_IF.class;
    }

    @Override
    public void setEffectiveDateStartWindow(Calendar effectiveDateStartWindow) {
        this.effectiveDateStartWindow = effectiveDateStartWindow;
    }

    @Override
    public Calendar getEffectiveDateStartWindow() {
        return this.effectiveDateStartWindow;
    }

    @Override
    public GrouperDataManager getGrouperDataManager() {
        return this.grouperDataManager;
    }
}

