/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3312;

import com.mmm.cms.homehealth.GrouperDataManager;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.EtiologyPairingListIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class GrouperDataManager_V3312
extends GrouperDataManager {
    public GrouperDataManager_V3312(HomeHealthGrouperIF homeHealthGrouper) {
        super(homeHealthGrouper);
    }

    @Override
    public void init(Properties props) throws Exception, RemoteException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.log(Level.INFO, "HH-PPS: init() - starting...");
        this.setBasePath(new File(this.getBasePathName(props)));
        String tmpstr = props.getProperty("include.code.descriptions", "false");
        this.setIncludeDescriptions(Boolean.parseBoolean(tmpstr));
        logger.log(Level.INFO, "HH-PPS: Loading configuration from base path: ''{0}''", this.getBasePath());
        logger.log(Level.INFO, "HH-PPS: Loading Diagnostic Groups");
        this.loadDiagnosticGroups();
        logger.log(Level.INFO, "HH-PPS: Loading Diagnosis Codes");
        this.loadDiagnosisCodes();
        logger.log(Level.INFO, "HH-PPS: Loading Case Mix Adujustments");
        this.loadCaseMixAdjustments();
        logger.log(Level.INFO, "HH-PPS: Loading NRS Diagnostic Groups");
        this.loadNRSDiagnosticGroups();
        logger.log(Level.INFO, "HH-PPS: Loading NRS Diagnosis Codes");
        this.loadNRSDiagnosisCodes();
        logger.log(Level.INFO, "HH-PPS: Loading NRS Case Mix Adujustments");
        this.loadNRSCaseMixAdjustments();
        logger.log(Level.INFO, "HH-PPS: init() - Done");
    }

    @Override
    protected void loadDiagnosisCodeBase(File file, Map<String, DiagnosisCodeIF> codeHash, boolean isNrs) throws IOException {
        String[] tokens = null;
        boolean incDesc = this.isIncludeDescriptions();
        Pattern pattern = this.getSplitPattern();
        Logger logger = Logger.getLogger(this.getClass().getName());
        BufferedReader reader = new BufferedReader(new FileReader(file));
        try {
            String line;
            logger.log(Level.INFO, "HH-PPS: Reading diagnosis file: {0}", file.getAbsolutePath());
            while ((line = reader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, "\t");
                if (tokens == null || tokens.length != tokenizer.countTokens()) {
                    tokens = new String[tokenizer.countTokens()];
                }
                for (int idx = 0; idx < tokens.length; ++idx) {
                    tokens[idx] = tokenizer.nextToken();
                }
                if (tokens.length <= 1 || tokens[0].trim().toUpperCase().startsWith("DIAGNOS")) continue;
                DiagnosisCodeIF diag = this.createDiagnosisCode(tokens[0].trim(), true, true);
                switch (tokens.length) {
                    case 4: 
                    case 5: {
                        String tmpStr = tokens[3].trim();
                        this.onParseDiagnosisCodeAttributes(diag, tmpStr);
                    }
                    case 3: {
                        if (!tokens[2].isEmpty()) {
                            this.onParseDiagnosisDiagGroup(diag, tokens[2], isNrs);
                        }
                    }
                    case 2: {
                        if (!incDesc) break;
                        this.onParseDiagnosisDescription(diag, tokens[1]);
                    }
                }
                if (diag.getDiagnosticGroup().getId() == 0) {
                    diag.setValidForScoring(false);
                }
                codeHash.put(diag.getCode(), diag);
            }
        }
        catch (OutOfMemoryError o) {
            logger.log(Level.INFO, "Out of memory");
        }
    }

    protected void onParseDiagnosisCodeAttributes(DiagnosisCodeIF diag, String str) {
        if ("M".equals(str)) {
            diag.setSecondaryOnly(true);
        } else if ("P".equals(str)) {
            diag.setOptionalPaymentCode(true);
        }
    }

    protected void onParseDiagnosisDescription(DiagnosisCodeIF diag, String str) {
        diag.setDescription(str);
    }

    protected void onParseDiagnosisDiagGroup(DiagnosisCodeIF diag, String str, boolean isNrs) {
        diag.setDiagnosticGroup(isNrs ? this.getNRSDiagnosticGroup(Long.parseLong(str)) : this.getDiagnosticGroup(Long.parseLong(str)));
    }

    @Override
    public void loadEtiologyPairs(Map<String, DiagnosisCodeIF> dxCodes) throws FileNotFoundException, IOException {
        String line;
        String[] tokens = null;
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (dxCodes == null || dxCodes.isEmpty()) {
            logger.log(Level.WARNING, "HH-PPS: Etiology Pairs: Can not load pairs.  No list of Diagnosis codes exist.  Please Diagnosis codes first.");
        }
        HashMap<String, Boolean> errorReported = new HashMap<String, Boolean>();
        File file = new File(this.getBasePath(), DIAGNOSIS_ETIOLOGY_PAIRS);
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            StringTokenizer tokenizer = new StringTokenizer(line, "\t");
            if (tokens == null || tokens.length != tokenizer.countTokens()) {
                tokens = new String[tokenizer.countTokens()];
            }
            for (int idx = 0; idx < tokens.length; ++idx) {
                tokens[idx] = tokenizer.nextToken();
            }
            if (tokens.length < 2 || tokens[0].trim().toUpperCase().startsWith("DIAGNOS")) continue;
            DiagnosisCodeIF primaryCode = dxCodes.get(tokens[0]);
            if (primaryCode != null) {
                DiagnosisCodeIF pairedCode = dxCodes.get(tokens[1]);
                if (pairedCode == null) {
                    pairedCode = this.createDiagnosisCode(tokens[1], false, false);
                    if (errorReported.get(tokens[1]) == null) {
                        errorReported.put(tokens[1], Boolean.TRUE);
                        logger.log(Level.FINE, "HH-PPS: Etiology Pairs: Paired/secondary Diagnosis code not found or not valid: ''{0}''", tokens[1]);
                    }
                }
                EtiologyPairingListIF pairingList = primaryCode.getEtiologyPairCodes();
                if (tokens.length == 3 && "E".equalsIgnoreCase(tokens[2])) {
                    pairingList.setInclusionary(false);
                }
                pairingList.add(pairedCode);
                continue;
            }
            if (errorReported.get(tokens[0]) != null) continue;
            errorReported.put(tokens[0], Boolean.TRUE);
            logger.log(Level.FINE, "HH-PPS: Etiology Pairs: Primary Diagnosis code not found or not valid: ''{0}''", tokens[0]);
        }
        if (!errorReported.isEmpty()) {
            logger.log(Level.WARNING, "HH-PPS: Etiology Pairs: Number of Missing/Invalid Diagnosis codes: {0}", errorReported.size());
        }
    }
}

