/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v4115;

import com.mmm.cms.homehealth.DiagnosisCode_Empty;
import com.mmm.cms.homehealth.DiagnosisScoringGrid;
import com.mmm.cms.homehealth.ScoringPoints;
import com.mmm.cms.homehealth.proto.AlreadyScoredException;
import com.mmm.cms.homehealth.proto.DataManagerIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosisScoringGridIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.homehealth.proto.ScoringPointsIF;
import com.mmm.cms.homehealth.v3312.ManifestationUtils;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ScoringEventFormatter;
import com.mmm.cms.util.ScoringModelUtils;
import com.mmm.cms.util.ValidateUtils;
import java.util.Collection;

public class ClinicalFunctional_ScoringModel_v4115
implements HomeHealthScoringModelIF {
    private final int id;
    protected DataManagerIF grouperDataManager;
    protected HomeHealthGrouperIF grouper;
    private transient String shortName;
    private boolean useOptionalLogic;

    public ClinicalFunctional_ScoringModel_v4115(HomeHealthGrouperIF grouper, DataManagerIF grouperDataManager, int equationId) {
        this(grouper, grouperDataManager, equationId, "Clinical/Functional, Equation " + equationId + ": ");
    }

    public ClinicalFunctional_ScoringModel_v4115(HomeHealthGrouperIF grouper, DataManagerIF grouperDataManager, int equationId, String shortName) {
        this.id = equationId;
        this.grouperDataManager = grouperDataManager;
        this.grouper = grouper;
        this.shortName = shortName;
        this.useOptionalLogic = true;
    }

    public boolean isUseOptionalLogic() {
        return this.useOptionalLogic;
    }

    public void setUseOptionalLogic(boolean useOptionalLogic) {
        this.useOptionalLogic = useOptionalLogic;
    }

    @Override
    public HomeHealthGrouperIF getGrouper() {
        return this.grouper;
    }

    @Override
    public String getName() {
        return "Clinical / Functional Scoring Model V4115";
    }

    public String getShortName() {
        return this.shortName;
    }

    protected DiagnosisCodeIF getDiagnosisCode(String codeValue) {
        DiagnosisCodeIF code = DiagnosisCode_Empty.DEFAULT;
        if (codeValue != null && !(codeValue = codeValue.trim()).isEmpty() && (code = this.grouperDataManager.getDiagnosisCode(codeValue)) == null) {
            code = this.grouperDataManager.createDiagnosisCode(codeValue, false, false);
        }
        return code;
    }

    @Override
    public void populateCodes(HomeHealthRecordIF record) {
        DiagnosisCodeIF tmpCode = record.getPRIMARY_DIAG_ICD();
        if (tmpCode != DiagnosisCode_Empty.DEFAULT) {
            record.setPRIMARY_DIAG_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG1_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG1_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG2_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG2_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG3_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG3_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG4_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG4_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if ((tmpCode = record.getOTH_DIAG5_ICD()) != DiagnosisCode_Empty.DEFAULT) {
            record.setOTH_DIAG5_ICD(this.getDiagnosisCode(tmpCode.getCode()));
        }
        if (this.isUseOptionalLogic()) {
            tmpCode = record.getPMT_DIAG_ICD_A3();
            if (tmpCode != DiagnosisCode_Empty.DEFAULT) {
                record.setPMT_DIAG_ICD_A3(this.getDiagnosisCode(tmpCode.getCode()));
            }
            if ((tmpCode = record.getPMT_DIAG_ICD_B3()) != DiagnosisCode_Empty.DEFAULT) {
                record.setPMT_DIAG_ICD_B3(this.getDiagnosisCode(tmpCode.getCode()));
            }
            if ((tmpCode = record.getPMT_DIAG_ICD_C3()) != DiagnosisCode_Empty.DEFAULT) {
                record.setPMT_DIAG_ICD_C3(this.getDiagnosisCode(tmpCode.getCode()));
            }
            if ((tmpCode = record.getPMT_DIAG_ICD_D3()) != DiagnosisCode_Empty.DEFAULT) {
                record.setPMT_DIAG_ICD_D3(this.getDiagnosisCode(tmpCode.getCode()));
            }
            if ((tmpCode = record.getPMT_DIAG_ICD_E3()) != DiagnosisCode_Empty.DEFAULT) {
                record.setPMT_DIAG_ICD_E3(this.getDiagnosisCode(tmpCode.getCode()));
            }
            if ((tmpCode = record.getPMT_DIAG_ICD_F3()) != DiagnosisCode_Empty.DEFAULT) {
                record.setPMT_DIAG_ICD_F3(this.getDiagnosisCode(tmpCode.getCode()));
            }
            if ((tmpCode = record.getPMT_DIAG_ICD_A4()) != DiagnosisCode_Empty.DEFAULT) {
                record.setPMT_DIAG_ICD_A4(this.getDiagnosisCode(tmpCode.getCode()));
            }
            if ((tmpCode = record.getPMT_DIAG_ICD_B4()) != DiagnosisCode_Empty.DEFAULT) {
                record.setPMT_DIAG_ICD_B4(this.getDiagnosisCode(tmpCode.getCode()));
            }
            if ((tmpCode = record.getPMT_DIAG_ICD_C4()) != DiagnosisCode_Empty.DEFAULT) {
                record.setPMT_DIAG_ICD_C4(this.getDiagnosisCode(tmpCode.getCode()));
            }
            if ((tmpCode = record.getPMT_DIAG_ICD_D4()) != DiagnosisCode_Empty.DEFAULT) {
                record.setPMT_DIAG_ICD_D4(this.getDiagnosisCode(tmpCode.getCode()));
            }
            if ((tmpCode = record.getPMT_DIAG_ICD_E4()) != DiagnosisCode_Empty.DEFAULT) {
                record.setPMT_DIAG_ICD_E4(this.getDiagnosisCode(tmpCode.getCode()));
            }
            if ((tmpCode = record.getPMT_DIAG_ICD_F4()) != DiagnosisCode_Empty.DEFAULT) {
                record.setPMT_DIAG_ICD_F4(this.getDiagnosisCode(tmpCode.getCode()));
            }
        }
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void preprocessRecord(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void preprocessRecord(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, Collection<HomeHealthEventListenerIF> listeners) {
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder, Collection<HomeHealthEventListenerIF> listeners) {
        ScoringPoints points = new ScoringPoints(2);
        this.preprocessRecord(record, validator, listeners);
        points.setScoreAt(0, this.scoreClinical(record, validator, scoreOrder, listeners));
        points.setScoreAt(1, this.scoreFunctional(record, validator, listeners));
        ScoringEventFormatter.fireScoringGeneral(listeners, this.grouper, this, "Final equation score (clinical + functional): ", Integer.toString(points.getScores()[0] + points.getScores()[1]));
        return points;
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder) {
        return this.score(record, validator, scoreOrder, null);
    }

    public void scoreAny(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, HomeHealthRecordValidatorIF validator, int diagIdx, DiagnosisScoringGridIF scoringGrid, Collection<HomeHealthEventListenerIF> listeners) throws AlreadyScoredException {
        switch (diagCode.getDiagnosticGroup().getId()) {
            case 1: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 1, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 1, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 1, tmpScore);
                break;
            }
            case 2: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 2, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 2, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 2, tmpScore);
                break;
            }
            case 3: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 3, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 3, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 3, tmpScore);
                break;
            }
            case 5: {
                int tmpScore;
                if (record.isDiagnosticGroupOnRecord(12, diagIdx)) {
                    tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 6, this.id);
                    scoringGrid.addScore(diagCode, diagIdx, 6, tmpScore, true);
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 6, tmpScore);
                }
                if (!validator.isTHERAPIES_Valid() || !validator.isINTERNAL_LOGIC_Valid() || !"1".equals(record.getTHH_ENT_NUTRITION())) break;
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 7, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 7, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 7, tmpScore);
                break;
            }
            case 6: {
                int tmpInt;
                if (!validator.isSTGPRSUL_Valid() || (tmpInt = IntegerUtils.parseInt(record.getSTG_PRBLM_ULCER(), Integer.MAX_VALUE)) < 1 || tmpInt > 4) break;
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 19, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 19, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 19, tmpScore);
                break;
            }
            case 7: {
                int tmpInt;
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 8, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 8, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 8, tmpScore);
                if (validator.isOSTOMY_Valid() && ((tmpInt = IntegerUtils.parseInt(record.getOSTOMY(), Integer.MAX_VALUE)) == 1 || tmpInt == 2)) {
                    tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 9, this.id);
                    scoringGrid.addScore(diagCode, diagIdx, 9, tmpScore, true);
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 9, tmpScore);
                }
                if (!record.isDiagnosticGroupOnRecord(10, diagIdx) && !record.isDiagnosticGroupOnRecord(11, diagIdx) && !record.isDiagnosticGroupOnRecord(12, diagIdx) && !record.isDiagnosticGroupOnRecord(13, diagIdx)) break;
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 10, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 10, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 10, tmpScore);
                break;
            }
            case 8: 
            case 9: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 11, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 11, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 11, tmpScore);
                break;
            }
            case 10: {
                int tmpScore;
                int tmpInt;
                if (validator.isCUR_TOILETING_Valid() && (tmpInt = IntegerUtils.parseInt(record.getCRNT_TOILTG(), Integer.MAX_VALUE)) >= 2 && tmpInt <= 4) {
                    tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 13, this.id);
                    scoringGrid.addScore(diagCode, diagIdx, 13, tmpScore, true);
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 13, tmpScore);
                }
            }
            case 11: {
                if (!validator.isCUR_DRESS_Valid()) break;
                int tmpInt = IntegerUtils.parseInt(record.getCRNT_DRESS_UPPER(), Integer.MAX_VALUE);
                int tmpInt2 = IntegerUtils.parseInt(record.getCRNT_DRESS_LOWER(), Integer.MAX_VALUE);
                if ((tmpInt < 1 || tmpInt > 3) && (tmpInt2 < 1 || tmpInt2 > 3)) break;
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 14, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 14, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 14, tmpScore);
                break;
            }
            case 12: {
                int tmpInt;
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 15, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 15, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 15, tmpScore);
                if (validator.isCUR_DRESS_Valid()) {
                    tmpInt = IntegerUtils.parseInt(record.getCRNT_DRESS_UPPER(), Integer.MAX_VALUE);
                    int tmpInt2 = IntegerUtils.parseInt(record.getCRNT_DRESS_LOWER(), Integer.MAX_VALUE);
                    if (tmpInt >= 1 && tmpInt <= 3 || tmpInt2 >= 1 && tmpInt2 <= 3) {
                        tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 16, this.id);
                        scoringGrid.addScore(diagCode, diagIdx, 16, tmpScore, true);
                        ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 16, tmpScore);
                    }
                }
                if (!validator.isCUR_AMBULATION_Valid() || (tmpInt = IntegerUtils.parseInt(record.getCRNT_AMBLTN(), Integer.MAX_VALUE)) < 4 || tmpInt > 6) break;
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 17, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 17, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 17, tmpScore);
                break;
            }
            case 13: {
                int tmpInt4;
                int tmpInt = validator.isCUR_BATHING_Valid() ? IntegerUtils.parseInt(record.getCRNT_BATHG(), Integer.MIN_VALUE) : 0;
                int tmpInt2 = validator.isCUR_TOILETING_Valid() ? IntegerUtils.parseInt(record.getCRNT_TOILTG(), Integer.MIN_VALUE) : 0;
                int tmpInt3 = validator.isCUR_TRANSFER_Valid() ? IntegerUtils.parseInt(record.getCRNT_TRNSFRNG(), Integer.MIN_VALUE) : 0;
                int n = tmpInt4 = validator.isCUR_AMBULATION_Valid() ? IntegerUtils.parseInt(record.getCRNT_AMBLTN(), Integer.MIN_VALUE) : 0;
                if (tmpInt < 2 && tmpInt2 < 2 && tmpInt3 < 2 && tmpInt4 < 4) break;
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 18, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 18, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 18, tmpScore);
                break;
            }
            case 14: {
                int tmpScore;
                int tmpInt;
                if (validator.isSTGPRSUL_Valid() && (tmpInt = IntegerUtils.parseInt(record.getSTG_PRBLM_ULCER(), Integer.MIN_VALUE)) >= 1 && tmpInt <= 4) {
                    tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 19, this.id);
                    scoringGrid.addScore(diagCode, diagIdx, 19, tmpScore, true);
                    ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 19, tmpScore);
                }
            }
            case 15: {
                if (!validator.isINTERNAL_LOGIC_Valid() || !validator.isTHERAPIES_Valid() || !"1".equals(record.getTHH_IV_INFUSION()) && !"1".equals(record.getTHH_PAR_NUTRITION())) break;
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 20, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 20, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 20, tmpScore);
                break;
            }
            case 16: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 21, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 21, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 21, tmpScore);
                break;
            }
            case 17: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 22, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 22, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 22, tmpScore);
                break;
            }
            case 18: {
                int tmpInt;
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 23, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 23, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 23, tmpScore);
                if (!validator.isCUR_AMBULATION_Valid() || (tmpInt = IntegerUtils.parseInt(record.getCRNT_AMBLTN(), Integer.MIN_VALUE)) < 1 || tmpInt > 6) break;
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 24, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 24, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 24, tmpScore);
                break;
            }
            case 20: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 28, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 28, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 28, tmpScore);
            }
            case 19: {
                if (!validator.isINTERNAL_LOGIC_Valid() || !validator.isTHERAPIES_Valid() || !"1".equals(record.getTHH_IV_INFUSION()) && !"1".equals(record.getTHH_PAR_NUTRITION())) break;
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 27, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 27, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 27, tmpScore);
                break;
            }
            case 21: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 29, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 29, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 29, tmpScore);
                break;
            }
            case 22: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 30, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 30, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 30, tmpScore);
            }
        }
    }

    public int scoreClinical(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder, Collection<HomeHealthEventListenerIF> listeners) {
        DiagnosisScoringGrid scoringGrid = new DiagnosisScoringGrid();
        ScoringEventFormatter.fireScoringSectionStart(listeners, this.grouper, this, "Clinical Scoring");
        for (int currentPass = 1; currentPass <= 2; ++currentPass) {
            for (int diagIdx = 0; diagIdx < 6; ++diagIdx) {
                DiagnosisCodeIF pairedDiagCode;
                DiagnosisCodeIF diagCode = record.getDiagnosisCode(diagIdx);
                if (this.useOptionalLogic && diagCode.isVCode() && diagCode.isOptionalPaymentCode()) {
                    if (!diagCode.isEtiologyInPairingList(record.getOptionalDiagnosisCode3(diagIdx))) continue;
                    this.scoreClinicalColumn3_4(record, validator, diagIdx, scoringGrid, scoreOrder, currentPass, listeners);
                    continue;
                }
                if (currentPass != scoreOrder[diagIdx][0] || !diagCode.isValidForScoring()) continue;
                this.scoreClinicalCode(record, diagCode, validator, diagIdx, scoringGrid, listeners);
                if (!diagCode.isSecondaryOnly() || (pairedDiagCode = ManifestationUtils.getPairedCode(this.grouper, record, diagCode, diagIdx)) == null || !pairedDiagCode.isValidForScoring()) continue;
                if (scoringGrid.getTotalScoreForDiagnosis(pairedDiagCode.getOffset()) == 0) {
                    this.scoreClinicalCode(record, pairedDiagCode, validator, pairedDiagCode.getOffset(), scoringGrid, listeners);
                }
                ScoringModelUtils.resolveEtiologyManifestationContention(this.grouper, this, pairedDiagCode, pairedDiagCode.getOffset(), diagCode, diagIdx, scoringGrid, listeners);
            }
        }
        int totalScore = scoringGrid.getTotalScore();
        totalScore += this.scoreRemainingVariables(record, validator, totalScore, listeners);
        ScoringEventFormatter.fireScoringSectionFinished(listeners, this.grouper, (HomeHealthScoringModelIF)this, "Clinical Scoring", totalScore);
        return totalScore;
    }

    public void scoreClinicalCode(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, HomeHealthRecordValidatorIF validator, int diagIdx, DiagnosisScoringGridIF scoringGrid, Collection<HomeHealthEventListenerIF> listeners) {
        ScoringEventFormatter.fireScoringGeneral(listeners, this.grouper, this, "Attempting to score Diagnosis ", diagCode.getCode(), " (", diagCode.getDiagnosticGroup().getDescription(), ") at position ", Integer.toString(diagIdx + 1));
        try {
            if (diagIdx == 0 || diagIdx == 6 || diagCode.isSecondaryOnly() && (diagIdx == 1 || diagIdx == 12)) {
                this.scorePrimaryOnly(record, diagCode, diagIdx, scoringGrid, listeners);
            } else if (diagIdx == 1 && record.getPRIMARY_DIAG_ICD().isPrimaryAwardableCode() && diagCode.getDiagnosticGroup().isAlternatePrimaryScorable()) {
                this.scorePrimaryOnly(record, diagCode, diagIdx, scoringGrid, listeners);
            } else if (diagIdx == 2 && diagCode.isSecondaryOnly() && record.getPRIMARY_DIAG_ICD().isPrimaryAwardableCode() && record.getOTH_DIAG1_ICD().getDiagnosticGroup().isAlternatePrimaryScorable()) {
                this.scorePrimaryOnly(record, diagCode, diagIdx, scoringGrid, listeners);
            } else if (diagIdx == 2 && diagCode.isSecondaryOnly() && record.getPRIMARY_DIAG_ICD().isPrimaryAwardableCode() && diagCode.getDiagnosticGroup().isAlternatePrimaryScorable()) {
                this.scorePrimaryOnly(record, diagCode, diagIdx, scoringGrid, listeners);
            } else {
                this.scoreOtherOnly(record, diagCode, diagIdx, scoringGrid, listeners);
            }
            this.scoreAny(record, diagCode, validator, diagIdx, scoringGrid, listeners);
        }
        catch (AlreadyScoredException e) {
            ScoringEventFormatter.fireDxGroupAlreadyScored(listeners, this.grouper, this, diagCode, diagIdx + 1, e);
        }
    }

    public void scoreClinicalColumn3_4(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int rowIdx, DiagnosisScoringGridIF scoringGrid, int[][] scoreOrder, int currentPass, Collection<HomeHealthEventListenerIF> listeners) {
        DiagnosisCodeIF diagCodeCol_4;
        DiagnosisCodeIF diagCodeCol_3 = null;
        if (currentPass == scoreOrder[rowIdx][1] && (diagCodeCol_3 = record.getOptionalDiagnosisCode3(rowIdx)).isValidForScoring()) {
            this.scoreClinicalCode(record, diagCodeCol_3, validator, rowIdx + 6, scoringGrid, listeners);
        }
        if (currentPass == scoreOrder[rowIdx][2] && (diagCodeCol_4 = record.getOptionalDiagnosisCode4(rowIdx)).isValidForScoring() && diagCodeCol_4.isSecondaryOnly()) {
            this.scoreClinicalCode(record, diagCodeCol_4, validator, rowIdx + 12, scoringGrid, listeners);
            ScoringModelUtils.resolveEtiologyManifestationContention(this.grouper, this, diagCodeCol_3, rowIdx + 6, diagCodeCol_4, rowIdx + 12, scoringGrid, listeners);
        }
    }

    public int scoreFunctional(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, Collection<HomeHealthEventListenerIF> listeners) {
        int tmpScore;
        int tmpInt;
        int score = 0;
        ScoringEventFormatter.fireScoringSectionStart(listeners, this.grouper, this, "Functional scoring");
        if (validator.isCUR_DRESS_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getCRNT_DRESS_UPPER(), Integer.MAX_VALUE);
            int tmpInt2 = IntegerUtils.parseInt(record.getCRNT_DRESS_LOWER(), Integer.MAX_VALUE);
            if (tmpInt >= 1 && tmpInt <= 3 || tmpInt2 >= 1 && tmpInt2 <= 3) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 46, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "For CUR_DRESS", 46, tmpScore);
            }
        }
        if (validator.isCUR_BATHING_Valid() && (tmpInt = IntegerUtils.parseInt(record.getCRNT_BATHG(), Integer.MAX_VALUE)) >= 2 && tmpInt <= 6) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 47, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "For CUR_BATHING", 47, tmpScore);
        }
        if (validator.isCUR_TOILETING_Valid() && (tmpInt = IntegerUtils.parseInt(record.getCRNT_TOILTG(), Integer.MAX_VALUE)) >= 2 && tmpInt <= 4) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 48, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "For CUR_TOILETING", 48, tmpScore);
        }
        if (validator.isCUR_TRANSFER_Valid() && (tmpInt = IntegerUtils.parseInt(record.getCRNT_TRNSFRNG(), Integer.MAX_VALUE)) >= 2 && tmpInt <= 5) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 49, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "For CUR_TRANSFER", 49, tmpScore);
        }
        if (validator.isCUR_AMBULATION_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getCRNT_AMBLTN(), Integer.MAX_VALUE);
            if (tmpInt >= 1 && tmpInt <= 3) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 50, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "For CUR_AMBULATION", 50, tmpScore);
            } else if (tmpInt >= 4 && tmpInt <= 6) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 51, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "For CUR_AMBULATION", 51, tmpScore);
            }
        }
        ScoringEventFormatter.fireScoringSectionFinished(listeners, this.grouper, (HomeHealthScoringModelIF)this, "Functional scoring", score);
        return score;
    }

    public void scoreOtherOnly(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, int diagIdx, DiagnosisScoringGridIF scoringGrid, Collection<HomeHealthEventListenerIF> listeners) throws AlreadyScoredException {
        switch (diagCode.getDiagnosticGroup().getId()) {
            case 4: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 5, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 5, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 5, tmpScore);
                break;
            }
            case 19: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 26, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 26, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 26, tmpScore);
            }
        }
    }

    public void scorePrimaryOnly(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, int diagIdx, DiagnosisScoringGridIF scoringGrid, Collection<HomeHealthEventListenerIF> listeners) throws AlreadyScoredException {
        switch (diagCode.getDiagnosticGroup().getId()) {
            case 4: {
                int tmpScore = ScoringModelUtils.calculatePrimaryAdjustment(this.grouperDataManager, true, this.id, scoringGrid, 4, 5);
                scoringGrid.addScore(diagCode, diagIdx, 4, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 4, tmpScore);
                break;
            }
            case 10: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 12, this.id);
                scoringGrid.addScore(diagCode, diagIdx, 12, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 12, tmpScore);
                break;
            }
            case 19: {
                int tmpScore = ScoringModelUtils.calculatePrimaryAdjustment(this.grouperDataManager, true, this.id, scoringGrid, 25, 26);
                scoringGrid.addScore(diagCode, diagIdx, 25, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 25, tmpScore);
            }
        }
    }

    public int scoreRemainingVariables(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int currentScore, Collection<HomeHealthEventListenerIF> listeners) {
        int tmpInt;
        int tmpScore;
        int score = 0;
        if (validator.isINTERNAL_LOGIC_Valid() && validator.isTHERAPIES_Valid()) {
            if ("1".equals(record.getTHH_IV_INFUSION()) || "1".equals(record.getTHH_PAR_NUTRITION())) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 31, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item THH_IV_INFUSION or THH_PAR_NUTRITION", 31, tmpScore);
            }
            if ("1".equals(record.getTHH_ENT_NUTRITION())) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 32, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item THH_ENT_NUTRITION", 32, tmpScore);
            }
        }
        if ((tmpInt = IntegerUtils.parseInt(record.getVISION(), Integer.MAX_VALUE)) == 1 || tmpInt == 2) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 33, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item VISION", 33, tmpScore);
        }
        if ((tmpInt = IntegerUtils.parseInt(record.getPAIN_FREQ_ACTVTY_MVMT(), Integer.MAX_VALUE)) == 3 || tmpInt == 4) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 34, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item FREQ_PAIN", 34, tmpScore);
        }
        if (validator.isNPRSULC3_Valid() && validator.isNPRSULC4_Valid()) {
            int tmpInt2 = 0;
            tmpInt = 0;
            String tmpStr = record.getNBR_PRSULC_STG3();
            if (!ValidateUtils.isEmpty(tmpStr)) {
                tmpInt = IntegerUtils.parseInt(tmpStr, 0);
            }
            if (!ValidateUtils.isEmpty(tmpStr = record.getNBR_PRSULC_STG4())) {
                tmpInt2 = IntegerUtils.parseInt(tmpStr, 0);
            }
            if (tmpInt + tmpInt2 >= 2) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 35, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item NBR_PRSULC_STG3 + NBR_PRSULC_STG4", 35, tmpScore);
            }
        }
        if (validator.isSTGPRSUL_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getSTG_PRBLM_ULCER(), Integer.MAX_VALUE);
            if (tmpInt == 1 || tmpInt == 2) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 36, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item STG_PRBLM_ULCER = 01 or 02", 36, tmpScore);
            } else if (tmpInt == 3 || tmpInt == 4) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 37, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item STG_PRBLM_ULCER = 03 or 04", 37, tmpScore);
            }
        }
        if (validator.isSTATSTASIS_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getSTUS_PRBLM_STAS_ULCR(), Integer.MAX_VALUE);
            if (tmpInt == 2) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 38, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item STAT_PRB_STASULC = 02", 38, tmpScore);
            } else if (tmpInt == 3) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 39, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item STAT_PRB_STASULC = 03", 39, tmpScore);
            }
        }
        if (validator.isSTATSURG_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getSTUS_PRBLM_SRGCL_WND(), Integer.MAX_VALUE);
            if (tmpInt == 2) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 40, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item STAT_PRB_SURGWND = 02", 40, tmpScore);
            } else if (tmpInt == 3) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 41, this.id);
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item STAT_PRB_SURGWND = 03", 41, tmpScore);
            }
        }
        if (validator.isDYSPNEIC_Valid() && (tmpInt = IntegerUtils.parseInt(record.getWHEN_DYSPNEIC(), Integer.MAX_VALUE)) >= 2 && tmpInt <= 4) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 42, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item WHEN_DYSPNEIC = 02,03 or 04", 42, tmpScore);
        }
        if (validator.isBWLINCONT_Valid() && (tmpInt = IntegerUtils.parseInt(record.getBWL_INCONT(), Integer.MAX_VALUE)) >= 2 && tmpInt <= 5) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 43, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item BWL_INCONT = 02,03,04 or 05", 43, tmpScore);
        }
        if (validator.isOSTOMY_Valid() && ((tmpInt = IntegerUtils.parseInt(record.getOSTOMY(), Integer.MAX_VALUE)) == 1 || tmpInt == 2)) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 44, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item OSTOMY = 01 or 02", 44, tmpScore);
        }
        if (validator.isCUR_INJECT_MEDS_Valid() && (tmpInt = IntegerUtils.parseInt(record.getCRNT_MGMT_INJCTN_MDCTN(), Integer.MAX_VALUE)) >= 0 && tmpInt <= 3) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, true, 45, this.id);
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "Special Item CUR_INJECT_MEDS = 00, 01, 02 or 03", 45, tmpScore);
        }
        return score;
    }

    @Override
    public void setGrouper(HomeHealthGrouperIF grouper) {
        this.grouper = grouper;
    }

    @Override
    public void setName(String name) {
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
    }
}

