/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v4115;

import com.mmm.cms.homehealth.DiagnosisCode_Empty;
import com.mmm.cms.homehealth.ScoringPoints;
import com.mmm.cms.homehealth.proto.AlreadyScoredException;
import com.mmm.cms.homehealth.proto.DataManagerIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosisScoringGridIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.HomeHealthRecord_C_IF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.homehealth.proto.ScoringPointsIF;
import com.mmm.cms.homehealth.v4115.ClinicalFunctional_ScoringModel_v4115;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ScoringEventFormatter;
import com.mmm.cms.util.ScoringModelUtils;
import com.mmm.cms.util.ValidateUtils;
import java.util.Collection;

public class NRS_ScoringModel_v4115
extends ClinicalFunctional_ScoringModel_v4115 {
    public NRS_ScoringModel_v4115(HomeHealthGrouperIF grouper, DataManagerIF dataManager) {
        super(grouper, dataManager, 1, "NRS Equation");
    }

    @Override
    public ScoringPointsIF score(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int[][] scoreOrder, Collection<HomeHealthEventListenerIF> listeners) {
        ScoringPoints points = new ScoringPoints(1);
        this.preprocessRecord(record, validator, listeners);
        points.setScoreAt(0, this.scoreClinical(record, validator, scoreOrder, listeners));
        ScoringEventFormatter.fireScoringGeneral(listeners, this.grouper, this, "Final NRS equation score: ", Integer.toString(points.getScores()[0]));
        return points;
    }

    @Override
    public void preprocessRecord(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, Collection<HomeHealthEventListenerIF> listeners) {
        int idx;
        DiagnosisCodeIF code;
        int ulcerIndex;
        ScoringEventFormatter.fireScoringSectionStart(listeners, this.grouper, this, "NRS Pre-process record");
        DiagnosisCodeIF primaryCode = record.getPRIMARY_DIAG_ICD();
        if (primaryCode.isOptionalPaymentCode() && primaryCode.isValidEtiologyPairing(record.getPMT_DIAG_ICD_A3())) {
            primaryCode = record.getPMT_DIAG_ICD_A3();
            ulcerIndex = 1;
        } else if (primaryCode.isPrimaryAwardableCode()) {
            primaryCode = record.getOTH_DIAG1_ICD();
            ulcerIndex = 2;
        } else {
            ulcerIndex = 1;
        }
        if (primaryCode.isDiabeticUlcer()) {
            code = record.getDiagnosisCode(ulcerIndex);
            if (code.isOptionalPaymentCode()) {
                code = record.getDiagnosisCode(ulcerIndex + 6);
                if (code.isUlcer()) {
                    code.setValidForScoring(false);
                } else {
                    primaryCode.setValidForScoring(false);
                    ScoringEventFormatter.fireScoringGeneral(listeners, this.grouper, this, "Set PRIMARY_DIAG_ICD not valid for scoring due to missing Ulcer code in column 3");
                }
            } else if (!code.isValidForScoring() || !code.isUlcer()) {
                primaryCode.setValidForScoring(false);
                ScoringEventFormatter.fireScoringGeneral(listeners, this.grouper, this, "Set PRIMARY_DIAG_ICD not valid for scoring due to missing Ulcer code");
            } else if (code.isUlcer()) {
                code.setValidForScoring(false);
            }
        }
        for (idx = ulcerIndex; idx < 6; ++idx) {
            code = record.getDiagnosisCode(idx);
            if (!code.isDiabeticUlcer()) continue;
            code.setValidForScoring(false);
            ScoringEventFormatter.fireScoringGeneral(listeners, this.grouper, this, "Set DIAG code ", code.getCode(), " not valid for scoring due previous Diabetic Ulcer code");
        }
        if (this.isUseOptionalLogic()) {
            for (idx = ulcerIndex; idx < 6; ++idx) {
                code = record.getOptionalDiagnosisCode3(idx);
                if (!code.isDiabeticUlcer()) continue;
                code.setValidForScoring(false);
                ScoringEventFormatter.fireScoringGeneral(listeners, this.grouper, this, "Set DIAG code ", code.getCode(), " not valid for scoring due previous Diabetic Ulcer code");
            }
        }
        ScoringEventFormatter.fireScoringSectionFinished(listeners, this.grouper, (HomeHealthScoringModelIF)this, "NRS Pre-process record", 0);
    }

    @Override
    public void scorePrimaryOnly(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, int diagIdx, DiagnosisScoringGridIF scoringGrid, Collection<HomeHealthEventListenerIF> listeners) throws AlreadyScoredException {
        switch (diagCode.getDiagnosticGroup().getId()) {
            case 1: {
                int tmpScore = ScoringModelUtils.calculatePrimaryAdjustment(this.grouperDataManager, false, 1, scoringGrid, 1, 2);
                scoringGrid.setScore(diagCode, diagIdx, 1, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 1, tmpScore);
                break;
            }
            case 2: {
                int tmpScore = ScoringModelUtils.calculatePrimaryAdjustment(this.grouperDataManager, false, 1, scoringGrid, 3, 4);
                scoringGrid.setScore(diagCode, diagIdx, 3, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 3, tmpScore);
                break;
            }
            case 3: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 5, this.getId());
                scoringGrid.addScore(diagCode, diagIdx, 5, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 5, tmpScore);
                break;
            }
            case 4: {
                int tmpScore = ScoringModelUtils.calculatePrimaryAdjustment(this.grouperDataManager, false, 1, scoringGrid, 6, 7);
                scoringGrid.setScore(diagCode, diagIdx, 6, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 6, tmpScore);
                break;
            }
            case 5: {
                int tmpScore = ScoringModelUtils.calculatePrimaryAdjustment(this.grouperDataManager, false, 1, scoringGrid, 8, 9);
                scoringGrid.setScore(diagCode, diagIdx, 8, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 8, tmpScore);
                break;
            }
            case 7: {
                int tmpScore = ScoringModelUtils.calculatePrimaryAdjustment(this.grouperDataManager, false, 1, scoringGrid, 11, 12);
                scoringGrid.setScore(diagCode, diagIdx, 11, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 11, tmpScore);
                break;
            }
            case 8: {
                int tmpScore = ScoringModelUtils.calculatePrimaryAdjustment(this.grouperDataManager, false, 1, scoringGrid, 13, 14);
                scoringGrid.setScore(diagCode, diagIdx, 13, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 13, tmpScore);
                break;
            }
            case 9: {
                int tmpScore = ScoringModelUtils.calculatePrimaryAdjustment(this.grouperDataManager, false, 1, scoringGrid, 15, 16);
                scoringGrid.setScore(diagCode, diagIdx, 15, tmpScore, false);
                ScoringEventFormatter.fireScoringIncreasePrimaryCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 15, tmpScore);
                break;
            }
            default: {
                ScoringEventFormatter.fireScoringGeneral(listeners, this.grouper, this, "Diagnosis code '", diagCode.getCode(), "' valid for scoring, but Diagnosis Group ", Integer.toString(diagCode.getDiagnosticGroup().getId()), " not scorable for Primary-Only diagnosis.");
            }
        }
    }

    @Override
    public void scoreOtherOnly(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, int diagIdx, DiagnosisScoringGridIF scoringGrid, Collection<HomeHealthEventListenerIF> listeners) throws AlreadyScoredException {
        switch (diagCode.getDiagnosticGroup().getId()) {
            case 1: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 2, this.getId());
                scoringGrid.addScore(diagCode, diagIdx, 2, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 2, tmpScore);
                break;
            }
            case 2: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 4, this.getId());
                scoringGrid.addScore(diagCode, diagIdx, 4, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 4, tmpScore);
                break;
            }
            case 4: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 7, this.getId());
                scoringGrid.addScore(diagCode, diagIdx, 7, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 7, tmpScore);
                break;
            }
            case 5: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 9, this.getId());
                scoringGrid.addScore(diagCode, diagIdx, 9, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 9, tmpScore);
                break;
            }
            case 7: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 12, this.getId());
                scoringGrid.addScore(diagCode, diagIdx, 12, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 12, tmpScore);
                break;
            }
            case 8: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 14, this.getId());
                scoringGrid.addScore(diagCode, diagIdx, 14, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 14, tmpScore);
                break;
            }
            case 9: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 16, this.getId());
                scoringGrid.addScore(diagCode, diagIdx, 16, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 16, tmpScore);
                break;
            }
            default: {
                ScoringEventFormatter.fireScoringGeneral(listeners, this.grouper, this, "Diagnosis code '", diagCode.getCode(), "' valid for scoring, but Diagnosis Group ", Integer.toString(diagCode.getDiagnosticGroup().getId()), " not scorable for Other-Only diagnosis.");
            }
        }
    }

    @Override
    public void scoreAny(HomeHealthRecordIF record, DiagnosisCodeIF diagCode, HomeHealthRecordValidatorIF validator, int diagIdx, DiagnosisScoringGridIF scoringGrid, Collection<HomeHealthEventListenerIF> listeners) throws AlreadyScoredException {
        switch (diagCode.getDiagnosticGroup().getId()) {
            case 6: {
                if (record.isDiagnosticGroupOnRecord(3, diagIdx)) break;
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 10, this.getId());
                scoringGrid.addScore(diagCode, diagIdx, 10, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 10, tmpScore);
                break;
            }
            case 10: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 17, this.getId());
                scoringGrid.addScore(diagCode, diagIdx, 17, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 17, tmpScore);
                break;
            }
            case 11: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 18, this.getId());
                scoringGrid.addScore(diagCode, diagIdx, 18, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 18, tmpScore);
                break;
            }
            case 12: {
                int tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 19, this.getId());
                scoringGrid.addScore(diagCode, diagIdx, 19, tmpScore, true);
                ScoringEventFormatter.fireScoringIncreaseCodeEvent(listeners, this.grouper, this, diagCode, diagIdx + 1, 19, tmpScore);
                break;
            }
        }
    }

    @Override
    public int scoreRemainingVariables(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, int currentScore, Collection<HomeHealthEventListenerIF> listeners) {
        String tmpStr;
        int tmpScore;
        int tmpInt;
        int score = 0;
        ScoringEventFormatter.fireScoringSectionStart(listeners, this.grouper, this, "calculate Special Items");
        if (validator.isNPRSULC1_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getNBR_PRSULC_STG1(), Integer.MAX_VALUE);
            if (tmpInt == 1 || tmpInt == 2) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 20, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG1", 20, tmpScore);
            } else if (tmpInt == 3 || tmpInt == 4) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 21, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG1", 21, tmpScore);
            }
        }
        if (validator.isNPRSULC2_Valid() && !ValidateUtils.isValidValue(tmpStr = record.getNBR_PRSULC_STG2(), new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
            tmpInt = IntegerUtils.parseInt(tmpStr, Integer.MAX_VALUE);
            if (1 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 22, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG2", 22, tmpScore);
            } else if (2 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 23, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG2", 23, tmpScore);
            } else if (3 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 24, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG2", 24, tmpScore);
            } else if (4 <= tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 25, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG2", 25, tmpScore);
            }
        }
        if (validator.isNPRSULC3_Valid() && !ValidateUtils.isValidValue(tmpStr = record.getNBR_PRSULC_STG3(), new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
            tmpInt = IntegerUtils.parseInt(tmpStr, Integer.MAX_VALUE);
            if (1 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 26, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG3", 26, tmpScore);
            } else if (2 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 27, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG3", 27, tmpScore);
            } else if (3 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 28, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG3", 28, tmpScore);
            } else if (4 <= tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 29, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG3", 29, tmpScore);
            }
        }
        if (validator.isNPRSULC4_Valid() && !ValidateUtils.isValidValue(tmpStr = record.getNBR_PRSULC_STG4(), new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
            tmpInt = IntegerUtils.parseInt(tmpStr, Integer.MAX_VALUE);
            if (1 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 30, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG4", 30, tmpScore);
            } else if (2 == tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 31, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG4", 31, tmpScore);
            } else if (3 <= tmpInt) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 32, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_PRSULC_STG4", 32, tmpScore);
            }
        }
        if (validator.isUNOBS_PRSULC_Valid()) {
            tmpInt = IntegerUtils.parseInt(((HomeHealthRecord_C_IF)record).getNSTG_DRSG(), Integer.MIN_VALUE);
            int tmpInt2 = IntegerUtils.parseInt(((HomeHealthRecord_C_IF)record).getNSTG_CVRG(), Integer.MIN_VALUE);
            if (tmpInt > 0 || tmpInt2 > 0) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 33, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NSTG_DRSG or NSTG_CVRG", 33, tmpScore);
            }
        }
        if (validator.isNBR_STASULC_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getNBR_STAS_ULCR(), Integer.MAX_VALUE);
            if (tmpInt == 2) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 34, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_STASULC", 34, tmpScore);
            } else if (tmpInt == 3) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 35, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_STASULC", 35, tmpScore);
            } else if (tmpInt == 4) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 36, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to NBR_STASULC", 36, tmpScore);
            }
        }
        if (validator.isUNOBS_STASULC_Valid() && ((tmpInt = IntegerUtils.parseInt(record.getSTAS_ULCR_PRSNT(), Integer.MAX_VALUE)) == 1 || tmpInt == 3)) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 37, this.getId());
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to Unobserved STAS_ULCR_PRSNT", 37, tmpScore);
        }
        if (validator.isSTATSTASIS_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getSTUS_PRBLM_STAS_ULCR(), Integer.MAX_VALUE);
            if (tmpInt == 1) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 38, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to STAT_PRB_STASULC", 38, tmpScore);
            } else if (tmpInt == 2) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 39, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to STAT_PRB_STASULC", 39, tmpScore);
            } else if (tmpInt == 3) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 40, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to STAT_PRB_STASULC", 40, tmpScore);
            }
        }
        if (validator.isSTATSURG_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getSTUS_PRBLM_SRGCL_WND(), Integer.MAX_VALUE);
            if (tmpInt == 2) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 41, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to STAT_PRB_SURGWND", 41, tmpScore);
            } else if (tmpInt == 3) {
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 42, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to STAT_PRB_SURGWND", 42, tmpScore);
            }
        }
        if (validator.isOSTOMY_Valid()) {
            tmpInt = IntegerUtils.parseInt(record.getOSTOMY(), Integer.MAX_VALUE);
            if (tmpInt == 1) {
                if (currentScore > 0 || score > 0) {
                    tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 45, this.getId());
                    score += tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to OSTOMY and skin score > 0", 45, tmpScore);
                }
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 43, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to OSTOMY", 43, tmpScore);
            } else if (tmpInt == 2) {
                if (currentScore > 0 || score > 0) {
                    tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 46, this.getId());
                    score += tmpScore;
                    ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to OSTOMY and skin score > 0", 46, tmpScore);
                }
                tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 44, this.getId());
                score += tmpScore;
                ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to OSTOMY", 44, tmpScore);
            }
        }
        if (validator.isTHERAPIES_Valid() && validator.isINTERNAL_LOGIC_Valid() && "1".equals(record.getTHH_IV_INFUSION())) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 47, this.getId());
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to THH_IV_INFUSION", 47, tmpScore);
        }
        if (validator.isUR_INCONT_Valid() && (tmpInt = IntegerUtils.parseInt(record.getUR_INCONT(), Integer.MAX_VALUE)) == 2) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 48, this.getId());
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to UR_INCONT", 48, tmpScore);
        }
        if (validator.isBWLINCONT_Valid() && ((tmpInt = IntegerUtils.parseInt(record.getBWL_INCONT(), Integer.MAX_VALUE)) == 4 || tmpInt == 5)) {
            tmpScore = ScoringModelUtils.getCaseMixAdjustmentEquation(this.grouperDataManager, false, 49, this.getId());
            score += tmpScore;
            ScoringEventFormatter.fireScoringIncreaseEvent(listeners, this.grouper, this, "score added due to BWL_INCONT", 49, tmpScore);
        }
        ScoringEventFormatter.fireScoringSectionFinished(listeners, this.grouper, (HomeHealthScoringModelIF)this, "calculate Special Items", score);
        return score;
    }

    @Override
    public String getName() {
        return "Non-Routine Supplies Scoring Model v4115";
    }

    @Override
    protected DiagnosisCodeIF getDiagnosisCode(String codeValue) {
        DiagnosisCodeIF code = DiagnosisCode_Empty.DEFAULT;
        if (codeValue != null && !(codeValue = codeValue.trim()).isEmpty() && (code = this.grouperDataManager.getNRSDiagnosisCode(codeValue)) == null) {
            code = this.grouperDataManager.createDiagnosisCode(codeValue, false, false);
        }
        return code;
    }
}

