/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.v3210.AbstractBaseValidator_v3210;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractClinicalItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateLesionOpenWound
extends AbstractClinicalItemValidator
implements RecordItemValidatorIF {
    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_3060});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractBaseValidator_v3210.ASSESSMENT_1_3_ONLY}) && !ValidateUtils.isValidValue(record.getLESION_OPEN_WND(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
            ++count;
            edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1350_LESION_OPEN_WND", record.getLESION_OPEN_WND())));
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates Lesion Open Wound for edits: 3060";
    }
}

