/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.util;

import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MacroProperties
extends Properties {
    public static void main(String[] args) {
        MacroProperties props = new MacroProperties();
        props.setProperty("base.dir", "C:\\Program Files\\HomeHealthGrouper");
        props.setProperty("data.dir", "${base.dir}\\dataAndStuff");
        System.out.println("Raw Properties");
        System.out.println("\t" + props.getPropertyRaw("base.dir"));
        System.out.println("\t" + props.getPropertyRaw("data.dir"));
        System.out.println("\t" + props.getPropertyRaw("junk"));
        System.out.println("Marco Properties");
        System.out.println("\t" + ((Properties)props).getProperty("base.dir"));
        System.out.println("\t" + ((Properties)props).getProperty("data.dir"));
        System.out.println("\t" + ((Properties)props).getProperty("junk"));
    }

    public MacroProperties() {
    }

    public MacroProperties(Properties props) {
        super(props);
        Enumeration<Object> enumeration = props.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            this.setProperty(key, props.getProperty(key));
        }
    }

    @Override
    public String getProperty(String arg0) {
        String str;
        try {
            String value = super.getProperty(arg0);
            str = this.parsePropertiesInString(value, false);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
            str = null;
        }
        return str;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String property;
        try {
            defaultValue = super.getProperty(key, defaultValue);
            property = this.parsePropertiesInString(defaultValue, false);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
            property = defaultValue;
        }
        return property;
    }

    public String parsePropertiesInString(String string, boolean failIfMissing) throws Exception {
        int startIndex;
        if (string != null && (startIndex = string.indexOf("${")) != -1) {
            String value;
            int endIndex;
            int openedBrackets = 1;
            int lastStartIndex = startIndex + 2;
            while (true) {
                endIndex = string.indexOf("}", lastStartIndex);
                int otherStartIndex = string.indexOf("${", lastStartIndex);
                if (otherStartIndex != -1 && otherStartIndex < endIndex) {
                    ++openedBrackets;
                    lastStartIndex = otherStartIndex + 2;
                    continue;
                }
                if (--openedBrackets == 0) break;
                lastStartIndex = endIndex + 1;
            }
            if (endIndex < startIndex + 2) {
                throw new Exception("Unclosed brackets in " + string);
            }
            String property = string.substring(startIndex + 2, endIndex);
            String propertyName = this.parsePropertiesInString(property, failIfMissing);
            String string2 = value = "".equals(propertyName) ? "" : (String)this.get(propertyName);
            if (value == null) {
                if (failIfMissing) {
                    throw new Exception("Property \"" + propertyName + "\" is not defined. Please check the order in which you have used your properties.");
                }
                value = "${" + propertyName + "}";
            }
            string = string.substring(0, startIndex) + value + this.parsePropertiesInString(string.substring(endIndex + 1), failIfMissing);
        }
        return string;
    }

    public String getPropertyRaw(String key) {
        return super.getProperty(key);
    }
}

