/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.AbstractGrouper;
import com.mmm.cms.homehealth.hipps.HIPPSCode;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HIPPSCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.PointsScoringEquationsIF;
import com.mmm.cms.homehealth.proto.ScoringResultsIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import java.util.Calendar;
import java.util.Collection;

public abstract class AbstractGrouper_2
extends AbstractGrouper {
    public AbstractGrouper_2(Calendar start, Calendar thru, Calendar window, String versionName) {
        super(start, thru, window, versionName);
    }

    @Override
    public int[][] determineScoreOrder(HomeHealthRecordIF record) {
        int[][] scoreOrder = new int[6][3];
        block0: for (int diagIdx = 0; diagIdx < 6; ++diagIdx) {
            DiagnosisCodeIF diagCode = record.getDiagnosisCode(diagIdx);
            if (diagCode.isOptionalPaymentCode()) {
                DiagnosisCodeIF diagCodeOptional = record.getOptionalDiagnosisCode4(diagIdx);
                if (diagCodeOptional.isValidForScoring()) {
                    scoreOrder[diagIdx][2] = 2;
                    scoreOrder[diagIdx][1] = 2;
                    continue;
                }
                diagCodeOptional = record.getOptionalDiagnosisCode3(diagIdx);
                if (!diagCodeOptional.isValidForScoring()) continue;
                scoreOrder[diagIdx][1] = 1;
                continue;
            }
            if (!diagCode.isValidForScoring()) continue;
            if (diagCode.isSecondaryOnly()) {
                scoreOrder[diagIdx][0] = 2;
                for (int preIdx = diagIdx - 1; preIdx >= 0; --preIdx) {
                    DiagnosisCodeIF prevDiagCode = record.getDiagnosisCode(preIdx);
                    if (!diagCode.isValidEtiologyPairing(prevDiagCode)) continue;
                    scoreOrder[preIdx][0] = 2;
                    continue block0;
                }
                continue;
            }
            scoreOrder[diagIdx][0] = 1;
        }
        return scoreOrder;
    }

    public abstract ScoringResultsIF score(HomeHealthRecordIF var1, boolean var2, CollectionValidationEditsIF var3, Collection<HomeHealthEventListenerIF> var4);

    public ScoringResultsIF score(HomeHealthRecordIF recordOasisC, boolean validateDates) {
        return this.score(recordOasisC, validateDates, null, null);
    }

    public HIPPSCodeIF createHippsCode() {
        return new HIPPSCode();
    }

    public HIPPSCodeIF createHippsCode(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, PointsScoringEquationsIF clinicalScore, PointsScoringEquationsIF functionalScore, int nrsScore) {
        return new HIPPSCode(record, validator, clinicalScore, functionalScore, nrsScore);
    }
}

