/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.EtiologyPairingListIF;
import com.mmm.cms.util.DiagnosisCodeComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class EtiologyPairsList
extends ArrayList<DiagnosisCodeIF>
implements EtiologyPairingListIF {
    private boolean dirty;
    private boolean inclusionary;

    public EtiologyPairsList() {
        super(20);
        this.inclusionary = true;
    }

    public EtiologyPairsList(boolean inclusionary) {
        super(20);
        this.inclusionary = inclusionary;
    }

    @Override
    public boolean add(DiagnosisCodeIF dxCode) {
        this.dirty = true;
        return super.add(dxCode);
    }

    @Override
    public void add(int index, DiagnosisCodeIF element) {
        this.dirty = true;
        super.add(index, element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends DiagnosisCodeIF> collection) {
        this.dirty = true;
        return super.addAll(index, collection);
    }

    public boolean contains(DiagnosisCodeIF code) {
        int idx;
        if (this.dirty) {
            Collections.sort(this, DiagnosisCodeComparator.codeComparator);
            this.dirty = false;
        }
        return (idx = Collections.binarySearch(this, code, DiagnosisCodeComparator.codeComparator)) >= 0;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isInclusionary() {
        return this.inclusionary;
    }

    @Override
    public boolean isValidEtiologyPairing(DiagnosisCodeIF etiologyCode) {
        boolean isValid = this.inclusionary ? this.contains(etiologyCode) : (etiologyCode.isVCode() || etiologyCode.isExternalCauseCode() || etiologyCode.isSecondaryOnly() ? false : !this.contains(etiologyCode));
        return isValid;
    }

    @Override
    public DiagnosisCodeIF remove(int index) {
        this.dirty = true;
        return (DiagnosisCodeIF)super.remove(index);
    }

    @Override
    public boolean remove(Object obj) {
        this.dirty = true;
        return super.remove(obj);
    }

    @Override
    public DiagnosisCodeIF set(int index, DiagnosisCodeIF element) {
        this.dirty = true;
        return super.set(index, element);
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public void setInclusionary(boolean bool) throws IllegalStateException {
        if (bool != this.inclusionary && this.size() > 0) {
            throw new IllegalStateException("Inclusionary flag can not be reset after codes have been added to the list. Please check the data for valid code Inclusion/exclusion definitions.");
        }
        this.inclusionary = bool;
    }
}

