/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.proto.EventId_EN;
import com.mmm.cms.homehealth.proto.HomeHealthEventIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.HomeHealthScoringModelIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import java.util.EventObject;

public class HomeHealthEvent
extends EventObject
implements HomeHealthEventIF {
    private EventId_EN eventId;
    private HomeHealthRecordIF record;
    private String message;
    private HomeHealthScoringModelIF model;
    private Exception exception;

    public HomeHealthEvent(EventId_EN eventId, HomeHealthGrouperIF source, HomeHealthRecordIF record, String message, HomeHealthScoringModelIF model) {
        super(source);
        this.eventId = eventId;
        this.record = record;
        this.message = message;
        this.model = model;
    }

    public HomeHealthEvent(HomeHealthGrouperIF source) {
        super(source);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public HomeHealthScoringModelIF getModel() {
        return this.model;
    }

    @Override
    public void setModel(HomeHealthScoringModelIF model) {
        this.model = model;
    }

    @Override
    public HomeHealthRecordIF getRecord() {
        return this.record;
    }

    @Override
    public void setRecord(HomeHealthRecordIF record) {
        this.record = record;
    }

    @Override
    public EventId_EN getEventId() {
        return this.eventId;
    }

    @Override
    public void setEventId(EventId_EN eventId) {
        this.eventId = eventId;
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    @Override
    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public HomeHealthGrouperIF getGrouper() {
        return (HomeHealthGrouperIF)this.getSource();
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder("HH-PPS:  Event: (");
        buffer.append(this.eventId);
        buffer.append(")");
        if (this.getSource() != null) {
            buffer.append("- Version: ");
            buffer.append(((HomeHealthGrouperIF)this.getSource()).getVersion());
            buffer.append(" ");
        }
        if (this.model != null) {
            buffer.append(this.model.getName());
            buffer.append(", Eq = ");
            buffer.append(this.model.getId());
            buffer.append(" ");
        }
        switch (this.eventId) {
            case GENERAL: {
                break;
            }
            case WARNING: {
                break;
            }
            case EXCEPTION: {
                if (this.exception == null) break;
                buffer.append(" - Exception: '");
                buffer.append(this.exception.toString());
                buffer.append("'");
                break;
            }
            case SCORING_STARTING: 
            case SCORING_FINISHED: 
            case SCORING_INCREASED: 
            case SCORING_SECTION_STARTING: 
            case SCORING_SECTION_FINISHED: 
            case VALIDATION_ISSUE: {
                break;
            }
        }
        if (this.message != null) {
            buffer.append("- Message: '");
            buffer.append(this.message);
            buffer.append("' ");
        }
        return buffer.toString();
    }
}

