/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.RecordValidatorFactory;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperFactoryIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.InvalidDateException;
import com.mmm.cms.homehealth.proto.ServiceIssueException;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.util.MacroProperties;
import com.mmm.cms.util.OasisCalendarFormatter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class HomeHealthGrouperFactory
implements HomeHealthGrouperFactoryIF {
    public static final String PROPERTY_HH_CLASS_LIST = "home.health.grouper.class.list";
    public static final String PROPERT_CONFIG_SUFFIX = ".config";
    public static final String PROPERTY_DEFAULT_GROUPER_CLASS_NAME = "default.grouper.class.name";
    public static final String PROPERTY_DEFAULT_VERSION_PREFIX = "default.version.prefix";
    public static final String PROPERTY_HOME_HEALTH_QUIET = "home_health_quiet";
    public static final String PROPERTY_START_DATE_SUFFIX = ".start.date";
    public static final String PROPERTY_END_DATE_SUFFIX = ".end.date";
    private List<HomeHealthGrouperIF> homeHealthGroupers = new ArrayList<HomeHealthGrouperIF>();
    private transient HomeHealthGrouperIF defaultGrouper;
    private transient JFrame progressFrame = null;
    private Properties properties;
    private boolean quiet = true;
    protected String defaultGrouperClassName;
    protected String defaultVersionPrefix;

    public String getDefaultGrouperClassName() {
        return this.defaultGrouperClassName;
    }

    public String getDefaultVersionPrefix() {
        return this.defaultVersionPrefix;
    }

    @Override
    public HomeHealthGrouperIF getGrouper(HomeHealthRecordIF record) throws ServiceIssueException {
        if (record == null) {
            return null;
        }
        HomeHealthGrouperIF validGrouper = null;
        boolean v3413Found = false;
        try {
            if (record.getSTART_CARE_DT() != null && record.getSTART_CARE_DT().get(2) >= 0 && record.getINFO_COMPLETED_DT() != null && record.getINFO_COMPLETED_DT().get(2) >= 0) {
                for (HomeHealthGrouperIF grouper : this.homeHealthGroupers) {
                    if ("V3413".compareTo(grouper.getVersion()) <= 0) {
                        v3413Found = true;
                    }
                    try {
                        if (!grouper.isValidForVersion(record)) continue;
                        validGrouper = grouper;
                        break;
                    }
                    catch (InvalidDateException ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
                    }
                }
                if (!v3413Found && validGrouper == null && this.defaultGrouper != null && (this.defaultGrouper.getEffectiveDateStart().equals(record.getINFO_COMPLETED_DT()) || this.defaultGrouper.getEffectiveDateStart().before(record.getINFO_COMPLETED_DT()))) {
                    validGrouper = this.defaultGrouper;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: Could not determine a grouper for record because the Start of Care or Information Complete dates are not strict dates and may 'roll over' to an unintended date value");
        }
        if (validGrouper != null && "1".equals(record.getTHER_NEED_NA())) {
            throw new ServiceIssueException(validGrouper, "Therapies not needed");
        }
        return validGrouper;
    }

    @Override
    public HomeHealthGrouperIF getGrouper(String versionId) {
        HomeHealthGrouperIF validGrouper = null;
        for (HomeHealthGrouperIF grouper : this.homeHealthGroupers) {
            if (!grouper.getVersion().equalsIgnoreCase(versionId)) continue;
            validGrouper = grouper;
            break;
        }
        return validGrouper;
    }

    @Override
    public List<HomeHealthGrouperIF> getGroupers() {
        return this.homeHealthGroupers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Properties props) throws Exception, RemoteException {
        try {
            String tmpStr;
            if (props == null) {
                this.getPropertiesFromEnv();
            } else {
                this.properties = props instanceof MacroProperties ? props : new MacroProperties(props);
            }
            this.defaultGrouperClassName = this.properties.getProperty(PROPERTY_DEFAULT_GROUPER_CLASS_NAME);
            this.defaultVersionPrefix = this.properties.getProperty(PROPERTY_DEFAULT_VERSION_PREFIX);
            if (this.defaultVersionPrefix != null && this.defaultVersionPrefix.length() > 1) {
                this.defaultVersionPrefix = this.defaultVersionPrefix.substring(0, 1);
            }
            if ("false".equalsIgnoreCase(tmpStr = this.properties.getProperty(PROPERTY_HOME_HEALTH_QUIET, "false"))) {
                this.quiet = false;
            }
            if ((tmpStr = this.properties.getProperty(PROPERTY_HH_CLASS_LIST)) != null) {
                String[] classes;
                this.startProgressBar();
                for (String className : classes = tmpStr.split(" ")) {
                    className = className.trim();
                    this.homeHealthGroupers.add(this.loadGrouper("", className));
                }
            } else {
                throw new Exception("HomeHealthGrouperFactory no class listing found in configuration properties (name = 'home.health.grouper.class.list'");
            }
            RecordValidatorFactory.getInstance(this.properties);
        }
        finally {
            this.endProgressBar();
        }
    }

    private void setDefaultGrouperVersion(HomeHealthGrouperIF grouper) {
        if (this.defaultVersionPrefix != null) {
            grouper.setVersion(this.defaultVersionPrefix + grouper.getVersion().substring(1));
        }
    }

    public Properties getPropertiesFromEnv() {
        String configFilename = null;
        try {
            configFilename = System.getenv("home_health_config");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Exception: Could not obtain Environment Variable: home_health_config");
        }
        try {
            File file;
            if (configFilename == null || configFilename.trim().isEmpty()) {
                file = new File("config/HomeHealthGrouper.properties");
                if (file.exists()) {
                    configFilename = file.getAbsolutePath();
                } else {
                    file = new File("C:/Program Files/HomeHealthGrouper/config/HomeHealthGrouper.properties");
                    if (file.exists()) {
                        configFilename = file.getAbsolutePath();
                    } else {
                        file = new File("C:/hhpps/HomeHealthGrouper/config/HomeHealthGrouper.properties");
                        if (file.exists()) {
                            configFilename = file.getAbsolutePath();
                        }
                    }
                }
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "HH-PPS: Home Health Java: init() - envirnment variable ''home_health_config'' not set.  Using default properties file: ''{0}''", configFilename);
            } else {
                file = new File(configFilename);
            }
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "HH-PPS: Home Health Java: init() - config file: ''{0}''", configFilename);
            this.properties = new MacroProperties();
            this.properties.load(new FileInputStream(file));
            if (this.properties.size() == 0) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "HH-PPS: Environment variable ''home_health_config'' set to file ''{0}'' but the file is empty.", file.getAbsolutePath());
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: Environment variable 'home_health_config' might not be set causing the following 'file not found' error... ", ex);
            this.properties = null;
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: ", ex);
            this.properties = null;
        }
        return this.properties;
    }

    protected HomeHealthGrouperIF loadGrouper(String versionName, String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, Exception {
        Properties grouperProps;
        Logger logger = Logger.getLogger(this.getClass().getName());
        Class<?> clazz = Class.forName(className);
        HomeHealthGrouperIF grouper = (HomeHealthGrouperIF)clazz.newInstance();
        String tmpStr = this.properties.getProperty(className + PROPERT_CONFIG_SUFFIX);
        if (tmpStr == null) {
            grouperProps = this.properties;
            logger.log(Level.INFO, "HH-PPS: Grouper named ''{0}'' does not have a configuration file identified. Using default properties", className);
        } else {
            logger.log(Level.INFO, "HH-PPS: Grouper= ''{0}'', config file=''{1}''", new Object[]{className, tmpStr});
            grouperProps = new Properties();
            grouperProps.load(new FileInputStream(tmpStr));
        }
        grouper.init(grouperProps);
        tmpStr = this.properties.getProperty(className + PROPERTY_START_DATE_SUFFIX);
        if (tmpStr != null) {
            try {
                Calendar calendar = OasisCalendarFormatter.parse(tmpStr);
                grouper.setEffectiveDateStart(calendar);
                grouper.setEffectiveDateStartWindow(calendar);
            }
            catch (NumberFormatException e) {
                logger.log(Level.INFO, "HH-PPS: Grouper= ''{0}'', invalid start date =''{1}'', must be YYYYMMDD", new Object[]{className, tmpStr});
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.INFO, "HH-PPS: Grouper= ''{0}'', invalid start date =''{1}'', must be YYYYMMDD", new Object[]{className, tmpStr});
            }
        }
        if ((tmpStr = this.properties.getProperty(className + PROPERTY_END_DATE_SUFFIX)) != null) {
            try {
                grouper.setEffectiveDateThru(OasisCalendarFormatter.parse(tmpStr));
            }
            catch (NumberFormatException e) {
                logger.log(Level.INFO, "HH-PPS: Grouper= ''{0}'', invalid end date =''{1}'', must be YYYYMMDD", new Object[]{className, tmpStr});
            }
            catch (IllegalArgumentException e) {
                logger.log(Level.INFO, "HH-PPS: Grouper= ''{0}'', invalid end date =''{1}'', must be YYYYMMDD", new Object[]{className, tmpStr});
            }
        }
        if (this.defaultGrouperClassName != null && this.defaultGrouperClassName.equals(className)) {
            this.defaultGrouper = (HomeHealthGrouperIF)clazz.newInstance();
            this.defaultGrouper.init(grouperProps);
            this.setDefaultGrouperVersion(this.defaultGrouper);
        }
        return grouper;
    }

    public void setDefaultGrouperClassName(String defaultGrouperClassName) {
        this.defaultGrouperClassName = defaultGrouperClassName;
    }

    public void setDefaultVersionPrefix(String defaultVersionPrefix) {
        this.defaultVersionPrefix = defaultVersionPrefix;
    }

    protected void startProgressBar() {
        if (!this.quiet) {
            JProgressBar progressBar = new JProgressBar(0, 100);
            progressBar.setValue(0);
            progressBar.setStringPainted(true);
            progressBar.setIndeterminate(true);
            progressBar.setStringPainted(true);
            progressBar.setString("Please wait...");
            progressBar.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JLabel labelWait = new JLabel("Initializing Home Health Grouper's Java components");
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)labelWait, "North");
            jPanel.add((Component)progressBar, "South");
            jPanel.setOpaque(true);
            jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            this.progressFrame = new JFrame("Home Health Grouper");
            this.progressFrame.setDefaultCloseOperation(3);
            this.progressFrame.setLocationRelativeTo(null);
            this.progressFrame.setContentPane(jPanel);
            this.progressFrame.pack();
            this.progressFrame.setVisible(true);
        }
    }

    protected void endProgressBar() {
        if (!this.quiet && this.progressFrame != null) {
            this.progressFrame.setVisible(false);
            this.progressFrame.dispose();
            this.progressFrame = null;
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }
}

