/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.proto.RecordValidatorFactoryIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.vut.oasis.OasisValidatorItems;
import com.mmm.cms.util.Initializable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RecordValidatorFactory
implements Initializable,
RecordValidatorFactoryIF {
    public static final String PROPERTY_RECORD_FACTORY_CLASS = "record.validator.factory.class";
    private static RecordValidatorFactory myInstance;
    private RecordValidatorFactoryIF validatorFactory;
    private String factoryClassName;

    private RecordValidatorFactory() {
    }

    public static RecordValidatorFactoryIF getInstance(Properties properties) throws Exception {
        if (myInstance == null) {
            myInstance = new RecordValidatorFactory();
            myInstance.init(properties);
        }
        return myInstance;
    }

    @Override
    public void init(Properties properties) throws Exception {
        if (this.validatorFactory == null) {
            try {
                this.factoryClassName = properties.getProperty(PROPERTY_RECORD_FACTORY_CLASS, OasisValidatorItems.class.getName());
                Class<?> clazz = Class.forName(this.factoryClassName);
                this.validatorFactory = (RecordValidatorFactoryIF)clazz.newInstance();
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, "HH-PPS:  - RecordValidatorFactory set to class: {0}", this.factoryClassName);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS:  - RecordValidatorFactory class NOT FOUND: {0}", this.factoryClassName);
                throw ex;
            }
        }
    }

    @Override
    public RecordItemValidatorIF[] getValidationItems(HomeHealthRecordIF record) {
        return this.validatorFactory.getValidationItems(record);
    }
}

