/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.proto.PointsScoringEquationsIF;
import com.mmm.cms.homehealth.proto.TreatmentAuthorizationIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.util.HexavigesimalCalendarFormat;
import com.mmm.cms.util.HexavigesimalFormat;
import com.mmm.cms.util.IntegerFormat;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ValidateUtils;
import java.util.Calendar;

public class TreatmentAuthorization
implements TreatmentAuthorizationIF {
    public static final HexavigesimalCalendarFormat HEXAVIG_CALENDAR_FORMAT = new HexavigesimalCalendarFormat();
    public static final HexavigesimalFormat HEXAVIG_INTEGER_FORMAT = new HexavigesimalFormat();
    protected boolean blank;
    protected Calendar startOfCareDate;
    protected Calendar infoCompletedDate;
    protected int assessmentReason;
    protected int episodeTiming;
    protected PointsScoringEquationsIF clinicalScore;
    protected PointsScoringEquationsIF functionalScore;

    public TreatmentAuthorization(HomeHealthRecordIF record) {
        this(record, null, null, null);
    }

    public TreatmentAuthorization(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, PointsScoringEquationsIF clinScore, PointsScoringEquationsIF funcScore) {
        this.clinicalScore = clinScore;
        this.functionalScore = funcScore;
        if (record == null) {
            this.blank = true;
            return;
        }
        String timing = record.getEPISODE_TIMING();
        if (this.clinicalScore == null || this.functionalScore == null || validator != null && (!validator.isINFO_COMPLETED_DT_Valid() || !validator.isASSMT_REASON_Valid() || "1".equals(record.getTHER_NEED_NA()) || !ValidateUtils.isValidValue(timing, new String[][]{ValidateUtils.ARRAY_DOUBLE_ONE_TWO}) && !"UK".equals(timing))) {
            this.blank = true;
            return;
        }
        this.startOfCareDate = record.getSTART_CARE_DT();
        this.infoCompletedDate = record.getINFO_COMPLETED_DT();
        this.assessmentReason = IntegerUtils.parseInt(record.getASSMT_REASON(), 0);
        this.episodeTiming = IntegerUtils.parseInt(record.getEPISODE_TIMING(), 1);
    }

    @Override
    public int getASSMT_REASON() {
        return this.assessmentReason;
    }

    @Override
    public void setASSMT_REASON(int M0100_ASSMT_REASON2) {
        this.assessmentReason = M0100_ASSMT_REASON2;
    }

    @Override
    public Calendar getSTART_CARE_YR34() {
        return this.startOfCareDate;
    }

    @Override
    public void setSTART_CARE_YR34(Calendar M0030_START_CARE_YR34) {
        this.startOfCareDate = M0030_START_CARE_YR34;
    }

    @Override
    public Calendar getINFO_COMPLETED_YR34() {
        return this.infoCompletedDate;
    }

    @Override
    public void setINFO_COMPLETED_YR34(Calendar M0090_INFO_COMPLETED_YR34) {
        this.infoCompletedDate = M0090_INFO_COMPLETED_YR34;
    }

    @Override
    public int getEPISODE_TIMING() {
        return this.episodeTiming;
    }

    @Override
    public void setEPISODE_TIMING(int M0110_EPISODE_TIMING) {
        this.episodeTiming = M0110_EPISODE_TIMING;
    }

    @Override
    public PointsScoringEquationsIF getClinicalScore() {
        return this.clinicalScore;
    }

    @Override
    public void setClinicalScore(PointsScoringEquationsIF clinicalScore) {
        this.clinicalScore = clinicalScore;
    }

    @Override
    public PointsScoringEquationsIF getFunctionalScore() {
        return this.functionalScore;
    }

    @Override
    public void setFunctionalScore(PointsScoringEquationsIF functionalScore) {
        this.functionalScore = functionalScore;
    }

    @Override
    public int getClinicalScoreCount() {
        return this.clinicalScore != null ? 4 : 0;
    }

    @Override
    public int getFunctionalScoreCount() {
        return this.functionalScore != null ? 4 : 0;
    }

    @Override
    public int getClinicalScoreValue(int equationNumber) {
        return this.getScoreValue(this.clinicalScore, equationNumber);
    }

    @Override
    public int getFunctionalScoreValue(int equationNumber) {
        return this.getScoreValue(this.functionalScore, equationNumber);
    }

    protected final int getScoreValue(PointsScoringEquationsIF score, int equationNumber) {
        int retval;
        if (score != null) {
            switch (equationNumber) {
                case 1: {
                    retval = score.getEarly13AndUnder();
                    break;
                }
                case 2: {
                    retval = score.getEarly14Plus();
                    break;
                }
                case 3: {
                    retval = score.getLater13AndUnder();
                    break;
                }
                case 4: {
                    retval = score.getLater14Plus();
                    break;
                }
                default: {
                    retval = 0;
                    break;
                }
            }
        } else {
            retval = 0;
        }
        return retval;
    }

    @Override
    public String getAuthorizationCode() {
        String value;
        if (this.blank) {
            value = "                  ";
        } else {
            StringBuilder buffer = new StringBuilder(18);
            buffer.append(IntegerFormat.INTEGER_FORMAT_DIGITS_2.format(this.startOfCareDate.get(1) % 100));
            buffer.append(HEXAVIG_CALENDAR_FORMAT.format(this.startOfCareDate));
            buffer.append(IntegerFormat.INTEGER_FORMAT_DIGITS_2.format(this.infoCompletedDate.get(1) % 100));
            buffer.append(HEXAVIG_CALENDAR_FORMAT.format(this.infoCompletedDate));
            if (this.assessmentReason > 0) {
                buffer.append(this.assessmentReason);
            } else {
                buffer.append(" ");
            }
            buffer.append(this.episodeTiming);
            buffer.append(HEXAVIG_INTEGER_FORMAT.format(this.clinicalScore.getEarly13AndUnder()));
            buffer.append(HEXAVIG_INTEGER_FORMAT.format(this.functionalScore.getEarly13AndUnder()));
            buffer.append(HEXAVIG_INTEGER_FORMAT.format(this.clinicalScore.getEarly14Plus()));
            buffer.append(HEXAVIG_INTEGER_FORMAT.format(this.functionalScore.getEarly14Plus()));
            buffer.append(HEXAVIG_INTEGER_FORMAT.format(this.clinicalScore.getLater13AndUnder()));
            buffer.append(HEXAVIG_INTEGER_FORMAT.format(this.functionalScore.getLater13AndUnder()));
            buffer.append(HEXAVIG_INTEGER_FORMAT.format(this.clinicalScore.getLater14Plus()));
            buffer.append(HEXAVIG_INTEGER_FORMAT.format(this.functionalScore.getLater14Plus()));
            value = buffer.toString();
        }
        return value;
    }

    @Override
    public String[] getAuthorizationCodeParts() {
        String[] parts = new String[14];
        String code = this.getAuthorizationCode();
        parts[0] = code.substring(0, 2);
        parts[1] = code.substring(2, 4);
        parts[2] = code.substring(4, 6);
        parts[3] = code.substring(6, 8);
        parts[4] = code.substring(8, 9);
        parts[5] = code.substring(9, 10);
        parts[6] = code.substring(10, 11);
        parts[7] = code.substring(11, 12);
        parts[8] = code.substring(12, 13);
        parts[9] = code.substring(13, 14);
        parts[10] = code.substring(14, 15);
        parts[11] = code.substring(15, 16);
        parts[12] = code.substring(16, 17);
        parts[13] = code.substring(17);
        return parts;
    }

    public String toString() {
        return this.getAuthorizationCode();
    }

    static {
        HEXAVIG_INTEGER_FORMAT.setMaximumIntegerDigits(1);
    }
}

