/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth;

import com.mmm.cms.homehealth.TreatmentAuthorization;
import com.mmm.cms.homehealth.proto.PointsScoringEquationsIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.util.IntegerFormat;

public class TreatmentAuthorization_2015
extends TreatmentAuthorization {
    public TreatmentAuthorization_2015(HomeHealthRecordIF record) {
        super(record);
    }

    public TreatmentAuthorization_2015(HomeHealthRecordIF record, HomeHealthRecordValidatorIF validator, PointsScoringEquationsIF clinScore, PointsScoringEquationsIF funcScore) {
        super(record, validator, clinScore, funcScore);
    }

    @Override
    public String getAuthorizationCode() {
        String value;
        if (this.blank) {
            value = "                  ";
        } else {
            StringBuilder buffer = new StringBuilder(18);
            buffer.append(IntegerFormat.INTEGER_FORMAT_DIGITS_2.format(this.startOfCareDate.get(1) % 100));
            buffer.append(HEXAVIG_CALENDAR_FORMAT.format(this.startOfCareDate));
            buffer.append(IntegerFormat.INTEGER_FORMAT_DIGITS_2.format(this.infoCompletedDate.get(1) % 100));
            buffer.append(HEXAVIG_CALENDAR_FORMAT.format(this.infoCompletedDate));
            if (this.assessmentReason > 0) {
                buffer.append(this.assessmentReason);
            } else {
                buffer.append(" ");
            }
            buffer.append(this.episodeTiming);
            buffer.append(this.getNewHexavigesimal(this.clinicalScore.getEarly13AndUnder()));
            buffer.append(this.getNewHexavigesimal(this.functionalScore.getEarly13AndUnder()));
            buffer.append(this.getNewHexavigesimal(this.clinicalScore.getEarly14Plus()));
            buffer.append(this.getNewHexavigesimal(this.functionalScore.getEarly14Plus()));
            buffer.append(this.getNewHexavigesimal(this.clinicalScore.getLater13AndUnder()));
            buffer.append(this.getNewHexavigesimal(this.functionalScore.getLater13AndUnder()));
            buffer.append(this.getNewHexavigesimal(this.clinicalScore.getLater14Plus()));
            buffer.append(this.getNewHexavigesimal(this.functionalScore.getLater14Plus()));
            value = buffer.toString();
        }
        return value;
    }

    private char getNewHexavigesimal(int value) {
        return value >= 25 ? (char)'Z' : (char)(65 + value);
    }
}

