/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.test;

import com.mmm.cms.homehealth.HomeHealthGrouperFactory;
import com.mmm.cms.homehealth.HomeHealthRecord;
import com.mmm.cms.homehealth.io.OasisReaderFactory;
import com.mmm.cms.homehealth.io.OasisRecordConverterIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperFactoryIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.test.CommandLineParams;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CommonTester {
    static final Logger logger = Logger.getLogger(CommonTester.class.getName());
    protected CommandLineParams params;
    protected OasisReaderFactory readerFactory;
    public HomeHealthRecordIF recordEOF = new HomeHealthRecord();

    public CommonTester() {
        this.readerFactory = new OasisReaderFactory();
    }

    public String getOutFileSuffix() {
        return "_TESTOUT";
    }

    public HomeHealthRecordIF readRecord(BufferedReader inReader, int curRecNum) {
        HomeHealthRecordIF record = null;
        try {
            String strRecord;
            if (this.params.getInputFile().getName().toLowerCase().contains(".xml")) {
                StringBuilder buffer = new StringBuilder();
                while ((strRecord = inReader.readLine()) != null) {
                    buffer.append(strRecord);
                }
                strRecord = buffer.length() > 0 ? buffer.toString() : null;
            } else {
                strRecord = inReader.readLine();
            }
            if (strRecord != null) {
                OasisRecordConverterIF recordConverter = this.readerFactory.getRecordConverter(strRecord);
                if (recordConverter != null) {
                    record = recordConverter.convertToHomeHealthRec(strRecord, curRecNum, true);
                }
            } else {
                record = this.recordEOF;
            }
        }
        catch (ParseException ex) {
            logger.log(Level.SEVERE, "HH-PPS: Record " + curRecNum, ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "HH-PPS: Record " + curRecNum, ex);
        }
        return record;
    }

    public void runTest(String[] args) {
        this.params = this.getCommandLineParams(args);
        this.printOptions(this.params.getCommandOptions());
        if (this.params.getInputFile() == null || !new File(this.params.getInputFile().getPath()).exists()) {
            throw new IllegalArgumentException("Missing InputFile: \n" + this.params.getInputFile().getPath() + "\n" + this.params.getSyntax(this.getClass()));
        }
        Properties properties = null;
        long overallStarttime = System.currentTimeMillis();
        if (this.params.getPropertiesFile() != null) {
            try {
                properties = new Properties();
                properties.load(new FileInputStream(this.params.getPropertiesFile()));
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "HH-PPS: Could not open properties file: " + args[1], ex);
            }
        }
        this.runTest(this.params, properties);
        long elapsedTime = System.currentTimeMillis() - overallStarttime;
        logger.log(Level.INFO, "Overall Elapsed time: {0}", elapsedTime);
    }

    public void runTest(CommandLineParams params, Properties properties) {
        HomeHealthGrouperFactory grouperFactory = new HomeHealthGrouperFactory();
        if (properties != null) {
            String basePath = params.getBasePath();
            if (basePath != null && !basePath.isEmpty()) {
                properties.setProperty("master.base.path", basePath);
            }
            try {
                grouperFactory.init(properties);
            }
            catch (RemoteException ex) {
                logger.log(Level.SEVERE, "HH-PPS: ", ex);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "HH-PPS: ", ex);
            }
            try {
                this.readerFactory.init(properties);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        File inputFilename = params.getInputFile();
        File outputFilename = params.getOutputFile();
        if (outputFilename == null) {
            String tmpStr = inputFilename.getAbsolutePath();
            int idx = tmpStr.lastIndexOf(46);
            outputFilename = idx > -1 ? new File(tmpStr.substring(0, idx) + this.getOutFileSuffix() + tmpStr.substring(idx)) : new File(tmpStr + this.getOutFileSuffix());
        }
        System.out.println("Input file is: " + inputFilename.getAbsolutePath());
        System.out.println("Output file is: " + outputFilename.getAbsolutePath());
        this.runTest(params, grouperFactory, inputFilename, outputFilename);
    }

    public void runTest(CommandLineParams params, HomeHealthGrouperFactoryIF grouperFactory, File inputFilename, File outputFilename) {
        try {
            BufferedReader bufReader = new BufferedReader(new FileReader(inputFilename), 57920);
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputFilename), 57920);
            this.runTest(bufReader, writer, grouperFactory, params);
            ((Writer)writer).flush();
            bufReader.close();
            ((Writer)writer).close();
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    public CommandLineParams getCommandLineParams(String[] args) {
        return new CommandLineParams(args);
    }

    public abstract void runTest(BufferedReader var1, Writer var2, HomeHealthGrouperFactoryIF var3, CommandLineParams var4);

    public void printOptions(List<String> options) {
        System.out.println("Options:");
        for (String str : options) {
            System.out.print("\t");
            System.out.println(str);
        }
        System.out.println();
    }
}

