/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.test;

import com.mmm.cms.homehealth.ScoringResults;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperFactoryIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.ScoringResultsIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.test.CommandLineParams;
import com.mmm.cms.homehealth.test.CommonTester;
import com.mmm.cms.homehealth.test.OasisRecord_B_ReadWriteTest;
import com.mmm.cms.util.HHEventConsole;
import com.mmm.cms.util.IntegerFormat;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HomeHealthGroupingFactoryTest
extends CommonTester {
    public static void main(String[] args) {
        HomeHealthGroupingFactoryTest tester = new HomeHealthGroupingFactoryTest();
        tester.runTest(args);
    }

    @Override
    public void runTest(BufferedReader bufReader, Writer writer, HomeHealthGrouperFactoryIF grouperFactory, CommandLineParams commandLine) {
        long elapsedTime;
        long starttime;
        List<HomeHealthRecordIF> oasisRecords = null;
        int recordNumber = 0;
        long overallStarttime = System.currentTimeMillis();
        OasisRecord_B_ReadWriteTest tester = new OasisRecord_B_ReadWriteTest();
        HomeHealthGroupingFactoryTest groupingTester = new HomeHealthGroupingFactoryTest();
        try {
            starttime = System.currentTimeMillis();
            oasisRecords = tester.readConvertTest(bufReader);
            elapsedTime = System.currentTimeMillis() - starttime;
            System.out.println("Number of Oasis Records read: " + oasisRecords.size() + ", elapsed time: " + elapsedTime);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: During ReadTest", ex);
            System.out.println("During ReadTest: " + ex);
            System.exit(2);
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: During ReadTest", ex);
            System.out.println("During ReadTest: " + ex);
            System.exit(3);
        }
        try {
            starttime = System.currentTimeMillis();
            List<ScoringResultsIF> scoringResults = groupingTester.groupingTest(grouperFactory, oasisRecords, recordNumber);
            elapsedTime = System.currentTimeMillis() - starttime;
            System.out.println("Number of Oasis Records scored: " + scoringResults.size() + ", elapsed time: " + elapsedTime);
            groupingTester.writeOutputFile(scoringResults, writer);
        }
        catch (Exception ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "HH-PPS: Validation Test", ex);
            System.out.println("Grouping test could not complete due to: " + ex);
            ex.printStackTrace();
        }
        elapsedTime = System.currentTimeMillis() - overallStarttime;
        System.out.println();
        System.out.println("Total processing elapsed time: " + elapsedTime);
    }

    public List<ScoringResultsIF> groupingTest(HomeHealthGrouperFactoryIF grouperFactory, List<HomeHealthRecordIF> oasisRecords, int recordNumber) throws Exception {
        int idx = 0;
        Level tmpLevel = null;
        ConsoleHandler consoleHandler = null;
        Logger logger = null;
        HHEventConsole listener = null;
        ArrayList<ScoringResultsIF> scoringResults = new ArrayList<ScoringResultsIF>(oasisRecords.size());
        for (HomeHealthRecordIF record : oasisRecords) {
            HomeHealthGrouperIF grouper = grouperFactory.getGrouper(record);
            if (grouper != null) {
                if (++idx == recordNumber) {
                    System.out.println("record " + idx);
                    System.out.flush();
                    listener = new HHEventConsole();
                    grouper.addEventListener(listener);
                    consoleHandler = new ConsoleHandler();
                    consoleHandler.setLevel(Level.FINE);
                    logger = Logger.getLogger(this.getClass().getName());
                    tmpLevel = logger.getLevel();
                    logger.setLevel(Level.FINE);
                    logger.addHandler(consoleHandler);
                }
                ScoringResultsIF scoring = grouper.score(record, false);
                scoringResults.add(scoring);
                if (logger == null) continue;
                logger.removeHandler(consoleHandler);
                logger.setLevel(tmpLevel);
                System.err.flush();
                logger = null;
                grouper.removeEventListener(listener);
                listener = null;
                continue;
            }
            logger = Logger.getLogger(this.getClass().getName());
            logger.log(Level.WARNING, "HH-PPS: Could not find grouper for record number: {0}", ++idx);
            scoringResults.add(new ScoringResults(record));
        }
        return scoringResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOutputFile(List<ScoringResultsIF> scoringResults, Writer writer) throws IOException {
        long starttime = System.currentTimeMillis();
        StringBuilder buffer = new StringBuilder();
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        IntegerFormat iformat = new IntegerFormat('0');
        iformat.setMinimumIntegerDigits(6);
        iformat.setMaximumIntegerDigits(6);
        try {
            int idx = 1;
            for (ScoringResultsIF scoringResult : scoringResults) {
                buffer.setLength(0);
                buffer.append("Record ");
                buffer.append(iformat.format(idx++));
                buffer.append(": Code ");
                if (scoringResult.getHIPPSCode() != null) {
                    buffer.append(scoringResult.getHIPPSCode().getCode());
                    buffer.append("--OASIS ");
                } else {
                    buffer.append("     ");
                }
                if (scoringResult.getHIPPSCode() != null && !scoringResult.getHIPPSCode().getCode().trim().isEmpty()) {
                    buffer.append(scoringResult.getTreatmentAuthorization().getAuthorizationCode());
                } else {
                    buffer.append("                  ");
                }
                buffer.append("--Version ");
                buffer.append(scoringResult.getGrouperVersion());
                buffer.append(" --Flag ");
                buffer.append(scoringResult.getValidityFlag().getValidityFlag());
                buffer.append("\r\n");
                bufferedWriter.write(buffer.toString());
            }
        }
        finally {
            bufferedWriter.close();
            long elapsedTime = System.currentTimeMillis() - starttime;
            System.out.println("Records written: elapsed time: " + elapsedTime);
        }
    }
}

