/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3110_1;

import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_C_IF;
import com.mmm.cms.homehealth.v2308_1.AbstractBaseValidator_v2308;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ScoringEventFormatter;
import com.mmm.cms.util.ValidateUtils;
import java.util.Collection;

public abstract class AbstractBaseValidator_v3110
extends AbstractBaseValidator_v2308 {
    public static final String blank4 = "    ";

    public AbstractBaseValidator_v3110(HomeHealthGrouperIF grouper) {
        super(grouper);
    }

    @Override
    public CollectionValidationEditsIF validate(HomeHealthRecordIF record, Collection<HomeHealthEventListenerIF> listeners) {
        CollectionValidationEditsIF edits = null;
        if (!this.validateASSMT_REASON(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Assessment Reason", record.getASSMT_REASON());
        }
        if (!this.validateExistingCodes(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Primary Diagnosis", record.getPRIMARY_DIAG_ICD().getCode());
        }
        if (!this.validatePRIMARY_DIAG_ICD(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Primary Diagnosis", record.getPRIMARY_DIAG_ICD().getCode());
        }
        if (!this.validatePAYMENT_ECodes(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Payment Diagnosis E-codes", "<various>");
        }
        if (!this.validateDiagnosisUnique(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Other Diagnosis are not unique", "<various>");
        }
        if (!this.validateTHH(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Therapies Received at Home", record.getTHH_IV_INFUSION() + ", " + record.getTHH_PAR_NUTRITION() + ", " + record.getTHH_ENT_NUTRITION() + ", " + record.getTHH_NONE_ABOVE());
        }
        if (!this.validateVISION(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Vision", record.getVISION());
        }
        if (!this.validateFREQ_PAIN(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Frequent Pain", record.getPAIN_FREQ_ACTVTY_MVMT());
        }
        if (!this.validateNPRSULC(record, listeners)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Number of Pressure Ulcers (4 stages)", record.getNBR_PRSULC_STG1() + ", " + record.getNBR_PRSULC_STG2() + ", " + record.getNBR_PRSULC_STG3() + ", " + record.getNBR_PRSULC_STG4());
        }
        if (!this.validateSTGPRSUL(record, listeners)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Stage of Most Problematic Pressure Ulcer", record.getSTG_PRBLM_ULCER());
        }
        if (!this.validateNBR_STASULC(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Number of Stasis Ulcers", record.getNBR_STAS_ULCR());
        }
        if (!this.validateUNOBS_STASULC(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Unobserved Stasis Ulcer", "stat_ulcr_prsnt=" + record.getSTAS_ULCR_PRSNT() + "num_stas_ulcr=" + record.getNBR_STAS_ULCR() + "stus_prblm_stas_ulcr=" + record.getSTUS_PRBLM_STAS_ULCR());
        }
        if (!this.validateSTATSTASIS(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Status Stasis Ulcer", record.getSTUS_PRBLM_STAS_ULCR());
        }
        if (!this.validateSTATSURG(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Status Surgical Wound", record.getSTUS_PRBLM_SRGCL_WND());
        }
        if (!this.validateWHEN_DYSPNEIC(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "When Dyspneic", record.getWHEN_DYSPNEIC());
        }
        if (!this.validateUR_INCONT(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Urinary Incontinence", record.getUR_INCONT());
        }
        if (!this.validateBWL_INCONT(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Bowl Incontinence", record.getBWL_INCONT());
        }
        if (!this.validateBWL_INCONT_OSTOMY(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Bowl Incontence Ostomy", record.getOSTOMY());
        }
        if (!this.validateCUR_INJECT_MEDS(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Injectable Meds", record.getCRNT_MGMT_INJCTN_MDCTN());
        }
        if (!this.validateCUR_DRESS(record)) {
            this.dataValidityFlag.setFunctionalIssue(true);
            ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Dressing (Upper & Lower)", record.getCRNT_DRESS_UPPER() + ", " + record.getCRNT_DRESS_LOWER());
        }
        if (!this.validateCUR_BATHING(record)) {
            this.dataValidityFlag.setFunctionalIssue(true);
            ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Bathing", record.getCRNT_BATHG());
        }
        if (!this.validateCUR_TOILETING(record)) {
            this.dataValidityFlag.setFunctionalIssue(true);
            ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Toileting", record.getCRNT_TOILTG());
        }
        if (!this.validateCUR_TRANSFERRING(record)) {
            this.dataValidityFlag.setFunctionalIssue(true);
            ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Transferring", record.getCRNT_TRNSFRNG());
        }
        if (!this.validateCUR_AMBULATION(record)) {
            this.dataValidityFlag.setFunctionalIssue(true);
            ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Ambulation", record.getCRNT_AMBLTN());
        }
        if (!this.validateTHER_NEED(record)) {
            this.dataValidityFlag.setServiceIssue(true);
            ScoringEventFormatter.fireServiceIssueEvent(listeners, this.grouper, null, "Therapy Need and Number of Therapies", record.getTHER_NEED_NBR() + ", " + record.getTHER_NEED_NA());
        }
        if (!this.isValidPrincipalDiagnosisCode(record)) {
            this.dataValidityFlag.setManifestationSequenceIssue(true);
            ScoringEventFormatter.fireManifestationIssueEvent(listeners, this.grouper, null, "Primary Diagnosis", record.getPRIMARY_DIAG_ICD().getCode());
        }
        if (!this.validateDiagnosisCodes(record, listeners)) {
            this.dataValidityFlag.setManifestationSequenceIssue(true);
            ScoringEventFormatter.fireManifestationIssueEvent(listeners, this.grouper, null, "All Diagnosis Codes", "<various>");
        }
        for (int idx = 0; idx < 18; ++idx) {
            DiagnosisCodeIF code = record.getDiagnosisCode(idx);
            this.diagnosisScoringStatus[idx] = code.isValidForScoring() ? 2 : (code.isValidCode() || code.isOptionalPaymentCode() ? 1 : 0);
        }
        return edits;
    }

    public boolean validateOtherDiagnosisSeries(HomeHealthRecordIF record) {
        boolean valid = true;
        int idx = 1;
        while (idx < 5) {
            DiagnosisCodeIF previousCode = record.getDiagnosisCode(idx++);
            DiagnosisCodeIF currentCode = record.getDiagnosisCode(idx);
            if (!previousCode.isEmpty() || currentCode.isEmpty()) continue;
            currentCode.setValidForScoring(false);
            while (++idx < 6) {
                currentCode = record.getDiagnosisCode(idx);
                currentCode.setValidForScoring(false);
            }
            valid = false;
            break;
        }
        return valid;
    }

    public boolean validateDiagnosisUnique(HomeHealthRecordIF record) {
        boolean valid = true;
        int idx = 0;
        while (idx < 5) {
            DiagnosisCodeIF currentCode;
            if (!(currentCode = record.getDiagnosisCode(idx++)).isValidCode()) continue;
            int j = idx;
            while (j < 6) {
                DiagnosisCodeIF otherCode;
                if (!currentCode.equals(otherCode = record.getDiagnosisCode(j++))) continue;
                otherCode.setValidForScoring(false);
                valid = false;
            }
        }
        return valid;
    }

    @Override
    public boolean validatePRIMARY_DIAG_ICD(HomeHealthRecordIF record) {
        boolean valid = super.validatePRIMARY_DIAG_ICD(record);
        DiagnosisCodeIF code = record.getPRIMARY_DIAG_ICD();
        if (code.isEmpty()) {
            int idx = 1;
            while (idx < 18) {
                if ((code = record.getDiagnosisCode(idx++)) == null) continue;
                code.setValidForScoring(false);
            }
            valid = false;
        }
        return valid;
    }

    @Override
    public boolean validateTHH(HomeHealthRecordIF record) {
        return ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) ? super.validateTHH(record) : true;
    }

    @Override
    public boolean validateVISION(HomeHealthRecordIF record) {
        return ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) ? super.validateVISION(record) : true;
    }

    @Override
    public boolean validateFREQ_PAIN(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) && !ValidateUtils.isValidValue(record.getPAIN_FREQ_ACTVTY_MVMT(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
            this.PAIN_INVLD = true;
        }
        return !this.PAIN_INVLD;
    }

    @Override
    public boolean validateLESION_OPEN_WND(HomeHealthRecordIF record) {
        return ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) ? super.validateLESION_OPEN_WND(record) : true;
    }

    @Override
    public boolean validateNPRSULC(HomeHealthRecordIF record, Collection<HomeHealthEventListenerIF> listeners) {
        HomeHealthRecord_C_IF recordC;
        if (record instanceof HomeHealthRecord_C_IF && ValidateUtils.isValidValue((recordC = (HomeHealthRecord_C_IF)record).getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            int intStage1 = IntegerUtils.parseInt(recordC.getNBR_PRSULC_STG1().trim(), -1);
            if (intStage1 < 0 || intStage1 > 4) {
                this.NPRSULC1_INVLD = true;
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG1", "Value out of range: " + recordC.getNBR_PRSULC_STG1());
            }
            int intStage2 = IntegerUtils.parseInt(recordC.getNBR_PRSULC_STG2().trim(), -1);
            int intStage3 = IntegerUtils.parseInt(recordC.getNBR_PRSULC_STG3().trim(), -1);
            int intStage4 = IntegerUtils.parseInt(recordC.getNBR_PRSULC_STG4().trim(), -1);
            int intNonStageCovering = IntegerUtils.parseInt(recordC.getNSTG_CVRG().trim(), -1);
            int intNonStageDeepTissue = IntegerUtils.parseInt(recordC.getNSTG_DEEP_TISUE().trim(), -1);
            if ((intStage3 > 0 || intStage4 > 0) && ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) && !ValidateUtils.isValidValue(recordC.getSTUS_PRBLM_PRSR_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE})) {
                this.NPRSULC3_INVLD = true;
                this.NPRSULC4_INVLD = true;
            }
            if ("0".equals(recordC.getUNHLD_STG2_PRSR_ULCR())) {
                if (intStage2 >= 0 || ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && !recordC.getNBR_STG2_AT_SOC_ROC().trim().isEmpty()) {
                    this.NPRSULC2_INVLD = true;
                }
                if (intStage3 >= 0 || ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && !recordC.getNBR_STG3_AT_SOC_ROC().trim().isEmpty()) {
                    this.NPRSULC3_INVLD = true;
                }
                if (intStage4 >= 0 || ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && !recordC.getNBR_STG4_AT_SOC_ROC().trim().isEmpty()) {
                    this.NPRSULC4_INVLD = true;
                }
                if (!recordC.getNSTG_DEEP_TISUE().trim().isEmpty()) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
                if (!recordC.getNSTG_DRSG().trim().isEmpty() || intNonStageCovering >= 0) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                    this.UNOBS_PRSULC_INVLD = true;
                }
                if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) && !recordC.getPRSR_ULCR_LNGTH().trim().isEmpty() || !recordC.getPRSR_ULCR_WDTH().trim().isEmpty() || !recordC.getPRSR_ULCR_DEPTH().trim().isEmpty() || !recordC.getSTUS_PRBLM_PRSR_ULCR().trim().isEmpty()) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
                if (!(!ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) || recordC.getNSTG_DRSG_SOC_ROC().trim().isEmpty() && recordC.getNSTG_CVRG_SOC_ROC().trim().isEmpty() && recordC.getNSTG_DEEP_TISSUE_SOC_ROC().trim().isEmpty())) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
            } else if ("1".equals(recordC.getUNHLD_STG2_PRSR_ULCR())) {
                int tmpInt;
                boolean atLeastOne = false;
                if (intStage2 > 0) {
                    atLeastOne = true;
                    if (!"  ".equals(recordC.getNBR_STG2_AT_SOC_ROC())) {
                        try {
                            tmpInt = IntegerUtils.parseInt(recordC.getNBR_STG2_AT_SOC_ROC(), Integer.MAX_VALUE);
                            if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && tmpInt > intStage2) {
                                this.NPRSULC2_INVLD = true;
                            }
                        }
                        catch (NumberFormatException e) {
                            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG2_AT_SOC_ROC", e.toString());
                            this.NPRSULC2_INVLD = true;
                        }
                    }
                } else if (intStage2 < 0) {
                    this.NPRSULC2_INVLD = true;
                }
                if (intStage3 > 0) {
                    atLeastOne = true;
                    if (!"  ".equals(recordC.getNBR_STG3_AT_SOC_ROC())) {
                        try {
                            tmpInt = IntegerUtils.parseInt(recordC.getNBR_STG3_AT_SOC_ROC(), Integer.MAX_VALUE);
                            if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && tmpInt > intStage3) {
                                this.NPRSULC3_INVLD = true;
                            }
                        }
                        catch (NumberFormatException e) {
                            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG3_AT_SOC_ROC", e.toString());
                            this.NPRSULC3_INVLD = true;
                        }
                    }
                } else if (intStage3 < 0) {
                    this.NPRSULC3_INVLD = true;
                }
                if (intStage4 > 0) {
                    atLeastOne = true;
                    if (!"  ".equals(recordC.getNBR_STG4_AT_SOC_ROC())) {
                        try {
                            tmpInt = IntegerUtils.parseInt(recordC.getNBR_STG4_AT_SOC_ROC(), Integer.MAX_VALUE);
                            if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && tmpInt > intStage4) {
                                this.NPRSULC4_INVLD = true;
                            }
                        }
                        catch (NumberFormatException e) {
                            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG4_AT_SOC_ROC", e.toString());
                            this.NPRSULC4_INVLD = true;
                        }
                    }
                } else if (intStage4 < 0) {
                    this.NPRSULC4_INVLD = true;
                }
                if ("00".compareTo(recordC.getNSTG_DRSG()) < 0 || "00".compareTo(recordC.getNSTG_CVRG()) < 0 || "00".compareTo(recordC.getNSTG_DEEP_TISUE()) < 0) {
                    atLeastOne = true;
                } else if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && ("00".compareTo(recordC.getNSTG_DRSG_SOC_ROC()) < 0 || "00".compareTo(recordC.getNSTG_CVRG_SOC_ROC()) < 0 || "00".compareTo(recordC.getNSTG_DEEP_TISSUE_SOC_ROC()) < 0)) {
                    atLeastOne = true;
                }
                if (!atLeastOne) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
                if (intStage2 == 0 && intStage3 == 0 && intStage4 == 0 && intNonStageDeepTissue == 0) {
                    if (intNonStageCovering == 0) {
                        if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) && !"NA".equals(recordC.getSTUS_PRBLM_PRSR_ULCR())) {
                            this.NPRSULC2_INVLD = true;
                            this.NPRSULC3_INVLD = true;
                            this.NPRSULC4_INVLD = true;
                        }
                    } else if (intNonStageCovering > 0 && ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) && !ValidateUtils.isValidValue(recordC.getSTUS_PRBLM_PRSR_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE})) {
                        this.NPRSULC2_INVLD = true;
                        this.NPRSULC3_INVLD = true;
                        this.NPRSULC4_INVLD = true;
                        this.UNOBS_PRSULC_INVLD = true;
                    }
                } else if ((intStage2 > 0 || intNonStageDeepTissue > 0) && intStage3 == 0 && intStage4 == 0 && intNonStageCovering == 0 && ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) && !"03".equals(recordC.getSTUS_PRBLM_PRSR_ULCR())) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
                if ((intStage3 > 0 || intStage4 > 0) && ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) && !ValidateUtils.isValidValue(recordC.getSTUS_PRBLM_PRSR_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE})) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
                if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY})) {
                    if (recordC.getNSTG_DRSG_SOC_ROC().compareTo(recordC.getNSTG_DRSG()) > 0) {
                        this.NPRSULC2_INVLD = true;
                        this.NPRSULC3_INVLD = true;
                        this.NPRSULC4_INVLD = true;
                        this.UNOBS_PRSULC_INVLD = true;
                    }
                    if (recordC.getNSTG_CVRG_SOC_ROC().compareTo(recordC.getNSTG_CVRG()) > 0) {
                        this.NPRSULC2_INVLD = true;
                        this.NPRSULC3_INVLD = true;
                        this.NPRSULC4_INVLD = true;
                        this.UNOBS_PRSULC_INVLD = true;
                    }
                    if (recordC.getNSTG_DEEP_TISSUE_SOC_ROC().compareTo(recordC.getNSTG_DEEP_TISUE()) > 0) {
                        this.NPRSULC2_INVLD = true;
                        this.NPRSULC3_INVLD = true;
                        this.NPRSULC4_INVLD = true;
                    }
                }
            } else {
                this.NPRSULC2_INVLD = true;
                this.NPRSULC3_INVLD = true;
                this.NPRSULC4_INVLD = true;
                this.UNOBS_PRSULC_INVLD = true;
            }
            if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) && (intStage3 > 0 || intStage4 > 0 || intNonStageCovering > 0) && (blank4.equals(recordC.getPRSR_ULCR_LNGTH()) || blank4.equals(recordC.getPRSR_ULCR_WDTH()) || blank4.equals(recordC.getPRSR_ULCR_DEPTH()))) {
                this.NPRSULC3_INVLD = true;
                this.NPRSULC4_INVLD = true;
            }
            if (!(intStage3 != 0 || intStage4 != 0 || intNonStageCovering != 0 || blank4.equals(recordC.getPRSR_ULCR_LNGTH()) && blank4.equals(recordC.getPRSR_ULCR_WDTH()) && blank4.equals(recordC.getPRSR_ULCR_DEPTH()))) {
                this.NPRSULC3_INVLD = true;
                this.NPRSULC4_INVLD = true;
            }
        }
        this.UNOBS_PRSULC_INVLD = this.UNOBS_PRSULC_INVLD || this.NPRSULC2_INVLD || this.NPRSULC3_INVLD || this.NPRSULC4_INVLD;
        return !this.NPRSULC1_INVLD && !this.NPRSULC2_INVLD && !this.NPRSULC3_INVLD && !this.NPRSULC4_INVLD && !this.UNOBS_PRSULC_INVLD;
    }

    @Override
    public boolean validateSTGPRSUL(HomeHealthRecordIF record, Collection<HomeHealthEventListenerIF> listeners) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            if ("01".equals(record.getSTG_PRBLM_ULCER())) {
                int tmpInt = IntegerUtils.parseInt(record.getNBR_PRSULC_STG1(), -1);
                if (tmpInt <= 0) {
                    this.STGPRSUL_INVLD = true;
                    ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG1", "Value out of range: " + record.getNBR_PRSULC_STG1());
                }
            } else if ("02".equals(record.getSTG_PRBLM_ULCER())) {
                int tmpInt = IntegerUtils.parseInt(record.getNBR_PRSULC_STG2(), -1);
                if (tmpInt <= 0) {
                    this.STGPRSUL_INVLD = true;
                    ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG2", "Value out of range: " + record.getNBR_PRSULC_STG2());
                }
            } else if ("03".equals(record.getSTG_PRBLM_ULCER())) {
                int tmpInt = IntegerUtils.parseInt(record.getNBR_PRSULC_STG3(), -1);
                if (tmpInt <= 0) {
                    this.STGPRSUL_INVLD = true;
                    ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG3", "Value out of range: " + record.getNBR_PRSULC_STG3());
                }
            } else if ("04".equals(record.getSTG_PRBLM_ULCER())) {
                int tmpInt = IntegerUtils.parseInt(record.getNBR_PRSULC_STG4(), -1);
                if (tmpInt <= 0) {
                    this.STGPRSUL_INVLD = true;
                    ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG4", "Value out of range: " + record.getNBR_PRSULC_STG4());
                }
            } else if ("00".equals(record.getNBR_PRSULC_STG1()) && "00".equals(record.getNBR_PRSULC_STG2()) && "00".equals(record.getNBR_PRSULC_STG3()) && "00".equals(record.getNBR_PRSULC_STG4()) && !"NA".equals(record.getSTG_PRBLM_ULCER())) {
                this.STGPRSUL_INVLD = true;
            }
        }
        return !this.STGPRSUL_INVLD;
    }

    @Override
    public boolean validateNBR_STASULC(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            String str = record.getSTAS_ULCR_PRSNT();
            if (!ValidateUtils.isValidValue(record.getNBR_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR}) && !"  ".equals(record.getNBR_STAS_ULCR())) {
                this.NBR_STASULC_INVLD = true;
            } else if ("01".equals(str) || "02".equals(str)) {
                if ("  ".equals(record.getNBR_STAS_ULCR()) || "  ".equals(record.getSTUS_PRBLM_STAS_ULCR())) {
                    this.NBR_STASULC_INVLD = true;
                }
            } else if (!(!"00".equals(str) && !"03".equals(str) || "  ".equals(record.getNBR_STAS_ULCR()) && "  ".equals(record.getSTUS_PRBLM_STAS_ULCR()))) {
                this.NBR_STASULC_INVLD = true;
            }
        }
        return !this.NBR_STASULC_INVLD;
    }

    @Override
    public boolean validateUNOBS_STASULC(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            String str = record.getSTAS_ULCR_PRSNT();
            if (!ValidateUtils.isValidValue(str, new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE})) {
                this.UNOBS_STASULC_INVLD = true;
            } else if ("01".equals(str) || "02".equals(str)) {
                if ("  ".equals(record.getNBR_STAS_ULCR()) || "  ".equals(record.getSTUS_PRBLM_STAS_ULCR())) {
                    this.UNOBS_STASULC_INVLD = true;
                }
            } else if (("00".equals(str) || "03".equals(str)) && !"  ".equals(record.getNBR_STAS_ULCR()) || !"  ".equals(record.getSTUS_PRBLM_STAS_ULCR())) {
                this.UNOBS_STASULC_INVLD = true;
            }
        }
        return !this.UNOBS_STASULC_INVLD;
    }

    @Override
    public boolean validateSTATSTASIS(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            String str = record.getSTAS_ULCR_PRSNT();
            if (!ValidateUtils.isValidValue(record.getSTUS_PRBLM_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE}) && !"  ".equals(record.getSTUS_PRBLM_STAS_ULCR())) {
                this.STATSTASIS_INVLD = true;
            } else if ("01".equals(str) || "02".equals(str)) {
                if (!ValidateUtils.isValidValue(record.getSTUS_PRBLM_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE}) || "  ".equals(record.getNBR_STAS_ULCR())) {
                    this.STATSTASIS_INVLD = true;
                }
            } else if (!(!"00".equals(str) && !"03".equals(str) || "  ".equals(record.getNBR_STAS_ULCR()) && "  ".equals(record.getSTUS_PRBLM_STAS_ULCR()))) {
                this.STATSTASIS_INVLD = true;
            }
        }
        return !this.STATSTASIS_INVLD;
    }

    @Override
    public boolean validateSTATSURG(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            if ("01".equals(record.getSRGCL_WND_PRSNT())) {
                if ("  ".equals(record.getSTUS_PRBLM_SRGCL_WND())) {
                    this.STATSURG_INVLD = true;
                }
            } else if (("00".equals(record.getSRGCL_WND_PRSNT()) || "02".equals(record.getSRGCL_WND_PRSNT())) && !"  ".equals(record.getSTUS_PRBLM_SRGCL_WND())) {
                this.STATSURG_INVLD = true;
            }
        }
        return !this.STATSURG_INVLD;
    }

    @Override
    public boolean validateWHEN_DYSPNEIC(HomeHealthRecordIF record) {
        return ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) ? super.validateWHEN_DYSPNEIC(record) : true;
    }

    @Override
    public boolean validateUR_INCONT(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) && super.validateUR_INCONT(record)) {
            if ("01".equals(record.getUR_INCONT())) {
                if ("  ".equals(((HomeHealthRecord_C_IF)record).getINCNTNT_TIMING())) {
                    this.UR_INCONT_INVLD = true;
                }
            } else if (!"  ".equals(((HomeHealthRecord_C_IF)record).getINCNTNT_TIMING())) {
                this.UR_INCONT_INVLD = true;
            }
        }
        return !this.UR_INCONT_INVLD;
    }

    @Override
    public boolean validateBWL_INCONT(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && !ValidateUtils.isValidValue(record.getBWL_INCONT(), ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
            this.BWLINCONT_INVLD = true;
        }
        return !this.BWLINCONT_INVLD;
    }

    @Override
    public boolean validateBWL_INCONT_OSTOMY(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            if ("NA".equals(record.getBWL_INCONT())) {
                if (!"01".equals(record.getOSTOMY()) && !"02".equals(record.getOSTOMY())) {
                    this.OSTOMY_INVLD = true;
                }
            } else if (ValidateUtils.isValidValue(record.getBWL_INCONT(), ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE, ValidateUtils.ARRAY_UNKNOWN_UK) && !"00".equals(record.getOSTOMY())) {
                this.OSTOMY_INVLD = true;
            }
        }
        return !this.OSTOMY_INVLD;
    }

    @Override
    public boolean validateCUR_DRESS(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            if (!ValidateUtils.isValidValue(record.getCRNT_DRESS_UPPER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE})) {
                this.CUR_DRESS_INVLD = true;
            } else if (!ValidateUtils.isValidValue(record.getCRNT_DRESS_LOWER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE})) {
                this.CUR_DRESS_INVLD = true;
            }
        }
        return !this.CUR_DRESS_INVLD;
    }

    @Override
    public boolean validateCUR_BATHING(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) && !ValidateUtils.isValidValue(record.getCRNT_BATHG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE_SIX})) {
            this.CUR_BATHING_INVLD = true;
        }
        return !this.CUR_BATHING_INVLD;
    }

    @Override
    public boolean validateCUR_TOILETING(HomeHealthRecordIF record) {
        return ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) ? super.validateCUR_TOILETING(record) : true;
    }

    @Override
    public boolean validateCUR_TRANSFERRING(HomeHealthRecordIF record) {
        return ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) ? super.validateCUR_TRANSFERRING(record) : true;
    }

    @Override
    public boolean validateCUR_AMBULATION(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) && !ValidateUtils.isValidValue(record.getCRNT_AMBLTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE_SIX})) {
            this.CUR_AMBULATION_INVLD = true;
        }
        return !this.CUR_AMBULATION_INVLD;
    }

    @Override
    public boolean validateCUR_INJECT_MEDS(HomeHealthRecordIF record) {
        String tmpInjectMeds = record.getCRNT_MGMT_INJCTN_MDCTN();
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY})) {
            String tmpRgmn = ((HomeHealthRecord_C_IF)record).getDRUG_RGMN_RVW();
            if (ValidateUtils.isValidValue(tmpRgmn, new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO})) {
                if (!ValidateUtils.isValidValue(tmpInjectMeds, ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
                    this.CUR_INJECT_MEDS_INVLD = true;
                }
            } else if ("NA".equals(tmpRgmn) && !"  ".equals(record.getCRNT_MGMT_INJCTN_MDCTN())) {
                this.CUR_INJECT_MEDS_INVLD = true;
            }
        } else if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && !ValidateUtils.isValidValue(tmpInjectMeds, ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
            this.CUR_INJECT_MEDS_INVLD = true;
        }
        return !this.CUR_INJECT_MEDS_INVLD;
    }

    @Override
    public boolean validateTHER_NEED(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            if ("1".equals(record.getTHER_NEED_NA())) {
                if (record.getTHER_NEED_NBR() >= 0) {
                    this.THER_NEED_INVLD = true;
                }
            } else if ("0".equals(record.getTHER_NEED_NA()) && (record.getTHER_NEED_NBR() < 0 || record.getTHER_NEED_NBR() > 999)) {
                this.THER_NEED_INVLD = true;
            }
        }
        return !this.THER_NEED_INVLD;
    }
}

