/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3210;

import com.mmm.cms.homehealth.DataValidityFlag;
import com.mmm.cms.homehealth.proto.DataValidityFlagIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_C_IF;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisDataItemIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditTypeEN;
import com.mmm.cms.homehealth.vut.proto.OasisValidationEditIF;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ScoringEventFormatter;
import com.mmm.cms.util.ValidateUtils;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractBaseValidator_v3210
implements HomeHealthRecordValidatorIF {
    public static final String[] ASSESSMENT_REASON_VALUES_ALL = new String[]{"01", "03", "04", "05", "06", "07", "08", "09"};
    public static final String[] ASSESSMENT_REASON_VALUES = new String[]{"01", "03", "04", "05"};
    public static final String[] ASSESSMENT_1_3_ONLY = new String[]{"01", "03"};
    public static final String[] ASSESSMENT_4_5_ONLY = new String[]{"04", "05"};
    public static final String blank4 = "    ";
    protected boolean ASSMT_REASON_INVLD;
    protected boolean INFO_COMPLETED_DT_INVLD;
    protected boolean THERAPIES_INVLD;
    protected boolean INTERNAL_LOGIC_INVLD;
    protected boolean VISION_INVLD;
    protected boolean PAIN_INVLD;
    protected boolean LESION_INVLD;
    protected boolean NPRSULC1_INVLD;
    protected boolean NPRSULC2_INVLD;
    protected boolean NPRSULC3_INVLD;
    protected boolean NPRSULC4_INVLD;
    protected boolean UNOBS_PRSULC_INVLD;
    protected boolean STGPRSUL_INVLD;
    protected boolean NBR_STASULC_INVLD;
    protected boolean UNOBS_STASULC_INVLD;
    protected boolean STATSTASIS_INVLD;
    protected boolean STATSURG_INVLD;
    protected boolean DYSPNEIC_INVLD;
    protected boolean UR_INCONT_INVLD;
    protected boolean BWLINCONT_INVLD;
    protected boolean OSTOMY_INVLD;
    protected boolean CUR_DRESS_INVLD;
    protected boolean CUR_BATHING_INVLD;
    protected boolean CUR_TOILETING_INVLD;
    protected boolean CUR_TRANSFER_INVLD;
    protected boolean CUR_AMBULATION_INVLD;
    protected boolean CUR_INJECT_MEDS_INVLD;
    protected boolean THER_NEED_INVLD;
    protected DataValidityFlagIF dataValidityFlag;
    protected transient HomeHealthGrouperIF grouper;
    protected int[] diagnosisScoringStatus;

    public AbstractBaseValidator_v3210(HomeHealthGrouperIF grouper) {
        this.grouper = grouper;
        this.dataValidityFlag = new DataValidityFlag();
        this.diagnosisScoringStatus = new int[18];
    }

    @Override
    public DataValidityFlagIF getDataValidityFlag() {
        return this.dataValidityFlag;
    }

    @Override
    public void setDataValidityFlag(DataValidityFlagIF dataValidityFlag) {
        if (dataValidityFlag == null) {
            throw new IllegalArgumentException("dataValidityFlag parameter can not be null");
        }
        this.dataValidityFlag = dataValidityFlag;
    }

    @Override
    public final boolean isClinicalDomainDataIssueFlag() {
        return this.dataValidityFlag.isClinicalIssue();
    }

    @Override
    public final boolean isFunctionalDomainDataIssueFlag() {
        return this.dataValidityFlag.isFunctionalIssue();
    }

    @Override
    public final boolean isManifestationSequenceIssueFlag() {
        return this.dataValidityFlag.isManifestationSequenceIssue();
    }

    @Override
    public final boolean isServiceDomainDataIssueFlag() {
        return this.dataValidityFlag.isServiceIssue();
    }

    @Override
    public CollectionValidationEditsIF validate(HomeHealthRecordIF record, Collection<HomeHealthEventListenerIF> listeners) {
        if (!this.validateASSMT_REASON(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Assessment Reason", record.getASSMT_REASON());
        }
        if (!this.validateExistingCodes(record, listeners)) {
            this.dataValidityFlag.setClinicalIssue(true);
        }
        if (!this.validatePRIMARY_DIAG_ICD(record, listeners)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Primary Diagnosis", record.getPRIMARY_DIAG_ICD().getCode());
        }
        if (!this.validatePAYMENT_ECodes(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Payment Diagnosis E-codes", "<various>");
        }
        if (!this.validateDiagnosisUnique(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Other Diagnosis are not unique", "<various>");
        }
        if (!this.validateTHH(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Therapies Received at Home", record.getTHH_IV_INFUSION() + ", " + record.getTHH_PAR_NUTRITION() + ", " + record.getTHH_ENT_NUTRITION() + ", " + record.getTHH_NONE_ABOVE());
        }
        if (!this.validateVISION(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Vision", record.getVISION());
        }
        if (!this.validateFREQ_PAIN(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Frequent Pain", record.getPAIN_FREQ_ACTVTY_MVMT());
        }
        if (!this.validateNPRSULC(record, listeners)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Number of Pressure Ulcers (4 stages)", record.getNBR_PRSULC_STG1() + ", " + record.getNBR_PRSULC_STG2() + ", " + record.getNBR_PRSULC_STG3() + ", " + record.getNBR_PRSULC_STG4());
        }
        if (!this.validateSTGPRSUL(record, listeners)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Stage of Most Problematic Pressure Ulcer", record.getSTG_PRBLM_ULCER());
        }
        if (!this.validateNBR_STASULC(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Number of Stasis Ulcers", record.getNBR_STAS_ULCR());
        }
        if (!this.validateUNOBS_STASULC(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Unobserved Stasis Ulcer", record.getSTAS_ULCR_PRSNT());
        }
        if (!this.validateSTATSTASIS(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Status Stasis Ulcer", record.getSTUS_PRBLM_STAS_ULCR());
        }
        if (!this.validateSTATSURG(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Status Surgical Wound", record.getSTUS_PRBLM_SRGCL_WND());
        }
        if (!this.validateWHEN_DYSPNEIC(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "When Dyspneic", record.getWHEN_DYSPNEIC());
        }
        if (!this.validateUR_INCONT(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Urinary Incontinence", record.getUR_INCONT());
        }
        if (!this.validateBWL_INCONT(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Bowl Incontinence", record.getBWL_INCONT());
        }
        if (!this.validateBWL_INCONT_OSTOMY(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Bowl Incontinence Ostomy", record.getOSTOMY());
        }
        if (!this.validateCUR_INJECT_MEDS(record)) {
            this.dataValidityFlag.setClinicalIssue(true);
            ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Injectable Meds", record.getCRNT_MGMT_INJCTN_MDCTN());
        }
        if (!this.validateCUR_DRESS(record)) {
            this.dataValidityFlag.setFunctionalIssue(true);
            ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Dressing (Upper & Lower)", record.getCRNT_DRESS_UPPER() + ", " + record.getCRNT_DRESS_LOWER());
        }
        if (!this.validateCUR_BATHING(record)) {
            this.dataValidityFlag.setFunctionalIssue(true);
            ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Bathing", record.getCRNT_BATHG());
        }
        if (!this.validateCUR_TOILETING(record)) {
            this.dataValidityFlag.setFunctionalIssue(true);
            ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Toileting", record.getCRNT_TOILTG());
        }
        if (!this.validateCUR_TRANSFERRING(record)) {
            this.dataValidityFlag.setFunctionalIssue(true);
            ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Transferring", record.getCRNT_TRNSFRNG());
        }
        if (!this.validateCUR_AMBULATION(record)) {
            this.dataValidityFlag.setFunctionalIssue(true);
            ScoringEventFormatter.fireFunctionalIssueEvent(listeners, this.grouper, null, "Current Ambulation", record.getCRNT_AMBLTN());
        }
        if (!this.validateTHER_NEED(record)) {
            this.dataValidityFlag.setServiceIssue(true);
            ScoringEventFormatter.fireServiceIssueEvent(listeners, this.grouper, null, "Therapy Need and Number of Therapies", record.getTHER_NEED_NBR() + ", " + record.getTHER_NEED_NA());
        }
        if (!this.isValidPrincipalDiagnosisCode(record)) {
            this.dataValidityFlag.setManifestationSequenceIssue(true);
            ScoringEventFormatter.fireManifestationIssueEvent(listeners, this.grouper, null, "Primary Diagnosis", record.getPRIMARY_DIAG_ICD().getCode());
        }
        if (!this.validateDiagnosisCodes(record, listeners)) {
            this.dataValidityFlag.setManifestationSequenceIssue(true);
            ScoringEventFormatter.fireManifestationIssueEvent(listeners, this.grouper, null, "All Diagnosis Codes", "<various>");
        }
        for (int idx = 0; idx < 18; ++idx) {
            DiagnosisCodeIF code = record.getDiagnosisCode(idx);
            this.diagnosisScoringStatus[idx] = code.isValidForScoring() ? 2 : (code.isValidCode() || code.isOptionalPaymentCode() ? 1 : 0);
        }
        return null;
    }

    @Override
    public boolean validate(HomeHealthRecordIF record) {
        this.validate(record, null);
        return !this.dataValidityFlag.isIssuePresent();
    }

    public boolean validateASSMT_REASON(HomeHealthRecordIF record) {
        if (!ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES_ALL})) {
            this.ASSMT_REASON_INVLD = true;
        }
        return !this.ASSMT_REASON_INVLD;
    }

    public boolean validateExistingCodes(HomeHealthRecordIF record, Collection<HomeHealthEventListenerIF> listeners) {
        DiagnosisCodeIF code;
        int idx;
        boolean valid = true;
        for (idx = 0; idx < 6; ++idx) {
            code = record.getDiagnosisCode(idx);
            if (code.isValidCode() || code.isEmpty()) continue;
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Invalid Diagnosis code", code.getCode());
            valid = false;
        }
        for (idx = 0; idx < 6; ++idx) {
            code = record.getOptionalDiagnosisCode3(idx);
            if (!code.isValidCode() && !code.isEmpty()) {
                ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Invalid Diagnosis code", code.getCode());
                valid = false;
            }
            if ((code = record.getOptionalDiagnosisCode4(idx)).isValidCode() || code.isEmpty()) continue;
            ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "Invalid Diagnosis code", code.getCode());
            valid = false;
        }
        return valid;
    }

    public boolean validatePAYMENT_ECodes(HomeHealthRecordIF record) {
        boolean valid = true;
        for (int idx = 0; idx < 6; ++idx) {
            DiagnosisCodeIF code = record.getOptionalDiagnosisCode3(idx);
            if (code.isExternalCauseCode()) {
                valid = false;
                code.setValidForScoring(valid);
            }
            if (!(code = record.getOptionalDiagnosisCode4(idx)).isExternalCauseCode()) continue;
            valid = false;
            code.setValidForScoring(valid);
        }
        return valid;
    }

    public boolean validateOtherDiagnosisSeries(HomeHealthRecordIF record) {
        boolean valid = true;
        int idx = 1;
        while (idx < 5) {
            DiagnosisCodeIF previousCode = record.getDiagnosisCode(idx++);
            DiagnosisCodeIF currentCode = record.getDiagnosisCode(idx);
            if (!previousCode.isEmpty() || currentCode.isEmpty()) continue;
            currentCode.setValidForScoring(false);
            while (++idx < 6) {
                currentCode = record.getDiagnosisCode(idx);
                currentCode.setValidForScoring(false);
            }
            valid = false;
            break;
        }
        return valid;
    }

    public boolean validateDiagnosisUnique(HomeHealthRecordIF record) {
        boolean valid = true;
        int idx = 0;
        while (idx < 5) {
            DiagnosisCodeIF currentCode;
            if (!(currentCode = record.getDiagnosisCode(idx++)).isValidCode()) continue;
            int j = idx;
            while (j < 6) {
                DiagnosisCodeIF otherCode;
                if (!(otherCode = record.getDiagnosisCode(j++)).isValidCode() || !currentCode.equals(otherCode)) continue;
                otherCode.setValidForScoring(false);
                valid = false;
            }
        }
        return valid;
    }

    public boolean validatePRIMARY_DIAG_ICD(HomeHealthRecordIF record, Collection<HomeHealthEventListenerIF> listeners) {
        boolean valid = true;
        DiagnosisCodeIF code = record.getPRIMARY_DIAG_ICD();
        if (code.isExternalCauseCode()) {
            code.setValidForScoring(false);
            valid = false;
        }
        if (code.isEmpty()) {
            int idx = 1;
            while (idx < 18) {
                if ((code = record.getDiagnosisCode(idx++)) == null) continue;
                code.setValidForScoring(false);
            }
            valid = false;
        }
        return valid;
    }

    public boolean validateTHH(HomeHealthRecordIF record) {
        boolean valid;
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            if (!ValidateUtils.isValidValue(record.getTHH_IV_INFUSION(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                this.THERAPIES_INVLD = true;
            }
            if (!ValidateUtils.isValidValue(record.getTHH_PAR_NUTRITION(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                this.THERAPIES_INVLD = true;
            }
            if (!ValidateUtils.isValidValue(record.getTHH_ENT_NUTRITION(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                this.THERAPIES_INVLD = true;
            }
            if (!ValidateUtils.isValidValue(record.getTHH_NONE_ABOVE(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
                this.THERAPIES_INVLD = true;
            }
            if ("1".equals(record.getTHH_NONE_ABOVE()) && ("1".equals(record.getTHH_IV_INFUSION()) || "1".equals(record.getTHH_PAR_NUTRITION()) || "1".equals(record.getTHH_ENT_NUTRITION()))) {
                this.INTERNAL_LOGIC_INVLD = true;
            }
            if ("0".equals(record.getTHH_NONE_ABOVE()) && "0".equals(record.getTHH_IV_INFUSION()) && "0".equals(record.getTHH_PAR_NUTRITION()) && "0".equals(record.getTHH_ENT_NUTRITION())) {
                this.INTERNAL_LOGIC_INVLD = true;
            }
            valid = !this.THERAPIES_INVLD && !this.INTERNAL_LOGIC_INVLD;
        } else {
            valid = true;
        }
        return valid;
    }

    public boolean validateVISION(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) && !ValidateUtils.isValidValue(record.getVISION(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO})) {
            this.VISION_INVLD = true;
        }
        return !this.VISION_INVLD;
    }

    public boolean validateFREQ_PAIN(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) && !ValidateUtils.isValidValue(record.getPAIN_FREQ_ACTVTY_MVMT(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
            this.PAIN_INVLD = true;
        }
        return !this.PAIN_INVLD;
    }

    public boolean validateLESION_OPEN_WND(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) && !ValidateUtils.isValidValue(record.getLESION_OPEN_WND(), new String[][]{ValidateUtils.ARRAY_ZERO_ONE})) {
            this.LESION_INVLD = true;
        }
        return !this.LESION_INVLD;
    }

    public boolean validateNPRSULC(HomeHealthRecordIF record, Collection<HomeHealthEventListenerIF> listeners) {
        HomeHealthRecord_C_IF recordC;
        if (record instanceof HomeHealthRecord_C_IF && ValidateUtils.isValidValue((recordC = (HomeHealthRecord_C_IF)record).getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            int intNonStageDeepTissue;
            int intNonStageCovering;
            int intStage4;
            int intStage3;
            int intStage2;
            String tmpStr = recordC.getNBR_PRSULC_STG1();
            if (!ValidateUtils.isEmpty(tmpStr)) {
                int intStage1 = IntegerUtils.parseInt(tmpStr, -1);
                if (intStage1 < 0 || intStage1 > 4) {
                    this.NPRSULC1_INVLD = true;
                    ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG1", "Value not in range: " + tmpStr);
                }
            } else {
                this.NPRSULC1_INVLD = true;
            }
            if (!ValidateUtils.isEmpty(tmpStr = recordC.getNBR_PRSULC_STG2())) {
                intStage2 = IntegerUtils.parseInt(tmpStr, -2);
                if (intStage2 == -2) {
                    this.NPRSULC2_INVLD = true;
                }
            } else {
                intStage2 = -1;
            }
            if (!ValidateUtils.isEmpty(tmpStr = recordC.getNBR_PRSULC_STG3())) {
                intStage3 = IntegerUtils.parseInt(tmpStr, -2);
                if (intStage3 == -2) {
                    this.NPRSULC3_INVLD = true;
                }
            } else {
                intStage3 = -1;
            }
            if (!ValidateUtils.isEmpty(tmpStr = recordC.getNBR_PRSULC_STG4())) {
                intStage4 = IntegerUtils.parseInt(tmpStr, -2);
                if (intStage4 == -2) {
                    this.NPRSULC4_INVLD = true;
                }
            } else {
                intStage4 = -1;
            }
            if (!ValidateUtils.isEmpty(tmpStr = recordC.getNSTG_CVRG())) {
                intNonStageCovering = IntegerUtils.parseInt(tmpStr, -2);
                if (intNonStageCovering == -2) {
                    this.UNOBS_PRSULC_INVLD = true;
                }
            } else {
                intNonStageCovering = -1;
            }
            if (!ValidateUtils.isEmpty(tmpStr = recordC.getNSTG_DEEP_TISUE())) {
                intNonStageDeepTissue = IntegerUtils.parseInt(tmpStr, -2);
                if (intNonStageDeepTissue == -2) {
                    this.UNOBS_PRSULC_INVLD = true;
                }
            } else {
                intNonStageDeepTissue = -1;
            }
            if ((intStage3 > 0 || intStage4 > 0) && ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) && !ValidateUtils.isValidValue(recordC.getSTUS_PRBLM_PRSR_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE})) {
                this.NPRSULC3_INVLD = true;
                this.NPRSULC4_INVLD = true;
            }
            if ("0".equals(tmpStr = recordC.getUNHLD_STG2_PRSR_ULCR())) {
                if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && (intStage2 >= 0 || !ValidateUtils.isEmpty(recordC.getNBR_STG2_AT_SOC_ROC()))) {
                    this.NPRSULC2_INVLD = true;
                }
                if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && (intStage3 >= 0 || !ValidateUtils.isEmpty(recordC.getNBR_STG3_AT_SOC_ROC()))) {
                    this.NPRSULC3_INVLD = true;
                }
                if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && (intStage4 >= 0 || !ValidateUtils.isEmpty(recordC.getNBR_STG4_AT_SOC_ROC()))) {
                    this.NPRSULC4_INVLD = true;
                }
                if (!ValidateUtils.isEmpty(recordC.getNSTG_DEEP_TISUE())) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
                if (!ValidateUtils.isEmpty(recordC.getNSTG_DRSG()) || intNonStageCovering >= 0) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                    this.UNOBS_PRSULC_INVLD = true;
                }
                if (!(!ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) || ValidateUtils.isEmpty(recordC.getPRSR_ULCR_LNGTH()) && ValidateUtils.isEmpty(recordC.getPRSR_ULCR_WDTH()) && ValidateUtils.isEmpty(recordC.getPRSR_ULCR_DEPTH()) && ValidateUtils.isEmpty(recordC.getSTUS_PRBLM_PRSR_ULCR()))) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
                if (!(!ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) || ValidateUtils.isEmpty(recordC.getNSTG_DRSG_SOC_ROC()) && ValidateUtils.isEmpty(recordC.getNSTG_CVRG_SOC_ROC()) && ValidateUtils.isEmpty(recordC.getNSTG_DEEP_TISSUE_SOC_ROC()))) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
            } else if ("1".equals(tmpStr)) {
                boolean atLeastOne = false;
                if (intStage2 > 0) {
                    atLeastOne = true;
                    if (!"  ".equals(recordC.getNBR_STG2_AT_SOC_ROC()) && ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && IntegerUtils.parseInt(recordC.getNBR_STG2_AT_SOC_ROC(), 9999) > intStage2) {
                        this.NPRSULC2_INVLD = true;
                        ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG2_AT_SOC_ROC", "Value out of range: " + recordC.getNBR_STG2_AT_SOC_ROC());
                    }
                } else if (intStage2 < 0) {
                    this.NPRSULC2_INVLD = true;
                }
                if (intStage3 > 0) {
                    atLeastOne = true;
                    if (!"  ".equals(recordC.getNBR_STG3_AT_SOC_ROC()) && ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && IntegerUtils.parseInt(recordC.getNBR_STG3_AT_SOC_ROC(), 9999) > intStage3) {
                        this.NPRSULC3_INVLD = true;
                        ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG3_AT_SOC_ROC", "Value out of range: " + recordC.getNBR_STG3_AT_SOC_ROC());
                    }
                } else if (intStage3 < 0) {
                    this.NPRSULC3_INVLD = true;
                }
                if (intStage4 > 0) {
                    atLeastOne = true;
                    if (!"  ".equals(recordC.getNBR_STG4_AT_SOC_ROC()) && ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && IntegerUtils.parseInt(recordC.getNBR_STG4_AT_SOC_ROC(), 9999) > intStage4) {
                        this.NPRSULC4_INVLD = true;
                        ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG4_AT_SOC_ROC", "Value out of range: " + recordC.getNBR_STG4_AT_SOC_ROC());
                    }
                } else if (intStage4 < 0) {
                    this.NPRSULC4_INVLD = true;
                }
                try {
                    if ("00".compareTo(recordC.getNSTG_DRSG()) < 0 || "00".compareTo(recordC.getNSTG_CVRG()) < 0 || "00".compareTo(recordC.getNSTG_DEEP_TISUE()) < 0) {
                        atLeastOne = true;
                    } else if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && ("00".compareTo(recordC.getNSTG_DRSG_SOC_ROC()) < 0 || "00".compareTo(recordC.getNSTG_CVRG_SOC_ROC()) < 0 || "00".compareTo(recordC.getNSTG_DEEP_TISSUE_SOC_ROC()) < 0)) {
                        atLeastOne = true;
                    }
                }
                catch (NullPointerException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, " What?");
                }
                if (!atLeastOne) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
                if (intStage2 == 0 && intStage3 == 0 && intStage4 == 0 && intNonStageDeepTissue == 0) {
                    if (intNonStageCovering == 0) {
                        if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) && !"NA".equals(recordC.getSTUS_PRBLM_PRSR_ULCR())) {
                            this.NPRSULC2_INVLD = true;
                            this.NPRSULC3_INVLD = true;
                            this.NPRSULC4_INVLD = true;
                        }
                    } else if (intNonStageCovering > 0 && ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) && !ValidateUtils.isValidValue(recordC.getSTUS_PRBLM_PRSR_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_TWO_THREE})) {
                        this.NPRSULC2_INVLD = true;
                        this.NPRSULC3_INVLD = true;
                        this.NPRSULC4_INVLD = true;
                        this.UNOBS_PRSULC_INVLD = true;
                    }
                } else if ((intStage2 > 0 || intNonStageDeepTissue > 0) && intStage3 == 0 && intStage4 == 0 && intNonStageCovering == 0 && ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) && !"03".equals(recordC.getSTUS_PRBLM_PRSR_ULCR())) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
                if ((intStage3 > 0 || intStage4 > 0) && ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY}) && !ValidateUtils.isValidValue(recordC.getSTUS_PRBLM_PRSR_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE})) {
                    this.NPRSULC2_INVLD = true;
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
                if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY})) {
                    if (recordC.getNSTG_DRSG_SOC_ROC().compareTo(recordC.getNSTG_DRSG()) > 0) {
                        this.NPRSULC2_INVLD = true;
                        this.NPRSULC3_INVLD = true;
                        this.NPRSULC4_INVLD = true;
                        this.UNOBS_PRSULC_INVLD = true;
                    }
                    if (recordC.getNSTG_CVRG_SOC_ROC().compareTo(recordC.getNSTG_CVRG()) > 0) {
                        this.NPRSULC2_INVLD = true;
                        this.NPRSULC3_INVLD = true;
                        this.NPRSULC4_INVLD = true;
                        this.UNOBS_PRSULC_INVLD = true;
                    }
                    if (recordC.getNSTG_DEEP_TISSUE_SOC_ROC().compareTo(recordC.getNSTG_DEEP_TISUE()) > 0) {
                        this.NPRSULC2_INVLD = true;
                        this.NPRSULC3_INVLD = true;
                        this.NPRSULC4_INVLD = true;
                    }
                }
            } else {
                this.NPRSULC2_INVLD = true;
                this.NPRSULC3_INVLD = true;
                this.NPRSULC4_INVLD = true;
                this.UNOBS_PRSULC_INVLD = true;
            }
            if (ValidateUtils.isValidValue(recordC.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY})) {
                if ((intStage3 > 0 || intStage4 > 0 || intNonStageCovering > 0) && (blank4.equals(recordC.getPRSR_ULCR_LNGTH()) || blank4.equals(recordC.getPRSR_ULCR_WDTH()) || blank4.equals(recordC.getPRSR_ULCR_DEPTH()))) {
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
                if (!(intStage3 != 0 || intStage4 != 0 || intNonStageCovering != 0 || blank4.equals(recordC.getPRSR_ULCR_LNGTH()) && blank4.equals(recordC.getPRSR_ULCR_WDTH()) && blank4.equals(recordC.getPRSR_ULCR_DEPTH()))) {
                    this.NPRSULC3_INVLD = true;
                    this.NPRSULC4_INVLD = true;
                }
            }
        }
        this.UNOBS_PRSULC_INVLD = this.UNOBS_PRSULC_INVLD || this.NPRSULC2_INVLD || this.NPRSULC3_INVLD || this.NPRSULC4_INVLD;
        return !this.NPRSULC1_INVLD && !this.NPRSULC2_INVLD && !this.NPRSULC3_INVLD && !this.NPRSULC4_INVLD && !this.UNOBS_PRSULC_INVLD;
    }

    public boolean validateSTGPRSUL(HomeHealthRecordIF record, Collection<HomeHealthEventListenerIF> listeners) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            String problemUlcer = record.getSTG_PRBLM_ULCER();
            if ("01".equals(problemUlcer)) {
                String tmpStr = record.getNBR_PRSULC_STG1();
                if (!ValidateUtils.isEmpty(tmpStr)) {
                    try {
                        int tmpInt = IntegerUtils.parseInt(tmpStr, 10, Integer.MAX_VALUE, false);
                        if (tmpInt <= 0) {
                            this.STGPRSUL_INVLD = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG1", e.toString());
                        this.STGPRSUL_INVLD = true;
                    }
                } else {
                    this.STGPRSUL_INVLD = true;
                }
            } else if ("02".equals(problemUlcer)) {
                String tmpStr = record.getNBR_PRSULC_STG2();
                if (!ValidateUtils.isEmpty(tmpStr)) {
                    try {
                        int tmpInt = IntegerUtils.parseInt(tmpStr, 10, Integer.MAX_VALUE, false);
                        if (tmpInt <= 0) {
                            this.STGPRSUL_INVLD = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG2", e.toString());
                        this.STGPRSUL_INVLD = true;
                    }
                } else {
                    this.STGPRSUL_INVLD = true;
                }
            } else if ("03".equals(problemUlcer)) {
                String tmpStr = record.getNBR_PRSULC_STG3();
                if (!ValidateUtils.isEmpty(tmpStr)) {
                    try {
                        int tmpInt = IntegerUtils.parseInt(tmpStr, 10, Integer.MAX_VALUE, false);
                        if (tmpInt <= 0) {
                            this.STGPRSUL_INVLD = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG3", e.toString());
                        this.STGPRSUL_INVLD = true;
                    }
                } else {
                    this.STGPRSUL_INVLD = true;
                }
            } else if ("04".equals(problemUlcer)) {
                String tmpStr = record.getNBR_PRSULC_STG4();
                if (!ValidateUtils.isEmpty(tmpStr)) {
                    try {
                        int tmpInt = IntegerUtils.parseInt(tmpStr, 10, Integer.MAX_VALUE, false);
                        if (tmpInt <= 0) {
                            this.STGPRSUL_INVLD = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        ScoringEventFormatter.fireClinicalIssueEvent(listeners, this.grouper, null, "NBR_PRSULC_STG4", e.toString());
                        this.STGPRSUL_INVLD = true;
                    }
                } else {
                    this.STGPRSUL_INVLD = true;
                }
            } else if ("00".equals(record.getNBR_PRSULC_STG1()) && "00".equals(record.getNBR_PRSULC_STG2()) && "00".equals(record.getNBR_PRSULC_STG3()) && "00".equals(record.getNBR_PRSULC_STG4()) && !"NA".equals(problemUlcer)) {
                this.STGPRSUL_INVLD = true;
            }
        }
        return !this.STGPRSUL_INVLD;
    }

    public boolean validateNBR_STASULC(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            String str = record.getSTAS_ULCR_PRSNT();
            String numStasisUlcers = record.getNBR_STAS_ULCR();
            if (!ValidateUtils.isValidValue(numStasisUlcers, new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR}) && !"  ".equals(numStasisUlcers)) {
                this.NBR_STASULC_INVLD = true;
            } else if ("01".equals(str) || "02".equals(str)) {
                if ("  ".equals(numStasisUlcers) || "  ".equals(record.getSTUS_PRBLM_STAS_ULCR())) {
                    this.NBR_STASULC_INVLD = true;
                }
            } else if (!(!"00".equals(str) && !"03".equals(str) || "  ".equals(numStasisUlcers) && "  ".equals(record.getSTUS_PRBLM_STAS_ULCR()))) {
                this.NBR_STASULC_INVLD = true;
            }
        }
        return !this.NBR_STASULC_INVLD;
    }

    public boolean validateUNOBS_STASULC(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            String str = record.getSTAS_ULCR_PRSNT();
            if (!ValidateUtils.isValidValue(str, new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE})) {
                this.UNOBS_STASULC_INVLD = true;
            } else if ("01".equals(str) || "02".equals(str)) {
                if ("  ".equals(record.getNBR_STAS_ULCR()) || "  ".equals(record.getSTUS_PRBLM_STAS_ULCR())) {
                    this.UNOBS_STASULC_INVLD = true;
                }
            } else if (!(!"00".equals(str) && !"03".equals(str) || "  ".equals(record.getNBR_STAS_ULCR()) && "  ".equals(record.getSTUS_PRBLM_STAS_ULCR()))) {
                this.UNOBS_STASULC_INVLD = true;
            }
        }
        return !this.UNOBS_STASULC_INVLD;
    }

    public boolean validateSTATSTASIS(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            if (!ValidateUtils.isValidValue(record.getSTUS_PRBLM_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE}) && !"  ".equals(record.getSTUS_PRBLM_STAS_ULCR())) {
                this.STATSTASIS_INVLD = true;
            } else {
                String tmpStr = record.getSTAS_ULCR_PRSNT();
                if ("01".equals(tmpStr) || "02".equals(tmpStr)) {
                    if (!ValidateUtils.isValidValue(record.getSTUS_PRBLM_STAS_ULCR(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE}) || "  ".equals(record.getNBR_STAS_ULCR())) {
                        this.STATSTASIS_INVLD = true;
                    }
                } else if (!(!"00".equals(tmpStr) && !"03".equals(tmpStr) || "  ".equals(record.getNBR_STAS_ULCR()) && "  ".equals(record.getSTUS_PRBLM_STAS_ULCR()))) {
                    this.STATSTASIS_INVLD = true;
                }
            }
        }
        return !this.STATSTASIS_INVLD;
    }

    public boolean validateSTATSURG(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            String tmpStr = record.getSRGCL_WND_PRSNT();
            if ("01".equals(tmpStr)) {
                if ("  ".equals(record.getSTUS_PRBLM_SRGCL_WND())) {
                    this.STATSURG_INVLD = true;
                }
            } else if (("00".equals(tmpStr) || "02".equals(tmpStr)) && !"  ".equals(record.getSTUS_PRBLM_SRGCL_WND())) {
                this.STATSURG_INVLD = true;
            }
        }
        return !this.STATSURG_INVLD;
    }

    public boolean validateWHEN_DYSPNEIC(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) && !ValidateUtils.isValidValue(record.getWHEN_DYSPNEIC(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
            this.DYSPNEIC_INVLD = true;
        }
        return !this.DYSPNEIC_INVLD;
    }

    public boolean validateUR_INCONT(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            if (!ValidateUtils.isValidValue(record.getUR_INCONT(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO})) {
                this.UR_INCONT_INVLD = true;
            }
            if (!this.UR_INCONT_INVLD && ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY})) {
                if ("01".equals(record.getUR_INCONT())) {
                    if ("  ".equals(((HomeHealthRecord_C_IF)record).getINCNTNT_TIMING())) {
                        this.UR_INCONT_INVLD = true;
                    }
                } else if (!"  ".equals(((HomeHealthRecord_C_IF)record).getINCNTNT_TIMING())) {
                    this.UR_INCONT_INVLD = true;
                }
            }
        }
        return !this.UR_INCONT_INVLD;
    }

    public boolean validateBWL_INCONT(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && !ValidateUtils.isValidValue(record.getBWL_INCONT(), ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
            this.BWLINCONT_INVLD = true;
        }
        return !this.BWLINCONT_INVLD;
    }

    public boolean validateBWL_INCONT_OSTOMY(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            if ("NA".equals(record.getBWL_INCONT())) {
                if (!"01".equals(record.getOSTOMY()) && !"02".equals(record.getOSTOMY())) {
                    this.OSTOMY_INVLD = true;
                }
            } else if (ValidateUtils.isValidValue(record.getBWL_INCONT(), ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE, ValidateUtils.ARRAY_UNKNOWN_UK) && !"00".equals(record.getOSTOMY())) {
                this.OSTOMY_INVLD = true;
            }
        }
        return !this.OSTOMY_INVLD;
    }

    public boolean validateCUR_INJECT_MEDS(HomeHealthRecordIF record) {
        String tmpInjectMeds = record.getCRNT_MGMT_INJCTN_MDCTN();
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_1_3_ONLY})) {
            String tmpRgmn = ((HomeHealthRecord_C_IF)record).getDRUG_RGMN_RVW();
            if (ValidateUtils.isValidValue(tmpRgmn, new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO})) {
                if (!ValidateUtils.isValidValue(tmpInjectMeds, ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
                    this.CUR_INJECT_MEDS_INVLD = true;
                }
            } else if ("NA".equals(tmpRgmn) && !"  ".equals(record.getCRNT_MGMT_INJCTN_MDCTN())) {
                this.CUR_INJECT_MEDS_INVLD = true;
            }
        } else if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_4_5_ONLY}) && !ValidateUtils.isValidValue(tmpInjectMeds, ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE, ValidateUtils.ARRAY_NOT_APPLICABLE)) {
            this.CUR_INJECT_MEDS_INVLD = true;
        }
        return !this.CUR_INJECT_MEDS_INVLD;
    }

    public boolean validateCUR_DRESS(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            if (!ValidateUtils.isValidValue(record.getCRNT_DRESS_UPPER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE})) {
                this.CUR_DRESS_INVLD = true;
            } else if (!ValidateUtils.isValidValue(record.getCRNT_DRESS_LOWER(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE})) {
                this.CUR_DRESS_INVLD = true;
            }
        }
        return !this.CUR_DRESS_INVLD;
    }

    public boolean validateCUR_BATHING(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) && !ValidateUtils.isValidValue(record.getCRNT_BATHG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE_SIX})) {
            this.CUR_BATHING_INVLD = true;
        }
        return !this.CUR_BATHING_INVLD;
    }

    public boolean validateCUR_TOILETING(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) && !ValidateUtils.isValidValue(record.getCRNT_TOILTG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR})) {
            this.CUR_TOILETING_INVLD = true;
        }
        return !this.CUR_TOILETING_INVLD;
    }

    public boolean validateCUR_TRANSFERRING(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) && !ValidateUtils.isValidValue(record.getCRNT_TRNSFRNG(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE})) {
            this.CUR_TRANSFER_INVLD = true;
        }
        return !this.CUR_TRANSFER_INVLD;
    }

    public boolean validateCUR_AMBULATION(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES}) && !ValidateUtils.isValidValue(record.getCRNT_AMBLTN(), new String[][]{ValidateUtils.ARRAY_DOUBLE_ZERO_ONE_TWO_THREE_FOUR_FIVE_SIX})) {
            this.CUR_AMBULATION_INVLD = true;
        }
        return !this.CUR_AMBULATION_INVLD;
    }

    public boolean validateTHER_NEED(HomeHealthRecordIF record) {
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{ASSESSMENT_REASON_VALUES})) {
            String tmpStr = record.getTHER_NEED_NA();
            if ("1".equals(tmpStr)) {
                if (record.getTHER_NEED_NBR() >= 0) {
                    this.THER_NEED_INVLD = true;
                }
            } else if ("0".equals(tmpStr) && (record.getTHER_NEED_NBR() < 0 || record.getTHER_NEED_NBR() > 999)) {
                this.THER_NEED_INVLD = true;
            }
        }
        return !this.THER_NEED_INVLD;
    }

    public boolean isValidPrincipalDiagnosisCode(HomeHealthRecordIF record) {
        DiagnosisCodeIF code = record.getPRIMARY_DIAG_ICD();
        return code != null && !code.isEmpty() && !code.isSecondaryOnly() && !code.isExternalCauseCode();
    }

    public abstract boolean validateDiagnosisCodes(HomeHealthRecordIF var1, Collection<HomeHealthEventListenerIF> var2);

    @Override
    public int[] getDiagnosisScoringStatus() {
        return this.diagnosisScoringStatus;
    }

    @Override
    public void setDiagnosisScoringStatus(int[] diagnosisScoringStatus) {
        this.diagnosisScoringStatus = diagnosisScoringStatus;
    }

    @Override
    public boolean isCUR_BATHING_Valid() {
        return !this.CUR_BATHING_INVLD;
    }

    @Override
    public boolean isCUR_TOILETING_Valid() {
        return !this.CUR_TOILETING_INVLD;
    }

    @Override
    public boolean isCUR_TRANSFER_Valid() {
        return !this.CUR_TRANSFER_INVLD;
    }

    @Override
    public boolean isCUR_AMBULATION_Valid() {
        return !this.CUR_AMBULATION_INVLD;
    }

    @Override
    public boolean isCUR_INJECT_MEDS_Valid() {
        return !this.CUR_INJECT_MEDS_INVLD;
    }

    @Override
    public boolean isTHER_NEED_Valid() {
        return !this.THER_NEED_INVLD;
    }

    @Override
    public boolean isDYSPNEIC_Valid() {
        return !this.DYSPNEIC_INVLD;
    }

    @Override
    public boolean isUR_INCONT_Valid() {
        return !this.UR_INCONT_INVLD;
    }

    @Override
    public boolean isBWLINCONT_Valid() {
        return !this.BWLINCONT_INVLD;
    }

    @Override
    public boolean isOSTOMY_Valid() {
        return !this.OSTOMY_INVLD;
    }

    @Override
    public boolean isCUR_DRESS_Valid() {
        return !this.CUR_DRESS_INVLD;
    }

    @Override
    public boolean isSTGPRSUL_Valid() {
        return !this.STGPRSUL_INVLD;
    }

    @Override
    public boolean isNBR_STASULC_Valid() {
        return !this.NBR_STASULC_INVLD;
    }

    @Override
    public boolean isUNOBS_STASULC_Valid() {
        return !this.UNOBS_STASULC_INVLD;
    }

    @Override
    public boolean isSTATSTASIS_Valid() {
        return !this.STATSTASIS_INVLD;
    }

    @Override
    public boolean isSTATSURG_Valid() {
        return !this.STATSURG_INVLD;
    }

    @Override
    public boolean isNPRSULC1_Valid() {
        return !this.NPRSULC1_INVLD;
    }

    @Override
    public boolean isNPRSULC2_Valid() {
        return !this.NPRSULC2_INVLD;
    }

    @Override
    public boolean isNPRSULC3_Valid() {
        return !this.NPRSULC3_INVLD;
    }

    @Override
    public boolean isNPRSULC4_Valid() {
        return !this.NPRSULC4_INVLD;
    }

    @Override
    public boolean isUNOBS_PRSULC_Valid() {
        return !this.UNOBS_PRSULC_INVLD;
    }

    @Override
    public boolean isASSMT_REASON_Valid() {
        return !this.ASSMT_REASON_INVLD;
    }

    @Override
    public boolean isINFO_COMPLETED_DT_Valid() {
        return !this.INFO_COMPLETED_DT_INVLD;
    }

    @Override
    public boolean isINTERNAL_LOGIC_Valid() {
        return !this.INTERNAL_LOGIC_INVLD;
    }

    @Override
    public boolean isTHERAPIES_Valid() {
        return !this.THERAPIES_INVLD;
    }

    @Override
    public boolean isVISION_Valid() {
        return !this.VISION_INVLD;
    }

    @Override
    public boolean isPAIN_Valid() {
        return !this.PAIN_INVLD;
    }

    @Override
    public boolean isLESION_Valid() {
        return !this.LESION_INVLD;
    }

    public String toString() {
        return "Validator: " + this.getClass().getSimpleName() + "{ASSMT_REASON_INVLD=" + this.ASSMT_REASON_INVLD + ", INFO_COMPLETED_DT_INVLD=" + this.INFO_COMPLETED_DT_INVLD + ", THERAPIES_INVLD=" + this.THERAPIES_INVLD + ", INTERNAL_LOGIC_INVLD=" + this.INTERNAL_LOGIC_INVLD + ", VISION_INVLD=" + this.VISION_INVLD + ", PAIN_INVLD=" + this.PAIN_INVLD + ", LESION_INVLD=" + this.LESION_INVLD + ", NPRSULC1_INVLD=" + this.NPRSULC1_INVLD + ", NPRSULC2_INVLD=" + this.NPRSULC2_INVLD + ", NPRSULC3_INVLD=" + this.NPRSULC3_INVLD + ", NPRSULC4_INVLD=" + this.NPRSULC4_INVLD + ", UNOBS_PRSULC_INVLD=" + this.UNOBS_PRSULC_INVLD + ", STGPRSUL_INVLD=" + this.STGPRSUL_INVLD + ", NBR_STASULC_INVLD=" + this.NBR_STASULC_INVLD + ", UNOBS_STASULC_INVLD=" + this.UNOBS_STASULC_INVLD + ", STATSTASIS_INVLD=" + this.STATSTASIS_INVLD + ", STATSURG_INVLD=" + this.STATSURG_INVLD + ", DYSPNEIC_INVLD=" + this.DYSPNEIC_INVLD + ", UR_INCONT_INVLD=" + this.UR_INCONT_INVLD + ", BWLINCONT_INVLD=" + this.BWLINCONT_INVLD + ", OSTOMY_INVLD=" + this.OSTOMY_INVLD + ", CUR_DRESS_INVLD=" + this.CUR_DRESS_INVLD + ", CUR_BATHING_INVLD=" + this.CUR_BATHING_INVLD + ", CUR_TOILETING_INVLD=" + this.CUR_TOILETING_INVLD + ", CUR_TRANSFER_INVLD=" + this.CUR_TRANSFER_INVLD + ", CUR_AMBULATION_INVLD=" + this.CUR_AMBULATION_INVLD + ", CUR_INJECT_MEDS_INVLD=" + this.CUR_INJECT_MEDS_INVLD + ", THER_NEED_INVLD=" + this.THER_NEED_INVLD + ", dataValidityFlag=" + this.dataValidityFlag + ", grouper=" + this.grouper + ", diagnosisScoringStatus=" + this.diagnosisScoringStatus + '}';
    }

    class MyOasisDataItemIF
    implements OasisDataItemIF {
        private final String key;
        private String value;

        public MyOasisDataItemIF(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String setValue(String value) {
            this.value = value;
            return value;
        }
    }

    class MyOasisEditIF
    implements OasisEditIF {
        private final String message;

        public MyOasisEditIF(String message) {
            this.message = message;
        }

        public long getId() {
            return 90000L;
        }

        public String getDescription() {
            return "Historical Edit: " + this.message;
        }

        public OasisEditTypeEN getType() {
            return OasisEditTypeEN.INFORMATION;
        }

        public Level getServerityLevel() {
            return Level.WARNING;
        }

        public String getVersionActiveTo() {
            return "3210";
        }
    }

    class MyOasisValidationEdit
    implements OasisValidationEditIF {
        private OasisEditIF oasisEdit;
        private OasisDataItemIF oasisDataItem;

        public MyOasisValidationEdit(String message, String dataKey, String dataValue) {
            this.oasisEdit = new MyOasisEditIF(message);
            this.oasisDataItem = new MyOasisDataItemIF(dataKey, dataValue);
        }

        public OasisEditIF getEdit() {
            return this.oasisEdit;
        }

        public OasisDataItemIF getOasisDataItem() {
            return this.oasisDataItem;
        }

        public void setEdit(OasisEditIF oeif) {
        }

        public void setOasisDataItem(OasisDataItemIF odiif) {
        }
    }
}

