/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v3414;

import com.mmm.cms.homehealth.AbstractGrouper_2;
import com.mmm.cms.homehealth.HomeHealthEventNotifier;
import com.mmm.cms.homehealth.PointsScoringEquations;
import com.mmm.cms.homehealth.ScoringResults;
import com.mmm.cms.homehealth.TreatmentAuthorization;
import com.mmm.cms.homehealth.proto.CaseMixAdjustmentItemIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.DiagnosisScoringStatus_EN;
import com.mmm.cms.homehealth.proto.DiagnosticGroupIF;
import com.mmm.cms.homehealth.proto.HIPPSCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.ScoringPointsIF;
import com.mmm.cms.homehealth.proto.ScoringResultsIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_C_IF;
import com.mmm.cms.homehealth.v3413.GrouperDataManager_V3413;
import com.mmm.cms.homehealth.v3413.HomeHealthRecordClinicalValidator_v3413;
import com.mmm.cms.homehealth.v3414.ClinicalFunctional_ScoringModel_v3414;
import com.mmm.cms.homehealth.v3414.NRS_ScoringModel_v3414;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.util.ScoringEventFormatter;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class GrouperVersion_v3414
extends AbstractGrouper_2
implements HomeHealthGrouperIF {
    HomeHealthEventNotifier eventNotifier = new HomeHealthEventNotifier();

    public GrouperVersion_v3414() {
        this(new GregorianCalendar(2014, 0, 1), new GregorianCalendar(2014, 8, 30), null, "V3414");
    }

    public GrouperVersion_v3414(Calendar start, Calendar thru, Calendar window, String versionName) {
        super(start, thru, window, versionName);
    }

    @Override
    public void copyCodes(HomeHealthRecordIF recordSrc, HomeHealthRecordIF recordDest) {
        recordDest.setPRIMARY_DIAG_ICD(recordSrc.getPRIMARY_DIAG_ICD());
        recordDest.setOTH_DIAG1_ICD(recordSrc.getOTH_DIAG1_ICD());
        recordDest.setOTH_DIAG2_ICD(recordSrc.getOTH_DIAG2_ICD());
        recordDest.setOTH_DIAG3_ICD(recordSrc.getOTH_DIAG3_ICD());
        recordDest.setOTH_DIAG4_ICD(recordSrc.getOTH_DIAG4_ICD());
        recordDest.setOTH_DIAG5_ICD(recordSrc.getOTH_DIAG5_ICD());
        recordDest.setPMT_DIAG_ICD_A3(recordSrc.getPMT_DIAG_ICD_A3());
        recordDest.setPMT_DIAG_ICD_B3(recordSrc.getPMT_DIAG_ICD_B3());
        recordDest.setPMT_DIAG_ICD_C3(recordSrc.getPMT_DIAG_ICD_C3());
        recordDest.setPMT_DIAG_ICD_D3(recordSrc.getPMT_DIAG_ICD_D3());
        recordDest.setPMT_DIAG_ICD_E3(recordSrc.getPMT_DIAG_ICD_E3());
        recordDest.setPMT_DIAG_ICD_F3(recordSrc.getPMT_DIAG_ICD_F3());
        recordDest.setPMT_DIAG_ICD_A4(recordSrc.getPMT_DIAG_ICD_A4());
        recordDest.setPMT_DIAG_ICD_B4(recordSrc.getPMT_DIAG_ICD_B4());
        recordDest.setPMT_DIAG_ICD_C4(recordSrc.getPMT_DIAG_ICD_C4());
        recordDest.setPMT_DIAG_ICD_D4(recordSrc.getPMT_DIAG_ICD_D4());
        recordDest.setPMT_DIAG_ICD_E4(recordSrc.getPMT_DIAG_ICD_E4());
        recordDest.setPMT_DIAG_ICD_F4(recordSrc.getPMT_DIAG_ICD_F4());
    }

    @Override
    public List<DiagnosticGroupIF> getDiagnosticGroups() {
        return this.dataManager.getDiagnosticGroups();
    }

    @Override
    public List<DiagnosticGroupIF> getDiagnosticGroupsNRS() {
        return this.dataManager.getDiagnosticGroupsNRS();
    }

    @Override
    public List<CaseMixAdjustmentItemIF> getCaseMixAdjustments() {
        return this.dataManager.getCaseMixAdjustments();
    }

    @Override
    public HomeHealthRecordValidatorIF getClinicalValidator() {
        return new HomeHealthRecordClinicalValidator_v3413(this);
    }

    @Override
    public Class getAcceptableRecordClass() {
        return HomeHealthRecord_C_IF.class;
    }

    @Override
    public List<DiagnosisCodeIF> getClinicalCodes() {
        return this.dataManager.getClinicalCodes();
    }

    @Override
    public String getName() {
        return "HHA PPS Grouper - October 2010 ICD-9-CM codes, " + this.getVersion();
    }

    @Override
    public List<CaseMixAdjustmentItemIF> getNRSCaseMixAdjustments() {
        return this.dataManager.getNRSCaseMixAdjustments();
    }

    @Override
    public HomeHealthRecordValidatorIF getNRSValidator() {
        return new HomeHealthRecordClinicalValidator_v3413(this);
    }

    @Override
    public List<DiagnosisCodeIF> getNonRoutineCodes() {
        return this.dataManager.getNonRoutineCodes();
    }

    @Override
    public void init(Properties props) throws Exception {
        this.dataManager = new GrouperDataManager_V3413(this);
        this.dataManager.init(props);
        this.clinicalModel_1 = new ClinicalFunctional_ScoringModel_v3414(this, this.dataManager, 1);
        this.clinicalModel_2 = new ClinicalFunctional_ScoringModel_v3414(this, this.dataManager, 2);
        this.clinicalModel_3 = new ClinicalFunctional_ScoringModel_v3414(this, this.dataManager, 3);
        this.clinicalModel_4 = new ClinicalFunctional_ScoringModel_v3414(this, this.dataManager, 4);
        this.nrsScoringModel = new NRS_ScoringModel_v3414(this, this.dataManager);
    }

    @Override
    public boolean isValidDiagnosisCode(HomeHealthRecordIF record, DiagnosisCodeIF code) {
        return code == null ? false : this.dataManager.getDiagnosisCode(code.getCode()) != null;
    }

    @Override
    public HomeHealthRecordValidatorIF populateValidateClinicalCodes(HomeHealthRecordIF record) {
        HomeHealthRecordValidatorIF validator = this.getClinicalValidator();
        this.clinicalModel_1.populateCodes(record);
        validator.validate(record);
        return validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized ScoringResultsIF score(HomeHealthRecordIF record, boolean validateDates, CollectionValidationEditsIF validationEdits, Collection<HomeHealthEventListenerIF> listeners) {
        try {
            if (listeners != null) {
                for (HomeHealthEventListenerIF listener : listeners) {
                    this.addEventListener(listener);
                }
            }
            ScoringResultsIF scoringResultsIF = this.score(record, validateDates);
            return scoringResultsIF;
        }
        finally {
            if (listeners != null) {
                for (HomeHealthEventListenerIF listener : listeners) {
                    this.removeEventListener(listener);
                }
            }
        }
    }

    @Override
    public ScoringResultsIF score(HomeHealthRecordIF recordOasisC, boolean validateDates) {
        ScoringResults scoringResult;
        ScoringEventFormatter.fireScoringRecord(this.eventNotifier.getEventListenersList(), this, "Pre-scoring: ", recordOasisC);
        if (validateDates && !this.isValidForVersion(recordOasisC)) {
            ScoringEventFormatter.fireScoringGeneral(this.eventNotifier.getEventListenersList(), this, null, ": record not valid for this version");
            scoringResult = new ScoringResults(recordOasisC);
        } else if (!(recordOasisC instanceof HomeHealthRecord_C_IF)) {
            ScoringEventFormatter.fireScoringGeneral(this.eventNotifier.getEventListenersList(), this, null, ": Invalid record format for this version");
            scoringResult = new ScoringResults(recordOasisC);
        } else {
            DiagnosisCodeIF diagCode;
            int idx;
            DiagnosisScoringStatus_EN[] diagnosisStatus = new DiagnosisScoringStatus_EN[18];
            DiagnosisScoringStatus_EN[] nrsDiagnosisStatus = new DiagnosisScoringStatus_EN[18];
            PointsScoringEquations clinicalScore = new PointsScoringEquations();
            PointsScoringEquations functionalScore = new PointsScoringEquations();
            ScoringEventFormatter.fireScoringGeneral(this.eventNotifier.getEventListenersList(), this, null, "populating codes for Clinical/Functional scoring");
            this.clinicalModel_1.populateCodes(recordOasisC);
            ScoringEventFormatter.fireScoringRecord(this.eventNotifier.getEventListenersList(), this, "Post-populating record: ", recordOasisC);
            ScoringEventFormatter.fireScoringGeneral(this.eventNotifier.getEventListenersList(), this, null, "Validating record");
            HomeHealthRecordValidatorIF validator = this.getClinicalValidator();
            validator.validate(recordOasisC, this.eventNotifier.getEventListenersList());
            ScoringEventFormatter.fireScoringGeneral(this.eventNotifier.getEventListenersList(), this, null, "Validating record - Done");
            for (idx = 0; idx < diagnosisStatus.length; ++idx) {
                diagCode = recordOasisC.getDiagnosisCode(idx);
                DiagnosisScoringStatus_EN diagnosisScoringStatus_EN = diagCode.isValidCode() ? (diagCode.isValidForScoring() ? DiagnosisScoringStatus_EN.VALID_SCORABLE : DiagnosisScoringStatus_EN.VALID) : (diagnosisStatus[idx] = DiagnosisScoringStatus_EN.INVALID);
                if (diagCode.isEmpty() || diagCode.isValidForScoring()) continue;
                ScoringEventFormatter.fireValidCodeWarning(this.getEventListenersList(), this, this.clinicalModel_1, diagCode, idx + 1, diagCode.isValidCode());
            }
            int[][] scoreOrder = this.determineScoreOrder(recordOasisC);
            ScoringPointsIF scoringPoints = this.clinicalModel_1.score(recordOasisC, validator, scoreOrder);
            clinicalScore.setEarly13AndUnder(scoringPoints.getScores()[0]);
            functionalScore.setEarly13AndUnder(scoringPoints.getScores()[1]);
            scoringPoints = this.clinicalModel_2.score(recordOasisC, validator, scoreOrder);
            clinicalScore.setEarly14Plus(scoringPoints.getScores()[0]);
            functionalScore.setEarly14Plus(scoringPoints.getScores()[1]);
            scoringPoints = this.clinicalModel_3.score(recordOasisC, validator, scoreOrder);
            clinicalScore.setLater13AndUnder(scoringPoints.getScores()[0]);
            functionalScore.setLater13AndUnder(scoringPoints.getScores()[1]);
            scoringPoints = this.clinicalModel_4.score(recordOasisC, validator, scoreOrder);
            clinicalScore.setLater14Plus(scoringPoints.getScores()[0]);
            functionalScore.setLater14Plus(scoringPoints.getScores()[1]);
            ScoringEventFormatter.fireScoringGeneral(this.eventNotifier.getEventListenersList(), this, null, "populating codes for Non-Routine Supplies scoring");
            this.nrsScoringModel.populateCodes(recordOasisC);
            ScoringEventFormatter.fireScoringRecord(this.eventNotifier.getEventListenersList(), this, "Post-populate with NRS Diagnosis: ", recordOasisC);
            ScoringEventFormatter.fireScoringGeneral(this.eventNotifier.getEventListenersList(), this, null, "Validating NRS record");
            HomeHealthRecordValidatorIF nrsValidator = this.getNRSValidator();
            nrsValidator.validate(recordOasisC, this.eventNotifier.getEventListenersList());
            ScoringEventFormatter.fireScoringGeneral(this.eventNotifier.getEventListenersList(), this, null, "Validating NRS record - Done");
            for (idx = 0; idx < 6; ++idx) {
                diagCode = recordOasisC.getDiagnosisCode(idx);
                if (diagCode.isEmpty() || diagCode.isValidForScoring()) continue;
                ScoringEventFormatter.fireValidCodeWarning(this.getEventListenersList(), this, this.nrsScoringModel, diagCode, idx + 1, diagCode.isValidCode());
            }
            for (idx = 0; idx < nrsDiagnosisStatus.length; ++idx) {
                diagCode = recordOasisC.getDiagnosisCode(idx);
                nrsDiagnosisStatus[idx] = diagCode.isValidCode() ? (diagCode.isValidForScoring() ? DiagnosisScoringStatus_EN.VALID_SCORABLE : DiagnosisScoringStatus_EN.VALID) : DiagnosisScoringStatus_EN.INVALID;
            }
            scoreOrder = this.determineScoreOrder(recordOasisC);
            scoringPoints = this.nrsScoringModel.score(recordOasisC, nrsValidator, scoreOrder);
            int nrsScore = scoringPoints.getScores()[0];
            HIPPSCodeIF hippsCode = this.createHippsCode(recordOasisC, validator, clinicalScore, functionalScore, nrsScore);
            TreatmentAuthorization treatment = hippsCode.getCode().trim().isEmpty() ? new TreatmentAuthorization(recordOasisC, null, null, null) : new TreatmentAuthorization(recordOasisC, validator, clinicalScore, functionalScore);
            scoringResult = new ScoringResults(hippsCode, this.getVersion(), validator.getDataValidityFlag(), treatment, validator, nrsValidator);
            scoringResult.setDiagnosisScoringStatus(diagnosisStatus);
            scoringResult.setNrsDiagnosisScoringStatus(nrsDiagnosisStatus);
        }
        return scoringResult;
    }

    @Override
    public void addEventListener(HomeHealthEventListenerIF listener) {
        this.eventNotifier.addEventListener(listener);
    }

    @Override
    public Iterator<HomeHealthEventListenerIF> getEventListeners() {
        return this.eventNotifier.getEventListeners();
    }

    @Override
    public List<HomeHealthEventListenerIF> getEventListenersList() {
        return this.eventNotifier.getEventListenersList();
    }

    @Override
    public void notifyEventListeners(HomeHealthEventIF event) {
        this.eventNotifier.notifyEventListeners(event);
    }

    @Override
    public void removeEventListener(HomeHealthEventListenerIF listener) {
        this.eventNotifier.removeEventListener(listener);
    }

    @Override
    public void removeEventListeners() {
        this.eventNotifier.removeEventListeners();
    }

    @Override
    public int getListenerCount() {
        return this.eventNotifier.getListenerCount();
    }
}

