/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.v4115;

import com.mmm.cms.homehealth.DataValidityFlag;
import com.mmm.cms.homehealth.RecordValidatorFactory;
import com.mmm.cms.homehealth.proto.DataValidityFlagIF;
import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.proto.RecordItemValidator_HH_PPS_IF;
import com.mmm.cms.homehealth.proto.RecordType;
import com.mmm.cms.homehealth.proto.RecordValidatorFactoryIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordValidatorIF;
import com.mmm.cms.homehealth.vut.CollectionValidationEdits;
import com.mmm.cms.homehealth.vut.pps.HhPpsValidatorItems;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.Describable;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HomeHealthRecordValidator_v4115
implements HomeHealthRecordValidatorIF {
    protected RecordItemValidatorIF[] oasisRecordItemValidators;
    protected RecordItemValidator_HH_PPS_IF[] hhPpsRecordItemValidators;
    protected DataValidityFlagIF dataValidityFlag;
    protected int[] diagnosisScoringStatus;
    protected CollectionValidationEditsIF edits;
    protected transient HomeHealthGrouperIF grouper;
    protected boolean skipOasisRecordValidation;

    public HomeHealthRecordValidator_v4115(HomeHealthGrouperIF grouper) {
        this.grouper = grouper;
        this.dataValidityFlag = new DataValidityFlag();
        this.diagnosisScoringStatus = new int[18];
        this.edits = new CollectionValidationEdits();
    }

    public HomeHealthRecordValidator_v4115(HomeHealthGrouperIF grouper, CollectionValidationEditsIF edits) {
        this.grouper = grouper;
        this.dataValidityFlag = new DataValidityFlag();
        this.diagnosisScoringStatus = new int[18];
        if (edits == null) {
            this.edits = new CollectionValidationEdits();
        } else {
            this.edits = edits;
            this.skipOasisRecordValidation = true;
        }
    }

    public RecordItemValidatorIF[] getOasisRecordItemValidators(HomeHealthRecordIF record) {
        if (this.oasisRecordItemValidators == null && !this.skipOasisRecordValidation) {
            try {
                RecordValidatorFactoryIF valFactory = RecordValidatorFactory.getInstance(null);
                this.oasisRecordItemValidators = valFactory.getValidationItems(record);
            }
            catch (Exception ex) {
                Logger.getLogger(HomeHealthRecordValidator_v4115.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.oasisRecordItemValidators = new RecordItemValidatorIF[0];
        }
        return this.oasisRecordItemValidators;
    }

    public void setOasisRecordItemValidators(RecordItemValidatorIF[] oasisRecordItemValidators) {
        this.oasisRecordItemValidators = oasisRecordItemValidators;
    }

    public RecordItemValidator_HH_PPS_IF[] getHhPpsRecordItemValidators(HomeHealthRecordIF record) {
        if (this.hhPpsRecordItemValidators == null) {
            HhPpsValidatorItems validator = HhPpsValidatorItems.getInstance();
            this.hhPpsRecordItemValidators = validator.getValidationItems(this.grouper, record);
        }
        return this.hhPpsRecordItemValidators;
    }

    public void setHhPpsRecordItemValidators(RecordItemValidator_HH_PPS_IF[] hhPpsRecordItemValidators) {
        this.hhPpsRecordItemValidators = hhPpsRecordItemValidators;
    }

    @Override
    public boolean isASSMT_REASON_Valid() {
        return !this.edits.isEditPresent("M0100_ASSMT_REASON");
    }

    @Override
    public boolean isINFO_COMPLETED_DT_Valid() {
        return !this.edits.isEditPresent("M0090_INFO_COMPLETED_DT");
    }

    @Override
    public boolean isTHERAPIES_Valid() {
        return !this.edits.isEditPresent("M1030_THH_IV_INFUSION") && !this.edits.isEditPresent("M1030_THH_PAR_NUTRITION") && !this.edits.isEditPresent("M1030_THH_ENT_NUTRITION") && !this.edits.isEditPresent("M1030_THH_NONE_ABOVE");
    }

    @Override
    public boolean isINTERNAL_LOGIC_Valid() {
        return !this.edits.isEditPresent((OasisEditIF)OasisEditsEN.EDIT_3880) && !this.edits.isEditPresent((OasisEditIF)OasisEditsEN.EDIT_3890);
    }

    @Override
    public boolean isVISION_Valid() {
        return !this.edits.isEditPresent("M1200_VISION");
    }

    @Override
    public boolean isPAIN_Valid() {
        return !this.edits.isEditPresent("M1242_PAIN_FREQ_ACTVTY_MVMT");
    }

    @Override
    public boolean isLESION_Valid() {
        return !this.edits.isEditPresent("M1350_LESION_OPEN_WND");
    }

    @Override
    public boolean isNPRSULC1_Valid() {
        return !this.edits.isEditPresent("M1322_NBR_PRSULC_STG1");
    }

    @Override
    public boolean isNPRSULC2_Valid() {
        return !this.edits.isEditPresent("M1308_NBR_PRSULC_STG2");
    }

    @Override
    public boolean isNPRSULC3_Valid() {
        return !this.edits.isEditPresent("M1308_NBR_PRSULC_STG3");
    }

    @Override
    public boolean isNPRSULC4_Valid() {
        return !this.edits.isEditPresent("M1308_NBR_PRSULC_STG4");
    }

    @Override
    public boolean isUNOBS_PRSULC_Valid() {
        return !this.edits.isEditPresent("M1308_NSTG_CVRG") && !this.edits.isEditPresent("M1308_NSTG_DRSG") && !this.edits.isEditPresent("M1308_NSTG_DEEP_TISUE");
    }

    @Override
    public boolean isSTGPRSUL_Valid() {
        return !this.edits.isEditPresent("M1324_STG_PRBLM_ULCER");
    }

    @Override
    public boolean isNBR_STASULC_Valid() {
        return !this.edits.isEditPresent("M1332_NBR_STAS_ULCR");
    }

    @Override
    public boolean isUNOBS_STASULC_Valid() {
        return !this.edits.isEditPresent("M1330_STAS_ULCR_PRSNT");
    }

    @Override
    public boolean isSTATSTASIS_Valid() {
        return !this.edits.isEditPresent("M1334_STUS_PRBLM_STAS_ULCR");
    }

    @Override
    public boolean isSTATSURG_Valid() {
        return !this.edits.isEditPresent("M1340_SRGCL_WND_PRSNT");
    }

    @Override
    public boolean isDYSPNEIC_Valid() {
        return !this.edits.isEditPresent("M1400_WHEN_DYSPNEIC");
    }

    @Override
    public boolean isUR_INCONT_Valid() {
        return !this.edits.isEditPresent("M1610_UR_INCONT") && !this.edits.isEditPresent("M1615_INCNTNT_TIMING");
    }

    @Override
    public boolean isBWLINCONT_Valid() {
        return !this.edits.isEditPresent("M1620_BWL_INCONT");
    }

    @Override
    public boolean isOSTOMY_Valid() {
        return !this.edits.isEditPresent("M1630_OSTOMY");
    }

    @Override
    public boolean isCUR_DRESS_Valid() {
        return !this.edits.isEditPresent("M1810_CRNT_DRESS_UPPER") && !this.edits.isEditPresent("M1820_CRNT_DRESS_LOWER");
    }

    @Override
    public boolean isCUR_BATHING_Valid() {
        return !this.edits.isEditPresent("M1830_CRNT_BATHG");
    }

    @Override
    public boolean isCUR_TOILETING_Valid() {
        return !this.edits.isEditPresent("M1840_CRNT_TOILTG");
    }

    @Override
    public boolean isCUR_TRANSFER_Valid() {
        return !this.edits.isEditPresent("M1850_CRNT_TRNSFRNG");
    }

    @Override
    public boolean isCUR_AMBULATION_Valid() {
        return !this.edits.isEditPresent("M1860_CRNT_AMBLTN");
    }

    @Override
    public boolean isCUR_INJECT_MEDS_Valid() {
        return !this.edits.isEditPresent("M2030_CRNT_MGMT_INJCTN_MDCTN");
    }

    @Override
    public boolean isTHER_NEED_Valid() {
        return !this.edits.isEditPresent("M2200_THER_NEED_NBR");
    }

    @Override
    public DataValidityFlagIF getDataValidityFlag() {
        return this.dataValidityFlag;
    }

    @Override
    public void setDataValidityFlag(DataValidityFlagIF dataValidityFlag) {
        if (dataValidityFlag == null) {
            throw new IllegalArgumentException("dataValidityFlag parameter can not be null");
        }
        this.dataValidityFlag = dataValidityFlag;
    }

    @Override
    public final boolean isClinicalDomainDataIssueFlag() {
        return this.dataValidityFlag.isClinicalIssue();
    }

    @Override
    public final boolean isFunctionalDomainDataIssueFlag() {
        return this.dataValidityFlag.isFunctionalIssue();
    }

    @Override
    public final boolean isManifestationSequenceIssueFlag() {
        return this.dataValidityFlag.isManifestationSequenceIssue();
    }

    @Override
    public final boolean isServiceDomainDataIssueFlag() {
        return this.dataValidityFlag.isServiceIssue();
    }

    @Override
    public int[] getDiagnosisScoringStatus() {
        return this.diagnosisScoringStatus;
    }

    public CollectionValidationEditsIF getEdits() {
        return this.edits;
    }

    @Override
    public void setDiagnosisScoringStatus(int[] diagnosisScoringStatus) {
        this.diagnosisScoringStatus = diagnosisScoringStatus;
    }

    @Override
    public boolean validate(HomeHealthRecordIF record) {
        this.validate(record, null);
        return this.edits.isEmpty();
    }

    @Override
    public CollectionValidationEditsIF validate(HomeHealthRecordIF record, Collection<HomeHealthEventListenerIF> listeners) {
        this.getOasisRecordItemValidators(record);
        for (RecordItemValidatorIF recordItemValidatorIF : this.oasisRecordItemValidators) {
            recordItemValidatorIF.validate(record, this.edits, this.dataValidityFlag);
        }
        this.getHhPpsRecordItemValidators(record);
        for (Describable describable : this.hhPpsRecordItemValidators) {
            describable.validate(this.grouper, record, this.edits, this.dataValidityFlag);
        }
        if (record.getRecordType() == RecordType.OASIS_C1_ICD_10 || record.getRecordType() == RecordType.OASIS_C2 || record.getRecordType() == RecordType.OASIS_D) {
            this.diagnosisScoringStatus = new int[6];
        }
        for (int idx = 0; idx < this.diagnosisScoringStatus.length; ++idx) {
            DiagnosisCodeIF code = record.getDiagnosisCode(idx);
            this.diagnosisScoringStatus[idx] = code.isValidForScoring() ? 2 : (code.isValidCode() || code.isOptionalPaymentCode() ? 1 : 0);
        }
        return this.edits;
    }
}

