/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut;

import com.mmm.cms.homehealth.io.HomeHealthRecordUtil;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_C1_IF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.proto.OasisDataItemIF;
import com.mmm.cms.homehealth.vut.proto.OasisValidatableRecordIF;
import com.mmm.cms.util.OasisCalendarFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class HHOasisValidatableRecord
implements OasisValidatableRecordIF {
    Map<String, OasisDataItemIF> oasisRecord;

    public HHOasisValidatableRecord(HomeHealthRecord_C1_IF homeHealthRecord) {
        this.createOasisRecordValueMap(homeHealthRecord);
    }

    public int size() {
        return this.oasisRecord.size();
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean isModifiable() {
        return false;
    }

    public boolean containsKey(Object key) {
        return this.get((String)key) != null;
    }

    public boolean containsValue(Object value) {
        return value instanceof String ? this.oasisRecord.containsValue(new HHOasisDataItem("", (String)value)) : this.oasisRecord.containsValue(value);
    }

    public OasisDataItemIF get(Object object) {
        return this.oasisRecord.get(object);
    }

    private void createOasisRecordValueMap(HomeHealthRecord_C1_IF homeHealthRecord) {
        StringBuilder buffer = new StringBuilder();
        this.oasisRecord = new HashMap<String, OasisDataItemIF>();
        this.oasisRecord.put("M0030_START_CARE_DT", new HHOasisDataItem("M0030_START_CARE_DT", OasisCalendarFormatter.format(homeHealthRecord.getSTART_CARE_DT(), buffer).toString()));
        buffer.setLength(0);
        this.oasisRecord.put("M0090_INFO_COMPLETED_DT", new HHOasisDataItem("M0090_INFO_COMPLETED_DT", OasisCalendarFormatter.format(homeHealthRecord.getINFO_COMPLETED_DT(), buffer).toString()));
        this.oasisRecord.put("M0100_ASSMT_REASON", new HHOasisDataItem("M0100_ASSMT_REASON", homeHealthRecord.getASSMT_REASON()));
        this.oasisRecord.put("M0110_EPISODE_TIMING", new HHOasisDataItem("M0110_EPISODE_TIMING", homeHealthRecord.getEPISODE_TIMING()));
        this.oasisRecord.put("M1030_THH_IV_INFUSION", new HHOasisDataItem("M1030_THH_IV_INFUSION", homeHealthRecord.getTHH_IV_INFUSION()));
        this.oasisRecord.put("M1030_THH_PAR_NUTRITION", new HHOasisDataItem("M1030_THH_PAR_NUTRITION", homeHealthRecord.getTHH_PAR_NUTRITION()));
        this.oasisRecord.put("M1030_THH_ENT_NUTRITION", new HHOasisDataItem("M1030_THH_ENT_NUTRITION", homeHealthRecord.getTHH_ENT_NUTRITION()));
        this.oasisRecord.put("M1030_THH_NONE_ABOVE", new HHOasisDataItem("M1030_THH_NONE_ABOVE", homeHealthRecord.getTHH_NONE_ABOVE()));
        this.oasisRecord.put("M1200_VISION", new HHOasisDataItem("M1200_VISION", homeHealthRecord.getVISION()));
        this.oasisRecord.put("M1242_PAIN_FREQ_ACTVTY_MVMT", new HHOasisDataItem("M1242_PAIN_FREQ_ACTVTY_MVMT", homeHealthRecord.getPAIN_FREQ_ACTVTY_MVMT()));
        this.oasisRecord.put("M1306_UNHLD_STG2_PRSR_ULCR", new HHOasisDataItem("M1306_UNHLD_STG2_PRSR_ULCR", homeHealthRecord.getUNHLD_STG2_PRSR_ULCR()));
        this.oasisRecord.put("M1308_NBR_PRSULC_STG2", new HHOasisDataItem("M1308_NBR_PRSULC_STG2", homeHealthRecord.getNBR_PRSULC_STG2()));
        this.oasisRecord.put("M1308_NBR_PRSULC_STG3", new HHOasisDataItem("M1308_NBR_PRSULC_STG3", homeHealthRecord.getNBR_PRSULC_STG3()));
        this.oasisRecord.put("M1308_NBR_PRSULC_STG4", new HHOasisDataItem("M1308_NBR_PRSULC_STG4", homeHealthRecord.getNBR_PRSULC_STG4()));
        this.oasisRecord.put("M1308_NSTG_DRSG", new HHOasisDataItem("M1308_NSTG_DRSG", homeHealthRecord.getNSTG_DRSG()));
        this.oasisRecord.put("M1308_NSTG_CVRG", new HHOasisDataItem("M1308_NSTG_CVRG", homeHealthRecord.getNSTG_CVRG()));
        this.oasisRecord.put("M1308_NSTG_DEEP_TISUE", new HHOasisDataItem("M1308_NSTG_DEEP_TISUE", homeHealthRecord.getNSTG_DEEP_TISUE()));
        this.oasisRecord.put("M1320_STUS_PRBLM_PRSR_ULCR", new HHOasisDataItem("M1320_STUS_PRBLM_PRSR_ULCR", homeHealthRecord.getSTUS_PRBLM_PRSR_ULCR()));
        this.oasisRecord.put("M1322_NBR_PRSULC_STG1", new HHOasisDataItem("M1322_NBR_PRSULC_STG1", homeHealthRecord.getNBR_PRSULC_STG1()));
        this.oasisRecord.put("M1324_STG_PRBLM_ULCER", new HHOasisDataItem("M1324_STG_PRBLM_ULCER", homeHealthRecord.getSTG_PRBLM_ULCER()));
        this.oasisRecord.put("M1330_STAS_ULCR_PRSNT", new HHOasisDataItem("M1330_STAS_ULCR_PRSNT", homeHealthRecord.getSTAS_ULCR_PRSNT()));
        this.oasisRecord.put("M1332_NUM_STAS_ULCR", new HHOasisDataItem("M1332_NUM_STAS_ULCR", homeHealthRecord.getNBR_STAS_ULCR()));
        this.oasisRecord.put("M1334_STUS_PRBLM_STAS_ULCR", new HHOasisDataItem("M1334_STUS_PRBLM_STAS_ULCR", homeHealthRecord.getSTUS_PRBLM_STAS_ULCR()));
        this.oasisRecord.put("M1340_SRGCL_WND_PRSNT", new HHOasisDataItem("M1340_SRGCL_WND_PRSNT", homeHealthRecord.getSRGCL_WND_PRSNT()));
        this.oasisRecord.put("M1342_STUS_PRBLM_SRGCL_WND", new HHOasisDataItem("M1342_STUS_PRBLM_SRGCL_WND", homeHealthRecord.getSTUS_PRBLM_SRGCL_WND()));
        this.oasisRecord.put("M1350_LESION_OPEN_WND", new HHOasisDataItem("M1350_LESION_OPEN_WND", homeHealthRecord.getLESION_OPEN_WND()));
        this.oasisRecord.put("M1400_WHEN_DYSPNEIC", new HHOasisDataItem("M1400_WHEN_DYSPNEIC", homeHealthRecord.getWHEN_DYSPNEIC()));
        this.oasisRecord.put("M1610_UR_INCONT", new HHOasisDataItem("M1610_UR_INCONT", homeHealthRecord.getUR_INCONT()));
        this.oasisRecord.put("M1615_INCNTNT_TIMING", new HHOasisDataItem("M1615_INCNTNT_TIMING", homeHealthRecord.getINCNTNT_TIMING()));
        this.oasisRecord.put("M1620_BWL_INCONT", new HHOasisDataItem("M1620_BWL_INCONT", homeHealthRecord.getBWL_INCONT()));
        this.oasisRecord.put("M1630_OSTOMY", new HHOasisDataItem("M1630_OSTOMY", homeHealthRecord.getOSTOMY()));
        this.oasisRecord.put("M1810_CUR_DRESS_UPPER", new HHOasisDataItem("M1810_CUR_DRESS_UPPER", homeHealthRecord.getCRNT_DRESS_UPPER()));
        this.oasisRecord.put("M1820_CUR_DRESS_LOWER", new HHOasisDataItem("M1820_CUR_DRESS_LOWER", homeHealthRecord.getCRNT_DRESS_LOWER()));
        this.oasisRecord.put("M1830_CRNT_BATHG", new HHOasisDataItem("M1830_CRNT_BATHG", homeHealthRecord.getCRNT_BATHG()));
        this.oasisRecord.put("M1840_CUR_TOILTG", new HHOasisDataItem("M1840_CUR_TOILTG", homeHealthRecord.getCRNT_TOILTG()));
        this.oasisRecord.put("M1850_CUR_TRNSFRNG", new HHOasisDataItem("M1850_CUR_TRNSFRNG", homeHealthRecord.getCRNT_TRNSFRNG()));
        this.oasisRecord.put("M1860_CRNT_AMBLTN", new HHOasisDataItem("M1860_CRNT_AMBLTN", homeHealthRecord.getCRNT_AMBLTN()));
        this.oasisRecord.put("M2000_DRUG_RGMN_RVW", new HHOasisDataItem("M2000_DRUG_RGMN_RVW", homeHealthRecord.getDRUG_RGMN_RVW()));
        this.oasisRecord.put("M2030_CRNT_MGMT_INJCTN_MDCTN", new HHOasisDataItem("M2030_CRNT_MGMT_INJCTN_MDCTN", homeHealthRecord.getCRNT_MGMT_INJCTN_MDCTN()));
        this.oasisRecord.put("M2200_THER_NEED_NUM", new HHOasisDataItem("M2200_THER_NEED_NUM", HomeHealthRecordUtil.formatTherapyNeedNum(homeHealthRecord.getTHER_NEED_NBR())));
        this.oasisRecord.put("M2200_THER_NEED_NA", new HHOasisDataItem("M2200_THER_NEED_NA", homeHealthRecord.getTHER_NEED_NA()));
        this.oasisRecord.put("M1021_PRIMARY_DIAG_ICD", new HHOasisDataItem("M1021_PRIMARY_DIAG_ICD", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getPRIMARY_DIAG_ICD())));
        this.oasisRecord.put("M1023_OTH_DIAG1_ICD", new HHOasisDataItem("M1023_OTH_DIAG1_ICD", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getOTH_DIAG1_ICD())));
        this.oasisRecord.put("M1023_OTH_DIAG2_ICD", new HHOasisDataItem("M1023_OTH_DIAG2_ICD", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getOTH_DIAG2_ICD())));
        this.oasisRecord.put("M1023_OTH_DIAG3_ICD", new HHOasisDataItem("M1023_OTH_DIAG3_ICD", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getOTH_DIAG3_ICD())));
        this.oasisRecord.put("M1023_OTH_DIAG4_ICD", new HHOasisDataItem("M1023_OTH_DIAG4_ICD", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getOTH_DIAG4_ICD())));
        this.oasisRecord.put("M1023_OTH_DIAG5_ICD", new HHOasisDataItem("M1023_OTH_DIAG5_ICD", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getOTH_DIAG5_ICD())));
        this.oasisRecord.put("M1025_PMT_DIAG_ICD_A3", new HHOasisDataItem("M1025_PMT_DIAG_ICD_A3", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getPMT_DIAG_ICD_A3())));
        this.oasisRecord.put("M1025_PMT_DIAG_ICD_A4", new HHOasisDataItem("M1025_PMT_DIAG_ICD_A4", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getPMT_DIAG_ICD_A4())));
        this.oasisRecord.put("M1025_PMT_DIAG_ICD_B3", new HHOasisDataItem("M1025_PMT_DIAG_ICD_B3", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getPMT_DIAG_ICD_B3())));
        this.oasisRecord.put("M1025_PMT_DIAG_ICD_B4", new HHOasisDataItem("M1025_PMT_DIAG_ICD_B4", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getPMT_DIAG_ICD_B4())));
        this.oasisRecord.put("M1025_PMT_DIAG_ICD_C3", new HHOasisDataItem("M1025_PMT_DIAG_ICD_C3", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getPMT_DIAG_ICD_C3())));
        this.oasisRecord.put("M1025_PMT_DIAG_ICD_C4", new HHOasisDataItem("M1025_PMT_DIAG_ICD_C4", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getPMT_DIAG_ICD_C4())));
        this.oasisRecord.put("M1025_PMT_DIAG_ICD_D3", new HHOasisDataItem("M1025_PMT_DIAG_ICD_D3", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getPMT_DIAG_ICD_D3())));
        this.oasisRecord.put("M1025_PMT_DIAG_ICD_D4", new HHOasisDataItem("M1025_PMT_DIAG_ICD_D4", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getPMT_DIAG_ICD_D4())));
        this.oasisRecord.put("M1025_PMT_DIAG_ICD_E3", new HHOasisDataItem("M1025_PMT_DIAG_ICD_E3", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getPMT_DIAG_ICD_E3())));
        this.oasisRecord.put("M1025_PMT_DIAG_ICD_E4", new HHOasisDataItem("M1025_PMT_DIAG_ICD_E4", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getPMT_DIAG_ICD_E4())));
        this.oasisRecord.put("M1025_PMT_DIAG_ICD_F3", new HHOasisDataItem("M1025_PMT_DIAG_ICD_F3", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getPMT_DIAG_ICD_F3())));
        this.oasisRecord.put("M1025_PMT_DIAG_ICD_F4", new HHOasisDataItem("M1025_PMT_DIAG_ICD_F4", HomeHealthRecordUtil.formatDxCode_C1(homeHealthRecord.getPMT_DIAG_ICD_F4())));
    }

    public OasisDataItemIF put(String key, OasisDataItemIF value) {
        return null;
    }

    public OasisDataItemIF remove(Object key) {
        return null;
    }

    public void putAll(Map<? extends String, ? extends OasisDataItemIF> m) {
    }

    public void clear() {
    }

    public Set<String> keySet() {
        return this.oasisRecord.keySet();
    }

    public Collection<OasisDataItemIF> values() {
        return this.oasisRecord.values();
    }

    public Set<Map.Entry<String, OasisDataItemIF>> entrySet() {
        return this.oasisRecord.entrySet();
    }
}

