/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractClinicalItemValidator;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateInjectableMeds_OASIS_C2
extends AbstractClinicalItemValidator
implements RecordItemValidatorIF {
    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_3060, OasisEditsEN.EDIT_4440, OasisEditsEN.EDIT_4450, OasisEditsEN.EDIT_4490});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        String assessmentReason = record.getASSMT_REASON();
        String tmpInjectMeds = record.getCRNT_MGMT_INJCTN_MDCTN();
        if (ValidateUtils.isValidValue(assessmentReason, new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_9_ONLY})) {
            if (!ValidateUtils.isValidValue(tmpInjectMeds, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3, ValidateUtils.ARRAY_NOT_APPLICABLE, ValidateUtils.ARRAY_CARET_VALUES)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M2030_CRNT_MGMT_INJCTN_MDCTN", tmpInjectMeds)));
            }
            if (ValidateUtils.isValidValue(assessmentReason, new String[][]{AbstractItemValidator.ASSESSMENT_4_5_9_ONLY}) && ValidateUtils.isValidValue(tmpInjectMeds, new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4490, new HHOasisDataItem("M2030_CRNT_MGMT_INJCTN_MDCTN", tmpInjectMeds)));
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates Current Injectable Meds for  edits: 3060, 4440, 4450, 4490";
    }
}

