/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecord_D_IF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractClinicalItemValidator;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidatePressureUlcer_OASIS_D
extends AbstractClinicalItemValidator
implements RecordItemValidatorIF {
    static final String[] validNumberOf;

    public ValidatePressureUlcer_OASIS_D() {
        super(HomeHealthRecord_D_IF.class);
    }

    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_3060, OasisEditsEN.EDIT_3010, OasisEditsEN.EDIT_4170, OasisEditsEN.EDIT_4211, OasisEditsEN.EDIT_5111, OasisEditsEN.EDIT_5122, OasisEditsEN.EDIT_5131, OasisEditsEN.EDIT_5660, OasisEditsEN.EDIT_5680});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        String assessmentReason = record.getASSMT_REASON();
        if (ValidateUtils.isValidValue(assessmentReason, new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_9_ONLY}) && record instanceof HomeHealthRecord_D_IF) {
            int intNonStageDeepTissue;
            HomeHealthRecord_D_IF recordD = (HomeHealthRecord_D_IF)record;
            String UNHLD_STG2_PRSR_ULCR = recordD.getUNHLD_STG2_PRSR_ULCR();
            String STG_PRBLM_ULCER = recordD.getSTG_PRBLM_ULCER();
            String NBR_PRSULC_STG1 = recordD.getNBR_PRSULC_STG1();
            String NBR_PRSULC_STG2 = recordD.getNBR_PRSULC_STG2();
            String NBR_PRSULC_STG3 = recordD.getNBR_PRSULC_STG3();
            String NBR_PRSULC_STG4 = recordD.getNBR_PRSULC_STG4();
            String NSTG_CVRG = recordD.getNSTG_CVRG();
            String NSTG_DEEP_TISUE = recordD.getNSTG_DEEP_TISUE();
            String NSTG_DRSG = recordD.getNSTG_DRSG();
            boolean isRFA_1_3_4_5_only = ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_ONLY});
            boolean isRFA_9_only = ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_9_ONLY});
            if (!ValidateUtils.isEmpty(UNHLD_STG2_PRSR_ULCR) && !ValidateUtils.isNumeric(UNHLD_STG2_PRSR_ULCR)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1306_UNHLD_STG2_PRSR_ULCR", UNHLD_STG2_PRSR_ULCR)));
            }
            if (!(ValidateUtils.isEmptyCaret(NBR_PRSULC_STG2) || this.isValueInRange01To99(NBR_PRSULC_STG2) || ValidateUtils.isValidValue(NBR_PRSULC_STG2, new String[][]{ValidateUtils.ARRAY_DASH_VALUES}))) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3100, new HHOasisDataItem("M1311_NBR_PRSULC_STG2_A1", NBR_PRSULC_STG2)));
            }
            if (!(ValidateUtils.isEmptyCaret(NBR_PRSULC_STG3) || this.isValueInRange01To99(NBR_PRSULC_STG3) || ValidateUtils.isValidValue(NBR_PRSULC_STG3, new String[][]{ValidateUtils.ARRAY_DASH_VALUES}))) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3100, new HHOasisDataItem("M1311_NBR_PRSULC_STG3_B1", NBR_PRSULC_STG3)));
            }
            if (!(ValidateUtils.isEmptyCaret(NBR_PRSULC_STG4) || this.isValueInRange01To99(NBR_PRSULC_STG4) || ValidateUtils.isValidValue(NBR_PRSULC_STG4, new String[][]{ValidateUtils.ARRAY_DASH_VALUES}))) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3100, new HHOasisDataItem("M1311_NBR_PRSULC_STG4_C1", NBR_PRSULC_STG4)));
            }
            if (!(ValidateUtils.isEmptyCaret(NSTG_CVRG) || this.isValueInRange01To99(NSTG_CVRG) || ValidateUtils.isValidValue(NSTG_CVRG, new String[][]{ValidateUtils.ARRAY_DASH_VALUES}))) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3100, new HHOasisDataItem("M1311_NSTG_CVRG_E1", NSTG_CVRG)));
            }
            if (!(ValidateUtils.isEmptyCaret(NSTG_DEEP_TISUE) || this.isValueInRange01To99(NSTG_DEEP_TISUE) || ValidateUtils.isValidValue(NSTG_DEEP_TISUE, new String[][]{ValidateUtils.ARRAY_DASH_VALUES}))) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3100, new HHOasisDataItem("M1311_NSTG_DEEP_TSUE_F1", NSTG_DEEP_TISUE)));
            }
            if (!(ValidateUtils.isEmptyCaret(NSTG_DRSG) || this.isValueInRange01To99(NSTG_DRSG) || ValidateUtils.isValidValue(NSTG_DRSG, new String[][]{ValidateUtils.ARRAY_DASH_VALUES}))) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3100, new HHOasisDataItem("M1311_NSTG_DRSG_D1", NSTG_DRSG)));
            }
            if (!ValidateUtils.isValidValue(STG_PRBLM_ULCER, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3, ValidateUtils.ARRAY_DOUBLE_4, {"NA"})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", STG_PRBLM_ULCER)));
            }
            if (isRFA_1_3_4_5_only) {
                if (ValidateUtils.isValidValue(NBR_PRSULC_STG2, new String[][]{ValidateUtils.ARRAY_DASH_VALUES})) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5660, new HHOasisDataItem("M1311_NBR_PRSULC_STG2_A1", NBR_PRSULC_STG2)));
                }
                if (ValidateUtils.isValidValue(NBR_PRSULC_STG3, new String[][]{ValidateUtils.ARRAY_DASH_VALUES})) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5660, new HHOasisDataItem("M1311_NBR_PRSULC_STG3_B1", NBR_PRSULC_STG3)));
                }
                if (ValidateUtils.isValidValue(NBR_PRSULC_STG4, new String[][]{ValidateUtils.ARRAY_DASH_VALUES})) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5660, new HHOasisDataItem("M1311_NBR_PRSULC_STG4_C1", NBR_PRSULC_STG4)));
                }
                if (ValidateUtils.isValidValue(NSTG_CVRG, new String[][]{ValidateUtils.ARRAY_DASH_VALUES})) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5660, new HHOasisDataItem("M1311_NSTG_CVRG_E1", NSTG_CVRG)));
                }
                if (ValidateUtils.isValidValue(NSTG_DEEP_TISUE, new String[][]{ValidateUtils.ARRAY_DASH_VALUES})) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5660, new HHOasisDataItem("M1311_NSTG_DEEP_TSUE_F1", NSTG_DEEP_TISUE)));
                }
                if (ValidateUtils.isValidValue(NSTG_DRSG, new String[][]{ValidateUtils.ARRAY_DASH_VALUES})) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5660, new HHOasisDataItem("M1311_NSTG_DRSG_D1", NSTG_DRSG)));
                }
            }
            if (!(!ValidateUtils.isValidValue(UNHLD_STG2_PRSR_ULCR, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) || ValidateUtils.isEmpty(NBR_PRSULC_STG2) && ValidateUtils.isEmpty(NBR_PRSULC_STG3) && ValidateUtils.isEmpty(NBR_PRSULC_STG4) && ValidateUtils.isEmpty(NSTG_CVRG) && ValidateUtils.isEmpty(NSTG_DEEP_TISUE) && ValidateUtils.isEmpty(NSTG_DRSG))) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5111, new HHOasisDataItem("M1306_UNHLD_STG2_PRSR_ULCR", UNHLD_STG2_PRSR_ULCR)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5111, new HHOasisDataItem("M1311_NBR_PRSULC_STG2_A1", NBR_PRSULC_STG2)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5111, new HHOasisDataItem("M1311_NBR_PRSULC_STG3_B1", NBR_PRSULC_STG3)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5111, new HHOasisDataItem("M1311_NBR_PRSULC_STG4_C1", NBR_PRSULC_STG4)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5111, new HHOasisDataItem("M1311_NSTG_CVRG_E1", NSTG_CVRG)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5111, new HHOasisDataItem("M1311_NSTG_DRSG_D1", NSTG_DRSG)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5111, new HHOasisDataItem("M1311_NSTG_DEEP_TSUE_F1", NSTG_DEEP_TISUE)));
            }
            if (ValidateUtils.isValidValue(UNHLD_STG2_PRSR_ULCR, new String[][]{ValidateUtils.ARRAY_DOUBLE_1}) && (ValidateUtils.isEmpty(NBR_PRSULC_STG2) || edits.isEditPresent("M1311_NBR_PRSULC_STG2_A1") || ValidateUtils.isEmpty(NBR_PRSULC_STG3) || edits.isEditPresent("M1311_NBR_PRSULC_STG3_B1") || ValidateUtils.isEmpty(NBR_PRSULC_STG4) || edits.isEditPresent("M1311_NBR_PRSULC_STG4_C1") || ValidateUtils.isEmpty(NSTG_CVRG) || edits.isEditPresent("M1311_NSTG_CVRG_E1") || ValidateUtils.isEmpty(NSTG_DEEP_TISUE) || edits.isEditPresent("M1311_NSTG_DEEP_TSUE_F1") || ValidateUtils.isEmpty(NSTG_DRSG) || edits.isEditPresent("M1311_NSTG_DRSG_D1"))) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5122, new HHOasisDataItem("M1306_UNHLD_STG2_PRSR_ULCR", UNHLD_STG2_PRSR_ULCR)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5122, new HHOasisDataItem("M1311_NBR_PRSULC_STG2_A1", NBR_PRSULC_STG2)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5122, new HHOasisDataItem("M1311_NBR_PRSULC_STG3_B1", NBR_PRSULC_STG3)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5122, new HHOasisDataItem("M1311_NBR_PRSULC_STG4_C1", NBR_PRSULC_STG4)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5122, new HHOasisDataItem("M1311_NSTG_CVRG_E1", NSTG_CVRG)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5122, new HHOasisDataItem("M1311_NSTG_DRSG_D1", NSTG_DRSG)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5122, new HHOasisDataItem("M1311_NSTG_DEEP_TSUE_F1", NSTG_DEEP_TISUE)));
            }
            if (ValidateUtils.isValidValue(NBR_PRSULC_STG2, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) && ValidateUtils.isValidValue(NBR_PRSULC_STG3, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) && ValidateUtils.isValidValue(NBR_PRSULC_STG4, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) && ValidateUtils.isValidValue(NSTG_CVRG, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) && ValidateUtils.isValidValue(NSTG_DRSG, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) && ValidateUtils.isValidValue(NSTG_DEEP_TISUE, new String[][]{ValidateUtils.ARRAY_DOUBLE_0})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5131, new HHOasisDataItem("M1311_NBR_PRSULC_STG2_A1", NBR_PRSULC_STG2)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5131, new HHOasisDataItem("M1311_NBR_PRSULC_STG3_B1", NBR_PRSULC_STG3)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5131, new HHOasisDataItem("M1311_NBR_PRSULC_STG4_C1", NBR_PRSULC_STG4)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5131, new HHOasisDataItem("M1311_NSTG_CVRG_E1", NSTG_CVRG)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5131, new HHOasisDataItem("M1311_NSTG_DRSG_D1", NSTG_DRSG)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5131, new HHOasisDataItem("M1311_NSTG_DEEP_TSUE_F1", NSTG_DEEP_TISUE)));
            }
            if (!ValidateUtils.isValidValue(UNHLD_STG2_PRSR_ULCR, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_1)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1306_UNHLD_STG2_PRSR_ULCR", UNHLD_STG2_PRSR_ULCR)));
            }
            if (ValidateUtils.isValidValue(NBR_PRSULC_STG1, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) && isRFA_1_3_4_5_only && (ValidateUtils.isValidValue(NBR_PRSULC_STG2, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) || ValidateUtils.isEmpty(NBR_PRSULC_STG2)) && (ValidateUtils.isValidValue(NBR_PRSULC_STG3, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) || ValidateUtils.isEmpty(NBR_PRSULC_STG3)) && (ValidateUtils.isValidValue(NBR_PRSULC_STG4, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) || ValidateUtils.isEmpty(NBR_PRSULC_STG4)) && !"NA".equals(STG_PRBLM_ULCER)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5680, new HHOasisDataItem("M1322_NBR_PRSULC_STG1", NBR_PRSULC_STG1)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5680, new HHOasisDataItem("M1311_NBR_PRSULC_STG2_A1", NBR_PRSULC_STG2)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5680, new HHOasisDataItem("M1311_NBR_PRSULC_STG3_B1", NBR_PRSULC_STG3)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5680, new HHOasisDataItem("M1311_NBR_PRSULC_STG4_C1", NBR_PRSULC_STG4)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5680, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", STG_PRBLM_ULCER)));
            }
            if (isRFA_9_only && (ValidateUtils.isValidValue(NBR_PRSULC_STG2, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) || ValidateUtils.isEmpty(NBR_PRSULC_STG2) || ValidateUtils.isValidValue(NBR_PRSULC_STG2, new String[][]{ValidateUtils.ARRAY_DASH_VALUES})) && (ValidateUtils.isValidValue(NBR_PRSULC_STG3, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) || ValidateUtils.isEmpty(NBR_PRSULC_STG3) || ValidateUtils.isValidValue(NBR_PRSULC_STG3, new String[][]{ValidateUtils.ARRAY_DASH_VALUES})) && (ValidateUtils.isValidValue(NBR_PRSULC_STG4, new String[][]{ValidateUtils.ARRAY_DOUBLE_0}) || ValidateUtils.isEmpty(NBR_PRSULC_STG4) || ValidateUtils.isValidValue(NBR_PRSULC_STG4, new String[][]{ValidateUtils.ARRAY_DASH_VALUES})) && !"NA".equals(STG_PRBLM_ULCER) && !ValidateUtils.isValidValue(STG_PRBLM_ULCER, new String[][]{ValidateUtils.ARRAY_DOUBLE_1})) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5680, new HHOasisDataItem("M1322_NBR_PRSULC_STG1", NBR_PRSULC_STG1)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5680, new HHOasisDataItem("M1311_NBR_PRSULC_STG2_A1", NBR_PRSULC_STG2)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5680, new HHOasisDataItem("M1311_NBR_PRSULC_STG3_B1", NBR_PRSULC_STG3)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5680, new HHOasisDataItem("M1311_NBR_PRSULC_STG4_C1", NBR_PRSULC_STG4)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_5680, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", STG_PRBLM_ULCER)));
            }
            int intStage2 = ValidateUtils.isEmpty(NBR_PRSULC_STG2) ? -1 : IntegerUtils.parseInt(NBR_PRSULC_STG2, -1);
            int intStage3 = ValidateUtils.isEmpty(NBR_PRSULC_STG3) ? -1 : IntegerUtils.parseInt(NBR_PRSULC_STG3, -1);
            int intStage4 = ValidateUtils.isEmpty(NBR_PRSULC_STG4) ? -1 : IntegerUtils.parseInt(NBR_PRSULC_STG4, -1);
            int intNonStageCovering = ValidateUtils.isEmpty(NSTG_CVRG) ? -1 : IntegerUtils.parseInt(NSTG_CVRG, -1);
            int n = intNonStageDeepTissue = ValidateUtils.isEmpty(NSTG_DEEP_TISUE) ? -1 : IntegerUtils.parseInt(NSTG_DEEP_TISUE, -1);
            if (ValidateUtils.isValidValue(NBR_PRSULC_STG1, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3, ValidateUtils.ARRAY_DOUBLE_4)) {
                if (ValidateUtils.isValidValue(STG_PRBLM_ULCER, new String[][]{ValidateUtils.ARRAY_DOUBLE_1}) && !ValidateUtils.isValidValue(NBR_PRSULC_STG1, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3, ValidateUtils.ARRAY_DOUBLE_4) && isRFA_1_3_4_5_only) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4170, new HHOasisDataItem("M1322_NBR_PRSULC_STG1", NBR_PRSULC_STG1)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4170, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", STG_PRBLM_ULCER)));
                }
            } else if (isRFA_1_3_4_5_only) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1322_NBR_PRSULC_STG1", NBR_PRSULC_STG1)));
            }
        }
        return count;
    }

    private boolean isValueInRange01To99(String value) {
        boolean valid = false;
        switch (value.length()) {
            case 2: {
                char char1 = value.charAt(0);
                char char2 = value.charAt(1);
                if (char1 == ' ') {
                    valid = Character.isDigit(char2);
                    break;
                }
                if (!Character.isDigit(char1)) break;
                valid = Character.isDigit(char2) || char2 == ' ';
                break;
            }
            case 1: {
                valid = Character.isDigit(value.charAt(0));
            }
        }
        return valid;
    }

    @Override
    public String getDescription() {
        return "Validates Pressure Ulcers for Stage 1 thru 4, and Non-staging pressure ulcers for edits: 3060, 4131, 4141,4151, 4161, 4170, 4211, 5110, 5121, 5131";
    }

    static {
        int idx;
        validNumberOf = new String[110];
        for (idx = 0; idx < 10; ++idx) {
            ValidatePressureUlcer_OASIS_D.validNumberOf[idx] = "0" + idx;
            ValidatePressureUlcer_OASIS_D.validNumberOf[idx + 10] = idx + " ";
        }
        for (idx = 20; idx < validNumberOf.length; ++idx) {
            ValidatePressureUlcer_OASIS_D.validNumberOf[idx] = Integer.toString(idx);
        }
    }
}

