/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractClinicalItemValidator;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.IntegerUtils;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateStageMostProblematicPressureUlcer
extends AbstractClinicalItemValidator
implements RecordItemValidatorIF {
    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_3060, OasisEditsEN.EDIT_4170, OasisEditsEN.EDIT_4180, OasisEditsEN.EDIT_4190, OasisEditsEN.EDIT_4200});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_9_ONLY})) {
            String tmpStr;
            String problemUlcer = record.getSTG_PRBLM_ULCER();
            if ("01".equals(problemUlcer)) {
                String tmpStr2 = record.getNBR_PRSULC_STG1();
                if (ValidateUtils.isValidValue(tmpStr2, new String[][]{ValidateUtils.ARRAY_CARET_VALUES}) || IntegerUtils.parseInt(tmpStr2, 0) <= 0) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4170, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", problemUlcer)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4170, new HHOasisDataItem("M1322_NBR_PRSULC_STG1", tmpStr2)));
                }
            } else if ("02".equals(problemUlcer)) {
                String tmpStr3 = record.getNBR_PRSULC_STG2();
                if (ValidateUtils.isValidValue(tmpStr3, new String[][]{ValidateUtils.ARRAY_CARET_VALUES}) || IntegerUtils.parseInt(tmpStr3, 0) <= 0) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4180, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", problemUlcer)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4180, new HHOasisDataItem("M1308_NBR_PRSULC_STG2", tmpStr3)));
                }
            } else if ("03".equals(problemUlcer)) {
                String tmpStr4 = record.getNBR_PRSULC_STG3();
                if (ValidateUtils.isValidValue(tmpStr4, new String[][]{ValidateUtils.ARRAY_CARET_VALUES}) || IntegerUtils.parseInt(tmpStr4, 0) <= 0) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4190, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", problemUlcer)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4190, new HHOasisDataItem("M1308_NBR_PRSULC_STG3", tmpStr4)));
                }
            } else if ("04".equals(problemUlcer) && (ValidateUtils.isValidValue(tmpStr = record.getNBR_PRSULC_STG4(), new String[][]{ValidateUtils.ARRAY_CARET_VALUES}) || IntegerUtils.parseInt(tmpStr, 0) <= 0)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4200, new HHOasisDataItem("M1324_STG_PRBLM_ULCER", problemUlcer)));
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4200, new HHOasisDataItem("M1308_NBR_PRSULC_STG4", tmpStr)));
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates Stage Most Problematic Pressure Ulcer for edits: 3060, 4170, 4180, 4190, 4200\n";
    }
}

