/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractClinicalItemValidator;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateStatusProblematicSurgicalWound
extends AbstractClinicalItemValidator
implements RecordItemValidatorIF {
    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_3060, OasisEditsEN.EDIT_4240, OasisEditsEN.EDIT_4250});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_9_ONLY})) {
            String surgPresent = record.getSRGCL_WND_PRSNT();
            String statSurg = record.getSTUS_PRBLM_SRGCL_WND();
            if (!ValidateUtils.isValidValue(statSurg, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_1, ValidateUtils.ARRAY_DOUBLE_2, ValidateUtils.ARRAY_DOUBLE_3, ValidateUtils.ARRAY_CARET_VALUES)) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1342_STUS_PRBLM_SRGCL_WND", statSurg)));
            }
            if (ValidateUtils.isValidValue(surgPresent, new String[][]{ValidateUtils.ARRAY_DOUBLE_1})) {
                if (ValidateUtils.isValidValue(statSurg, new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4250, new HHOasisDataItem("M1340_SRGCL_WND_PRSNT", surgPresent)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4250, new HHOasisDataItem("M1342_STUS_PRBLM_SRGCL_WND", surgPresent)));
                }
            } else if (ValidateUtils.isValidValue(surgPresent, ValidateUtils.ARRAY_DOUBLE_0, ValidateUtils.ARRAY_DOUBLE_2)) {
                if (!ValidateUtils.isValidValue(statSurg, new String[][]{ValidateUtils.ARRAY_CARET_VALUES})) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4240, new HHOasisDataItem("M1340_SRGCL_WND_PRSNT", surgPresent)));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4240, new HHOasisDataItem("M1342_STUS_PRBLM_SRGCL_WND", surgPresent)));
                }
            } else {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M1340_SRGCL_WND_PRSNT", surgPresent)));
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates Status Problematic Surgical Wound for edits: 3060, 4240, 4250";
    }
}

