/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.oasis;

import com.mmm.cms.homehealth.proto.RecordItemValidatorIF;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.oasis.AbstractServiceItemValidator;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditIF;
import com.mmm.cms.homehealth.vut.proto.OasisEditsEN;
import com.mmm.cms.util.ValidateUtils;
import java.util.List;

public class ValidateTherapyNeed
extends AbstractServiceItemValidator
implements RecordItemValidatorIF {
    @Override
    public List<OasisEditIF> getEditIdsUsed() {
        return super.getEditIdsUsed_base(new OasisEditIF[]{OasisEditsEN.EDIT_3060, OasisEditsEN.EDIT_4510, OasisEditsEN.EDIT_4520});
    }

    @Override
    public int validate(HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_ONLY})) {
            String tmpStr = record.getTHER_NEED_NA();
            int needNumber = record.getTHER_NEED_NBR();
            if ("1".equals(tmpStr)) {
                if (needNumber >= 0) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4520, new HHOasisDataItem("M2200_THER_NEED_NBR", Integer.toString(record.getTHER_NEED_NBR()))));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4520, new HHOasisDataItem("M2200_THER_NEED_NA", tmpStr)));
                }
            } else if ("0".equals(tmpStr)) {
                if (needNumber < 0 || needNumber > 999) {
                    ++count;
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4510, new HHOasisDataItem("M2200_THER_NEED_NBR", Integer.toString(record.getTHER_NEED_NBR()))));
                    edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_4510, new HHOasisDataItem("M2200_THER_NEED_NA", tmpStr)));
                }
            } else {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M2200_THER_NEED_NA", tmpStr)));
            }
            if (needNumber < -1) {
                ++count;
                edits.add((Object)new OasisValidationEdit((OasisEditIF)OasisEditsEN.EDIT_3060, new HHOasisDataItem("M2200_THER_NEED_NBR", Integer.toString(needNumber))));
            }
        }
        return count;
    }

    @Override
    public String getDescription() {
        return "Validates Therapy Need for edits: 3060, 4510, 4520";
    }
}

