/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.homehealth.vut.pps;

import com.mmm.cms.homehealth.proto.DiagnosisCodeIF;
import com.mmm.cms.homehealth.proto.HomeHealthGrouperIF;
import com.mmm.cms.homehealth.proto.edits.HH_PPS_OasisC1EditsEN;
import com.mmm.cms.homehealth.proto.record.HomeHealthRecordIF;
import com.mmm.cms.homehealth.v3312.ManifestationUtils;
import com.mmm.cms.homehealth.vut.HHOasisDataItem;
import com.mmm.cms.homehealth.vut.OasisValidationEdit;
import com.mmm.cms.homehealth.vut.oasis.AbstractItemValidator;
import com.mmm.cms.homehealth.vut.pps.ValidateManifestationEtiologyPairs;
import com.mmm.cms.homehealth.vut.proto.CollectionValidationEditsIF;
import com.mmm.cms.util.ValidateUtils;

public class ValidateManifestationEtiologyPairs_C2_220
extends ValidateManifestationEtiologyPairs {
    public ValidateManifestationEtiologyPairs_C2_220() {
    }

    public ValidateManifestationEtiologyPairs_C2_220(String primaryPrefix, String otherPrefix, String optPrefix) {
        super(primaryPrefix, otherPrefix, optPrefix);
    }

    @Override
    public int validate(HomeHealthGrouperIF grouper, HomeHealthRecordIF record, CollectionValidationEditsIF edits) {
        int count = 0;
        if (ValidateUtils.isValidValue(record.getASSMT_REASON(), new String[][]{AbstractItemValidator.ASSESSMENT_1_3_4_5_ONLY})) {
            for (int idx = 0; idx < 6; ++idx) {
                boolean etiologyPairFound = false;
                DiagnosisCodeIF code = record.getDiagnosisCode(idx);
                if (idx == 0 && !code.getCode().equalsIgnoreCase("I96.") || code.getDiagnosticGroup().getId() <= 0) continue;
                if (code.isSecondaryOnly()) {
                    etiologyPairFound = ManifestationUtils.getPairedCode(grouper, record, code, idx) != null;
                    code.setValidForScoring(etiologyPairFound);
                    if (etiologyPairFound) continue;
                    edits.add((Object)new OasisValidationEdit(HH_PPS_OasisC1EditsEN.EDIT_70030, new HHOasisDataItem(this.getOtherPrefix() + idx + "_ICD", code.getCode())));
                    ++count;
                    continue;
                }
                if (!code.getCode().equalsIgnoreCase("I96.")) continue;
                DiagnosisCodeIF codeAntiPair = ManifestationUtils.getExclusionCode(grouper, record, code, idx);
                etiologyPairFound = codeAntiPair != null;
                code.setValidForScoring(!etiologyPairFound);
                if (!etiologyPairFound) continue;
                edits.add((Object)new OasisValidationEdit(HH_PPS_OasisC1EditsEN.EDIT_70030, new HHOasisDataItem(this.getOtherPrefix() + idx + "_ICD", code.getCode())));
                ++count;
            }
        }
        return count;
    }
}

