/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.util;

import com.mmm.cms.homehealth.proto.HomeHealthEventIF;
import com.mmm.cms.homehealth.proto.HomeHealthEventListenerIF;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HHEventConsole
implements HomeHealthEventListenerIF {
    @Override
    public void homeHealthEvent(HomeHealthEventIF event) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        StringBuilder buffer = new StringBuilder("HHEvent: (");
        buffer.append(event.getEventId());
        buffer.append(")");
        if (event.getGrouper() != null) {
            buffer.append(" - Grouper: ");
            buffer.append(event.getGrouper().getName());
        }
        if (event.getModel() != null) {
            buffer.append(" - Model: '");
            buffer.append(event.getModel().getName());
        }
        if (event.getMessage() != null) {
            buffer.append(" - Message: '");
            buffer.append(event.getMessage());
        }
        switch (event.getEventId()) {
            case VALIDATION_ISSUE: 
            case GENERAL: {
                logger.log(Level.INFO, buffer.toString());
                break;
            }
            case WARNING: {
                logger.log(Level.WARNING, buffer.toString());
                break;
            }
            case EXCEPTION: {
                if (event.getException() != null) {
                    buffer.append(" - Exception: '");
                    buffer.append(event.getException().toString());
                    buffer.append("'");
                }
                logger.log(Level.SEVERE, buffer.toString());
                break;
            }
            case SCORING_STARTING: 
            case SCORING_FINISHED: 
            case SCORING_INCREASED: 
            case SCORING_SECTION_STARTING: 
            case SCORING_SECTION_FINISHED: {
                logger.log(Level.INFO, buffer.toString());
            }
        }
    }
}

