/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.hh.pdgm.claim;

import com.mmm.cms.hh.pdgm.claim.ClaimElementBase;
import com.mmm.cms.hh.pdgm.claim.ClaimElementCollection;
import com.mmm.cms.hh.pdgm.claim.ClaimElementCollectionIF;
import com.mmm.cms.hh.pdgm.claim.ClaimIF;
import com.mmm.cms.hh.pdgm.claim.DateFromIF;
import com.mmm.cms.hh.pdgm.claim.HippsCode;
import com.mmm.cms.hh.pdgm.claim.HippsCodeIF;
import com.mmm.cms.hh.pdgm.claim.OasisResponseIF;
import com.mmm.cms.hh.pdgm.claim.PeriodTimingIF;
import com.mmm.cms.hh.pdgm.claim.ReferralSourceIF;
import com.mmm.cms.hh.pdgm.claim.ReturnCode;
import com.mmm.cms.hh.pdgm.claim.ValidityFlag;
import com.mmm.cms.hh.pdgm.data.meta.enumer.EditId_EN;
import com.mmm.cms.hh.pdgm.data.meta.enumer.EditType_EN;
import com.mmm.cms.hh.pdgm.diagnosis.DiagnosisIF;
import com.mmm.cms.hh.pdgm.logic.validation.Edit;
import com.mmm.cms.hh.pdgm.logic.validation.EditCollection;
import com.mmm.cms.hh.pdgm.logic.validation.EditCollectionIF;
import java.util.Comparator;
import java.util.Optional;
import java.util.logging.Level;

public class Claim
extends ClaimElementBase
implements ClaimIF {
    private static final long serialVersionUID = 1L;
    private ClaimElementCollectionIF<ValidityFlag> validityFlags;
    private ClaimElementCollectionIF<ReturnCode> returnCodes;
    private ClaimElementCollectionIF<OasisResponseIF> oasisFields;
    private HippsCodeIF hippsCode = new HippsCode();
    private ClaimElementCollectionIF<DiagnosisIF> secondaryDiagnoses = new ClaimElementCollection<DiagnosisIF>();
    private DiagnosisIF primaryDiagnosis;
    private ReferralSourceIF referralSource;
    private DateFromIF dateFrom;
    private PeriodTimingIF periodTiming;
    private String claimId;
    private String grouperVersion;

    public String toString() {
        return "Claim{validityFlags=" + this.validityFlags + ", returnCodes=" + this.returnCodes + ", oasisFields=" + this.oasisFields + ", hippsCode=" + this.hippsCode + ", secondaryDiagnoses=" + this.secondaryDiagnoses + ", primaryDiagnosis=" + this.primaryDiagnosis + ", referralSource=" + this.referralSource + ", dateFrom=" + this.dateFrom + ", periodTiming=" + this.periodTiming + ", ClaimId=" + this.claimId + '}';
    }

    public Claim() {
        this.oasisFields = new ClaimElementCollection<OasisResponseIF>();
        this.returnCodes = new ClaimElementCollection<ReturnCode>();
        this.validityFlags = new ClaimElementCollection<ValidityFlag>();
    }

    @Override
    public ClaimElementCollectionIF<ValidityFlag> getValidityFlags() {
        return this.validityFlags;
    }

    @Override
    public void setValidityFlags(ClaimElementCollectionIF<ValidityFlag> validityFlags) {
        this.validityFlags = validityFlags;
    }

    @Override
    public ClaimElementCollectionIF<ReturnCode> getReturnCodes() {
        return this.returnCodes;
    }

    @Override
    public void setReturnCodes(ClaimElementCollectionIF<ReturnCode> returnCodes) {
        this.returnCodes = returnCodes;
    }

    @Override
    public ClaimElementCollectionIF<OasisResponseIF> getOasisFields() {
        return this.oasisFields;
    }

    @Override
    public void setOasisFields(ClaimElementCollectionIF<OasisResponseIF> oasisFields) {
        this.oasisFields = oasisFields;
    }

    @Override
    public HippsCodeIF getHippsCode() {
        return this.hippsCode;
    }

    @Override
    public void setHippsCode(HippsCodeIF hippsCode) {
        this.hippsCode = hippsCode;
    }

    @Override
    public ClaimElementCollectionIF<DiagnosisIF> getSecondaryDiagnoses() {
        return this.secondaryDiagnoses;
    }

    @Override
    public void setSecondaryDiagnoses(ClaimElementCollectionIF<DiagnosisIF> secondaryDiagnoses) {
        this.secondaryDiagnoses = secondaryDiagnoses;
    }

    @Override
    public DiagnosisIF getPrimaryDiagnosis() {
        return this.primaryDiagnosis;
    }

    @Override
    public void setPrimaryDiagnosis(DiagnosisIF primaryDiagnosis) {
        this.primaryDiagnosis = primaryDiagnosis;
    }

    @Override
    public ReferralSourceIF getReferralSource() {
        return this.referralSource;
    }

    @Override
    public void setReferralSource(ReferralSourceIF referralSource) {
        this.referralSource = referralSource;
    }

    @Override
    public DateFromIF getDateFrom() {
        return this.dateFrom;
    }

    @Override
    public void setDateFrom(DateFromIF dateFrom) {
        this.dateFrom = dateFrom;
    }

    @Override
    public PeriodTimingIF getPeriodTiming() {
        return this.periodTiming;
    }

    @Override
    public void setPeriodTiming(PeriodTimingIF periodTiming) {
        this.periodTiming = periodTiming;
    }

    @Override
    public String getClaimId() {
        return this.claimId;
    }

    @Override
    public void setClaimId(String ClaimId) {
        this.claimId = ClaimId;
    }

    @Override
    public ReturnCode getSingleReturnCode() {
        Optional<ReturnCode> retGrc;
        if (!this.returnCodes.isEmpty() && (retGrc = this.returnCodes.stream().min(Comparator.comparing(ReturnCode::getId))).isPresent()) {
            return retGrc.get();
        }
        return new ReturnCode(50, "Fatal error - Component corrupted or not set up");
    }

    @Override
    public ValidityFlag getSingleValidityFlag() {
        Optional<ValidityFlag> retVal;
        if (!this.validityFlags.isEmpty() && (retVal = this.validityFlags.stream().min(Comparator.comparing(ValidityFlag::getValue))).isPresent()) {
            return retVal.get();
        }
        return new ValidityFlag("00", "Validity Flag not used");
    }

    @Override
    public String getGrouperVersion() {
        return this.grouperVersion;
    }

    @Override
    public void setGrouperVersion(String grouperVersion) {
        this.grouperVersion = grouperVersion;
    }

    @Override
    public EditCollectionIF getClaimEdits() {
        EditCollection retEdColl = new EditCollection();
        retEdColl.addEdits(this.getEditCollection().getEdits());
        if (this.dateFrom != null) {
            retEdColl.addEdits(this.dateFrom.getEditCollection().getEdits());
        }
        if (this.periodTiming != null) {
            retEdColl.addEdits(this.periodTiming.getEditCollection().getEdits());
        }
        if (this.referralSource != null) {
            retEdColl.addEdits(this.referralSource.getEditCollection().getEdits());
        }
        if (this.primaryDiagnosis != null) {
            retEdColl.addEdits(this.primaryDiagnosis.getEditCollection().getEdits());
        }
        retEdColl.addEdits(this.secondaryDiagnoses.getEditCollection().getEdits());
        this.secondaryDiagnoses.forEach(sdx -> retEdColl.addEdits(sdx.getEditCollection().getEdits()));
        retEdColl.addEdits(this.oasisFields.getEditCollection().getEdits());
        this.oasisFields.forEach(field -> retEdColl.addEdits(field.getEditCollection().getEdits()));
        retEdColl.addEdits(this.hippsCode.getEditCollection().getEdits());
        this.returnCodes.forEach(returnCode -> retEdColl.addEdit(new Edit(EditId_EN.VALUE_RETURN, returnCode.toString(), EditType_EN.INFO, Level.INFO)));
        this.validityFlags.forEach(validityFlag -> retEdColl.addEdit(new Edit(EditId_EN.VALUE_RETURN, validityFlag.toString(), EditType_EN.INFO, Level.INFO)));
        return retEdColl;
    }

    @Override
    public boolean hasReturnCode(int returnCode) {
        return this.returnCodes.stream().anyMatch(code -> code.getId() == returnCode);
    }

    @Override
    public boolean hasValidityFlag(String validityFlag) {
        return this.validityFlags.stream().anyMatch(flag -> flag.getValue().equalsIgnoreCase(validityFlag.trim()));
    }
}

