/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.hh.pdgm.logic.processor;

import com.mmm.cms.hh.pdgm.claim.ClaimElementCollectionIF;
import com.mmm.cms.hh.pdgm.claim.ClaimIF;
import com.mmm.cms.hh.pdgm.claim.OasisResponseIF;
import com.mmm.cms.hh.pdgm.data.files.TableNames_EN;
import com.mmm.cms.hh.pdgm.data.meta.enumer.EditId_EN;
import com.mmm.cms.hh.pdgm.data.meta.enumer.FunctionalLevel_EN;
import com.mmm.cms.hh.pdgm.diagnosis.DiagnosisIF;
import com.mmm.cms.hh.pdgm.grouper.DataManagerIF;
import com.mmm.cms.hh.pdgm.logic.processor.HippsPositionAbstract;
import com.mmm.cms.hh.pdgm.logic.processor.HippsPositionIF;
import com.mmm.cms.hh.pdgm.logic.processor.HippsPositionSelectorIF;
import com.mmm.cms.hh.pdgm.reference.objects.OasisRespondObject;
import java.util.List;

public class HippsPosition3
extends HippsPositionAbstract
implements HippsPositionIF {
    public HippsPosition3(ClaimIF claim, DataManagerIF dataManager) {
        super(claim, dataManager);
    }

    @Override
    public void process(HippsPositionSelectorIF visitor) {
        visitor.select(this);
    }

    @Override
    public boolean validate() {
        return this.validateFunctionalFields();
    }

    @Override
    public boolean calculate() {
        int HIPPS_POSITION = 3;
        DiagnosisIF pdx = this.getClaim().getPrimaryDiagnosis();
        if (!this.getClaim().getOasisFields().getEditCollection().hasCriticalEdits() && !pdx.getEditCollection().hasCriticalEdits()) {
            int score = this.getRiskHospitalisationScore() + this.getOtherFunctionalScore();
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS3, "Total Functional Impairment points " + score);
            String value = this.getHippsValue(score);
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS3, "HIPPS Position 3 = " + value + " (" + FunctionalLevel_EN.valueOf(value).getName() + ", see PDX clinical group low/high value range)");
            return this.setHippsCode(3, value);
        }
        String text = "Functional Impairment Fields or PDX have critical issue(s). Please see validation messages";
        this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS3, text);
        text = "HIPPS Position 3 = 0 (Not calculated)";
        this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS3, text);
        return false;
    }

    private String getHippsValue(int score) {
        String retVal = null;
        int lowPoints = this.getClaim().getPrimaryDiagnosis().getClinicalGroup().getLowPoints();
        int highPoints = this.getClaim().getPrimaryDiagnosis().getClinicalGroup().getHighPoints();
        retVal = score <= lowPoints ? FunctionalLevel_EN.A.name() : (score >= highPoints ? FunctionalLevel_EN.C.name() : FunctionalLevel_EN.B.name());
        return retVal;
    }

    private int getOtherFunctionalScore() {
        String PREFIX_NOT = "M1033";
        int sum = 0;
        ClaimElementCollectionIF<OasisResponseIF> oResList = this.getClaim().getOasisFields();
        for (OasisResponseIF oResp : oResList) {
            if (oResp.getType().name().startsWith("M1033")) continue;
            sum += oResp.getScore();
            this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS3, "OASIS " + oResp.getType().name() + " points = " + oResp.getScore());
        }
        return sum;
    }

    private int getRiskHospitalisationScore() {
        int retScore = 0;
        String PREFIX = "M1033";
        List refList = this.getDataManager().getDataMap().get(TableNames_EN.OASIS_Responses).getData();
        OasisRespondObject ref = null;
        for (OasisRespondObject oasRespObj : refList) {
            if (!oasRespObj.getFieldId().startsWith("M1033")) continue;
            ref = oasRespObj;
        }
        int sum = 0;
        ClaimElementCollectionIF<OasisResponseIF> oResList = this.getClaim().getOasisFields();
        for (OasisResponseIF oResp : oResList) {
            if (!oResp.getType().name().startsWith("M1033") || oResp.getEditCollection().hasEditId(EditId_EN.VALUE_IGNORE)) continue;
            int val = Integer.parseInt(oResp.getValue());
            sum += val;
        }
        if (ref != null && sum >= Integer.parseInt(ref.getResponseLimit())) {
            retScore = Integer.parseInt(ref.getCategoryPoints());
        }
        this.addHippsLogicMessage(EditId_EN.VALUE_HIPPS3, "OASIS M1033 Hospitalization Risk points total = " + retScore);
        return retScore;
    }
}

