/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.cms.hh.pdgm.reference.objects;

import com.mmm.cms.hh.pdgm.data.exchange.ClaimContainerIF;
import com.mmm.cms.hh.pdgm.data.exchange.DxContainer;
import com.mmm.cms.hh.pdgm.data.exchange.DxContainerIF;
import com.mmm.cms.hh.pdgm.data.exchange.ReturnCodeContainerIF;
import com.mmm.cms.hh.pdgm.data.exchange.ValidityFlagContainerIF;
import com.mmm.cms.hh.pdgm.data.interf.PositionAccessorIF;
import com.mmm.cms.hh.pdgm.data.meta.enumer.Oasis_EN;
import com.mmm.cms.hh.pdgm.logic.validation.EditCollectionIF;
import com.mmm.cms.hh2.xml.data.claim.Claim;
import com.mmm.cms.hh2.xml.data.claim.ClinicalFields;
import com.mmm.cms.hh2.xml.data.claim.Diagnoses;
import com.mmm.cms.hh2.xml.data.claim.Dx;
import com.mmm.cms.hh2.xml.data.claim.FunctionalField;
import com.mmm.cms.hh2.xml.data.claim.FunctionalFields;
import com.mmm.cms.hh2.xml.data.claim.GrouperReturnCode;
import com.mmm.cms.hh2.xml.data.claim.HippsCode;
import com.mmm.cms.hh2.xml.data.claim.Input;
import com.mmm.cms.hh2.xml.data.claim.Options;
import com.mmm.cms.hh2.xml.data.claim.Output;
import com.mmm.cms.hh2.xml.data.claim.Principal;
import com.mmm.cms.hh2.xml.data.claim.Secondary;
import com.mmm.cms.hh2.xml.data.claim.Subfield;
import com.mmm.cms.hh2.xml.data.claim.ValidityFlag;
import com.mmm.cms.hh2.xml.data.claim.VersionUsed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ClaimObject
extends Claim
implements PositionAccessorIF,
ClaimContainerIF {
    private boolean loadDescription;

    public ClaimObject() {
        this.init();
    }

    private void init() {
        this.setOptions(new Options());
        this.setInput(new Input());
        this.getInput().setClinicalFields(new ClinicalFields());
        this.getInput().getClinicalFields().setDiagnoses(new Diagnoses());
        this.getInput().getClinicalFields().getDiagnoses().setPrincipal(new Principal());
        this.getInput().getClinicalFields().getDiagnoses().setSecondary(new Secondary());
        this.getInput().setFunctionalFields(new FunctionalFields());
        this.setOutput(new Output());
        this.getOutput().setVersionUsed(new VersionUsed());
        this.getOutput().setHippsCode(new HippsCode());
        this.getOutput().setValidityFlag(new ValidityFlag());
        this.getOutput().setGrouperReturnCode(new GrouperReturnCode());
    }

    public String toString() {
        String nl = "\n";
        return "ClaimObject{" + nl + "ID='" + this.getId() + "'," + nl + "Description='" + (this.getDescription() == null ? "" : this.getDescription()) + "'," + nl + "From Date='" + this.getInput().getClinicalFields().getFromDate() + "'," + nl + "Period Timing='" + this.getInput().getClinicalFields().getPeriodTiming() + "'," + nl + "Referral Source='" + this.getInput().getClinicalFields().getReferralSource() + "'," + nl + this.formatDx(this.getInput().getClinicalFields().getDiagnoses().getPrincipal().getDx(), "P", nl) + this.formatDx(this.getInput().getClinicalFields().getDiagnoses().getSecondary().getDx(), "S", nl) + this.formatOasis(this.getInput().getFunctionalFields().getFunctionalField(), nl) + "Version Used='" + this.formatVersion(this.getOutput().getVersionUsed()) + "'," + nl + "HIPPS Code='" + this.formatHippsCode(this.getOutput().getHippsCode()) + "'," + nl + "Validity Flag='" + this.getOutput().getValidityFlag().getValue() + "'," + nl + "Grouper Return Code='" + this.getOutput().getGrouperReturnCode().getValue() + "'," + nl + "ActionFlag='" + this.getOptions().getActionFlag() + "'," + nl + "}";
    }

    @Override
    public String getByPosition(int position) {
        if (position == 0) {
            return this.getId();
        }
        if (position == 1) {
            return this.getInput().getClinicalFields().getFromDate();
        }
        if (position == 2) {
            return this.getInput().getClinicalFields().getPeriodTiming();
        }
        if (position == 3) {
            return this.getInput().getClinicalFields().getReferralSource();
        }
        if (position == 4) {
            Dx dx = this.getInput().getClinicalFields().getDiagnoses().getPrincipal().getDx();
            String retDx = dx.getCode() + dx.getPoa();
            return retDx;
        }
        return null;
    }

    @Override
    public boolean setByPosition(int position, String value) {
        Subfield sf;
        FunctionalField ff;
        if (position == 0) {
            this.setId(value);
        }
        if (position == 1) {
            this.getInput().getClinicalFields().setFromDate(value);
        }
        if (position == 2) {
            this.getInput().getClinicalFields().setPeriodTiming(value);
        }
        if (position == 3) {
            this.getInput().getClinicalFields().setReferralSource(value);
        }
        if (position == 4) {
            Dx dx = new Dx();
            dx.setCode(value.substring(0, value.length() - 1));
            dx.setPoa(value.substring(value.length() - 1));
            dx.setOccurrence("0");
            this.getInput().getClinicalFields().getDiagnoses().getPrincipal().setDx(dx);
        }
        if (position > 4 && position <= 28) {
            List<Dx> dxList = this.getInput().getClinicalFields().getDiagnoses().getSecondary().getDx();
            Dx dx = new Dx();
            dx.setCode(value.substring(0, value.length() - 1));
            dx.setPoa(value.substring(value.length() - 1));
            dx.setOccurrence("" + (dxList.size() + 1));
            dxList.add(dx);
        }
        if (position > 33 && position <= 43) {
            ff = null;
            if (position == 34) {
                ff = new FunctionalField();
                String name = Oasis_EN.values()[0].name().substring(0, 5);
                ff.setFieldName(name);
                this.getInput().getFunctionalFields().getFunctionalField().add(ff);
            } else {
                ff = this.getInput().getFunctionalFields().getFunctionalField().get(0);
            }
            sf = new Subfield();
            sf.setName(Oasis_EN.values()[position - 34].name());
            sf.setValue(value);
            ff.getSubfield().add(sf);
        }
        if (position > 43 && position < 51) {
            ff = new FunctionalField();
            sf = new Subfield();
            String name = Oasis_EN.values()[position - 34].name();
            ff.setFieldName(name.substring(0, 5));
            sf.setName(name);
            sf.setValue(value);
            ff.getSubfield().add(sf);
            this.getInput().getFunctionalFields().getFunctionalField().add(ff);
        }
        if (position == 52) {
            this.getOptions().setActionFlag(value);
        }
        if (position == 53) {
            VersionUsed vu = this.getOutput().getVersionUsed();
            if (value.contains(".")) {
                vu.setVersion(value.substring(0, 2));
                vu.setRelease(value.substring(3, 4));
                vu.setYear(value.substring(5));
            } else {
                vu.setVersion(value);
                vu.setRelease("");
                vu.setYear("");
            }
        }
        if (position == 54) {
            HippsCode hc = this.getOutput().getHippsCode();
            hc.setEpisodeTiming(value.substring(0, 1));
            hc.setClinicalGroup(value.substring(1, 2));
            hc.setFunctionalLevel(value.substring(2, 3));
            hc.setComorbidityPresent(value.substring(3, 4));
            hc.setFiller(value.substring(4, 5));
        }
        if (position == 55) {
            ValidityFlag vf = this.getOutput().getValidityFlag();
            vf.setValue(value);
        }
        if (position == 56) {
            GrouperReturnCode grc = this.getOutput().getGrouperReturnCode();
            grc.setValue(value);
        }
        return false;
    }

    private String formatDx(Dx dx, String pref, String del) {
        if (dx.getCode().trim().isEmpty()) {
            return null;
        }
        return pref + "DX='{'" + dx.getCode() + "','" + dx.getPoa() + "','" + dx.getOccurrence() + "'}" + del;
    }

    private String formatDx(List<Dx> dxList, String pref, String del) {
        StringBuilder ret = new StringBuilder();
        dxList.stream().map(dx -> this.formatDx((Dx)dx, pref, del)).filter(retStr -> retStr != null).forEachOrdered(retStr -> ret.append((String)retStr));
        return ret.toString();
    }

    private String formatOasis(List<FunctionalField> ffList, String del) {
        String ret = "";
        for (FunctionalField ff : ffList) {
            List<Subfield> sfList = ff.getSubfield();
            ret = sfList.stream().map(sf -> "OASIS Field={" + sf.getName() + "='" + sf.getValue() + "'}" + del).reduce(ret, String::concat);
        }
        return ret;
    }

    private String formatVersion(VersionUsed vu) {
        String ret = "";
        ret = vu.getVersion() + "." + vu.getRelease() + "." + vu.getYear();
        return ret;
    }

    private String formatHippsCode(HippsCode hc) {
        String ret = "";
        ret = hc.getEpisodeTiming() + hc.getClinicalGroup() + hc.getFunctionalLevel() + hc.getComorbidityPresent() + hc.getFiller();
        return ret;
    }

    public String tempGetOutput() {
        return this.formatVersion(this.getOutput().getVersionUsed()) + this.formatHippsCode(this.getOutput().getHippsCode()) + this.getOutput().getValidityFlag().getValue() + this.getOutput().getGrouperReturnCode().getValue();
    }

    @Override
    public int getNumberOfFields() {
        return 56;
    }

    @Override
    public boolean isLoadDescription() {
        return this.loadDescription;
    }

    @Override
    public void setLoadDescription(boolean loadDescription) {
        this.loadDescription = loadDescription;
    }

    @Override
    public String getHippsCode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getReturnCodeValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getReturnCodeDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getValidityFlagValue() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getValidityFlagDescription() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getVersionUsed() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setAmbulation(String ambulation) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setBathing(String bathing) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getClaimId() {
        return this.getId();
    }

    @Override
    public void setClaimId(String claimId) {
        this.setId(claimId);
    }

    @Override
    public void setDressLower(String dressLower) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setDressUpper(String dressUpper) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setFromDate(String fromDate) {
        this.getInput().getClinicalFields().setFromDate(fromDate);
    }

    @Override
    public void setGrooming(String grooming) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskCompliance(String hospRiskCompliance) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskFiveMoreMeds(String hospRiskFiveMoreMeds) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskHistoryFalls(String hospRiskHistoryFalls) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskMentalBehavDecl(String hospRiskMentalBehavDecl) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskMultiEdVisit(String hospRiskMultiEdVisit) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskMultiHospital(String hospRiskMultiHospital) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskNoneAbove(String hospRiskNoneAbove) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskOtherRisk(String hospRiskOtherRisk) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskExhaustion(String hospRiskExhaustion) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHospRiskWeightLoss(String hospRiskWeightLoss) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPdx(String pdx, String poa) {
        Dx dx = new Dx();
        dx.setCode(pdx);
        dx.setPoa(poa);
        dx.setOccurrence("0");
        this.getInput().getClinicalFields().getDiagnoses().getPrincipal().setDx(dx);
    }

    @Override
    public void addSdx(String sdx, String poa) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setPeriodTiming(String periodTiming) {
        this.getInput().getClinicalFields().setPeriodTiming(periodTiming);
    }

    @Override
    public void setReferralSource(String referralSource) {
        this.getInput().getClinicalFields().setReferralSource(referralSource);
    }

    @Override
    public void setToileting(String toileting) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setTransferring(String transferring) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getAmbulation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getBathing() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDressLower() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getDressUpper() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getFromDate() {
        return this.getInput().getClinicalFields().getFromDate();
    }

    @Override
    public String getGrooming() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskCompliance() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskFiveMoreMeds() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskHistoryFalls() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskMentalBehavDecl() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskMultiEdVisit() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskMultiHospital() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskNoneAbove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskOtherRisk() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskExhaustion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getHospRiskWeightLoss() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public DxContainerIF getPdx() {
        Dx dx = this.getInput().getClinicalFields().getDiagnoses().getPrincipal().getDx();
        DxContainer pdx = new DxContainer(dx.getCode(), dx.getPoa());
        return pdx;
    }

    @Override
    public String getPeriodTiming() {
        return this.getInput().getClinicalFields().getPeriodTiming();
    }

    @Override
    public String getReferralSource() {
        return this.getInput().getClinicalFields().getReferralSource();
    }

    @Override
    public ReturnCodeContainerIF getReturnCode() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public List<DxContainerIF> getSdxList() {
        ArrayList<DxContainer> retList = null;
        List<Dx> dxList = this.getInput().getClinicalFields().getDiagnoses().getSecondary().getDx();
        for (Dx dx : dxList) {
            DxContainer diag = new DxContainer(dx.getCode(), dx.getPoa());
            if (retList == null) {
                retList = new ArrayList<DxContainer>();
            }
            retList.add(diag);
        }
        return retList;
    }

    @Override
    public String getToileting() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getTransferring() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ValidityFlagContainerIF getValidityFlag() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setHippsCode(String HippsCode2) {
        this.setByPosition(54, HippsCode2);
    }

    @Override
    public void setPdx(DxContainerIF pdx) {
        Dx dx = new Dx();
        dx.setCode(pdx.getDx());
        dx.setPoa(pdx.getPoa());
        dx.setOccurrence("0");
        this.getInput().getClinicalFields().getDiagnoses().getPrincipal().setDx(dx);
    }

    @Override
    public void setReturnCode(ReturnCodeContainerIF returnCode) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setSdxList(List<DxContainerIF> sdxList) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setValidityFlag(ValidityFlagContainerIF validityFlag) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setVersionUsed(String versionUsed) {
        this.setByPosition(53, versionUsed);
    }

    @Override
    public Map<String, String> getFunctionalFields() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        List<FunctionalField> ffList = this.getInput().getFunctionalFields().getFunctionalField();
        for (FunctionalField ff : ffList) {
            List<Subfield> sfList = ff.getSubfield();
            for (Subfield sf : sfList) {
                retMap.put(sf.getName(), sf.getValue());
            }
        }
        return retMap;
    }

    @Override
    public EditCollectionIF getEdits() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setEdits(EditCollectionIF edits) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

